/*.BM*********************************************************************
	Copyright (C) 1982,1983,1985 Intermetrics, Inc.
AUTHOR		:   Arra Avakian; ed. Randy Hudson; Julian Horn
SECTION		:   ROM Processor - rcopy() routine
MODULE		:   m/rt/c/68000/com/rcopy.c
SCCS ID		:   1.1
LAST DELTA	:   6/10/91  17:48:24
DATE OF GET	:   6/13/91  17:35:12
UNIX FILE	:   s.rcopy.c
@(#)m/rt/c/68000/com/rcopy.c	1.1

    FUNCTIONS DEFINED :
	rcopy
    RELATION :
	ROM initialization utility.
	Rcopy is called when a new C program starts up.
	It receives the address of an initialization segment
	created by an off-line utility program ("romp" or "llink").
	Its purpose is to initialize read-write data.
**************************************************************************
.EM*/

#include "rcopy.h"
#include "string.h"

    void
rcopy(table)
    struct hdr *table;   /* input: pointer to initialization segment */
{
    register char *src,*dst;  /* pointers to current bytes in data, dest */
    register COUNT cnt,i;     /* cnt: bytes left, i: index */

    while (cnt = table->bytes) {
	if (cnt < 0) {
	    cnt = -cnt;
	    memset(table->dest,0,(size_t)cnt); /* set block to zero */
	    table = (struct hdr *)&(table->data[0]);  /* next block */
	} else {
	    /* round i to even cnt */
	    i = (cnt+1)&(~1);
	    for (dst = table->dest, src = &(table->data[0]); cnt--; ) {
		*dst++ = *src++ ;
	    }
	    table = (struct hdr *)&(table->data[i]);  /* next block */
	}
    }
} /* rcopy */
