/*.BM*********************************************************************
	Copyright (C) 1989 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/68000/dm/time.h
SCCS ID		:   1.2
LAST DELTA	:   10/15/90  18:20:10
DATE OF GET	:   9/29/93  09:54:29
UNIX FILE	:   /usr2/millen/m/rt/c/68000/dm/s.time.h
@(#)m/rt/c/68000/dm/time.h	1.2

**************************************************************************
.EM*/

#ifndef __TIME_INCLUDED
#define __TIME_INCLUDED

#ifndef NULL
#define NULL ((void *)0)
#endif

#ifndef CLOCKS_PER_SEC
#define CLOCKS_PER_SEC 1
#endif

#ifndef __SIZE_T
#define __SIZE_T
typedef unsigned long size_t;
#endif

typedef unsigned long time_t;
typedef unsigned long clock_t;

struct tm {
    int tm_sec;
    int tm_min;
    int tm_hour;
    int tm_mday;
    int tm_mon;
    int tm_year;
    int tm_wday;
    int tm_yday;
    int tm_isdst;
};

/* Time manipulation functions */

extern clock_t	clock(void);
extern double	difftime(time_t, time_t);
extern time_t	mktime(struct tm *);
extern time_t	time(time_t *);

/* Time conversion functions */

extern char *	asctime(const struct tm *);
extern char *	ctime(const time_t *);
extern struct tm * gmtime(const time_t *);
extern struct tm * localtime(const time_t *);
extern size_t	strftime(char *, size_t, const char *, const struct tm *);

#endif
