/****************************************************************************
	file	:	boot.h
	header file for Flash PROM boot module

	changes : chetan 21st July 1997
				 changed memory locations
				 See the comments NEW_BOOT
****************************************************************************/
#ifndef _BOOT_H_
#define _BOOT_H_

#ifndef byte
#define	byte BYTE
#endif
#ifndef word
#define	word USHORT
#endif
#ifndef dword
#define	dword ULONG
#endif
#ifndef BOOL
#define	BOOL int
#endif

#define	MAGIC_NUM	0xABCD		/* Magic number in CodeHeader and Config recs */
#define	DOWNLOAD_MODE	0xA5		/* Number for download mode */
#define	WARM_BOOT_MODE	0x5A		/* Number for warm boot (after new cnf) mode */

#define	FRAME_DELIM	0x7e

#define	LedPort	*(dword *)(0xff000010)

#define	FL_PG_SIZE_10	128			/* Flash PROM page size */
#define	FL_PG_SIZE_20	256			/* Flash PROM page size */
#define	FL_PG_SIZE_40	512			/* Flash PROM page size */

#define	FL_PAGE_SIZE	FL_PG_SIZE_40

#define	PKTS_PER_PAGE	((word)(FL_PAGE_SIZE/DNLD_PKT_SIZE))

#define	FL_BOOT_CODE	0x0000000l		/* = 0  */
#define	BOOT_CODE_SIZE	(68*1024)

/* assuming 512 bytes as FLASH PROM page length */


/* Sachin (changed the memory map) 23/08/1996 */

/* NEW_BOOT */
#if 1
#define FL_ROMM_START 0x08000000L  /* 68K for boot code */
#define FL_PROM_SIZE 0x80000L  /* 512K */
#define NUM_OF_FL_PROMS 2
#define FL_PROM_END (FL_ROMM_START + (FL_PROM_SIZE * NUM_OF_FL_PROMS) - 1)
#else
#define FL_ROMM_START   0x00000000l                      /* 68K for boot code */
#endif
/* NEW_BOOT */

/* Jyothi 23/2/98 */
#define UDB_ADDRESS   (FL_ROMM_START + 0xC0000)
/* Jyothi 23/2/98 */

#define FL_BOOT_HDR     (FL_ROMM_START + BOOT_CODE_SIZE) /* 1 page for boot cfg hdr */
#define FL_CODE_HDR     (FL_BOOT_HDR   + FL_PAGE_SIZE)   /* 1 page for code hdr */
#define FL_CFG_HDR      (FL_CODE_HDR   + FL_PAGE_SIZE)   /* 1 page for system cfg hdr */
#define FL_UDB_HDR      (FL_CFG_HDR    + FL_PAGE_SIZE)
#define FL_SCRIPT_HDR   (FL_UDB_HDR    + FL_PAGE_SIZE)
#define FL_SNMP_HDR     (FL_SCRIPT_HDR + FL_PAGE_SIZE)
/* Sachin added this on 30th Sept. 1997 */
#define FL_DHCP_HDR (FL_SNMP_HDR   + FL_PAGE_SIZE)
#define FL_RESERVED_2   (FL_SNMP_HDR   + 2 * FL_PAGE_SIZE)
#define FL_RESERVED_3   (FL_SNMP_HDR   + 3 * FL_PAGE_SIZE)

#define FL_SNMP_CFG     (FL_RESERVED_3 + FL_PAGE_SIZE)

/*
	SNMP variables : 0x12200 4 pages
	SYSTEM CONFIG  : 0x12600 (Max. 60K i.e, 120 pages)
	CODE START     : 0x21600 
*/

/* chetan 4/11/96 */
/* NEW_BOOT */
#if 1
#define UDB_DNLD_ADDR 0x080C0000L
#else
#define UDB_DNLD_ADDR 0xC0000L
#endif
/* NEW_BOOT */

#define SINGLE_SCR_SIZE (8 * 1024)
#define TOT_SCR_SIZES (3 * SINGLE_SCR_SIZE)
#define SCRIPT_ONE_DNLD_ADDR (UDB_DNLD_ADDR - TOT_SCR_SIZES)
#define SCRIPT_TWO_DNLD_ADDR (SCRIPT_ONE_DNLD_ADDR + SINGLE_SCR_SIZE)
#define SCRIPT_THREE_DNLD_ADDR (SCRIPT_TWO_DNLD_ADDR + SINGLE_SCR_SIZE)
/* chetan 4/11/96 */


/* Sachin (changed the memory map) 23/08/1996 */


#define	RECV_7E		0
#define	RECV_DATA	1
#define	RECV_QUOTE	2

#define	ERR_CRC			12		/* part of UI err codes */
#define	ERR_PASSWORD	13
#define	ERR_SCC1			14
#define	ERR_SCC2			15
#define	ERR_SCC3			16
#define	ERR_SCC4			17

#define	ERR_NO_BRD_GET_PASSWORD		18
#define	ERR_NO_BRD_NO_PASSWORD		19
#define	ERR_INV_MEM_RANGE				20
#define	ERR_ROUTER_UP					21

#define	TRGT_CMND_TYPE	0	/* part of UI commands */
#define	RES_TYPE			12
#define	PASSWORD_TYPE	30
#define	REBOOT_TYPE		22
#define	READ_REQ_TYPE	31
#define	READ_RESP_TYPE	32
#define	WRITE_REQ_TYPE	33

/* target command types */
#define	DNLOAD_CODE_TYPE		0
#define	HW_DIAG_TYPE			1
#define	DNLOAD_CFG_TYPE		3

/* download types */
#define	NO_DNLD		0
#define	DNLD_CODE	1
#define	DNLD_CFG		2

/* Ports */
#define	SCC1		1
#define	SCC2		2
#define	SCC3		3
#define	SCC4		4

/* #defines for different speeds */
#define	CLOCK_UNKNOWN			0
#define	CLOCK_250000MHZ		1
#define	CLOCK_258048MHZ		2
#define	CLOCK_330000MHZ		3
#define	CLOCK_33344MHZ			4

/* a byte to denote the hardware model */
#define	MODEL_UNKNOWN			0	/* unknown hardware type */
#define	MODEL_MTSR3				1	/* one LAN, 3 RS232/V.35 WAN ports */
#define	MODEL_MTSR1_100		2	/* one LAN, 1 RS232/V.35 WAN port */
#define	MODEL_MTSR1_200		3	/* one LAN, one 33.6K modem port */
#define	MODEL_MTSR3_200		4	/* one LAN, three modems port */
#define	MODEL_MTSR1_202ST		5	/* one LAN, one ISDN ST port */
#define	MODEL_MTSR1_202NT		6	/* one LAN, one ISDN NT port */
#define	MODEL_MTSR2_201		7	/* one LAN, one DSU and one RS232/V.35 WAN ports */
#define	MODEL_MTSR1_120		8	/* 2 LAN and one RS232/V.35 WAN ports */

/* Boot prom width */
#define	PROM_WIDTH_UNKNOWN	0
#define	PROM_WIDTH_8BITS		1
#define	PROM_WIDTH_16BITS		2
#define	PROM_WIDTH_32BITS		3


#define	MIN_PKT_SIZE	4	/* DnLdPktHead(2 Abort Pkt) + CRC(2) */

#define	INC_CIR_IDX(seqnum, maxval)	seqnum++; seqnum &= (maxval -1)

/* Packet format of all Target Command packets 
   +----+------+------+----+----+---+-----+----+----+---...----
   | 7e |  SMC header | Pkt data... |    CRC   | 7e |	
   +----+------+------+----+----+---------+----+----+---...----
	  1         4                          2      1
CRC is calculated from Type  */
#ifndef _BOOT_CONFIG_TYPE_DEFINED_
#define _BOOT_CONFIG_TYPE_DEFINED_
typedef struct
{
	byte	Version[10];		/* version number of this record ASCIIZ */
	byte	EthernetAddr[6];	/* Ethernet address */
	byte	PassWord[20];		/* password for Boot config */
	byte	NumberOfPorts;
	byte	Base1;
	byte	Size1;
	byte	Base2;
	byte	Size2;

	byte	ClockSpeed;
	byte	BootBusWidth;
	byte	ModelNumber;

	byte Reserved[8] ;       /* for future use */   
	dword MagicNumber;		/* 0xA55AA55A to indicate valid config */
	dword	FlashPromSize;		/* System related information */
	dword	RamSize;
	dword	RamStart;
} BootConfigType;
#endif

/* Generic Header Pkt for all downloads. Each download type will use some 
or all of these fields */
#define _HEADER_TYPE_DEFINED_
typedef struct
{
	byte	Version[10];		/* 0 .. 9 	version number as ASCIIZ */
	byte	DateStamp[25];		/* 10.. 34	date as ASCIIZ */
	byte	Dmy;					/* 35 */
	word	MagicNum;			/* 36.. 37 */
	word	CRC;					/* 38.. 39	16bit CRC value */
	dword	CodeLength;			/* 40.. 43	Valid length of compressed code */
	dword DnLdAddr;			/* 52.. 55	Address where compressed code is put */
	dword LoadAddr;			/* 44.. 47	Address to start loading at */
	dword	StartAddr;			/* 48.. 51	Address to start execution at */
	byte	Reserved[20];		/* 56.. 75	for future use */
}HeaderType;

/* Sachin added the User database header here : 23rd December 1996 */
typedef struct
{
	BYTE version[10] ;
	BYTE date_stamp[25] ;
	BYTE dummy ;
	USHORT magic_number ;
	USHORT crc ;
	ULONG length ;
	ULONG down_load_address ;
	ULONG load_address ;
	ULONG start_address ;
	USHORT no_of_records ;
	BYTE reserved[20] ;
	BYTE description[15] ;
} UDB_HEADER ;


/* Sachin added the DHCP Server Database header here : 30th Sept. 1997 */
typedef struct
{
	BYTE version[10] ;
	BYTE date_stamp[25] ;
	BYTE dummy ;
	USHORT magic_number ;
	USHORT crc ;
	ULONG length ;
	ULONG down_load_address ;
	ULONG load_address ;
	ULONG start_address ;
	USHORT no_of_records ;
	BYTE reserved[20] ;
	BYTE description[15] ;
} DHCP_SERVER_DATABASE_HEADER ;


/* Sachin moved this here. 25/01/97 */
typedef struct
{
	char	Version[8];
	char	Date[24];
	char	MagicNum[5];
} VersionDateType;

/* Sachin moved this here. 25/01/97 */

#if 0
typedef struct
{
	byte	BridgeNumber[4];
} SMCPktHeadType;

typedef struct
{
	byte	Ptype;				/* 0 */
	char	Password[11];		/* 1 .. 11 */
}	PasswordPktType;

typedef struct
{
	byte	Ptype;				/* 0 */
	byte	TargetAction;		/* 1 */
	byte	Port;					/* 2	  These 2 fields are for  */
	byte	BaudIndex;			/* 3	  Hardware Diagnostics */
} TargetCmdType;

typedef struct
{
	byte	Ptype;				/* 0 */
	byte  Length;				/* 1 */
	byte	Dmy[2];				/* 2..3 */
	dword Address;				/* 4..7 */
}	ReadLocReqType;

typedef struct {
	byte	Ptype;				/* 0 */
	byte	ErrCode;				/* 1 */
	byte	Length;				/* 2 */
	byte	Dmy[1];				/* Vidy added Dmy and Address */
	dword Address;				/* 3..6 */
	byte	buffer[128];		/* 7..134 */
}  ReadLocRespType;

typedef	struct {
	byte	Ptype;				/* 0 */
	byte	Dmy;					/* 1 */
	word	Length;				/* 2..3 */
	dword Address;				/* 4..7 */
	byte	Buffer[FL_PAGE_SIZE];	/* 8..519 */
} WriteLocReqType;

#endif

extern	word	ReceiveIndex;
extern	byte	ReceiveState;
extern	byte	ReceiveBuffer[];	/* quoted buffer */
extern	word	ReceiveHead;
extern	word	ReceiveTail;
extern	byte	DownloadType;

/* all variables used in smc.68k */
extern	byte	WaitForXON;
extern	byte	NumOfXONs;
extern	byte	NumOfXOFFs;
extern	dword	NextBytePtr;
extern	word	NumBytesLeft;

extern	HeaderType	*CodeHeaderPtr;
extern	BootConfigType	*BootCfgPtr;
extern	HeaderType	*CfgHeaderPtr;

void	ClearRxBuffer(void);
void	ProcessCommand(void);
void GetPacket(void);
BOOL CheckPassword(char *);
word SearchRxBuffer(char	*);
word SendModemStr(char *);


#endif /* _BOOT_H_ */


