#include	<kstart.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "boot.h"

USHORT Fl1ProId;
USHORT Fl2ProId;
ULONG FlProId; /* sudha 22 Dec 1998 */

/* sudha 21 Dec 1998...
Introduced a new variable -> buswidth of ulong type to indicate whether boot
is 8 bit or 16 bit, based on which write_to_flash can be done accordingly
as byte write or word write to flash. */

extern void write_to_flash(char *src,char *dst,int num,ULONG BusWidth);

int higher_write_to_flash(char *src,char *dst,int num)
{
	unsigned long ToFlash;
	USHORT FlProdId;

/* sudha 21 Dec 1998...*/
	ULONG BusWidth = 0;
	BYTE boot_ver[10];
	BootConfigType *BootHeader;

	BootHeader = (BootConfigType *) (FL_BOOT_HDR);

/* sudha 24 March 1999. */	
	memcpy(boot_ver,BootHeader->Version, 10);

/*	printf("\n\rBoot Version is %s",boot_ver);  */
	if ((memcmp(boot_ver,"2.00.8",6) < 0) && (memcmp(boot_ver,"2.00.16",7) < 0))
		BusWidth = 1;
	else
/* sudha 24 March 1999. */	
		BusWidth = BootHeader->BootBusWidth;
/* printf("\n\rFLSHWR : Boot bus width is %lu", BusWidth); */
/* ...sudha 21 Dec 1998 */

		if (num > 512 ) return 0;   /* writes lesser than 512 bytes only */

		ToFlash = (unsigned long) dst;
		ToFlash &= 0x80000;

		if(ToFlash)      
			FlProdId = Fl2ProId;  /* it is go to the second flash */
		else
			FlProdId = Fl1ProId;

#ifdef DDDEBUG
		if(FlProdId == 0x1F5B)    /* AT29C040  512 bytes write */
			write_to_flash(src,dst,num,BusWidth);
		else {
			if(FlProdId == 0x1fA4){   /* AT29C040A   256 bytes write */
				if(num > 256){
					write_to_flash(src,dst,256,BusWidth);
					write_to_flash(src+256,dst+256,num-256,BusWidth);
				} else
					write_to_flash(src,dst,num,BusWidth);
			} else return(0);
		}
		return 1;
#endif
		if(FlProdId == 0x1FA4)
		{    /* AT29C040A  256 bytes write */
/* sudha taken from Chris 28 Dec 1998 for 16 bit hardware... */
        if (BusWidth== PROM_WIDTH_16BITS) 
		     write_to_flash(src,dst,num,BusWidth);
        else 
/* Sudha.22 March 1999.Removed the if check for PROM_WIDTH_8BITS in this else 
condition.Because if boot ver is 2.00 & not 2.00.8, buswidth var won't be 
there in the bootheader.And so, script,udb etc., won't get saved thru tftp 
with this prom of boot ver 2.00 even after upgrading the latest bin which 
supports both 8bit & 16bit. */
		  {  
/* ...sudha taken from Chris 28 Dec 1998 for 16 bit hardware */
				if(num > 256)
				{
					write_to_flash(src,dst,256,BusWidth);
					write_to_flash(src+256,dst+256,num-256,BusWidth);
				} 
				else
					write_to_flash(src,dst,num,BusWidth);
			}
		}
		else   									 /* AT29C040  512 bytes write */
				write_to_flash(src,dst,num,BusWidth);
		return 1;
}
