#include	"defs.h"
/*	$Modname: brouter.c$  $version: 1.6$      $date: 07/08/94$   */
/*
* 	$lgb$
1.0 10/30/93 ross certification version.
1.1 12/09/93 ross added new lsl.
1.2 03/26/94 ross new startup file.
1.3 04/04/94 ross removed header file, and moved CLOCK_TICKS... into this c file.
1.4 04/04/94 ross got rid of some extraneous include files.
1.5 06/13/94 ross ndis test version.
1.6 07/08/94 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1990 - 1994 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

/*----------------------------------------------------------------------------
Changes :
	{ chetan 21st July 1997
		see the comments NEW_BOOT
		Assignment the Boot Mode flag pointer done statically
		rather than dynamically }
 	{ sudha 15-Oct-1999. changed VersionDate to October 15.}
 	{ sudha 04-Oct-1999. changed VersionDate to November 04.}
 	{ sudha 12-Nov-1999. changed VersionDate to November 12.}

----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include	<softquot.h>

#include "lsl.h"
#define	byte BYTE
#define	word USHORT
#define	dword ULONG
#define	BOOL int
#include "boot.h"
#include	<rcopy.h>		/* This is for idata init */
#if EVENT_LOG
#include	<logif.h>
#endif
extern	char *rompOutSeg;

extern int	FrmRxed;
extern int	FrmTxed;
extern int StdLibInit(int,void *);

#ifdef __BORLANDC__
	#define INT03      {__emit__ (0xcc);}
	#include <conio.h>
#endif
extern enum TEST initialize_test_socket_udp (ULONG clock_ticks_per_second);
extern enum TEST initialize_test_socket_tcp (ULONG clock_ticks_per_second);
extern void	enable_wan_tx_rx(void);
extern void	EnableEthTXAndRx(int);
extern	void init_ipx_router_network(char *);
extern	int InitMicroCode(void);
extern	int IsBridgingEnabled(void);
extern	void determine_flash_types(ULONG BusWidth);

extern void calculate_crc_table (void) ;

void	enable_tx_rx(void);
#include "vrtrwstr.h"
#include <rwarebuf.h>
#include <serial.h>
extern void ChatForeground(void);
extern void do_telnet_receives(void);

ULONG code_stack_size ;
ULONG rmon_data_and_vect_table_size ;

/* NEW_BOOT */
#if 1
void *BridgeModeLoc = (void *) 0x1C10 ;
#else
void *BridgeModeLoc;
#endif
/* NEW_BOOT */

#define	SWSR 
/****************************************************************************/
#define CLOCK_TICKS_PER_SECOND 20
#if __SPEED__ == 25
#define	COUNT_50MS	1250000l
#define	COUNT_15MS	375000l
#elif __SPEED__ == 258048
#define	COUNT_50MS	1290240l
#define	COUNT_15MS	387072l
#elif __SPEED__ == 33344
#define	COUNT_50MS	1667200l
#define	COUNT_15MS	500160l
#else
&&&& - to check for null def
#endif



extern void initialize_system_timer (ULONG count_50ms, ULONG count_15ms);
extern void restore_timer (void);

extern void disable_dma (USHORT channel);
extern enum TEST initialize_dlsw_tcp_connection (void);

/* version number and date are also inside the program
the c structure for version and date are */

#pragma separate VersionDate
VersionDateType VersionDate =
{"2.10", "November 12, 1999", "ABCD"};

extern void SetErrorVec(void); /* implementation */
void operating_system (void);
/*static enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers);*/
enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers);
/****************************************************************************/
#if defined (__FLAT__) && defined (_MEMCHECK_H_)
	static void _MCCALLBACK routerware_error (char *message);
	ERF original_erf;

	extern void cdecl mcinitfp_startcheck (void);
	extern void cdecl mcexitfp_endcheck (void);
	#pragma startup mcinitfp_startcheck     16
	#pragma exit    mcexitfp_endcheck       16
#endif
/****************************************************************************/
int	InitializationDone = 0;
int	SyncRxError;
int	SyncTxError;
char *PtrToIniFile;
char *TmpPtrToIniFile;
ULONG WatchDogServiceRegister = 0xffff102f;
char ethernet_address[6] ;
void main ()
{
	HeaderType *sptr_cfg_header = (HeaderType *)FL_CFG_HDR ;
	unsigned long tmplong = (unsigned long)sptr_cfg_header->DnLdAddr ;
	ULONG available_dram ;

	ULONG BusWidth = 0; /* sudha 21 Dec 1998 */
	char *TmpCharPtr;
	int i;
	BYTE boot_ver[10];
	BootConfigType  *ptr_boot_config;

/*
	in pmain.68k we are clearing off the idata segment. we need to put the
	proper initialized values for the variables. this is kept in rompOutSeg
	segment. so we copy it into idata using rcopy. see manuals for details.
*/

	rcopy((struct hdr *) &rompOutSeg);		/* This is the idata initialization code  */
	InitializationDone = 0;

	*((BYTE *)WatchDogServiceRegister)= 0x55;
	*((BYTE *)WatchDogServiceRegister)= 0xAA;

	ptr_boot_config = (BootConfigType *)FL_BOOT_HDR;
	/*
	   First parameter  : Ram size,
	   Second parameter : Heap start
	*/
	/* StdLibInit(ptr_boot_config->RamSize - CODE_STACK_SIZE, ptr_boot_config->RamStart + CODE_STACK_SIZE); */
	StdLibInit((ptr_boot_config->RamSize - code_stack_size - rmon_data_and_vect_table_size),
	           (ptr_boot_config->RamStart + code_stack_size + rmon_data_and_vect_table_size)) ;

/* BridgeModLoc is the variable to tell whether it is warm boot or cold boot */
/* NEW_BOOT */
#if 1
#else
	BridgeModeLoc = (void *) (ptr_boot_config->RamSize + ptr_boot_config->RamStart - (64 * 1024)  - 0xC );
#endif

#ifndef SOFTWARE_QUOTING
/*  initialize the micro code */
	if (InitMicroCode() == 0)
	{
		printf("Fails to initialize microcode. Wrong version.\n");
		while(1);
	}
	printf("Microcode quoting enabled\n");
#else
	printf("Software quoting enabled\n");
#endif /* SOFTWARE_QUOTING */

/* initialize the timer */
	initialize_system_timer (COUNT_50MS, COUNT_15MS);

/* sudha 24 March 1999. */	
	memcpy(boot_ver,ptr_boot_config->Version,10);
/*	printf("\n\rBoot Version is %s",boot_ver); */
	if ((memcmp(boot_ver,"2.00.8",6) < 0) && (memcmp(boot_ver,"2.00.16",7) < 0))
		BusWidth = 1;
	else
		BusWidth = ptr_boot_config->BootBusWidth ; /* sudha 21 Dec 1998 */
/* printf("\n\rRTRWARE : Boot bus width is %lu", BusWidth); */
/* sudha 24 March 1999. */	

	determine_flash_types(BusWidth);

	if (initialize_uim_controller() == -1) 
		while(1);
	SendModemCommand();

/*  on smc there might be a modem also. So send AT and wait for Ok.if Ok 
		is recvd then modem is present else absent although it might be off.*/

	SMCForeground(TRUE);

	printf ("\r\n\r\n\r\n\r\nProxy Server Version : %s\r\n", VersionDate.Version);
	printf ("Dated : %s\r\n\r\n\r\n", VersionDate.Date);

	printf ("Copyright (C) 1996 Multi-Tech Systems, Inc.\r\n");
	printf ("Multi-Tech Systems, Inc., 2205 Woodale Drive\r\nMounds View, Minnesota 55112, USA.\r\n");

	SetErrorVec(); /* sets the cpm error vector */

	available_dram = (ptr_boot_config->RamSize - code_stack_size - rmon_data_and_vect_table_size) ;
	printf ("\n\n\rOperating with %d K DRAM for device drivers, applications and stacks\r",
	          (int) (available_dram/1024)) ;

#if 0
	printf ("Ram size : %08X, code stack size : %08X, RMON : %08X\n",
	         ptr_boot_config->RamSize,
				code_stack_size,
				rmon_data_and_vect_table_size) ;
#endif

/* All routers will be pre programmed to have a unique ethernet address. But
	this can be overridden by initalizing it in the config */

	PtrToIniFile = (char * )&lsl.port[0].rfc1213_ifEntry.ifPhysAddress;

#if PROXY_SERVER
#else
	init_ipx_router_network((char *)ptr_boot_config->EthernetAddr);
#endif

	for(i=0;i<6;i++)
		ethernet_address[i] = PtrToIniFile[i] = ptr_boot_config->EthernetAddr[i];

/* We cannot use the config file although presently uncompressed from the
	flash.this is because strtok() is used to get tokens. this puts a null
	after the token.if it is in flash it cannot write. hence we copy it into
	dram. NOTE:- if any other function uses strtok when processing the 
	configuration string this will create havoc.
*/
	PtrToIniFile = calloc(50 * 1024,1);
	if((PtrToIniFile == (char *) 0) || (PtrToIniFile == NULL))
	{
		printf("\n\r malloc failed for ini file \n\r");
		return;
	}
/* just copy the config file completely to dram */

	TmpCharPtr = (char *)tmplong;
	TmpPtrToIniFile= PtrToIniFile;
	while(*TmpCharPtr)
		(*TmpPtrToIniFile++) = (*TmpCharPtr++);

	if (initialize_nvram ((ULONG) NULL,(ULONG) PtrToIniFile) == FAIL)
	{
		printf ("\n\rNVRAM Failed to initialize properly\r\n");
		return;
	}
	free(PtrToIniFile);
		
	printf ("\n\rNVRAM Initialized\r\n");

	/* in lsl section lsl total buffer size tells about the maximum amount
	of memory that can be allocated to the different device drivers (ethernet 
	& ppp ports ). The mtu specified in the lsl section is used to caluculate
	the number of buffers that be allocated equally to all the different
	ports. lsl maintains these buffers as device driver buffers. freeing these
	and allocating is thro device_driver_free and device_driver_malloc().
	*/

	if (lsl_control (INITIALIZE_BUFFER_CLASS,(ULONG) NULL) == FAIL)
		{
		return;
		}

	printf ("Buffers Initialized\r\n");

/* Sachin 07/12/1996 */

	calculate_crc_table () ;
	init_flash_write_scheduler () ;
	printf ("Flash write scheduler initialized\n") ;

/* Sachin 07/12/1996 */

#if EVENT_LOG
	init_log();
	printf("Events log inited\n\r");
	write_log("Events log inited");
#endif

	if (initialize_routerware_software (&routerware_device_drivers[0]) == FAIL)
		{
		return;
		}

	printf ("Device Drivers Initialized\r\n");


	if (initialize_lsl (CLOCK_TICKS_PER_SECOND) == FAIL)
		{
		printf ("LSL Failed To Initialize Properly");

		return;
		}

	printf ("LSL Initialized\r\n");

	if (initialize_routerware_software (&routerware_protocol_software[0]) == FAIL)
		{
		return;
		}

	enable_tx_rx();

	operating_system ();


/*	getch ();*/
}

#ifdef SOFTWARE_QUOTING
	/* Vidy 17/10/96 */
extern		CheckAndRegainInterrupts();	/* somehow we loose ints */
#endif

/****************************************************************************/
extern ULONG old_timer_ulong, lsl_timer_ulong ;
void operating_system (void)
{
	USHORT num_of_calls = 0;
	InitializationDone = 1;

	*(ULONG *)0xff000010 = 0xFF;	/* Turn off Fail LED */
/* Sachin 20/01/1997 */
	old_timer_ulong = lsl_timer_ulong ;

	do
	{
			*( (BYTE *)WatchDogServiceRegister)= 0x55;
			*( (BYTE *)WatchDogServiceRegister)= 0xAA;
			poll_for_packet_received (TRUE);

			if(++num_of_calls == 100){

#ifdef SOFTWARE_QUOTING
			CheckAndRegainInterrupts();
#endif

			*( (BYTE *)WatchDogServiceRegister)= 0x55;
			*( (BYTE *)WatchDogServiceRegister)= 0xAA;
				SMCForeground(FALSE);
				ChatForeground();			/* 10/11/95 Sowmya */
				serial_foreground();

				do_telnet_receives();		/* 13, July, 1996, Sanjay */

				polling_timer_interrupt ();
				num_of_calls = 0;

			}

	} while (TRUE);

}
/****************************************************************************/
/*static enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers)*/
enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers)
{
	enum TEST return_code;

	while (sptr_routerware_device_drivers->fptr_initialization_function != NULL)
		{
		return_code = (*sptr_routerware_device_drivers->fptr_initialization_function) (CLOCK_TICKS_PER_SECOND);

		if (return_code == FAIL)
			{
			printf ("No function pointer FAILED\n");
			break;
			}

		++sptr_routerware_device_drivers;
		}

	return (return_code);
}
void enable_tx_rx(void)
{
#if PROXY_SERVER
	EnableEthTXAndRx(FALSE);
#else
	EnableEthTXAndRx( IsBridgingEnabled() );
#endif
}


#if PROXY_SERVER
void frame_relay_inc_ticks()
{
}
#endif

/* Brindha TCP/IP  dialout -  AG.  The  below  functions  are  present  in
   c:\rtrware\applicat\ag  itself */
#if 0
int ag_get_number_of_inbound_users (USHORT port_number)
{
   return 0 ;
}

enum BOOLEAN allot_port_to_inbound_if_required(USHORT port_number)
{
   return FALSE ;
}
#endif



