#include	<string.h>

#include	"..\..\rel\include\mctypes.h"
#include	"kaddr.h"
#include	"taddr.h"
#include	"faddr.h"

char	*Message[] = {
  "download",	/* Takes care of "Press 'd' to download..." & "Waiting for
					download" */
};

/****************************************************************************
	Routine	: SearchBuffForResp
	Function : Looks in the linear buffer -  for the 
	specified response.
****************************************************************************/
int	SearchBuffForResp(char *String, int length) 
{
	int	i,j;						
	int	Strnglen;

	if (!length)	/* Save some overhead, while waiting for responses */
		return FALSE;
	Strnglen = strlen(String);
	if (length < Strnglen)
		return FALSE;

	for(i=0; i<= (length - Strnglen); i++) {
		for (j = 0; j < Strnglen; j++) {
			if (RcvBuffer[i+j] != String[j])
				break;
		}
		if(j == Strnglen)
			return TRUE;
	}
	return FALSE;
}

int waitforMessage(int msgidx)
{
	int i = 0;

	time_ticks = 0;
	timer_on = 0;
	while(1) {
		while (((RcvBuffer[i++] = rcv_char()) != '\n') && time_ticks <= SECONDS_30) ;	
		if(time_ticks > SECONDS_30)
			return(-1);
		if (SearchBuffForResp(Message[msgidx], i) == TRUE) {
			snd_char('d');
			return(1);
		}
	}
}
		
