#include	<stdio.h>
#include <stdlib.h>
#include	<conio.h>
#include <dos.h>

#include	"..\..\rel\include\mctypes.h"
#include	"kaddr.h"
#include	"taddr.h"
#include	"faddr.h"

byte	RcvBuffer[512];
int	comport;
byte	timer_on;
/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : delay																		 */
/* PURPOSE       : To pause for sometime													 */
/* PARAMETER     : NONE																			 */ 
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void delay(void)
{
	int i=0;
	while (i++ < 1000);
}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : init_uart																	 */
/* PURPOSE       : To initialize the comport registers								 */
/* PARAMETER     : port																			 */ 
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/

int	init_uart(int	port) {
	switch (port)
	{
		case 1 : comport=0x3f8;   /*---com port 1----*/
					break;
		case 2 : comport=0x2f8;	 /*---com port 2----*/
					break;
		case 3 : comport=0x3e8;	 /*---com port 3----*/
					break;
		case 4 : comport=0x2e8;	 /*---com port 4----*/
					break;
		default:
			return (-1);
	}
	 /*------Set the MSB of the data format register----------*/
	outp(comport+3, 0x80);
	delay();
	 /*------------set the baud rate to 19200-------------*/
	outp(comport, 6);	 
	
	delay();
	/*-------------8N1-------------*/
	outp(comport+3, 3);
	delay();
	/*--------No interrupts---------*/
	outp(comport+1, 0);
	delay();
	/*--------Enable DTR and RTS------*/
	outp(comport+4, 3);
	delay();
	return(1);
}

void clear_uart_buff(void)
  {
	 int i;
	 i=inp(comport+5);
	 while (i & 1)
		{
		 inp(comport);
		 i=inp(comport+5);
		}
  }

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : chk_overrun()
/* PURPOSE       : To check whether a overrun of data has occured in UART
/* PARAMETER     : NONE
/* RETURN VALUE  : returns 1 or 0
/*-----------------------------------------------------------------------------*/
int chk_overrun(void)
{
	return(inp(comport+5) & 2);
}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : snd_char(ch)																 */
/* PURPOSE       : To send a character on the serial  line							 */
/* PARAMETER     : ch																			 */
/*                    -char																	 */
/*                    -holds the character to be sent on the serial line		 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void snd_char(byte ch)
{
    int i;
	 i=inp(comport+5);
	 while (!(i & (1 << 5)))    /*---while transmitter buffer is not empty----*/
		 i=inp(comport+5);
	 outp(comport, (int)ch);
}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : quote_and_snd(ch)														 */
/* PURPOSE       : To send a character on serial line with quoting if necessary*/
/* PARAMETER     : ch																			 */
/*                   -holds the character to be sent									 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void quote_and_snd(byte ch)
  {
    switch((byte) ch)
		{ 
		  case (byte)0x7e : /*-----ch='~'-----*/
		                    snd_char((byte)0x7d);
								  snd_char((byte)0x5e);
								  break;
		  case (byte)0x7d : snd_char((byte)0x7d);
								  snd_char((byte)0x5d);
								  break;
		  case (byte)0x13 : snd_char((byte)0x7d);
		                    snd_char((byte)0x33);
								  break;
		  case (byte)0x11 : snd_char((byte)0x7d);
		                    snd_char((byte)0x31);
								  break;
		  case (byte)0x93 : snd_char((byte)0x7d);
		                    snd_char((byte)0x93^0x20);
								  break;
		  case (byte)0x91 : snd_char((byte)0x7d);
		                    snd_char((byte)0x91^0x20);
								  break;
		  default          :snd_char((byte)ch);
								  break;
		 }
 }

void	send_packet(char *packet, word length)
{
	word	i;
	int crc=0xffff;
	byte c[4];
	snd_char((byte)0x7e);   /*-----send the quote character------*/
	/* send some 4 byte junk (BridgeId) */
	for( i=0; i< 4; i++) {
		quote_and_snd(c[i]);
		crc=updcrc(c[i], crc);
	}

	/* now send the packet */
	for (i=0; i< length; i++) {
		quote_and_snd(packet[i]);
		crc=updcrc(packet[i], crc);
	}
	crc=updcrc(0, updcrc(0, crc));
	quote_and_snd((byte)((crc >> 8) & 0xff)); /*---send higher byte of crc----*/
	quote_and_snd((byte)(crc & 0xff));        /*---send lower byte of crc---*/  
	snd_char((byte)0x7e);							  /*---send quote character----*/
}
		

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_char1()																	 */
/* PURPOSE       : To receive a character													 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
char rcv_char1(void)
{
    int i;
	 i=inp(comport+5);
	 time_ticks=0;
	 /*------Here timeout is for the each character--------- */
	 /*------while receive buffer is empty and not timed out--------*/
	 while (!(i & 1) && time_ticks <= SECONDS_4)
	     i=inp(comport+5);
	 if (time_ticks > SECONDS_4) 
		return((char) 0);
	 else
	   return( (char)inp(comport) );  
}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_char()																	 */
/* PURPOSE       : To receive a character													 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
char rcv_char0(void)
{
    int i;
	 i=inp(comport+5);
	 /*------Here timeout is for the entire message--------- */
	 /*------while receive buffer is empty and not timed out--------*/
	 while (!(i & 1) && time_ticks <= SECONDS_30)
	     i=inp(comport+5);
	 if (time_ticks > SECONDS_30) 
		return ((char)0);
	 else
	   return( (char)inp(comport) );  
}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_char()																	 */
/* PURPOSE       : To receive a character													 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
char rcv_char()
  {
    char (*rcv_fns[2])()={rcv_char0, rcv_char1};
	 return((*rcv_fns[timer_on])());
  }
		
/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_packet(pkt_data, pkt_size)										 */
/* PURPOSE       : To receive a packet of length pkt_size.							 */
/* PARAMETERS    : pkt_data																	 */
/*                    -pointer to an array of bytes									 */
/*                    -acts like a buffer for the data to be received			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
int recv_packet(void)
{
	int i=0;
	int crc=0xffff;
	byte ch;

	timer_on = 1;	
	/*---while the received character is not 7e or not timed out do------*/
	while ( (rcv_char()!=(byte)0x7e) && time_ticks <= SECONDS_4)
	{
		;
	}
	if (time_ticks < SECONDS_4)	{
		/*-----7e received------*/
		if (chk_overrun()) {
			printf("over run\n");
			return(-1);
		}
		while (1)  /*----receive packet-----*/
		{
			ch=rcv_char();
			if(time_ticks > SECONDS_4)
				goto timeout;
			if (ch == (byte)0x7e)
				break;
			if (ch==(byte)0x7d) {
				ch=rcv_char();
				if(time_ticks > SECONDS_4)
					goto timeout;
				ch=(byte)((int)ch ^ 0x20);  /*---unquote ch----*/
			}
			crc=updcrc(ch, crc);
			RcvBuffer[i++] = ch;
			if (chk_overrun()) {
				printf("over run\n");
				return(-1);
			}
		}
		if (crc) {
			printf("Crc Error\n"); 
			return(-1);
		}
		return(crc);
	}
timeout:
	printf("\nNo response from target.\n");	
	return(-1);
}
/*-----------------------------------------------------------------------------*/

	
		
