/* This program will be creating BIN's for download to a motorola chip based
** box (read "big-endian"). So take care of byte-endian issues when writing
** stuff to the BIN.
*/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <conio.h>
#include <stddef.h>

#include "bootimg.h"

char read_buf[4096];

int main(int argc, char *argv[])
{
	char ch;
	int nread, n;
	FILE *dfp, *sfp1, *sfp2;
	unsigned long BootCodeSize, BootCodeStartOffset;
	char *boot_changer, *boot_file, *final_boot_image;


	puts("Boot Image Creator (for Multi-Tech Router products), Version 1.00");
	puts("Copyright Multi-Tech Systems, Inc.");
	puts("(For internal use only)\n");

	if (argc < 2)
	{
		puts("USAGE: bootimg <boot_image_file> <new_boot_file> [<boot_changer_code>]");
		puts("       <boot_image_file>   - name of the final boot image");
		puts("       <new_boot_file>     - name of the new boot binary file");
		puts("       <boot_changer_code> - (optional) name of boot modifier code;");
		puts("                             defaults to BOOTCHG.BIN");
		puts("\nUse this program to prepare a new boot image for download to Multi-Tech's Router");
		return 1;
	}

	if (argc > 4)
		puts("WARNING: Ignoring extra parameters");

	final_boot_image = argv[1];
	boot_file = argv[2];
	if (argc >= 4)
		boot_changer = argv[3];
	else
		boot_changer = "BOOTCHG.BIN";

	dfp = fopen(final_boot_image, "rb");
	if (dfp != NULL)
	{
		fclose(dfp);

		printf("WARNING: %s already exists, overwrite(y/n)?", final_boot_image);
		ch = getch();
		do {
			ch = toupper(ch);
			if (ch == 'Y' || ch == 'N')
				break;
		} while (ch = getch());

		if (ch == 'N')
		{
			return 3;
		}
	}
	putchar('\n');

	dfp = fopen(final_boot_image, "wb");
	if (dfp == NULL)
	{
		printf("ERROR: Unable to create or overwrite %s\n", final_boot_image);
		return 3;
	}

	sfp1 = fopen(boot_changer, "rb");
	if (sfp1 == NULL)
	{
		printf("ERROR: %s does not exist\n", boot_changer);
		remove(final_boot_image);
		fclose(dfp);
		return 2;
	}

	sfp2 = fopen(boot_file, "rb");
	if (sfp2 == NULL)
	{
		printf("ERROR: %s does not exist\n", boot_file);
		remove(final_boot_image);
		fclose(sfp2);
		fclose(dfp);
		return 2;
	}

	while (nread = fread(read_buf, sizeof(char), sizeof(read_buf), sfp1))
	{
		fwrite(read_buf, sizeof(char), nread, dfp);
	}
	BootCodeStartOffset = ftell(sfp1);
	fclose(sfp1);
	while (nread = fread(read_buf, sizeof(char), sizeof(read_buf), sfp2))
	{
		fwrite(read_buf, sizeof(char), nread, dfp);
	}
	BootCodeSize = ftell(sfp2);
	fclose(sfp2);

	fclose(dfp);	/* Write out everything to disk */


	/* Re-open the file and check file size etc and put into the image */
	dfp = fopen(final_boot_image, "r+b");
	if (dfp == NULL)
	{
		puts("ERROR: Unknown error occured...exiting");
		return 4;
	}

	n = offsetof(BOOT_IMAGE_HEADER, NewBootSize);
	fseek(dfp, n, SEEK_SET);
	BootCodeSize = SwapLong(BootCodeSize);
	fwrite(&BootCodeSize, sizeof(BootCodeSize), 1, dfp);
	BootCodeStartOffset = SwapLong(BootCodeStartOffset);
	fwrite(&BootCodeStartOffset, sizeof(BootCodeStartOffset), 1, dfp);
	fclose(dfp);

	printf("%s created.", final_boot_image);

	return 0;
}

