typedef struct {
	char Version[8];					/* Version number string */
	char Date[24];						/* Date string */
	char IDString[16];				/* The ID string "ABCD" */
	unsigned long NewBootSize;		/* Size of the new boot code - reqd to know how much to write to flash */
	unsigned long NewBootStartAddr;/* Where from the boot code starts in the combined bootchg-newboot file */
} BOOT_IMAGE_HEADER;


#define SwapLong(swap_var)			((((unsigned long)swap_var >> 24) & 0x000000FFL) | \
											 (((unsigned long)swap_var << 24) & 0xFF000000L) | \
											 (((unsigned long)swap_var >>  8) & 0x0000FF00L) | \
											 (((unsigned long)swap_var <<  8) & 0x00FF0000L))
