/***************************************************************************
	DOWNLDR.C - file handling the download funtions
***************************************************************************/


#include	"..\include\mctypes.h"
#include	"..\include\boot.h"
#include	"..\include\downldr.h"
#include	"..\include\quote.h"
#include	"..\include\utils.h"
#include	"..\include\lzwx.h"

#define MAX_SEQ_NUM 128		/* number of PROM pages */
extern void	printstr (byte *) ;

/* important addresses in the DRAM */
byte *FlashPromBuf ; /* Buffer to save pkts till required length of info is got */

/* Error counters and timeout flags */
word	TotErrorCnt;		/* Cumulative error count */
byte	TimeoutOccured;
byte	GblTimeOut;			/* a global incremented in timeout PIT isr */
								/* when exceeds MAX val download is aborted */

word (*StateHandler[2])();	/* DownLoader state handlers */
byte	DownLdrState;
byte	CurSeqNum;
word	NextCodePage ;		/* offset of next code page to burn .*/
word	NumPktsSaved;		/* number of pkts saved in the Flash Buffer */

HeaderType	HeaderPkt;

byte	ReceiverEnabled ;		/* To stop the buffer overwriting */

byte	ProcessBuffer[RCV_BUF_SIZE];
byte	TmpBuffer[2048];	
byte	ResponseBuffer[2048];	/* quoted response buffer */

extern void TransmitCnt (byte *, word) ;
extern WriteToFlash (char *, char *, word) ;
extern void Execute (byte *) ;
extern void UpdateGlobalCRC (byte *Pkt, dword length) ;
extern int higher_write_to_flash (char *src, char *dst, int num) ;
extern BOOL CheckCRC (byte *Pkt, dword Length, word *CRCPtr) ;
extern word	GlobalCRC ;

extern void StartTimer (word timeout) ;
extern void StopTimer (void) ;
extern void ResetTimer (word timeout) ;

void SmallDelay (void) 
{
	int i = 512 ;
	while (i)
		i -- ;
}

void DownLoadNewInfo (void)
{
	word ret_val ;

	GlobalCRC = 0xffff ;
	TotErrorCnt = 0 ;			/* reset the counters */
	GblTimeOut = 0 ;
	CurSeqNum = 0 ;
	NumPktsSaved = 0 ;
	NextCodePage = 0 ;
	DownLdrState = STATE_WT_HDR ;

	StartTimer (TMOUT_VAL) ;
	while (GblTimeOut <= 3)
	{
		if (GetPacket())
		{
			StopTimer() ;				/* We got a packet so stop timer & start */
			GblTimeOut = 0 ;			/* packet has come,reset timeout counter */

			if (!CheckCRC (ProcessBuffer, (dword) ReceiveIndex, 0))
			{ 	/* Is the packet CRC OK */
				if (ProcessErrorRcv() == STOP_DNLD)
				{	/* if not OK send NACK */
					return ;				/* if err count too much stop */
				}
				else
				{
					StartTimer (TMOUT_VAL) ;
					continue ;
				}
			}
			/* If the previous packet comes again, send an ACK since it has 
			already been processed */
			if (((DnLdPktHdrType *) ProcessBuffer)->SeqNum == (CurSeqNum - 1))
			{
				CurSeqNum -- ;
				SendNACKorACK (PT_ACK) ;
			}
			else
			{
				ret_val = (*StateHandler[DownLdrState])() ;
				if (ret_val == STOP_DNLD)
					return ;
			}
			StartTimer (TMOUT_VAL) ;
		}
		else
			if (TimeoutOccured)
			{
				/* clear the receive buffer to receive a new packet */
				ReceiveState = RECV_7E ;
				SendNACKorACK (PT_NACK) ;
				ResetTimer (TMOUT_VAL) ;	  
			}
	}
	ResetTimer (TMOUT_VAL) ;
	while (!TimeoutOccured) ;
	StopTimer() ;
	if (GblTimeOut) 
    	AbortDownLoad (ERR_TMOUT) ;

	return ;
}

word ProcessErrorRcv(void)
{
	TotErrorCnt++;
	if (TotErrorCnt >= MAX_TOT_ERR)
	{
    	AbortDownLoad (ERR_MAX_ERR) ;
		return STOP_DNLD ;
	}
	SendNACKorACK (PT_NACK) ;
	return CONT_DNLD ;
}

/* This is state handler 0 */
word ProcessHeader (void)		
{
	DnLdHeadType *Header ;

	/* Has the proper packet come */
	switch (((DnLdPktHdrType *) ProcessBuffer)->PacketType)
	{
		case PT_HEADER :  
			if (((DnLdPktHdrType *) ProcessBuffer)->SeqNum == CurSeqNum)
			{
				/* Some of the fields come in the Header & rest in EOF struct */
				Header = (DnLdHeadType *) (ProcessBuffer + sizeof (DnLdPktHdrType)) ;
				if (Header->DnLdAddr < FL_SYSTEM_CFG)
				{
					AbortDownLoad (ERR_CODE_SAVE) ;
					return STOP_DNLD ;
				}
				memcpy (HeaderPkt.Version, Header->Version, 10) ;
				memcpy (HeaderPkt.DateStamp, Header->DateStamp, 25) ;
				HeaderPkt.MagicNum = Header->MagicNum ;
				HeaderPkt.DnLdAddr = Header->DnLdAddr ;
				if (DownloadType == DNLD_CODE)
				{
					HeaderPkt.LoadAddr = Header->LoadAddr ;
					HeaderPkt.StartAddr = Header->StartAddr ;
				}
				DownLdrState = STATE_WT_DATA ;
				/* Header is in a separate page */
				SendNACKorACK (PT_ACK) ;
				return CONT_DNLD ;
			}
			break ;

		case PT_ABORT :
			if (((DnLdPktHdrType *) ProcessBuffer)->SeqNum == CurSeqNum)
			{
	     		StopDownLoad() ;
				return STOP_DNLD ;
			}
			break ;

		default :
  			AbortDownLoad (ERR_INV_PKT) ;
			return STOP_DNLD ;
	}
  	AbortDownLoad (ERR_SEQ_NUM) ;
	return STOP_DNLD ;
}

word ProcessData (void)
{
	byte *PktPtr ;
	word PktLen ;
	int i ;

	switch (((DnLdPktHdrType *) ProcessBuffer)->PacketType)
	{
		case PT_DATA : 
			if (((DnLdPktHdrType *) ProcessBuffer)->SeqNum == CurSeqNum)
			{
				PktPtr = (byte *) (ProcessBuffer + sizeof (DnLdPktHdrType)) ;
				PktLen = ReceiveIndex - sizeof (DnLdPktHdrType) - 2 ; /* 2 for CRC */
				
				UpdateGlobalCRC (PktPtr, (dword) PktLen) ;
				/* If PktLen >= PAGE_SIZE, burn the code, else wait till PAGE
				length or End of File Pkt */
				if (PktLen < FL_PAGE_SIZE)
				{
					memcpy ((byte *) (FlashPromBuf + NumPktsSaved * DNLD_PKT_SIZE),
																				PktPtr, PktLen) ;
					INC_CIR_IDX (NumPktsSaved, PKTS_PER_PAGE) ;
					if (NumPktsSaved)
					{	
						/* wait here for some time and then send ACK */
						for (i = 0 ; i < 8 ; i ++)
							SmallDelay() ;
						SendNACKorACK (PT_ACK) ;
						return CONT_DNLD ;	
					}
					else
					{	/* last pkt for the page */
						PktPtr = (byte *) FlashPromBuf ;
						PktLen = FL_PAGE_SIZE ;
					}
				}

				if (CopyToFlash (PktPtr, (dword) PktLen))
				{
					SendNACKorACK (PT_ACK) ;
					return CONT_DNLD ;
				}
				else
				{
   				AbortDownLoad (ERR_CODE_SAVE) ;
					return STOP_DNLD ;
				}		
			}
			break ;

		case PT_EOF :
			if (((DnLdPktHdrType *) ProcessBuffer)->SeqNum == CurSeqNum)
			{
				ProcessEOF() ;
				return STOP_DNLD ;
			}
			break ;

		case PT_ABORT :
			if (((DnLdPktHdrType *) ProcessBuffer)->SeqNum == CurSeqNum)
			{
				StopDownLoad() ;
				return STOP_DNLD ;
			}
			break ;

		default :
    		AbortDownLoad (ERR_INV_PKT) ;
			return STOP_DNLD ;
	}
   AbortDownLoad (ERR_SEQ_NUM) ;
	return STOP_DNLD ;
}

void ProcessEOF (void)
{
	DnLdEOFType	*EndOF ;

	EndOF = (DnLdEOFType *) (ProcessBuffer + sizeof (DnLdPktHdrType)) ;
	HeaderPkt.CodeLength = EndOF->CodeLength ;
	HeaderPkt.CRC = EndOF->CRC ;

	/* The received code CRC does not match what we calculated so don't save */
	GlobalCRC = updcrc ((EndOF->CRC & 0xFF00) >> 8, GlobalCRC) ;
	GlobalCRC = updcrc ((EndOF->CRC & 0x00FF), GlobalCRC) ;
	if (GlobalCRC)
	{
	  	AbortDownLoad (ERR_DNLD) ;
		return ;
	}
	/* if some pkts are waiting to be written, write them */
	if (NumPktsSaved) 
		if (!CopyToFlash ((byte *) FlashPromBuf, (dword) ((dword) NumPktsSaved * DNLD_PKT_SIZE))) 
			AbortDownLoad (ERR_CODE_SAVE) ;

	/* wait here for some time and then send ACK */
	SmallDelay() ;
	SmallDelay() ;
	/* Burn the header and */
	if (CopyToFlash ((byte *) &HeaderPkt, sizeof (HeaderPkt)))
	{
		SendNACKorACK (PT_ACK) ;
		*((byte *) BOOT_MODE_LOCATION_IN_RAM) = 0 ;
	}
	else
	  	AbortDownLoad (ERR_CODE_SAVE) ;
}

/* When an invalid packet comes from the UI, target Aborts the download */
void AbortDownLoad (byte ErrVal)
{
	StopTimer() ;
	if (ErrVal)
		SendErrorAbort (ErrVal) ;
}

/* When an ABORT is inititated from the UI */
void StopDownLoad (void)
{
	StopTimer() ;
}


void SendNACKorACK (byte NackOrAck)
{

	word PktLen ;

	/* Form the packet. Calculate CRC. Quote and send */
	((DnLdPktHdrType *) TmpBuffer)->PacketType = NackOrAck ; /* PT_ACK or PT_NACK */
	((DnLdPktHdrType *) TmpBuffer)->SeqNum = CurSeqNum ;
	PktLen = sizeof (DnLdPktHdrType) ;
	AddCRC (TmpBuffer, (dword) PktLen) ;
	PktLen = Quote ((byte *) TmpBuffer, (byte *) ResponseBuffer + 1,
																				PktLen + 2) ;
	ResponseBuffer[0] = ResponseBuffer[PktLen+1] = FRAME_DELIM ;
	PktLen += 2 ;
	TransmitCnt (ResponseBuffer, PktLen) ;

	/* If ACK */
	/* Wait for next sequence num */
	/* else if NACK */
	/* wait for the same sequence num */
	if (NackOrAck == PT_ACK)
		INC_CIR_IDX (CurSeqNum, MAX_SEQ_NUM) ;
}


void SendErrorAbort (byte ErrVal)
{
	word PktLen ;

	/* Form the packet. Calculate CRC. Quote and send */
	((DnLdPktHdrType *) TmpBuffer)->PacketType = PT_ABORT ;
	((DnLdPktHdrType *) TmpBuffer)->SeqNum = CurSeqNum ;
	PktLen = sizeof (DnLdPktHdrType) ;
	*(TmpBuffer + PktLen) = ErrVal ;		/*  In Pkt Data */
	AddCRC (TmpBuffer, (dword) (PktLen + 1)) ;
	PktLen = Quote ((byte *) TmpBuffer, (byte *) ResponseBuffer + 1,
																				PktLen + 2 + 1) ;
	ResponseBuffer[0] = ResponseBuffer[PktLen+1] = FRAME_DELIM ;
	PktLen += 2 ;
	TransmitCnt (ResponseBuffer, PktLen) ;
	/* Wait for next sequence num */
	INC_CIR_IDX(CurSeqNum, MAX_SEQ_NUM) ;	
}

word	Fl1ProId;
word	Fl2ProId;

#if 0

int higher_write_to_flash (char *src, char *dst, int num)
{
	unsigned long ToFlash ;
	word FlProdId ;

	if (num > 512 )
		return 0 ;   /* writes max 512 bytes only */

	ToFlash = (unsigned long) dst ;
	ToFlash &= 0x80000 ;

	if (ToFlash)      
		FlProdId = Fl2ProId ;  /* it is go to the second flash */
	else
		FlProdId = Fl1ProId ;

	if (FlProdId == 0x1F5B)
	{    /* AT29C040  512 bytes write */
		WriteToFlash (src, dst, num) ;
	}
	else
	{
		if (FlProdId == 0x1fA4)
		{   /* AT29C040A   256 bytes write */
			if (num > 256)
			{
				WriteToFlash (src, dst, 256) ;
				WriteToFlash (src + 256, dst + 256, num - 256) ;
			}
			else
				WriteToFlash (src, dst, num) ;
		}
		else
		{
			return 0 ;
		}
	}

	return 1 ;
}
#else
/* Now we assume that the only type of flash that we support is
Atmel 29c040A */
int higher_write_to_flash (char *src, char *dst, int num)
{
	if (num > 512 )
		return 0 ;   /* writes max 512 bytes only */
	WriteToFlash (src, dst, num) ;
	return 1;
}
#endif

word BurnCode (byte *to, byte *from, dword len)
{
	word NumOfPages, i ;
	word Offset ;

	if ((len % FL_PAGE_SIZE))
		NumOfPages =  (word) (len / FL_PAGE_SIZE) + 1 ;
	else
		NumOfPages = (word) (len / FL_PAGE_SIZE) ;

	if (NumOfPages)
	{
		for (i = 0 ; i < (NumOfPages - 1) ; i ++)
		{
			Offset = i * FL_PAGE_SIZE ;
			higher_write_to_flash ((char *) (from + Offset),
									(char *) (to + Offset), FL_PAGE_SIZE) ;
		}

		/* Last page may not be full */
		Offset = i * FL_PAGE_SIZE ;
		higher_write_to_flash ((char *) (from + Offset),
									(char *) (to + Offset), len - Offset) ;
		NextCodePage += NumOfPages ;
		return TRUE ;
	}
	return FALSE ;
}


word CopyToFlash (byte *from, dword len) 
{
	byte *to ;

	if (from == (byte *) &HeaderPkt)
	{
		switch (DownloadType)
		{
			case DNLD_CODE :
				to = (byte *) CodeHeaderPtr ;
				break ;

			case DNLD_CFG :
				to = (byte *) CfgHeaderPtr ;
				break ;
		}
	}
	else 
		to = (byte *) (HeaderPkt.DnLdAddr + (dword) (NextCodePage) * FL_PAGE_SIZE) ;

	return (BurnCode (to, from, len)) ;
}


void ExpandAndLocate (void)
{
	LZWexpand ((byte *) CodeHeaderPtr->DnLdAddr,
		(byte *) CodeHeaderPtr->LoadAddr,
			(unsigned long) CodeHeaderPtr->CodeLength) ;
	Execute ((byte *) CodeHeaderPtr->StartAddr) ;
}
