/* LZVX.C -- LZW De-compression with variable number of bits.
** From code by Hemanth M.C. (Windows 95 Remote Control Project)
*/

#include "..\include\mctypes.h"
#include "lzv.h"
#include "lzvx.h"

/* Globals */
unsigned next_code;
unsigned next_bump_code;
unsigned current_code_bits;

/* #pragma separate decode_stack chetan 3/7/97 */
unsigned char decode_stack[TABLE_SIZE];

struct dictionary *dict_array[TABLE_BANKS];

extern void memcpy (byte *dest, byte *src, word count) ;
extern void ResetSWSR (void) ;

/* Local Prototypes */
unsigned InputBits(struct BitBufIndex *buffer, unsigned bit_length);
int InitializeStorage(void);
void InitializeDictionary(void);
unsigned decode_string(unsigned count, unsigned code);
int LZ15VExpandBuf(byte *lpCompData, int wCompLen, byte *lpOutputData, int wOutputLen);
int LZWexpand(byte *input, byte *output, dword totalpackedsize);

unsigned InputBits (struct BitBufIndex *buffer, unsigned bit_length)
{
	unsigned bits, byte_length ;

	bits = 0 ;
	while (buffer->bit_offset + bit_length > 8)
	{
		byte_length = 8 - buffer->bit_offset;
		bits <<= byte_length;
		bits |= *buffer->index & ( (1 << byte_length) - 1 );
		bit_length -= byte_length;
		buffer->bit_offset = 0;
		buffer->index++;
		buffer->length--;
	}
	bits <<= bit_length;
	bits |= (*buffer->index >> (8 - bit_length));
	buffer->bit_offset += bit_length;
	return bits;
}

/* chetan 3/7/97 */
/* #pragma separate DictStorage
byte DictStorage[TABLE_BANKS * 256 * sizeof(struct dictionary)]; */
byte *DictStoragePtr ;

int InitializeStorage()
{
	unsigned long i ;
	unsigned long *DPtr ;

/*	i = sizeof(DictStorage) / 4; */
	i = (TABLE_BANKS * 256 * sizeof (struct dictionary)) / 4 ; /* get size in longs */

/*	DPtr = (unsigned long *) DictStorage ; */
	DPtr = (unsigned long *) DictStoragePtr ;

	while (i--)
		*DPtr++ = 0L;

	return 1;
}


void InitializeDictionary()
{
	unsigned i;

	for (i = 0; i < TABLE_SIZE; i++)
		DICT(i).code_value = UNUSED;

	next_code = FIRST_CODE;

	current_code_bits = 9;
	next_bump_code = 511;
}

unsigned decode_string (unsigned count, unsigned code)
{

	while (code > 255)
	{
		decode_stack[count++] = DICT(code).character;
		code = DICT(code).parent_code;
	}
	decode_stack[count++] = (unsigned char)code;
	return count;
}

int LZ15VExpandBuf(byte *lpCompData, int wCompLen,	byte *lpOutputData, int wOutputLen)
{
	unsigned new_code;
	unsigned old_code;
	unsigned character;
	unsigned count;
	struct BitBufIndex input_buf;
	unsigned char *output_ix;
	unsigned output_count;

	output_ix = lpOutputData;
	output_count = wOutputLen;
	input_buf.index = (unsigned char *) lpCompData ;
	input_buf.length= wCompLen;
	input_buf.bit_offset = 0;
	
	if (InitializeStorage() == 0)
		return 0;

	for (;;)
	{
		InitializeDictionary();
		old_code = InputBits(&input_buf, current_code_bits);
		if (old_code == END_OF_STREAM)
			goto ReturnOutputLength;
		character = old_code;
		*output_ix++ = (unsigned char)old_code;
		output_count--;
		for (;;)
		{
			new_code = InputBits(&input_buf, current_code_bits);
			if (new_code == END_OF_STREAM)
				goto ReturnOutputLength;
			if (new_code == FLUSH_CODE)
				break;
			if (new_code == BUMP_CODE)
			{
				current_code_bits++;
				continue;
			}
			if (new_code >= next_code)
			{
				decode_stack[0] = (unsigned char)character;
				count = decode_string(1, old_code);
			}
			else
			{
				count = decode_string(0, new_code);
			}
			character = decode_stack[count - 1];
			while (count > 0 && output_count > 0)
			{
				*output_ix++ = decode_stack[--count];
				output_count--;
			}
			if (count > 0) 
			{
				goto ReturnError;
			}
			DICT(next_code).parent_code = old_code;
			DICT(next_code).character   = (unsigned char)character;
			next_code++;
			old_code = new_code;
		}
	}

ReturnError:
	return 0;

ReturnOutputLength:
	return wOutputLen - output_count;
}

/***************************************************************************
	This is a frontend function added to the lzwx functions. (vidy)
	The Compressed data is arranged as records of
	{
		short Length;
		byte	CompressedData[<Length bytes>]
		....
	}
****************************************************************************/

void CompressorInit (void)
{
	dword index ;

	next_code = next_bump_code = current_code_bits = 0 ;

	for (index = 0 ; index < TABLE_SIZE ; index ++)
		decode_stack[index] = 0 ;

	for (index = 0 ; index < TABLE_BANKS ; index ++)
	{
		/* chetan 3/7/97 */
		dict_array[index] = /* (struct dictionary *) */ (dword) 
						((dword) DictStoragePtr +
							(dword) (index * 256 * sizeof (struct dictionary))) ;
		/*		dict_array[index] = (struct dictionary *)
 				(&DictStorage[index*256*sizeof(struct dictionary)]); */
	}
}

int LZWexpand (byte *input, byte *output, unsigned long totalpackedsize)
{
	short CurCount, NxtCount;
	byte *CurSrcPtr, *NxtSrcPtr, *TargetPtr;
	int	ExpandedSize;
	dword	TotalCompressedSize;

	CompressorInit();

	NxtSrcPtr = input + sizeof(CurCount);
	NxtCount = *(short *) input;
	TargetPtr = output;
	TotalCompressedSize = totalpackedsize;

	while(TotalCompressedSize)
	{
		ResetSWSR() ; /* Do this else Router may reset due to SWT timeout */
		
		CurSrcPtr = NxtSrcPtr;
		CurCount = NxtCount;

		if (NxtCount < 0)
			NxtSrcPtr += (-NxtCount) + sizeof(CurCount);
		else
			NxtSrcPtr += NxtCount + sizeof(CurCount);

		NxtCount = *(short *)(NxtSrcPtr - sizeof(CurCount));
		if (CurCount < 0)
		{
			ExpandedSize = (int)-CurCount;
			memcpy(TargetPtr, CurSrcPtr, ExpandedSize);
			TotalCompressedSize -= (-CurCount + sizeof(CurCount));
		}
		else
		{
			ExpandedSize = LZ15VExpandBuf(CurSrcPtr, CurCount, TargetPtr, MAX_EXPAND_SIZE);
			TotalCompressedSize -= (CurCount + sizeof(CurCount));
		}
		TargetPtr += ExpandedSize;		/* increment TargetPtr for next iteration */
	}
	return TRUE;
}
