#define CODE_START_ADDRESS	0x2000L

/* Abs address 0 has following layout */
typedef struct AbsZeroLayout
{
	int InitSP ;			/* SP at startup time */
	int InitPC ;			/* PC at startup time */
	byte *BootCode ;  	/* Start of boot code */
} ABS_ZERO_LAYOUT ;

/* Format of header in the bootchg.bin file. This is put init-ed by an 
** external program.
*/
typedef struct BootChgHdr 
{
	char Version[8] ;			/* Version number string */
	char Date[24] ;				/* Date string */
	char IDString[16] ;		/* The ID string "ABCD" */
	int NewBootSize ;			/* Size of the new boot code - reqd to know how much to write to flash */
	byte *NewBootStartAddr ;	/* Where from the boot code starts in the combined bootchg-newboot file */
} BOOT_CHG_HDR ;


/* Prototypes for functions in BOOTCHG.C */
void main (void) ;
