/***************************************************************************
	File	:	downldr.h
****************************************************************************/

#define BOOT_MODE_LOCATION_IN_RAM 0x1C10
/* Size of download packets ( only data) received on SMC */
#define DNLD_PKT_SIZE 1024
#define RCV_BUF_SIZE (1024 * 2)

/* Download parameters - Timeouts*/
#define	TMOUT_VAL			0xff	/* 5 Secs Time out to wait for any packet */
#define	MDM_RESP_TIMEOUT	0x20	/*  around 2 seconds */

/* Download parameters - Max Error*/
#define	MAX_CUR_ERR			5
#define	MAX_TOT_ERR			25

/* funtion return values */
#define	STOP_DNLD			0
#define	CONT_DNLD			1

/* return values to the booter UI */
#define	NO_ERR				0
#define	ERR_DNLD				1		/* an error during download */
#define	ERR_TMOUT			2		/* timeout occured during download */
#define	ERR_MAX_ERR			3		/* total error count exceeds max val */
#define	ERR_CODE_SAVE		4		/* error while flashing code in PROM */
#define	ERR_NO_MEM			5		/* not enough FLASH to store code */
#define	ERR_SEQ_NUM			6		/* wrong sequence number packet */
#define	ERR_INV_PKT			7		/* unknown packet type */


#define	STATE_WT_HDR		0
#define	STATE_WT_DATA		1

	/* Packet format of all Download packets 
   +----+------+------+----+----+----+----+----+----+----+-...-----+----+----+
   | 7e | Type | Seq# |  Pkt data    |   CRC   | 7e |
   +----+------+------+----+----+----+----+----+----+----+-...-----+----+----+
   CRC is calculated from Type. These pkts do not have SMC header */

#define	MIN_PACKET_SIZE	(2+2)
typedef struct tagDnLdPktHdr {
	byte	PacketType;
	byte	SeqNum;
} DnLdPktHdrType;

/* Packet types */
#define	PT_UNKNOWN	0
#define	PT_HEADER	1		/* download header type - from UI */
#define	PT_DATA		2		/* download data pkt - from UI */
#define	PT_ABORT		3		/* abort download pkt - from UI and Target */
#define	PT_EOF		4		/* endof download packet - from UI */
#define	PT_NACK		5		/* negative ack - from Target */
#define	PT_ACK		6		/* positive ack - from Target */
#define	PT_TMOUT		7		/* Timeout packet - from Target */
#define	PT_INFO		8		/* Info req./response - from UI and Target */

/* Header Pkt for all downloads. */
typedef	struct
{
	byte Version[10] ;		/* 0 .. 9 	version number as ASCIIZ */
	byte DateStamp[25] ;		/* 10.. 34	date as ASCIIZ */
	byte Dmy[3] ;				/* 35..37 */
	word MagicNum ;			/* 38.. 39 */
	dword LoadAddr ;			/* 40.. 43	Address to start loading at */
	dword	StartAddr ;			/* 44.. 47	Address to start execution at */
	dword DnLdAddr ;			/* 48.. 51	Address where compressed code is put */
/*	byte	FlashWrite;	*/		/* 52	whether write is into FLash or DRAM */
	byte Reserved[21] ;		/* 53.. 72	for future use */
} DnLdHeadType ;

/* EOF pkt for all download types */
typedef struct
{
	dword	CodeLength ;			/* 0..3		Valid length of compressed code */
	word CRC ;					/* 4..5		16bit CRC value */
	byte Reserved[22] ;		/* 6..27		for future use */
} DnLdEOFType ;
	
typedef struct {
	byte	Version[10];		/* version number of this record ASCIIZ */
	byte	BootPort;			/* which port to use */
	dword	FlashPromSize;		/* System related information */
	dword	RamSize;
	dword	RamStart;
	word	DnLdPktSize;
	word	DnLdTmout;
	word	DnLdMaxTries;
}BootInfoType;

extern	byte	ProcessBuffer[];
extern	byte	ResponseBuffer[];
extern	byte	TmpBuffer[];

extern	byte	TimeoutOccured;
extern	byte	ReceiverEnabled ;

extern	byte	*FlashPromBuf;
extern	byte	ModemPresentAndOffline;

extern	word	(*StateHandler[])();

void	DownLoadNewInfo();
word	ProcessErrorRcv(void);
word 	ProcessHeader(void);
word 	ProcessData(void);
void 	ProcessEOF(void);
void	AbortDownLoad(byte);
void SendNACKorACK (byte);
void	Update(void);
void	SendErrorAbort(byte);
word	BurnCode(byte *, byte *, dword);
void	StopDownLoad(void);
void  ExpandAndLocate(void);
word	CopyToFlash(byte *, dword);


