*************************************************************************
*                                                                       *
*                       a360def.h                                       *
*                                                                       *
*                       ace360 monitor definition file                  *
*                                                                       *
*                       8/5/94                                          *
*                                                                       *
*************************************************************************

MBAR equ $3FF00

; QUICC SIM Register Addresses

ModBaseAdr equ $FFFF0000
DPR_Base        equ     ModBaseAdr
DPR_BASE        equ     DPR_Base
SPIRXBD         equ     ModBaseAdr+$50
SPITXBD         equ     ModBaseAdr+$58
SMC1RXBD        equ     ModBaseAdr
SMC1TXBD        equ     ModBaseAdr+$8

TxRdy           equ     $8000

SCC1PB          equ     ModBaseAdr+$0C00
SCC2PB          equ     ModBaseAdr+$0D00
SCC3PB          equ     ModBaseAdr+$0E00
SCC4PB          equ     ModBaseAdr+$0F00
SPIPB           equ     ModBaseAdr+$0D80
SMC1PB          equ     ModBaseAdr+$0E80
SMC2PB          equ     ModBaseAdr+$0F80
IDMA1Base       equ     ModBaseAdr+$0E70
IDMA2Base       equ     ModBaseAdr+$0F70

RBase           equ     ModBaseAdr+$1000
MCR             equ     RBase+0
AVR             equ     RBase+8
RSR				 equ		RBase+9  ; chetan
CLKOCR          equ     RBase+$C
PLLCR           equ     RBase+$10
SYPCR           equ     RBase+$22
PEPAR           equ     RBase+$16

PICR		equ	RBase+$26
PITR		equ	RBase+$2a

CR              equ     RBase+$5C0
GMR             equ     RBase+$40
BR0             equ     RBase+$50
OR0             equ     RBase+$54
BR1             equ     RBase+$60
OR1             equ     RBase+$64
BR2             equ     RBase+$70
OR2             equ     RBase+$74
BR3             equ     RBase+$80
OR3             equ     RBase+$84
BR4             equ     RBase+$90
OR4             equ     RBase+$94

CICR            equ     RBase+$540
CIPR            equ     RBase+$544
CIMR            equ     RBase+$548
CISR            equ     RBase+$54C

SDCR            equ     RBase+$051E
PADIR           equ     RBase+$0550
PAPAR           equ     RBase+$0552
PAODR           equ     RBase+$0554
PADAT           equ     RBase+$0556

PBDIR           equ     RBase+$06B8
PBPAR           equ     RBase+$06BC
PBODR           equ     RBase+$06C0
PBDAT           equ     RBase+$06C4

PCDIR           equ     RBase+$0560
PCPAR           equ     RBase+$0562
PCSO            equ     RBase+$0564
PCDAT           equ     RBase+$0566
PCINT           equ     RBase+$0568



; External Addresses
Flash1Base equ	$08000000    ; Base at 128 MB
Flash2Base equ $08080000    ; Base at 128 MB + 512 KB  
FlashFirstIDLocation equ $00005555   ; For Flash Identification
FlashSecondIDLocation equ $00002AAA	 ; For Flash Identification
Bank1BasePtr equ $00001C00
Bank1SizePtr equ $00001C04
Bank2BasePtr equ $00001C08
Bank2SizePtr equ $00001C0C
BootModeLocationInRAM equ $00001C10
BootModeLocationInDPRAM equ ModBaseAdr+$0590
MinDRAMSize equ $00200000
SMCRxBuf equ $00001C14
FlashPromBufRelative equ $00001C18
DRAMBootDataStartOffsetFromEnd equ (300*1024)
Bank1SizeinBootHdr equ Flash1Base+$11000+$26
Bank2SizeinBootHdr equ Bank1SizeinBootHdr+$2

LocalIO equ $FF000000
InitVBR equ $00000  		; this is the Vector base register
								; address.This address is used as the base
								; for building the vector table
     
;DramBootData equ $001D0000
; This is just dummy
InitSP equ $382800-$4

;               constants               

Rtn             equ     $D
LF              equ     $A

NumBanks        equ     2               ;# of DRAM banks

CPU_FC          equ     7
PllCtl          equ     $0              ;24.576 MHz
ClkCtl          equ     $0
InitSysProt     equ     $20
RstCR           equ     $8001

GAMX            equ     $20             ;enable internal DRAM adr mux
DWQ             equ     $80
PageSz256K      equ     $040000
PageSz1M        equ     $0C0000
PageSz4M        equ     $140000
PageSz16M       equ     $001C0000
RfshEn          equ     $800000
RfshCnt25       equ     $18000000       ;15.4usec refresh at 25MHz
RfshCyc3        equ     0               ;3 clock refresh
RfshCyc4        equ     $200000         ;4 clock refresh

			; Base register bits
BootWP          equ     2
Valid           equ     1

			; Option register bits
			
PortWidth8		equ     4       ; PortWidth32 = 0
PortWidth16		equ     2
DramSel			equ     1
PageMode		equ     8
BootAdrMask1	 equ     $0FF80000
BootAdrMask2    equ     $0FF00000
Bank1Mask		equ     $F800000        ;for 1M x 32 SIMM       
LocalIOMask		equ     $FFFF800        ;only use 4 kbytes
FastTerm		equ     0
Wait0			equ     $10000000
Wait1			equ     $20000000
Wait2			equ     $30000000
Wait3			equ     $40000000
Wait4			equ     $50000000
Wait5			equ     $60000000
Wait6			equ     $70000000

RAS2DD          equ     $600
RAS1DD          equ     $100
WeSel           equ     $80

PortAConfig     equ     $4FFF
PortADir        equ     0

*** Timer 1, 2, 3, 4
TGCR    EQU     RBase+$0580      ; Timer Global Configuration
*
TMR1    EQU     RBase+$0590      ; Timer1 Mode
TMR2    EQU     RBase+$0592      ; Timer2 Mode
TRR1    EQU     RBase+$0594      ; Timer1 Reference
TRR2    EQU     RBase+$0596      ; Timer2 Reference
TCR1    EQU     RBase+$0598      ; Timer1 Capture
TCR2    EQU     RBase+$059A      ; Timer2 Capture
TCN1    EQU     RBase+$059C      ; Timer1 Counter
TCN2    EQU     RBase+$059E      ; Timer2 Counter
*
TMR3    EQU     RBase+$05A0      ; Timer3 Mode
TMR4    EQU     RBase+$05A2      ; Timer4 Mode
TRR3    EQU     RBase+$05A4      ; Timer3 Reference
TRR4    EQU     RBase+$05A6      ; Timer4 Reference
TCR3    EQU     RBase+$05A8      ; Timer3 Capture
TCR4    EQU     RBase+$05AA      ; Timer4 Capture
TCN3    EQU     RBase+$05AC      ; Timer3 Counter
TCN4    EQU     RBase+$05AE      ; Timer4 Counter
*
TER1    EQU     RBase+$05B0      ; Timer1 Event
TER2    EQU     RBase+$05B2      ; Timer2 Event
TER3    EQU     RBase+$05B4      ; Timer3 Event
TER4    EQU     RBase+$05B6      ; Timer4 Event
*** CP
RCCR    EQU     RBase+$05C4      ; RISC Configuration
RTER    EQU     RBase+$05D6      ; RISC Timer Event Register
RTMR    EQU     RBase+$05DA      ; RISC Timer Mask Register
* BRG 1, 2, 3, 4
BRGC1   EQU     RBase+$05F0      ; BRG1 Configuration
BRGC2   EQU     RBase+$05F4      ; BRG2 Configuration
BRGC3   EQU     RBase+$05F8      ; BRG3 Configuration
BRGC4   EQU     RBase+$05FC      ; BRG4 Configuration
*** SCC 1, 2, 3, 4
* SCC1
GSMR_L1 EQU     RBase+$0600      ; SCC1 General Mode
GSMR_H1 EQU     RBase+$0604      ; SCC1 General Mode
PSMR1   EQU     RBase+$0608      ; SCC1 Protocol Specific Mode
TODR1   EQU     RBase+$060C      ; SCC1 Transmit On Demand
DSR1    EQU     RBase+$060E      ; SCC1 Data Sync
SCCE1   EQU     RBase+$0610      ; SCC1 Event
SCCM1   EQU     RBase+$0614      ; SCC1 Mask
SCCS1   EQU     RBase+$0617      ; SCC1 Status
* SCC2
GSMR_L2 EQU     RBase+$0620      ; SCC2 General Mode
GSMR_H2 EQU     RBase+$0624      ; SCC2 General Mode
PSMR2   EQU     RBase+$0628      ; SCC2 Protocol Specific Mode
TODR2   EQU     RBase+$062C      ; SCC2 Transmit On Demand
DSR2    EQU     RBase+$062E      ; SCC2 Data Sync
SCCE2   EQU     RBase+$0630      ; SCC2 Event
SCCM2   EQU     RBase+$0634      ; SCC2 Mask
SCCS2   EQU     RBase+$0637      ; SCC2 Status
* SCC3
GSMR_L3 EQU     RBase+$0640      ; SCC3 General Mode
GSMR_H3 EQU     RBase+$0644      ; SCC3 General Mode
PSMR3   EQU     RBase+$0648      ; SCC3 Protocol Specific Mode
TODR3   EQU     RBase+$064C      ; SCC3 Transmit On Demand
DSR3    EQU     RBase+$064E      ; SCC3 Data Sync
SCCE3   EQU     RBase+$0650      ; SCC3 Event
SCCM3   EQU     RBase+$0654      ; SCC3 Mask
SCCS3   EQU     RBase+$0657      ; SCC3 Status
* SCC4
GSMR_L4 EQU     RBase+$0660      ; SCC4 General Mode
GSMR_H4 EQU     RBase+$0664      ; SCC4 General Mode
PSMR4   EQU     RBase+$0668      ; SCC4 Protocol Specific Mode
TODR4   EQU     RBase+$066C      ; SCC4 Transmit On Demand
DSR4    EQU     RBase+$066E      ; SCC4 Data Sync
SCCE4   EQU     RBase+$0670      ; SCC4 Event
SCCM4   EQU     RBase+$0674      ; SCC4 Mask
SCCS4   EQU     RBase+$0677      ; SCC4 Status
*** SMC 1, 2
SMCMR1  EQU     RBase+$0682      ; SMC1 Mode
SMCE1   EQU     RBase+$0686      ; SMC1 Event
SMCM1   EQU     RBase+$068A      ; SMC1 Mask
*
SMCMR2  EQU     RBase+$0692      ; SMC2 Mode
SMCE2   EQU     RBase+$0696      ; SMC2 Event
SMCM2   EQU     RBase+$069A      ; SMC2 Mask
*** SPI
SPMODE  EQU     RBase+$06A0      ; SPI Mode
SPIE    EQU     RBase+$06A6      ; SPI Event
SPIM    EQU     RBase+$06AA      ; SPI Mask
SPCOM   EQU     RBase+$06AC      ; SPI Command
*** PIP
PIPC    EQU     RBase+$06B2      ; PIP Configuration
PTRR    EQU     RBase+$06B6      ; PIP Timing Parameter
*** Serial Interface
SIMODE  EQU     RBase+$06E0      ; SI Mode
SIGMR   EQU     RBase+$06E4      ; SI Global Mode
SISTR   EQU     RBase+$06E6      ; SI Status
SICMR   EQU     RBase+$06E7      ; SI Command
SICR    EQU     RBase+$06EC      ; SI Clock Routing
SIRP    EQU     RBase+$06F0      ; SI RAM Pointer
SIRAM   EQU     RBase+$0700      ; SI Routing RAM

************************ END of SIM/CPM Register MAP *******************

************************ SCC Parameters ********************************

RBASE1  EQU     SCC1PB+$000     ; SCC1 RX BD Base Address
TBASE1  EQU     SCC1PB+$002     ; SCC1 TX BD Base Address
RFCR1   EQU     SCC1PB+$004     ; SCC1 RX Function Code
TFCR1   EQU     SCC1PB+$005     ; SCC1 TX Function Code
MRBLR1  EQU     SCC1PB+$006     ; SCC1 MAX Buffer Length - RX
RSTATE1 EQU     SCC1PB+$008     ; SCC1 RX Internal State
RBPRT1  EQU     SCC1PB+$010     ; SCC1 RX BD Pointer
TSTATE1 EQU     SCC1PB+$018     ; SCC1 TX Internal State
TBPRT1  EQU     SCC1PB+$020     ; SCC1 TX BD Pointer
RCRC1   EQU     SCC1PB+$028     ; SCC1 Temp Receive CRC
TCRC1   EQU     SCC1PB+$02C     ; SCC1 Temp Transmit CRC

* SCC1, Ethernet Specific Parameter
C_PRES1      EQU     SCC1PB+$30   ; SCC1 Preset CRC ($FFFFFFFF)
C_MASK1      EQU     SCC1PB+$34   ; SCC1 Constant mask for CRC($20E3DEBB)
CRCEC1       EQU     SCC1PB+$38   ; SCC1 CRC error counter
ALEC1        EQU     SCC1PB+$3C   ; SCC1 alignment error counter
DISFC1       EQU     SCC1PB+$40   ; SCC1 discard frame counter
PADS1        EQU     SCC1PB+$44   ; SCC1 short frame PAD counter
RET_Lim1     EQU     SCC1PB+$46   ; SCC1 retry limit threshold
RET_cnt1     EQU     SCC1PB+$48   ; SCC1 retry limit counter
MFLR1        EQU     SCC1PB+$4A   ; SCC1 max. frame length reg.
MINFLR1      EQU     SCC1PB+$4C   ; SCC1 min. frame length reg.
MAXD11       EQU     SCC1PB+$4E   ; SCC1 max. DMA1 length reg.
MAXD21       EQU     SCC1PB+$50   ; SCC1 max. DMA2 length reg.
MAXD1        EQU     SCC1PB+$52   ; SCC1 Rx max DMA
DMA_cnt1     EQU     SCC1PB+$54   ; SCC1 Rx DMA count
MAX_b1       EQU     SCC1PB+$56   ; SCC1 max BD byte count
GADDR11      EQU     SCC1PB+$58   ; SCC1 Group Addr. Filter 1
GADDR21      EQU     SCC1PB+$5A   ; SCC1 Group Addr. Filter 2
GADDR31      EQU     SCC1PB+$5C   ; SCC1 Group Addr. Filter 3
GADDR41      EQU     SCC1PB+$5E   ; SCC1 Group Addr. Filter 4
TBUF0.data01 EQU     SCC1PB+$60   ; SCC1 save area 0 - current frame
TBUF0.data11 EQU     SCC1PB+$64   ; SCC1 save area 1 - current frame
TBUF0.rba01  EQU     SCC1PB+$68   ; SCC1
TBUF0.crc1   EQU     SCC1PB+$6C   ; SCC1
TBUF0.bcnt1  EQU     SCC1PB+$70   ; SCC1
PADDR1_H1    EQU     SCC1PB+$72   ; physical address 1 (MSB)
PADDR1_M1    EQU     SCC1PB+$74   ; physical address 1
PADDR1_L1    EQU     SCC1PB+$76   ; physical address 1 (LSB)
P_PER1       EQU     SCC1PB+$78   ; persistence
RFBD_ptr1    EQU     SCC1PB+$7A   ; Rx first BD pointer
TFBD_ptr1    EQU     SCC1PB+$7C   ; Tx first BD pointer
TLBD_ptr1    EQU     SCC1PB+$7E   ; Tx last BD pointer
TBUF1.data01 EQU     SCC1PB+$80   ; SCC1 save area 0 - next frame
TBUF1.data11 EQU     SCC1PB+$84   ; SCC1 save area 1 - next frame
TBUF1.rba01  EQU     SCC1PB+$88   ; SCC1
TBUF1.crc1   EQU     SCC1PB+$8C   ; SCC1
TBUF1.bcnt1  EQU     SCC1PB+$90   ; SCC1
TX_len1      EQU     SCC1PB+$92   ; SCC1 Tx frame length counter
IADDR11      EQU     SCC1PB+$94   ; SCC1 Individual Addr. Filter 1
IADDR21      EQU     SCC1PB+$96   ; SCC1 Individual Addr. Filter 2
IADDR31      EQU     SCC1PB+$98   ; SCC1 Individual Addr. Filter 3
IADDR41      EQU     SCC1PB+$9A   ; SCC1 Individual Addr. Filter 4
BOFF_CNT1    EQU     SCC1PB+$9C   ; back off counter
TADDR1_H1    EQU     SCC1PB+$9E   ; temp address  (MSB)
TADDR1_M1    EQU     SCC1PB+$A0   ; temp address
TADDR1_L1    EQU     SCC1PB+$A2   ; temp address  (LSB)


****** SCC2
RBASE2  EQU     SCC2PB+$000     ; SCC2 RX BD Base Address
TBASE2  EQU     SCC2PB+$002     ; SCC2 TX BD Base Address
RFCR2   EQU     SCC2PB+$004     ; SCC2 RX Function Code
TFCR2   EQU     SCC2PB+$005     ; SCC2 TX Function Code
MRBLR2  EQU     SCC2PB+$006     ; SCC2 MAX Buffer Length - RX
RSTATE2 EQU     SCC2PB+$008     ; SCC2 RX Internal State
RBPRT2  EQU     SCC2PB+$010     ; SCC2 RX BD Pointer
TSTATE2 EQU     SCC2PB+$018     ; SCC2 TX Internal State
TBPRT2  EQU     SCC2PB+$020     ; SCC2 TX BD Pointer
RCRC2   EQU     SCC2PB+$028     ; SCC2 Temp Receive CRC
TCRC2   EQU     SCC2PB+$02C     ; SCC2 Temp Transmit CRC

****** SCC3
RBASE3  EQU     SCC3PB+$000     ; SCC3 RX BD Base Address
TBASE3  EQU     SCC3PB+$002     ; SCC3 TX BD Base Address
RFCR3   EQU     SCC3PB+$004     ; SCC3 RX Function Code
TFCR3   EQU     SCC3PB+$005     ; SCC3 TX Function Code
MRBLR3  EQU     SCC3PB+$006     ; SCC3 MAX Buffer Length - RX
RSTATE3 EQU     SCC3PB+$008     ; SCC3 RX Internal State
RBPRT3  EQU     SCC3PB+$010     ; SCC3 RX BD Pointer
TSTATE3 EQU     SCC3PB+$018     ; SCC3 TX Internal State
TBPRT3  EQU     SCC3PB+$020     ; SCC3 TX BD Pointer
RCRC3   EQU     SCC3PB+$028     ; SCC3 Temp Receive CRC
TCRC3   EQU     SCC3PB+$02C     ; SCC3 Temp Transmit CRC

****** SCC4
RBASE4  EQU     SCC4PB+$000     ; SCC4 RX BD Base Address
TBASE4  EQU     SCC4PB+$002     ; SCC4 TX BD Base Address
RFCR4   EQU     SCC4PB+$004     ; SCC4 RX Function Code
TFCR4   EQU     SCC4PB+$005     ; SCC4 TX Function Code
MRBLR4  EQU     SCC4PB+$006     ; SCC4 MAX Buffer Length - RX
RSTATE4 EQU     SCC4PB+$008     ; SCC4 RX Internal State
RBPRT4  EQU     SCC4PB+$010     ; SCC4 RX BD Pointer
TSTATE4 EQU     SCC4PB+$018     ; SCC4 TX Internal State
TBPRT4  EQU     SCC4PB+$020     ; SCC4 TX BD Pointer
RCRC4   EQU     SCC4PB+$028     ; SCC4 Temp Receive CRC
TCRC4   EQU     SCC4PB+$02C     ; SCC4 Temp Transmit CRC
CRC_C4  EQU     SCC4PB+$030     ; SCC4 CRC Constant Total-Transparent
CRC_P4  EQU     SCC4PB+$034     ; SCC4 CRC Preset Total-Transparent

****** SMC1 => SMCA, simplify assembly coding
RBASEA  EQU     SMC1PB+$000     ; SMC1 RX BD Base Address
TBASEA  EQU     SMC1PB+$002     ; SMC1 TX BD Base Address
RFCRA   EQU     SMC1PB+$004     ; SMC1 RX Function Code
TFCRA   EQU     SMC1PB+$005     ; SMC1 TX Function Code
MRBLRA  EQU     SMC1PB+$006     ; SMC1 MAX Buffer Length - RX
RSTATEA EQU     SMC1PB+$008     ; SMC1 RX Internal State
RBPRTA  EQU     SMC1PB+$010     ; SMC1 RX BD Pointer
TSTATEA EQU     SMC1PB+$018     ; SMC1 TX Internal State
TDPTRA  EQU     SMC1PB+$01C     ; SMC1 TX Internal Data Ptr
TBPRTA  EQU     SMC1PB+$020     ; SMC1 TX BD Pointer
TBCNTA  EQU     SMC1PB+$022     ; SMC1 TX Internal Byte Count

****** SMC2 => SMCB
RBASEB  EQU     SMC2PB+$000     ; SMC2 RX BD Base Address
TBASEB  EQU     SMC2PB+$002     ; SMC2 TX BD Base Address
RFCRB   EQU     SMC2PB+$004     ; SMC2 RX Function Code
TFCRB   EQU     SMC2PB+$005     ; SMC2 TX Function Code
MRBLRB  EQU     SMC2PB+$006     ; SMC2 MAX Buffer Length - RX
RSTATEB EQU     SMC2PB+$008     ; SMC2 RX Internal State
RBPRTB  EQU     SMC2PB+$010     ; SMC2 RX BD Pointer
TSTATEB EQU     SMC2PB+$018     ; SMC2 TX Internal State
TDPTRB  EQU     SMC1PB+$01C     ; SMC2 TX Internal Data Ptr
TBPRTB  EQU     SMC2PB+$020     ; SMC2 TX BD Pointer
TBCNTB  EQU     SMC1PB+$022     ; SMC2 TX Internal Byte Count

* SPI PARAMETERS

RBASEI  equ     SPIPB+$000
TBASEI  equ     SPIPB+$002
RFCRI   equ     SPIPB+$004
TFCRI   equ     SPIPB+$005
MRBRLI  equ     SPIPB+$006

************************** Specific Parameters ******************************

* SCC2, UART Specific Parameters
MAXIDL2 EQU     SCC2PB+$38      ; SCC2 MAX IDLe cchars
IDLC2   EQU     SCC2PB+$3A      ; SCC2 temp IDLe Counter
BRKCR2  EQU     SCC2PB+$3C      ; SCC2 BReaK Count Register (TX)
PAREC2  EQU     SCC2PB+$3E      ; SCC2 Parity Error Counter (RX)
FRMER2  EQU     SCC2PB+$40      ; SCC2 Framing Error Counter (RX)
NOSEC2  EQU     SCC2PB+$42      ; SCC2 Noise Counter (RX)
BRKEC2  EQU     SCC2PB+$44      ; SCC2 BReaK Condition Counter (RX)
BRKLN2  EQU     SCC2PB+$46      ; SCC2 Last BReaK Length (RX)
UADDR12 EQU     SCC2PB+$48      ; SCC2 UART Address Character 1
UADDR22 EQU     SCC2PB+$4A      ; SCC2 UART Address Character 2
RETMP2  EQU     SCC2PB+$4C      ; SCC2 Temp storage
TOSEQ2  EQU     SCC2PB+$4E      ; SCC2 TX out of sequence Character
CCHAR12 EQU     SCC2PB+$50      ; SCC2 Control Character 1
CCHAR22 EQU     SCC2PB+$52      ; SCC2 Control Character 2
CCHAR32 EQU     SCC2PB+$54      ; SCC2 Control Character 3
CCHAR42 EQU     SCC2PB+$56      ; SCC2 Control Character 4
CCHAR52 EQU     SCC2PB+$58      ; SCC2 Control Character 5
CCHAR62 EQU     SCC2PB+$5A      ; SCC2 Control Character 6
CCHAR72 EQU     SCC2PB+$5C      ; SCC2 Control Character 7
CCHAR82 EQU     SCC2PB+$5E      ; SCC2 Control Character 8
RCCM2   EQU     SCC2PB+$60      ; SCC2 RX Control Character Mask
RCCR2   EQU     SCC2PB+$62      ; SCC2 RX Control Character
RLBC2   EQU     SCC2PB+$64      ; SCC2 RX Last Break Character

* SCC3, UART Specific Parameters
MAXIDL3 EQU     SCC3PB+$38      ; SCC3 MAX IDLe cchars
IDLC3   EQU     SCC3PB+$3A      ; SCC3 temp IDLe Counter
BRKCR3  EQU     SCC3PB+$3C      ; SCC3 BReaK Count Register (TX)
PAREC3  EQU     SCC3PB+$3E      ; SCC3 Parity Error Counter (RX)
FRMER3  EQU     SCC3PB+$40      ; SCC3 Framing Error Counter (RX)
NOSEC3  EQU     SCC3PB+$42      ; SCC3 Noise Counter (RX)
BRKEC3  EQU     SCC3PB+$44      ; SCC3 BReaK Condition Counter (RX)
BRKLN3  EQU     SCC3PB+$46      ; SCC3 Last BReaK Length (RX)
UADDR13 EQU     SCC3PB+$48      ; SCC3 UART Address Character 1
UADDR23 EQU     SCC3PB+$4A      ; SCC3 UART Address Character 2
RETMP3  EQU     SCC3PB+$4C      ; SCC3 Temp storage
TOSEQ3  EQU     SCC3PB+$4E      ; SCC3 TX out of sequence Character
CCHAR13 EQU     SCC3PB+$50      ; SCC3 Control Character 1
CCHAR23 EQU     SCC3PB+$52      ; SCC3 Control Character 2
CCHAR33 EQU     SCC3PB+$54      ; SCC3 Control Character 3
CCHAR43 EQU     SCC3PB+$56      ; SCC3 Control Character 4
CCHAR53 EQU     SCC3PB+$58      ; SCC3 Control Character 5
CCHAR63 EQU     SCC3PB+$5A      ; SCC3 Control Character 6
CCHAR73 EQU     SCC3PB+$5C      ; SCC3 Control Character 7
CCHAR83 EQU     SCC3PB+$5E      ; SCC3 Control Character 8
RCCM3   EQU     SCC3PB+$60      ; SCC3 RX Control Character Mask
RCCR3   EQU     SCC3PB+$62      ; SCC3 RX Control Character
RLBC3   EQU     SCC3PB+$64      ; SCC3 RX Last Break Character

* SCC4, UART Specific Parameters
MAXIDL4 EQU     SCC4PB+$38      ; SCC4 MAX IDLe cchars
IDLC4   EQU     SCC4PB+$3A      ; SCC4 temp IDLe Counter
BRKCR4  EQU     SCC4PB+$3C      ; SCC4 BReaK Count Register (TX)
PAREC4  EQU     SCC4PB+$3E      ; SCC4 Parity Error Counter (RX)
FRMER4  EQU     SCC4PB+$40      ; SCC4 Framing Error Counter (RX)
NOSEC4  EQU     SCC4PB+$42      ; SCC4 Noise Counter (RX)
BRKEC4  EQU     SCC4PB+$44      ; SCC4 BReaK Condition Counter (RX)
BRKLN4  EQU     SCC4PB+$46      ; SCC4 Last BReaK Length (RX)
UADDR14 EQU     SCC4PB+$48      ; SCC4 UART Address Character 1
UADDR24 EQU     SCC4PB+$4A      ; SCC4 UART Address Character 2
RETMP4  EQU     SCC4PB+$4C      ; SCC4 Temp storage
TOSEQ4  EQU     SCC4PB+$4E      ; SCC4 TX out of sequence Character
CCHAR14 EQU     SCC4PB+$50      ; SCC4 Control Character 1
CCHAR24 EQU     SCC4PB+$52      ; SCC4 Control Character 2
CCHAR34 EQU     SCC4PB+$54      ; SCC4 Control Character 3
CCHAR44 EQU     SCC4PB+$56      ; SCC4 Control Character 4
CCHAR54 EQU     SCC4PB+$58      ; SCC4 Control Character 5
CCHAR64 EQU     SCC4PB+$5A      ; SCC4 Control Character 6
CCHAR74 EQU     SCC4PB+$5C      ; SCC4 Control Character 7
CCHAR84 EQU     SCC4PB+$5E      ; SCC4 Control Character 8
RCCM4   EQU     SCC4PB+$60      ; SCC4 RX Control Character Mask
RCCR4   EQU     SCC4PB+$62      ; SCC4 RX Control Character
RLBC4   EQU     SCC4PB+$64      ; SCC4 RX Last Break Character

* SMC1, UART Specific Parameters
MAXIDLA EQU     SMC1PB+$28      ; SMC1 MAX IDLe cchars
IDLCA   EQU     SMC1PB+$2A      ; SMC1 temp IDLe Counter
BRKLA   EQU     SMC1PB+$2C      ; SMC1 last Received BReaK char length
BRKECA  EQU     SMC1PB+$2E      ; SMC1 receive BReaK Condition Counter
BRKCRA  EQU     SMC1PB+$30      ; SMC1 BReaK Count Register (TX)

*       CPM Interrupt Mask Bits (written to CIMR)

SCC1IEn equ     $40000000
SCC2IEn equ     $20000000
SCC3IEn equ     $10000000
SCC4IEn equ     $08000000
SPIIEn  equ     $20
SMC1IEn equ     $10

*       Interrupt Vectors

SCC1IV  equ     $9E
SCC2IV  equ     $9D
SCC3IV  equ     $9C
SCC4IV  equ     $9B
SMC1IV  equ     $84
SPIIV   equ     $85
SDMA_BE equ     $96


TIMER1IEn	EQU	$02000000
TIMER2IEn	EQU	$00040000
TIMER3IEn	EQU	$00001000
TIMER4IEn	equ	$00000080

TIMER1VEC	equ	$19
TIMER2VEC	equ	$12
TIMER3VEC	equ	$0C
TIMER4VEC	equ	$07
ERRORVEC	equ	$0

* SCC2, HDLC Specific Parameters
C_MASK2		EQU	SCC2PB+$34			;SCC2 CRC Constant
C_PRES2		EQU	SCC2PB+$38			;SCC2 CRC Preset
DISFC2		EQU	SCC2PB+$3C			;SCC2 Discard Frame Counter
CRCEC2		EQU	SCC2PB+$3E			;SCC2 CRC Error Counter
ABTSC2		EQU	SCC2PB+$40			;SCC2 Abort Sequnce Counter
NMARC2		EQU	SCC2PB+$42			;SCC2 Nonmatching Address Rx Counter
RETRC2		EQU	SCC2PB+$44			;SCC2 Frame Transmission Counter
MFLR2		EQU	SCC2PB+$46			;SCC2 Max Frame Length Register
RFTHR2		EQU	SCC2PB+$4A			;SCC2 Received Frames Threshold
HMASK2		EQU	SCC2PB+$4E			;SCC2 User Defined Frame Address Mask
HADDR12		EQU	SCC2PB+$50			;SCC2 User Defined Frame Address
HADDR22		EQU	SCC2PB+$52			;SCC2 User Defined Frame Address
HADDR32		EQU	SCC2PB+$54			;SCC2 User Defined Frame Address
HADDR42		EQU	SCC2PB+$56			;SCC2 User Defined Frame Address


* SCC3, HDLC Specific Parameters
C_MASK3		EQU	SCC3PB+$34			;SCC3 CRC Constant
C_PRES3		EQU	SCC3PB+$38			;SCC3 CRC Preset
DISFC3		EQU	SCC3PB+$3C			;SCC3 Discard Frame Counter
CRCEC3		EQU	SCC3PB+$3E			;SCC3 CRC Error Counter
ABTSC3		EQU	SCC3PB+$40			;SCC3 Abort Sequnce Counter
NMARC3		EQU	SCC3PB+$42			;SCC3 Nonmatching Address Rx Counter
RETRC3		EQU	SCC3PB+$44			;SCC3 Frame Transmission Counter
MFLR3			EQU	SCC3PB+$46			;SCC3 Max Frame Length Register
RFTHR3		EQU	SCC3PB+$4A			;SCC3 Received Frames Threshold
HMASK3		EQU	SCC3PB+$4E			;SCC3 User Defined Frame Address Mask
HADDR13		EQU	SCC3PB+$50			;SCC3 User Defined Frame Address
HADDR23		EQU	SCC3PB+$52			;SCC3 User Defined Frame Address
HADDR33		EQU	SCC3PB+$54			;SCC3 User Defined Frame Address
HADDR43		EQU	SCC3PB+$56			;SCC3 User Defined Frame Address


* SCC4, HDLC Specific Parameters
C_MASK4		EQU	SCC4PB+$34			;SCC4 CRC Constant
C_PRES4		EQU	SCC4PB+$38			;SCC4 CRC Preset
DISFC4		EQU	SCC4PB+$3C			;SCC4 Discard Frame Counter
CRCEC4		EQU	SCC4PB+$3E			;SCC4 CRC Error Counter
ABTSC4		EQU	SCC4PB+$40			;SCC4 Abort Sequnce Counter
NMARC4		EQU	SCC4PB+$42			;SCC4 Nonmatching Address Rx Counter
RETRC4		EQU	SCC4PB+$44			;SCC4 Frame Transmission Counter
MFLR4			EQU	SCC4PB+$46			;SCC4 Max Frame Length Register
RFTHR4		EQU	SCC4PB+$4A			;SCC4 Received Frames Threshold
HMASK4		EQU	SCC4PB+$4E			;SCC4 User Defined Frame Address Mask
HADDR14		EQU	SCC4PB+$50			;SCC4 User Defined Frame Address
HADDR24		EQU	SCC4PB+$52			;SCC4 User Defined Frame Address
HADDR34		EQU	SCC4PB+$54			;SCC4 User Defined Frame Address
HADDR44		EQU	SCC4PB+$56			;SCC4 User Defined Frame Address



