#include	"..\include\mctypes.h"
#include	"..\include\boot.h"
#include	"..\include\downldr.h"
#include	"..\include\utils.h"		/* both C and ASM utils header file for c */

extern void	TransmitCnt (byte *, word) ;
byte LocalTmOut ;

void	kprint(char *str)
{
#if KPRINT
	_kprint(str, strlen(str));
#endif
}
extern volatile x;

void	ultoh(char *dest, dword value)
{
	int index = 7;
	int	tmpval;

	memset(dest, ' ', 2*sizeof(dword));
	dest[8] = 0;
	while(value)
	{
		tmpval = value & 0xf;

		if (tmpval < 10)
			tmpval += '0';
		else
			tmpval += ('A' - 10);

		dest[index--] = tmpval;
		value >>= 4;
	}
}

/***** strlen - returns length of null term string *******************/
word strlen (byte *String)
{
	word count = 0 ;

	while (*String ++)
		count ++ ;
	return count ;
}

void	memset(byte *memptr, byte ch, int len)
{
	while(len--)
		*memptr++ = ch;
}

void memcpy (byte *Loc1, byte *Loc2, word count)
{
	while (count--)
		*Loc1 ++ = *Loc2 ++ ;
}

/****************************************************************************
Name : strcmp
Returns : 0 if equal else 1
Synopsis : It compares two null terminated strings
****************************************************************************/
word strcmp (byte *ptr1, byte *ptr2)
{
	while (*ptr1)
	{
		if (*ptr1 != *ptr2)
			break;
		ptr1 ++ ;
		ptr2 ++ ;
	}
	return (*ptr1 - *ptr2) ;
}

/********* transmit given string onto the monitor port ********/
void TransmitStr (byte *Msg)
{
	/* If a modem is present and not online we should not
	Stuff it with chars which are not modem commands */

	if (!ModemPresentAndOffline)
		TransmitCnt (Msg, strlen (Msg)) ;
}


/*##################### CRC TABLE AND ROUTINES FOR 16 BITS ################*/

unsigned int crctab[256] ;

/****************************************************************************
Name		:	Calculate CRC Table
Synopsis	:	Instead of storing a CRC table, we create it during
				Initialization, using following routine
****************************************************************************/
#define CONST_P 0x8408
void CalculateCRCTable (void)
{
	register	unsigned	int b, v;
	register word i;

	for (b = 0 ; ; )
	{
		v = b ;
		for (i = 8 ; i -- ; )
			v = v & 1  ?  (v >> 1) ^ CONST_P : v >> 1 ;

		crctab[b] = v & 0xffff ;
		if (++ b == 256)
			break ;
	}
}

/****************************************************************************
Name		:	AddCRC
Synopsis	:	This routine adds the CRC to the end of the data buffer
****************************************************************************/
void AddCRC (byte *Hptr, dword count)
{
	register	word crc = 0xffff ;
	register byte *pktptr ;
	register dword	i ;

	pktptr = (byte *) Hptr ;
	for (i = 0 ; i < count ; i ++)
		crc = updcrc (0xFF & *pktptr++, crc) ;
	crc = updcrc (0, updcrc (0, crc)) ;

	/* Higher byte 1st then lower byte of CRC */
	*(Hptr + count) = (crc & 0xff00) >> 8 ;
	*(Hptr + count + 1) = (crc & 0x00ff) ;
	return ;
}

/****************************************************************************
Name		:	CheckCRC
Returns	:	TRUE if Computed CRC of buffer matches passed in CRC, else FASLE
Synopsis	:	This routine is used for checking CRC of download packets and
				also for checking Setup and Firmware soundness. The 3rd parameter
				will be 0 in the first case and the stored CRC in the later cases.
****************************************************************************/
BOOL CheckCRC (byte *Hptr, dword count, word *CodConfgCRC)
{
	register word crc ;
	register dword	i ;

	for (crc = 0x0ffff, i = 0 ; i < count ; i ++)
		crc = updcrc (0xFF & *Hptr++, crc) ;

	if (CodConfgCRC != 0)
	{
		crc = updcrc ((*CodConfgCRC & 0xFF00) >> 8, crc) ;
		crc = updcrc (*CodConfgCRC & 0x00FF, crc) ;
	}

	if (crc)
		return FALSE ;
	return TRUE ;
}

/****************************************************************************
Name		:	InitData
Synopsis	:	Initialization routine for the whole boot
****************************************************************************/
void InitData (void) 
{
	StateHandler[0] = ProcessHeader ;
	StateHandler[1] = ProcessData	;   /* DownLoader state handlers */

	ReceiveHead = ReceiveTail = 0 ;
	ReceiveState = RECV_7E ;
	ReceiverEnabled = 1 ;		/* To stop the buffer overwriting */
	ModemPresentAndOffline = 0 ;	/* assume no modem or it is online */

	WaitForXON = 0 ;
	NumOfXONs = 0 ;
	NumOfXOFFs = 0 ;
	NextBytePtr = 0 ;
	NumBytesLeft = 0 ;

	CalculateCRCTable() ;
}

word	GlobalCRC ;
void UpdateGlobalCRC (byte *Pkt, dword length)
{
	dword i ;
	for (i = 0 ; i < length ; i ++)
		GlobalCRC = updcrc (0xff & Pkt[i], GlobalCRC) ;
}

