#include	"..\..\include\mctypes.h"

extern void	EthXternalLpBkInit(void);
extern void	Urt1LoopBackInit(dword);
extern void	Urt2LoopBackInit(dword);
extern void	Urt3LoopBackInit(dword);


void	GetBaud(byte);

extern int 	LoopBkOnEth(byte *,byte *, int, int);
extern void	LoopBkOnUart1(char *,char *,int,int);
extern void	LoopBkOnUart2(char *,char *,int,int);
extern void	LoopBkOnUart3(char *,char *,int,int);

byte DiagTxBuf[1518] ;

dword	baudval ;

/* WARNING !!!!!!!!!! Rxbuffers must start on long word boudaries
since all dwords will be alinged to longword boundaries, the above
definition will make the following DiagRxBuf to start at a long
word boundary. (There are certain compiler options which can make this
assumption false. But we don't use them */
byte DiagRxBuf[1518] ;

int bauddelay ;

TestDelay(int i)
{
	int j;
	for ( ;i--;)
		for (j = 0; j < 10000; j++);
}

void SetupBuffers(void)
{
	byte	ch = 0;
	int	i;

	for( i = 0; i < 14; i++){
		DiagTxBuf[i] = 0;
		DiagRxBuf[i] = 0;
	}

	for(; i < 1518; i++){
		if ((ch == 0x11) || (ch == 0x13))	/* avoid XON and XOFF chars */
			ch++;
		if ((ch == 0x91) || (ch == 0x93))	/* avoid XON and XOFF chars */
			ch++;
		DiagTxBuf[i] = ch++;
		DiagRxBuf[i] = 0;
	}
}

int TestSCC1()
{
	int		i;

	SetupBuffers();

	EthXternalLpBkInit();
	LoopBkOnEth(DiagTxBuf,DiagRxBuf,512, 100);

	/* avoid first 14 bytes which may contain address etc */
	for(i=14;i<512 + 14;i++)
		if(DiagTxBuf[i] != DiagRxBuf[i])
			return(0);
	return(1);
}

int TestSCC2(byte baudidx)
{
	int		i;

	SetupBuffers();

	if (baudidx & 0x80)
	{		/* MSB set for SYNC test */
		return 0;		/* no support for sync in small proxy */
	}
	else
	{
		GetBaud(baudidx);
		Urt1LoopBackInit(baudval);
		LoopBkOnUart1(DiagTxBuf,DiagRxBuf,64,bauddelay);
		TestDelay(5);
		for(i=14;i<64 + 14;i++)
			if(DiagTxBuf[i] != DiagRxBuf[i])
				return(0);
	}
	return(1);
}

int TestSCC3 (byte baudidx)
{
	int i ;

	SetupBuffers();

	if (baudidx & 0x80)
	{		/* MSB set for SYNC test */
		return 0;		/* no support for sync in small proxy */
	} else {
		GetBaud(baudidx);
		Urt2LoopBackInit(baudval);
		LoopBkOnUart2(DiagTxBuf,DiagRxBuf,64,bauddelay);
		TestDelay(5);
		for(i=14;i<64 + 14;i++)
			if(DiagTxBuf[i] != DiagRxBuf[i])
				return(0);
	}
	return(1);
}

int TestSCC4(byte baudidx)
{
	int		i;

	SetupBuffers();

	if (baudidx & 0x80) {				/* MSB set for SYNC test */
		return 0;		/* no support for sync in small proxy */
	} else {
		GetBaud(baudidx);
		Urt3LoopBackInit(baudval);
		LoopBkOnUart3(DiagTxBuf,DiagRxBuf,64,bauddelay);
		TestDelay(5);
		for(i=14;i<64 + 14;i++)
			if(DiagTxBuf[i] != DiagRxBuf[i])
				return(0);
	}
	return(1);
}

void		GetBaud(byte baudidx)
{
	baudval		= 0;
	bauddelay	= 0;

	switch(baudidx)
	{
		case 0	:	baudval		= 0x10a7e;
						bauddelay	= 0x8;				/* 1200  */
						break;
		case 1	:	baudval		= 0x1053e;
						bauddelay	= 0x4;				/* 2400  */
						break;
		case 2	:	baudval		= 0x1029e;
						bauddelay	= 0x2;				/* 4800  */
						break;
		case 3	:	baudval		= 0x1014e;
						bauddelay	= 0x1;				/* 9600  */
						break;
		case 4	:	baudval		= 0x100a6;			/* 19200  */
						break;
		case 5	:	baudval		= 0x10052;			/* 38400  */
						break;
		case 6	:	baudval		= 0x10036;			/* 57600  */
						break;
		case 7	:	baudval		= 0x1001a;			/* 11520  */
						break;
		case 8	:	baudval		= 0x1000C;			/* 230400  */
						break;
		case 9	:	baudval		= 0x10006;			/* 460800 */
						break;
	}
}

