#include	<stdio.h>
#include <string.h>
#include <memory.h>

#include	"..\boot\include\mctypes.h"
#include	"..\boot\include\boot.h"
#include	"..\boot\include\downldr.h"
#include	"kaddr.h"
#include	"taddr.h" 
#include	"faddr.h"

#define ETHERNET_ADDRESS_SIZE		6

void main(int	argc, char* argv[])
{
	WriteLocReqType	WritePkt;
	ReadLocReqType		ReadReqPkt;
	ReadLocRespType	*ReadRespPkt;
	BootConfigType		*BootCfgPkt;
	BootConfigType		*TmpPtr;
	ResultType			*ResultPkt;
	unsigned char		Address[15];
	unsigned char *	AddressInPacket;

	printf("***** MTRouter Ethernet Address Utility *****\n");
	printf("NOTE: To be used only for 3_100 hardware.\n");
	if (argc == 1) {
		printf("\nUsage: setaddr port-number (1 to 4) \n");
		return;
	}
	if (!init_uart((int)a2h(*argv[1]) ) )
		return;	

	printf("\nSwitch off and on the target system now.\n");
	delay();
	printf("\nLooking for target.... (May take about 30 seconds)\n") ;
	
	/* set timer handler */
	set_timer();
	/* wait for string "Press 'd' to download (configuration or code).\r\n" */
	if (waitforMessage(0) == -1) {
timeout:
		printf("\nNo response from target. Exiting.\n ");
		goto exit;
	}

	/* Read the current Boot Config */

	ReadReqPkt.Ptype = READ_REQ_TYPE;
	ReadReqPkt.Length = sizeof(BootConfigType);
	ReadReqPkt.Address = little_endian(FLASH_BOOT_HDR);
	send_packet((char *)&ReadReqPkt, sizeof(ReadLocReqType));
	if (recv_packet() == -1) 
		goto timeout;
	/* we don't need to convert any fields into 86 format since only the ethernet
	address is being used and it is an array of bytes */
	/* Response pkt is at an offset of 4 bytes(BridgeId) */

	ReadRespPkt = (ReadLocRespType *)(RcvBuffer+sizeof(SMCPktHeadType));
	if(ReadRespPkt->Address != ReadReqPkt.Address) {
		printf("\nError reading current configuration");
		goto exit;
	}
	BootCfgPkt = (BootConfigType *)&ReadRespPkt->buffer[0];
	AddressInPacket = (unsigned char *)	&BootCfgPkt->EthernetAddr_H;
	printf("\nTarget Current Ethernet Address   = %02x%02x%02x%02x%02x%02x\n",
									AddressInPacket[0],
									AddressInPacket[1],
									AddressInPacket[2],
									AddressInPacket[3],
									AddressInPacket[4],
									AddressInPacket[5]);

	/* Get the new address */
get_addr:
	printf("\nEnter Target New Ethernet Address (Q to quit) = ");
	scanf("%12s", Address);
	if( (Address[0] == 'Q') || (Address[0] == 'q'))
		goto exit;

	memset(AddressInPacket, 0, ETHERNET_ADDRESS_SIZE);
	if ( str2h((byte *)Address, (byte *)AddressInPacket,
	 							(word)ETHERNET_ADDRESS_SIZE, 16) == -1) {
		printf("\nInvalid characters in address!!!");
		goto exit;
		return;
	}


	/* Write the new address */

	WritePkt.Ptype = WRITE_REQ_TYPE;
	WritePkt.Length = ltl_endian_word(sizeof(BootConfigType));
	WritePkt.Address = little_endian(FLASH_BOOT_HDR);
	memcpy(WritePkt.Buffer, BootCfgPkt, sizeof(BootConfigType));
	send_packet((char *)&WritePkt, sizeof(WriteLocReqType));
	if(recv_packet() == -1) 
		goto timeout;
	ResultPkt = (ResultType *)(RcvBuffer + sizeof(SMCPktHeadType));
	if(ResultPkt->Errcode)
		printf("\nError writing to Flash\n");
	else {
		/* Read the current Boot Config again , to confirm*/


		ReadReqPkt.Ptype = READ_REQ_TYPE;
		ReadReqPkt.Length = sizeof(BootConfigType);
		ReadReqPkt.Address = little_endian(FLASH_BOOT_HDR);

		send_packet((char *)&ReadReqPkt, sizeof(ReadLocReqType));
		if (recv_packet() == -1) 
			goto timeout;
		ReadRespPkt = (ReadLocRespType *)(RcvBuffer + sizeof(SMCPktHeadType));
		if(ReadRespPkt->Address != ReadReqPkt.Address) {
			printf("\nError reading current configuration");
			goto exit;
		}
		BootCfgPkt = (BootConfigType *)&ReadRespPkt->buffer[0];

		AddressInPacket = (unsigned char *)	&BootCfgPkt->EthernetAddr_H;
		printf("\nTarget Current Ethernet Address   = %02x%02x%02x%02x%02x%02x\n",
									AddressInPacket[0],
									AddressInPacket[1],
									AddressInPacket[2],
									AddressInPacket[3],
									AddressInPacket[4],
									AddressInPacket[5]);

		TmpPtr= (BootConfigType *)WritePkt.Buffer;
		if ((BootCfgPkt->EthernetAddr_H != TmpPtr->EthernetAddr_H) ||
				(BootCfgPkt->EthernetAddr_L != TmpPtr->EthernetAddr_L))
			printf("\nError in writing address\n.");
	}
exit:
	restore_timer();
}
