#include	<string.h>

#include	"..\boot\include\mctypes.h"
#include	"kaddr.h"
#include	"taddr.h"
#include	"faddr.h"

/****************************************************************************
Name : str2h
Returns : 
Synopsis : It converts a null terminated char string to a hex
****************************************************************************/
int str2h(byte *src, byte *dest, word dcount, byte base)
{
	word scount;
	char c;

	scount = strlen(src);
	src += scount - 1;			/* point to last char */
	dest += dcount -1;
	while(scount && dcount) {
		if( (*dest = a2h(*src)) > 0xf)
			return (-1);
		scount--;
		src--;
		if(!scount) 
			break;
		c = a2h(*src);
		if (c > 0xf)
			return(-1);
		*dest += c * base;
		scount--;
		src--;
		dcount--;
		dest--;
	}
	return 1;
}
		
/****************************************************************************
Name : a2h
Returns : byte for the ascii passed
Synopsis : It converts an ascii to a hex value
****************************************************************************/
byte a2h(byte chr)
{
	if (chr >= '0' && chr <= '9')
		return((byte)(chr - '0'));
	chr |= CAPS_MASK;						/* make it lower case */
	return((byte)(chr + 0xA - 'a'));
}


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : little_endian																 */
/* PURPOSE       : To convert a double word in 86(68k) format into a double 	 */
/*                    word 68k(86) 															 */
/* PARAMETER     : num																			 */
/*                   -double word															 */
/*                   -holds the number to be converted								 */
/* RETURN VALUE  : returns a double word													 */
/*-----------------------------------------------------------------------------*/
dword little_endian(dword num)
{
	  dword num2;
	  byte *str;
	  byte *str2;
	  str=(byte *)&num;
	  str2=(byte *)&num2;
	  if ((int)sizeof(num)==(int)4)
	    {
	      str2[3]=str[0];
	      str2[2]=str[1];
	      str2[1]=str[2];
	      str2[0]=str[3];
		 }
	  else
	    { 
		  str2[0]=str[1];
		  str2[1]=str[0];
		 }
	  return(num2);
}

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : ltl_endian_word(num)													 */
/* PURPOSE       : To convert a word in 68k format into a word in 86 format and*/
/*                   vice versa																 */ 
/* PARAMETER     : num																			 */
/*                   -word																		 */
/*                   -holds the number to be converted								 */
/* RETURN VALUE  : returns the converted number											 */
/*-----------------------------------------------------------------------------*/
word ltl_endian_word(word num)
  {
    word num2;
    byte *str2, *str1;

	 str1=(byte *)&num;
	 str2=(byte *)&num2;
	 str2[0]=str1[1];
	 str2[1]=str1[0];
	 return(num2);
  }
