/* AGDEBUG.C -- Some debug code. Not included finally.
** By: Sanjay
** Start: 23, July, 1996
** Done: 30, August, 1996
*/

#include "rtrstd.h"

#include "kag.h"

#ifdef MEM_DEBUG

#include "vagstr.h"
#include "agpkttyp.h"
#include "agutil.h"

#include "agdebug.h"

#define MAX_RECORD			256

typedef struct MEM_ENTRY {
	unsigned char in_use;		/* 0 = free, 1 = inuse */
	void *buf_ptr;
	unsigned long size;
	void *link;
} MEM_ENTRY;

MEM_ENTRY ipxspx_alloced_list[MAX_RECORD];

STATIC void add_to_alloced_ipxspx_list(void *buf_ptr);
STATIC void remove_from_alloced_ipxspx_list(void *buf_ptr);

/* -- CODE ------------------------------------------------------------- */

STATIC void add_to_alloced_ipxspx_list(void *buf_ptr)
{
	int i;

	for (i = 0; i < MAX_RECORD; i++)
	{
		if (ipxspx_alloced_list[i].in_use == 0)
		{
			ipxspx_alloced_list[i].in_use = 1;
			ipxspx_alloced_list[i].buf_ptr = buf_ptr;
			ipxspx_alloced_list[i].size = *(unsigned long *)((BYTE *)buf_ptr - sizeof(void *) - sizeof(unsigned long));
			ipxspx_alloced_list[i].link = *(void **)((BYTE *)buf_ptr - sizeof(void *));
			return;
		}
	}
	printf("AG MEM DEBUG: No space to record buffer allocation\n\r");
}

STATIC void remove_from_alloced_ipxspx_list(void *buf_ptr)
{
	int i;
	int one_free = 0;
	void *recorded_ptr, *ptr;
	unsigned long recorded_size, size;

	for (i = 0; i < MAX_RECORD; i++)
	{
		if (ipxspx_alloced_list[i].in_use == 1)
		{
			if (ipxspx_alloced_list[i].buf_ptr == buf_ptr)
			{
				recorded_size = ipxspx_alloced_list[i].size;
				size = *(unsigned long *)((BYTE *)buf_ptr - sizeof(void *) - sizeof(unsigned long));
				if (recorded_size != size)
				{
					DebugBreak();
					printf("AG: 1 Malloced memory seems to be corrupted\n\r");
				}
				recorded_ptr = ipxspx_alloced_list[i].link;
				ptr = *(void **)((BYTE *)buf_ptr - sizeof(void *));
				if (recorded_ptr != ptr)
				{
					DebugBreak();
					printf("AG: 2 Malloced memory seems to be corrupted\n\r");
				}
				ipxspx_alloced_list[i].in_use = 0;
				ipxspx_alloced_list[i].buf_ptr = NULL;
				ipxspx_alloced_list[i].size = 0;
				ipxspx_alloced_list[i].link = NULL;
				return;
			}
		}
		else
			one_free = 1;
	}
	if (one_free)
	{
		DebugBreak(); 
		printf("AG MEM DEBUG: Freeing buffer pointer that was never allocated!!!\n\r");
	}
	else
		printf("AG MEM DEBUG: Freeing buffer pointer not found in full record list\n\r");
}

BYTE *mbm(USHORT data_size)
{
	BYTE *bptr;

	bptr = (BYTE *)buffer_malloc(data_size);
	add_to_alloced_ipxspx_list(bptr);

	return bptr;
}

BYTE *mtm(ULONG num_items, ULONG item_size)
{
	BYTE *bptr;

	bptr = (BYTE *)buffer_malloc(num_items * item_size);
	add_to_alloced_ipxspx_list(bptr);

	memset(bptr, 0, num_items * item_size);

	return bptr;
}

void mbf(BYTE *bptr)
{
	remove_from_alloced_ipxspx_list(bptr);
	buffer_free(bptr);
}

void mtf(void *bptr)
{
	remove_from_alloced_ipxspx_list(bptr);
	buffer_free(bptr);
}

/* -- END CODE -------------------------------------------------------- */

#endif /* MEM_DEBUG */

