/* AGINIT.C -- Init code for the AG Server
** By: Sanjay
** Start: 10, July, 1996
** Done: 30, August, 1996
*/

#include "rtrstd.h"

#include "kag.h"
#include "vagstr.h"
#include "agpkttyp.h"
#include "agutil.h"

#include "agctrl.h"
#include "agtimer.h"
#include "agnetif.h"
#include "agline.h"
#include "aginit.h"

#include "vnvag.h"

/* Local Prototypes */


/* Globals */
AG_CLASS ag;

/* Externals */
/* Picked up below from RTRWARE.C. Easier...though bad */
typedef struct VERSION_DATE {
	char	Version[8];
	char	Date[24];
	int		MagicNum;
} VERSION_DATE;
extern VERSION_DATE VersionDate;

/* -- CODE ------------------------------------------------------------- */

enum TEST initialize_ag(ULONG clock_ticks_per_second)
{
	if (ag.enabled == FALSE)
	{
		ag_printf(AG_INIT_PRINTF, "AG: AsyncGateway not initialized (disabled)\n\r");
		return PASS;
	}

	/* Since the working of AG depends on the working of the configured
	** network interface, refuse to bring up AG if the network interface
	** is not up.
	*/
	if (is_ag_net_interface_up() == FALSE)
	{
		ag_printf(AG_INIT_PRINTF, "AG: AsyncGateway not initialized as the network interface is down\n\r");
		return PASS;
	}

	ag.clock_ticks_per_second = clock_ticks_per_second;

	if ((enum TEST) lsl_control(REGISTER_APPLICATION, "AsyncGateway", ASYNC_GATEWAY, ag_timer, ag_control, &ag.application_id) == FAIL)
	{
		ag_printf(AG_INIT_PRINTF, "AG: AsyncGateway failed to register properly...application disabled\n\r");
		ag.enabled = FALSE;
		return PASS;
	}

	if (initialize_network_interface() == FAIL)
	{
		ag_printf(AG_INIT_PRINTF, "AG: AsyncGateway initialization failed...application disabled\n\r");
		ag.enabled = FALSE;
		return PASS;
	}

	if (initialize_line_information() == FAIL)
	{
		ag_printf(AG_INIT_PRINTF, "AG: AsyncGateway initialization failed...insufficient memory\n\r");
		ag.enabled = FALSE;
		return PASS;
	}

	ag.inbound_skip_ring = TRUE;
	ag.next_session_id_to_use = 0;

	memcpy(ag.version_string, VersionDate.Version, VERSION_STRING_LENGTH);
	ag.version_string[VERSION_STRING_LENGTH - 1] = '\0';

	get_current_date_time(&ag.boot_time);
	ag.timer_enabled = TRUE;
	ag_printf(AG_INIT_PRINTF, "AG: AsyncGateway initialization successful\n\r");
	return PASS;
}


/* -- END CODE -------------------------------------------------------- */

