/* AGINTERN.C -- Code to generate packets from within AG to be sent to
**				 clients as responses.
** By: Sanjay
** Start: 30, July, 1996
** Done: 30, August, 1996
*/

#include "rtrstd.h"

#include "kag.h"
#include "vagstr.h"
#include "agpkttyp.h"
#include "agutil.h"

#include "agnetif.h"
#include "agintern.h"

/* Local Prototypes */
STATIC void do_disconnect_send_complete_actions(SESSION_TABLE_ENTRY *sptr_session_entry);

/* -- CODE ------------------------------------------------------------- */

void send_disconnect_packet(SESSION_TABLE_ENTRY *sptr_session_entry, LINE_INFO_ENTRY *sptr_line_info, BYTE free_reason)
{
	USHORT data_size;
	UNION_AG_PACKET *sptr_ag_packet;


	sptr_line_info->freeup_reason = free_reason;
	sptr_session_entry->freeup_session = TRUE;

	data_size = sizeof(BYTE) + sizeof(CONNECTION_ABORT_TYPE);
	sptr_ag_packet = (UNION_AG_PACKET *)get_a_network_send_packet(data_size);
	if (sptr_ag_packet == NULL)
	{
		/* No buffer to complete this. We could perhaps wait and retry
		** some other time. For now, assuming that most times malloc will
		** be successful, we ignore the small chance of failing and if it
		** does, cleanup normally.
		*/
		ag_printf(AG_ALARM_PRINTF, "AG: Insufficient memory to inform client of disconnect\n\r");

		do_disconnect_send_complete_actions(sptr_session_entry);
		return;
	}

	/* Formulate a disconnect packet */
	sptr_ag_packet->packet_class = AG_CONNECT_ABORTED;
	sptr_ag_packet->packet_type.connection_abort_packet.channel_number = sptr_line_info->line_id;
	sptr_ag_packet->packet_type.connection_abort_packet.abort_reason = free_reason;

#ifdef DEBUG
	ag_printf(AG_MCSI_OUT_PRINTF, "AG: Sending DISCONNECT packet \n\r");
#endif /* DEBUG */
	change_endian(sptr_ag_packet);
	if (send_network_internal_packet(sptr_session_entry, sptr_ag_packet, data_size) == FAIL)
	{
		/* No buffer to complete this. We could perhaps wait and retry
		** some other time. For now, assuming that most times malloc will
		** be successful, we ignore the small chance of failing and if it
		** does, cleanup normally.
		*/
		ag_printf(AG_ALARM_PRINTF, "AG: Insufficient memory to inform client of disconnect\n\r");

		free_a_network_send_packet((BYTE *)sptr_ag_packet);
		do_disconnect_send_complete_actions(sptr_session_entry);
	}
}

/* ---------- Support functions for above functions ----------------------- */

void internal_sends_callback(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet)
{
	free_a_network_send_packet((BYTE *)sptr_ag_packet);
	do_disconnect_send_complete_actions(sptr_session_entry);
}

STATIC void do_disconnect_send_complete_actions(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	LINE_INFO_ENTRY *sptr_line_info;


	if (sptr_session_entry->freeup_session != TRUE)
		return;

	sptr_session_entry->freeup_session = FALSE;

	sptr_line_info = &ag.line_info_array[sptr_session_entry->line_in_use];

	if (sptr_line_info->freeup_reason == AGFL_CD_DROPPED)
	{
		sptr_line_info->freeup_reason = 0;
		sptr_session_entry->session_status = AG_SESS_CANCELLING;

		/* Do the following to be able to return all serial received buffers 
		** back to the serial driver.
		*/
		cancel_pending_network_calls(sptr_session_entry);

		/* In timer check to see when all posts are complete for this
		** session. When this happens, take the state to active while
		** freeing up the associated line.
		*/
		return;
	}

	/* In all other cases, abort the session. The call below will do the
	** job.
	*/

	terminate_network_connection(sptr_session_entry);
}

/* -- END CODE --------------------------------------------------------- */

