/* AGIPX.C -- Code related to dealing with the IPX interface (new code;
**			  old code is retained below under #if conditional compile)
** By: Sanjay
** Start: 1, August, 1996
** Done: 30, August, 1996
*/

#include "rtrstd.h"

#include "kag.h"
#include "..\..\stacks\ipx\kipx.h"
#include "..\..\stacks\ipx\vipxstr.h"
#include "vagstr.h"
#include "agipx.h"

/* External Prototypes */
extern void wait_for_connection(void);

/* Statics */
STATIC SAP_ID ag_SAP_id;

/* Externals */
extern IPX_CLASS ipx_class;

/* -- CODE ----------------------------------------------------------------*/

enum TEST initialize_for_ipx_spx()
{
	memcpy(&ag_SAP_id, get_ipx_internal_SAP_id(), sizeof(SAP_ID));	
	ag_SAP_id.SAP_type = swap(AG_IPX_SERVER_TYPE);
	ag_SAP_id.ipx_address.socket = swap(AG_IPX_SERVICE_SOCKET);
	ag_SAP_id.intervening_networks = swap (0x0001);
	ag_SAP_id.SAP_name[SERVER_NAME_LENGTH - 1] = '\0';

	if (add_SAP_entry((USHORT) (ipx_class.number_of_ports - ipx_class.remote_access_enabled),&ag_SAP_id,
			(ETHERNET_ADDRESS *) &ag_SAP_id.ipx_address.node_address,TRUE,TRUE,IPX_SAP,NULL) == FAIL)
		return FAIL;

	strncpy(ag.server_name, ag_SAP_id.SAP_name, SERVER_NAME_LENGTH);
	ag.server_name[SERVER_NAME_LENGTH - 1] = '\0';

	ag.ipx_interface.max_net_rx_buffer_size = MAX_NET_RX_BUFFER_SIZE;

	wait_for_connection();

	return PASS;
}


/* -- END CODE ------------------------------------------------------------*/




/*************************************************************************
** The original code is below. All of the IPX code is related to doing  **
** periodic SAP broadcasts advertising the server and responding to SAP **
** queries. Replaced the whole code with a simple mechanism -- now we   **
** directly put the SAP entry into the IPX layer SAP tables during init **
** time. The IPX layer periodically broadcasts the entry and takes care **
** of responding to queries.                                            **
*************************************************************************/

#if 0
/* AGIPX.C -- Code related to dealing with the IPX interface
** By: Sanjay
** Start: 10, July, 1996
** Done: 11, July, 1996
** NOTE: !!!See General Notes below before any modifications are done here!!!
*/

/* General Notes:
** 1. We use a header here (VIENDSTR.H) that has a structure declaration
**    for an Event Control Block (ECB) that can be used for IPX packets.
**	  This struct declaration is different from the one used for SPX 
**	  purposes.	So take care not to include SPX code in this file.
** 2. This IPX section generally is for doing periodic SAP broadcasts and
**    responding to SAP queries.
*/

#include "rtrstd.h"

#include "kag.h"
#include "vagstr.h"
#include "agpkttyp.h"
#include "agutil.h"

#include "..\..\stacks\ipx\kipx.h"
#include "..\..\stacks\ipx\vipxstr.h"
#include "..\..\stacks\ipx\endstatn\kipxends.h"
#include "..\..\stacks\ipx\endstatn\viendstr.h"

#include "ipx.h"

#include "agdebug.h"
#include "agspx.h"
#include "agipx.h"

/* Local Prototypes */
STATIC enum TEST initialize_broadcast_structures(void);
STATIC void issue_ag_sap_send(AG_SAP_BROADCAST_PACKET *response_to_use, IPX_ADDRESS *ipx_destination_address, MAC_ADDRESS *destination_address);
STATIC void sap_send_post_routine(EVENT_CONTROL_BLOCK *ecb_ptr);
STATIC void wait_for_query(void);
STATIC void sap_request_post_routine(EVENT_CONTROL_BLOCK *ecp_ptr);
STATIC IPX_PACKET *get_an_ipx_fragment_buffer(USHORT buf_size);
STATIC void free_an_ipx_fragment_buffer(BYTE *buf_ptr);

/* Local Structures */
typedef struct SAP_QUERY_BUFFER {
	BYTE extra_space[64];
	MAC_HEADER mac_header;
	IPX_HEADER ipx_header;
	AG_SAP_BROADCAST_PACKET sap_packet;
} SAP_QUERY_BUFFER;

/* Local Data */
STATIC AG_SAP_BROADCAST_PACKET service_broadcast_packet;
STATIC AG_SAP_BROADCAST_PACKET service_response_packet;
STATIC EVENT_CONTROL_BLOCK query_ecb;
STATIC SAP_QUERY_BUFFER query_buffer;

/* External Data */
extern ULONG router_timer;


/* -- CODE ------------------------------------------------------------- */

enum TEST initialize_for_ipx_spx()
{
	ag.ipx_interface.max_net_rx_buffer_size = MAX_NET_RX_BUFFER_SIZE;

	if (initialize_broadcast_structures() == FAIL)
		return FAIL;

	wait_for_query();
	wait_for_connection();

	return PASS;
}

STATIC enum TEST initialize_broadcast_structures()
{
	USHORT temp_socket;

	temp_socket = swap(AG_IPX_SAP_SOCKET);
	if (ipx_open_socket(&temp_socket) != IPX_END_STATION_OK)
	{
		return FAIL;
	}

	/* Init the service broadcast and broadcast response packets */

	service_broadcast_packet.response_type = swap(SAP_GENERAL_RESPONSE);
	service_broadcast_packet.server_type = swap(AG_IPX_SERVER_TYPE);
	strcpy(service_broadcast_packet.server_name, ipx_get_internal_name());
	ipx_get_internetwork_address((IPX_ADDRESS *)&service_broadcast_packet.network_ID);
	service_broadcast_packet.request_socket = swap(AG_IPX_SAP_SOCKET); /* Keep this after above */
	service_broadcast_packet.hops = swap(0x0001);

	ag.ipx_interface.last_broadcast_timer = 0;

	service_response_packet.response_type = swap(SAP_NEAREST_RESPONSE);
	service_response_packet.server_type = swap(AG_IPX_SERVER_TYPE);
	strcpy(service_response_packet.server_name, ipx_get_internal_name());
	ipx_get_internetwork_address((IPX_ADDRESS *)&service_response_packet.network_ID);
	service_response_packet.request_socket = swap(AG_IPX_SAP_SOCKET); /* Keep this after above */
	service_response_packet.hops = swap(0x0001);

	return PASS;
}

void do_ipx_interface_periodic_actions()
{
	MAC_ADDRESS immediate_address;
	IPX_ADDRESS ipx_destination_address;


	if (ag.ipx_interface.broadcast_interval + ag.ipx_interface.last_broadcast_timer < router_timer)
	{
		ipx_get_internetwork_address((IPX_ADDRESS *)&ipx_destination_address.network);
		ipx_destination_address.node_address._ulong = 0xFFFFFFFF;
		ipx_destination_address.node_address._ushort = 0xFFFF;
		ipx_destination_address.socket = swap(AG_IPX_SAP_SOCKET);

		immediate_address._ulong = 0xFFFFFFFF;
		immediate_address._ushort = 0xFFFF;
		issue_ag_sap_send(&service_broadcast_packet, &ipx_destination_address, &immediate_address);
		ag.ipx_interface.last_broadcast_timer = router_timer;
	}

	if (ag.issue_listen == TRUE)
		wait_for_connection();
}


STATIC void issue_ag_sap_send(AG_SAP_BROADCAST_PACKET *response_to_use, IPX_ADDRESS *ipx_destination_address, MAC_ADDRESS *destination_address)
{
	EVENT_CONTROL_BLOCK *ecb_ptr;
	IPX_PACKET *sptr_ipx_send_packet;


	/* Allocate and initialize an ECB */
	ecb_ptr = (EVENT_CONTROL_BLOCK *)buffer_malloc(sizeof(EVENT_CONTROL_BLOCK));
	if (ecb_ptr == NULL)
		return;

	sptr_ipx_send_packet = get_an_ipx_fragment_buffer(sizeof(AG_SAP_BROADCAST_PACKET));
	if (sptr_ipx_send_packet == NULL)
	{
		mbf(ecb_ptr);
		return;
	}

	ecb_ptr->fptr_event_service_routine = sap_send_post_routine;
	ecb_ptr->socket_number = swap(AG_IPX_SAP_SOCKET);
	ecb_ptr->immediate_address = *destination_address;
	ecb_ptr->fragment_count = 1;
	ecb_ptr->fragment_descriptor[0].size_of_buffer = sizeof(AG_SAP_BROADCAST_PACKET) +
		sizeof(MAC_HEADER) + sizeof(IPX_HEADER);
	ecb_ptr->fragment_descriptor[0].type.vptr_buffer = (void *)sptr_ipx_send_packet;


	/* Init the IPX header */
	sptr_ipx_send_packet->ipx_header.packet_type = 0;
	sptr_ipx_send_packet->ipx_header.destination = *ipx_destination_address;

	memcpy(sptr_ipx_send_packet->data, response_to_use, sizeof(AG_SAP_BROADCAST_PACKET));

	/* Send away... */
	if (ipx_end_station_send_packet(ecb_ptr, TRUE) == FAIL)
	{
		ag_printf(AG_ALARM_PRINTF, "AG: IPX Send Packet failed\n\r");

		free_an_ipx_fragment_buffer((BYTE *)sptr_ipx_send_packet);
		mbf(ecb_ptr);
	}
}

STATIC void sap_send_post_routine(EVENT_CONTROL_BLOCK *ecb_ptr)
{
	if (ecb_ptr->completion_code != IPX_USER_TX_OK)
		ag_printf(AG_ALARM_PRINTF, "AG: IPX Send Packet posted with bad error code\n\r");
	
	/* Free data buffer */
	free_an_ipx_fragment_buffer((BYTE *)ecb_ptr->fragment_descriptor[0].type.vptr_buffer);

	/* Free ECB */
	mbf(ecb_ptr);
}

STATIC void wait_for_query()
{
	/* Wait for a SAP request on the LAN */

	query_ecb.fptr_event_service_routine = sap_request_post_routine;
	query_ecb.socket_number = swap(AG_IPX_SAP_SOCKET);
	query_ecb.fragment_count = 1;
	query_ecb.fragment_descriptor[0].size_of_buffer = sizeof(SAP_QUERY_BUFFER);
	query_ecb.fragment_descriptor[0].type.vptr_buffer = (void *)&query_buffer;

	if (ipx_listen_for_packet(&query_ecb, NULL) != IPX_END_STATION_OK)
	{
		ag_printf(AG_ALARM_PRINTF, "AG: IPX Listen for packet failed...will not listen anymore\n\r");
	}
}

STATIC void sap_request_post_routine(EVENT_CONTROL_BLOCK *ecb_ptr)
{
	/* Handle a request by sending a response */

	USHORT sap_response_type;
	IPX_PACKET *sptr_ipx_packet;
	MAC_ADDRESS immediate_address;
	IPX_ADDRESS ipx_destination_address;
	AG_SAP_QUERY_PACKET *sptr_sap_query_packet;


#ifdef DEBUG
	printf("AG: Got a SAP request\n\r");
#endif /* DEBUG */

	if (ecb_ptr->completion_code == IPX_END_STATION_OK)
	{
		/* We need to make sure whether the packet received is really
		** a SAP query packet.
		*/
		sptr_ipx_packet = (IPX_PACKET *)ecb_ptr->fragment_descriptor[0].type.vptr_buffer;
		if (swap(sptr_ipx_packet->ipx_header.length) == sizeof(IPX_HEADER) + sizeof(AG_SAP_QUERY_PACKET))
		{
			/* Seems like a valid query packet...so reply appropriately */

			sptr_sap_query_packet = (AG_SAP_QUERY_PACKET *) &(sptr_ipx_packet->data[0]);
			sap_response_type = SAP_INVALID_RESPONSE;
			switch (swap(sptr_sap_query_packet->server_type))
			{
			case 0xFFFF:
				switch (swap(sptr_sap_query_packet->query_type))
				{
				case SAP_GENERAL_QUERY:
					sap_response_type = SAP_GENERAL_RESPONSE;
					break;
				case SAP_NEAREST_QUERY:
					/* Not allowed */
					break;
				}
				break;
			case AG_IPX_SERVER_TYPE:
				switch (swap(sptr_sap_query_packet->query_type))
				{
				case SAP_GENERAL_QUERY:
					sap_response_type = SAP_GENERAL_RESPONSE;
					break;
				case SAP_NEAREST_QUERY:
					sap_response_type = SAP_NEAREST_RESPONSE;
					break;
				}
				break;
			default:
				break;
			}

			if (sap_response_type != SAP_INVALID_RESPONSE)
			{
				ipx_destination_address = sptr_ipx_packet->ipx_header.source;
				immediate_address = ecb_ptr->immediate_address;

				service_response_packet.response_type = sap_response_type;
#ifdef DEBUG
				printf("AG: Sending a SAP response to query\n\r");
#endif /* DEBUG */
				issue_ag_sap_send(&service_response_packet, &ipx_destination_address, &immediate_address);
			}
		}
	}
#ifdef DEBUG
	else
		printf("AG: IPX Listen for Packet posted badly\n\r");
#endif

	wait_for_query();		/* Keep waiting... */
}

void deinitialize_ipx_spx()
{
	/* NOTE: !! Implementation incomplete as this is usually not required !! */

	USHORT temp_socket;

	/* Cancel pending IPX receive */

	/* Close socket */
	temp_socket = swap(AG_IPX_SAP_SOCKET);
	ipx_close_socket(temp_socket);
}

/* -- Utility routines follow --------------------------------------------- */

/* get_an_ipx_fragment_buffer()
**	Returns a buffer of requested size + sizeof(MAC_HEADER) + 
**	sizeof(IPX_HEADER) + some extra bytes (64). The returned pointer will
**	point to the MAC_HEADER or will be NULL. Beware.
*/
STATIC IPX_PACKET *get_an_ipx_fragment_buffer(USHORT buf_size)
{
	BYTE *buf_ptr;
	USHORT actual_buf_size;


	actual_buf_size = buf_size + sizeof(IPX_HEADER) + sizeof(MAC_HEADER) + 64;
	buf_ptr = (BYTE *)buffer_malloc(actual_buf_size);

#ifdef MEM_DEBUG
	add_to_alloced_ipxspx_list(buf_ptr);
#endif /* MEM_DEBUG */
   
	if (buf_ptr != NULL)
	{
		buf_ptr += 64;
	}
	return (IPX_PACKET *)buf_ptr;
}

/* free_an_ipx_fragment_buffer()
**	Frees a buffer that was allocated earlier using the 
**  get_an_ipx_fragment_buffer() function and sent to the IPX layer and got
**	back in the post routine. In the post routine, the pointer will now
**	point to the MAC header.
*/
STATIC void free_an_ipx_fragment_buffer(BYTE *buf_ptr)
{
	if (buf_ptr == NULL)
	{
		ag_printf(AG_ALARM_PRINTF, "AG: NULL pointer request to free\n\r");
		return;
	}
	buf_ptr -= 64;
#ifdef MEM_DEBUG
	remove_from_alloced_ipxspx_list(buf_ptr);
#endif /* MEM_DEBUG */
	mbf(buf_ptr);
}
#endif
/* -- END CODE -------------------------------------------------------- */

