/* AGNETIF.H -- Header to AGNETIF.C
*/

#ifndef _AGNETIF_H_
#define _AGNETIF_H_

extern enum BOOLEAN is_ag_net_interface_up(void);
extern enum TEST initialize_network_interface(void);
extern void do_network_interface_periodic_actions(void);
extern enum TEST allocate_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void free_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void send_network_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
extern enum TEST send_network_internal_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern enum TEST send_serial_rx_packet_on_network(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern USHORT get_max_network_rx_buffer_size(void);
extern BYTE *get_a_network_send_packet(USHORT data_size);
extern void free_a_network_send_packet(BYTE *bptr);
extern void reduce_network_receives(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void increase_network_receives(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void free_network_stuff(UNION_AG_PACKET *sptr_ag_packet);
extern enum BOOLEAN wait_for_network_packets(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void reduce_receives_and_wait_for_network_packets(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void terminate_network_connection(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum BOOLEAN network_says_ok_to_cleanup(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum BOOLEAN network_says_cancels_done(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void cancel_pending_network_calls(SESSION_TABLE_ENTRY *sptr_session_entry);
extern ULONG get_client_network_number(SESSION_TABLE_ENTRY *sptr_session_entry);
extern ULONG get_client_node_number_ulong(SESSION_TABLE_ENTRY *sptr_session_entry);
extern USHORT get_client_node_number_ushort(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void fill_user_address(SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_address);


#endif /* _AGNETIF_H_ */
