/* AGRX.C -- Code handling receives from the serial side
** By: Sanjay
** Start: 23, July, 1996
** Done: 30, August, 1996
*/

#include "rtrstd.h"

#include "kag.h"
#include "vagstr.h"
#include "agpkttyp.h"
#include "agutil.h"
#include "agnetif.h"
#include "agrx.h"
#include "aginbsup.h"

/* -- CODE ------------------------------------------------------------- */

void serial_rx_callback(USHORT line_id, SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_rx_data, USHORT rx_data_size)
{
	USHORT data_size;
	LINE_INFO_ENTRY *sptr_line_info;
	UNION_AG_PACKET *sptr_ag_packet;

#ifdef DEBUG
	printf("AG: Received a serial packet, port %u, size %u\n\r", line_id, rx_data_size);
#endif /* DEBUG */

	sptr_line_info = &ag.line_info_array[line_id];
	if (ag.owned_by_module[line_id] == INBOUND_MODULE && sptr_line_info->inbound_init_on == TRUE)
	{
		/* Some special handling during the init phase of inbound alone */

		serial_input_during_inbound_init(sptr_line_info, sptr_rx_data, rx_data_size);

		ag.fptr_rx_complete(line_id, sptr_rx_data);
		return;
	}

/* Naveen 01/01/1997 */

	if (sptr_line_info->line_status != AGLS_LINE_BUSY)
	{
		ag.fptr_rx_complete(line_id, sptr_rx_data);
		return;
	}

/* Naveen 01/01/1997 */

	if (sptr_session_entry == NULL)
	{
		ag.fptr_rx_complete((USHORT)line_id, sptr_rx_data);
		return;
	}

	if (sptr_session_entry->session_status == AG_SESS_ABORTED)
	{
		ag.fptr_rx_complete((USHORT)line_id, sptr_rx_data);
		return;
	}

	if (ag.fptr_msm_init_phase_callback[line_id] != NULL)
	{
		/* Modem init is going on. During this time, data is to go only to
		** the modem state machine module.
		*/
		ag.fptr_msm_init_phase_callback[line_id](line_id, sptr_rx_data, rx_data_size);
		ag.fptr_rx_complete(line_id, sptr_rx_data);

		return;
	}

	/* Create space for the MCSI header by moving pointer back. The serial
	** driver has reserved space for this.
	*/
	sptr_ag_packet = (UNION_AG_PACKET *)(((BYTE *)sptr_rx_data) - (sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE)));
	sptr_ag_packet->packet_class = AG_DATA_PACKET;
	sptr_ag_packet->packet_type.data_packet.channel_number = line_id;
	sptr_ag_packet->packet_type.data_packet.packet_size = rx_data_size;

	/* Statistics update */
	update_line_line_rx_statistics(line_id, rx_data_size);

	/* Reset the inactivity timer */
	sptr_line_info->inactivity_timer = sptr_line_info->line_vars.idle_time;

	data_size = rx_data_size + sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE);
	change_endian(sptr_ag_packet);
	if (send_serial_rx_packet_on_network(sptr_session_entry, sptr_ag_packet, data_size) == FAIL)
	{
		ag.fptr_rx_complete(line_id, sptr_rx_data);
	}
}

/* -- END CODE -------------------------------------------------------- */
