/* CODE HERE IS NOT ACTUALLY USED. YOU CAN EXTRACT AND USE THIS STUFF IF
** REQUIRED. RELATES TO SUPPORT FOR XON/XOFF FLOW CONTROL THAT IS NOT USED
** BY US. 10, August, 1996.
*/

/* Following can go into KAG.H */
enum XON_XOFF {
	XON  = 0,
	XOFF = 1
};

/* Following function can go into AGINTERN.C */
void send_xon_xoff_packet(SESSION_TABLE_ENTRY *sptr_session_entry, LINE_INFO_ENTRY *sptr_line_info, enum XON_XOFF xon_xoff)
{
	USHORT data_size;
	UNION_AG_PACKET *sptr_ag_packet;


	data_size = sizeof(BYTE) + sizeof(FLOW_CONTROL_TYPE);
	sptr_ag_packet = (UNION_AG_PACKET *)get_a_network_send_packet(data_size);
	if (sptr_ag_packet == NULL)
	{
		ag_printf(AG_ALARM_PRINTF, "AG: Insufficient memory to send XON/XOFF packet\n\r");
		
		return;						/* We can do nothing about this now */
	}

	sptr_ag_packet->packet_class = AG_FLOW_CONTROL;
	sptr_ag_packet->packet_type.flow_control_packet.stop_send = (BYTE)xon_xoff;
	sptr_ag_packet->packet_type.flow_control_packet.wait_time = calculate_wait_time(sptr_line_info);

	ag_printf(AG_MCSI_OUT_PRINTF, "AG: Sending XON/XOFF packet \n\r");
	change_endian(sptr_ag_packet);
	if (send_network_internal_packet(sptr_session_entry, sptr_ag_packet, data_size) == FAIL)
	{
		ag_printf(AG_ALARM_PRINTF, "AG: Insufficient memory to send XON/XOFF packet\n\r");
		
		free_a_network_send_packet((BYTE *)sptr_ag_packet);
		return;						/* We can do nothing about this now */
	}
}

/* Following functions can go into AGUTIL.C */

/* calculate_wait_time()
**	When we send an XOFF packet to a client, we also send a timer count
**	in PC timer ticks estimating the duration that the client should stop 
**	sending before attempting to transmit again. This function calculates 
**	this timer count as a function of the number of bytes from the client 
**	waiting to go out on the serial side and the current baud rate.
** NOTE: In our case (as compare to a driver on a PC), it is diffcult to
**	give such a time estimate due to the WAY the SCC uses buffers rather than
**	bytes.
*/
USHORT calculate_wait_time(LINE_INFO_ENTRY *sptr_line_info)
{
	USHORT wait_time;
	USHORT port_number = (USHORT)sptr_line_info->line_id;


	wait_time = serial_get_tx_time_estimate(port_number);
	ag_printf(AG_LINE_PRINTF, "AG: WAN %u: XOFF period = %u\n\r", port_number, wait_time);
	return wait_time;
}

void send_xoff_to_client(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	LINE_INFO_ENTRY *sptr_line_info;
	BYTE line_id = sptr_session_entry->line_in_use;


	if (line_id == UNKNOWN_LINE)
		return;

	sptr_line_info = &ag.line_info_array[line_id];
	send_xon_xoff_packet(sptr_session_entry, sptr_line_info, XOFF);
}


void send_xon_to_client(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	LINE_INFO_ENTRY *sptr_line_info;
	BYTE line_id = sptr_session_entry->line_in_use;


	if (line_id == UNKNOWN_LINE)
		return;

	sptr_line_info = &ag.line_info_array[line_id];
	send_xon_xoff_packet(sptr_session_entry, sptr_line_info, XON);
}

