#include <stddef.h>
#include <stdio.h>
#include "dhcp.h"

#include "kdhcps.h"
#include "vdhcpsst.h"
#include "dhcpsdata.h"
#include	<vnvrmstr.h>

#include	<cnffile.h>    / * Jo */
#include "vnvdhcp.h"

/* Jo 24/7/98 : Made changes for Small proxy	*/

	 /* Imran 8/10/98 */
int init_dhcp_server_class(char *dhcp_cfg_ptr); 
void add_dhcp_option(void *value, BYTE_ENUM (DHCP_OPTION_TYPE) option_type,BYTE option_length, int tag_number);
 	/* Imran 8/10/98 */

/* Jo 24/07/98 */
int dhcp_read_configuration (char *cptr_config) ;
void print_dhcp_configured_parameters () ;
/* Jo 24/07/98 */

/* Jo 24/07/98 : reads the DHCP configuration from flash into DHCP_CLASS 
					  starting from the location specified by cptr_config */

int dhcp_read_configuration (char *cptr_config)
{
	 CNF_DHCP *dhcp_ptr ;
	 USHORT section_length ;
	 dhcp_ptr = (CNF_DHCP *)cptr_config ;
	 if (dhcp_ptr->dhcp_header.magic_number != CNF_DHCP_MAGIC_NUMBER)
			return (0) ;
	
	 section_length = dhcp_ptr->dhcp_header.section_length ;
 /* Imran 8/10/98 */
	 if (!init_dhcp_server_class (cptr_config))
	 		return (0);
 /* Imran 8/10/98 */

	 return (section_length) ;
}

int init_dhcp_server_class(char *dhcp_cfg_ptr)
{
	char *cptr_temp;
	int next_byte,index;
	USHORT no_of_binds,mac_address_length,i,j;
	DHCP_STATIC_BINDING_ENTRY *sptr_temp_bind;
	CNF_DHCP_ADDRESS_RANGE *dhcp_addr_range_ptr;
	CNF_OPTIONS_INFO *dhcp_option_ptr;
	CNF_DHCP  *dhcp_ptr;
	CNF_BINDING_INFO *dhcp_bind_ptr;

	dhcp_ptr = (CNF_DHCP *) dhcp_cfg_ptr;
	dhcp_server.enabled = (enum BOOLEAN) dhcp_ptr->dhcp_header.dhcp_server_enabled;
	dhcp_server.number_of_tags = dhcp_ptr->dhcp_header.number_of_address_range_entries;
/* 14/06/99 Jo Added for RAS */ 
	dhcp.config.relay_agent_enabled = 0 ;
	dhcp.config.client_enabled = dhcp_ptr->dhcp_header.dhcp_client_enabled ;
	dhcp.config.server_ip_address = dhcp_ptr->dhcp_header.dhcp_server_ip_address ;
/* 14/06/99 Jo Added for RAS */ 
	dhcp_server.sptr_dhcp_database = NULL ;

	dhcp_server.sptr_tag_list = (DHCP_TAG_DEFINITION *) calloc (dhcp_server.number_of_tags , sizeof (DHCP_TAG_DEFINITION));
	if(dhcp_server.sptr_tag_list == NULL)
	{
	 	printf("\nDHCP Server : Failed to allocate memory space for tag list\n");
		return (0);
	}
	dhcp_addr_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) ((ULONG)dhcp_ptr + sizeof(CNF_DHCP_HEADER));

	for(i=0 ;i < dhcp_server.number_of_tags; i++)
	{
		dhcp_server.sptr_tag_list[i].lower_ip_address = dhcp_addr_range_ptr->lower_ip_address;
	 	dhcp_server.sptr_tag_list[i].higher_ip_address = dhcp_addr_range_ptr->higher_ip_address;
		dhcp_server.sptr_tag_list[i].subnet_mask = dhcp_addr_range_ptr->address_mask;
 
		if((dhcp_addr_range_ptr->exclude_lower_ip_address) && (dhcp_addr_range_ptr->exclude_higher_ip_address)) 
		{
		   dhcp_server.sptr_tag_list[i].sptr_exclusion_list =  (DHCP_EXCLUSION_ENTRY *) malloc (sizeof(DHCP_EXCLUSION_ENTRY));
			if (dhcp_server.sptr_tag_list[i].sptr_exclusion_list == NULL)
		   {
	  			printf("\nDHCP Server : Failed to allocate memory for dhcp exclusion list");
				return (0);
			}
			dhcp_server.sptr_tag_list[i].sptr_exclusion_list->sptr_next_entry = NULL;
			dhcp_server.sptr_tag_list[i].sptr_exclusion_list->lower_ip_address = dhcp_addr_range_ptr->exclude_lower_ip_address;
			dhcp_server.sptr_tag_list[i].sptr_exclusion_list->higher_ip_address = dhcp_addr_range_ptr->exclude_higher_ip_address;
		}
		else
		{
			dhcp_server.sptr_tag_list[i].sptr_exclusion_list = NULL;
		}	
			
		dhcp_server.sptr_tag_list[i].sptr_binding_list = NULL; 
		no_of_binds = dhcp_addr_range_ptr->number_of_bindings_entries;
   	dhcp_bind_ptr = (CNF_BINDING_INFO *) ((ULONG) dhcp_addr_range_ptr + (sizeof(CNF_DHCP_ADDRESS_RANGE) - sizeof(CNF_BINDING_INFO)));

	 	for(j = 0;j < no_of_binds;j++)
   	{
			mac_address_length = (USHORT) dhcp_bind_ptr->mac_address_length;
			sptr_temp_bind = (DHCP_STATIC_BINDING_ENTRY *) malloc (sizeof(DHCP_STATIC_BINDING_ENTRY) + (ULONG) (mac_address_length) - 1);
			if (sptr_temp_bind == NULL)
   	   {
			  	printf("\nDHCP SERVER : Failed to allocate memory for static binding entries");
				return (0);
		   }   		
			sptr_temp_bind->ip_address = dhcp_bind_ptr->ip_address;
			sptr_temp_bind->mac_address_length = dhcp_bind_ptr->mac_address_length;		  	

			cptr_temp = &dhcp_bind_ptr->mac_address[0];
			for (index = 0 ; index < sptr_temp_bind->mac_address_length  ; index++)
	      {
      	   sscanf (cptr_temp, "%2x", &next_byte) ;
         	sptr_temp_bind->mac_address[index] = next_byte ;
         	cptr_temp += 2 ;
   	   }
			sptr_temp_bind->sptr_next_entry = dhcp_server.sptr_tag_list[i].sptr_binding_list;
			dhcp_server.sptr_tag_list[i].sptr_binding_list = sptr_temp_bind;
			dhcp_bind_ptr = (CNF_BINDING_INFO *) ((ULONG) dhcp_bind_ptr + sizeof(CNF_BINDING_INFO));
  		}
		dhcp_option_ptr = (CNF_OPTIONS_INFO *) ((ULONG) dhcp_addr_range_ptr + (sizeof(ULONG) *  5) + sizeof(USHORT)) ;
		dhcp_server.sptr_tag_list[i].sptr_option_list = NULL;

	  /* Before adding any other options,add the subnet mask also as an option.*/
		add_dhcp_option((void *) &dhcp_server.sptr_tag_list[i].subnet_mask, SUBNET_MASK, (BYTE) sizeof(ULONG), i);

		if(dhcp_option_ptr->router_address != 0) 
			add_dhcp_option((void *) &dhcp_option_ptr->router_address,ROUTER, (BYTE) sizeof(ULONG), i);

		if(dhcp_option_ptr->domain_name[0] != 0)
			add_dhcp_option((void *) &dhcp_option_ptr->domain_name, DOMAIN_NAME, (BYTE) strlen(dhcp_option_ptr->domain_name) + 1, i);
		
		if(dhcp_option_ptr->reassembly_size != 0)
			add_dhcp_option((void *) &dhcp_option_ptr->reassembly_size, MAXIMUM_REASSEMBLY_SIZE, (BYTE) sizeof(USHORT), i);
		
		if(dhcp_option_ptr->default_ip_ttl != 0)
			add_dhcp_option((void *) &dhcp_option_ptr->default_ip_ttl, TTL, (BYTE) sizeof(BYTE), i);

		if(dhcp_option_ptr->mtu != 0) 
			add_dhcp_option((void *) &dhcp_option_ptr->mtu, MTU, (BYTE) sizeof(USHORT), i);
		
		if(dhcp_option_ptr->default_tcp_ttl != 0) 
			add_dhcp_option((void *) &dhcp_option_ptr->default_tcp_ttl, TCP_TTL, (BYTE) sizeof(BYTE), i);

		if(dhcp_option_ptr->lease_time != 0)
			add_dhcp_option((void *) &dhcp_option_ptr->lease_time, IP_ADDRESS_LEASE_TIME , (BYTE) sizeof(ULONG), i);
		
		dhcp_addr_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) ((ULONG) dhcp_addr_range_ptr + sizeof(CNF_DHCP_ADDRESS_RANGE) + ((no_of_binds - 1) * sizeof(CNF_BINDING_INFO)));
	}

#if PRINT_CONFIG
	print_dhcp_configured_parameters () ;
#endif
	return (TRUE);
}

void add_dhcp_option(void *value, BYTE_ENUM (DHCP_OPTION_TYPE) option_type,BYTE option_length,int tag_number)
{
	DHCP_OPTION_ENTRY *sptr_temp_option;

	sptr_temp_option = (DHCP_OPTION_ENTRY *) malloc (sizeof(DHCP_OPTION_ENTRY) - sizeof(DHCP_UNION_OPTION_DATA_TYPES) + option_length);
	if(sptr_temp_option == NULL)
	{
		printf("\nDHCP Server : Failed to allocate memory for dhcp options list\n");
		return;
	}
	sptr_temp_option->option_type = option_type;
	sptr_temp_option->option_length = option_length;
	memcpy( &sptr_temp_option->option_data, value, option_length);

	sptr_temp_option->sptr_next_option_entry = dhcp_server.sptr_tag_list[tag_number].sptr_option_list;
	dhcp_server.sptr_tag_list[tag_number].sptr_option_list = sptr_temp_option;
}

/* Jo 19/04/99 */
#if PRINT_CONFIG
void print_dhcp_configured_parameters ()
{
	BYTE temp_buf[1024],buffer[512];
	BYTE dot_lower_ip[16],dot_higher_ip[16],dot_net_mask[16];
	DHCP_OPTION_ENTRY *sptr_temp_option;
	int i;

	sprintf(temp_buf,"dhcp_enabled : %d\n"
		   			  "number_of_tags : %ld\n",
						  dhcp_server.enabled,
						  dhcp_server.number_of_tags);

	for( i=0 ;i < dhcp_server.number_of_tags; i++)
	{
		if(!dhcp_server.sptr_tag_list[i].lower_ip_address)
			strcpy(dot_lower_ip,"0.0.0.0");
		else
			ulong_to_dot_format(&dot_lower_ip[0], dhcp_server.sptr_tag_list[i].lower_ip_address );

		ulong_to_dot_format( &dot_higher_ip[0], dhcp_server.sptr_tag_list[i].higher_ip_address );
		ulong_to_dot_format( &dot_net_mask[0], dhcp_server.sptr_tag_list[i].subnet_mask );
		sprintf(buffer, "\nTAG %d\n"
 							 "lower_ip_address  : %s\n"	
							 "higher_ip_address : %s\n"
							 "address_mask      : %s\n",
							 i,
							 dot_lower_ip,
							 dot_higher_ip,
							 dot_net_mask);
		strcat(temp_buf,buffer);
		printf("\n%s",temp_buf);
		temp_buf[0] = 0;

		dhcp_display_exclusion_list(dhcp_server.sptr_tag_list[i].sptr_exclusion_list);
		dhcp_display_binding_list(dhcp_server.sptr_tag_list[i].sptr_binding_list);

		sptr_temp_option = dhcp_server.sptr_tag_list[i].sptr_option_list;
		while(sptr_temp_option)
		{
			switch(sptr_temp_option->option_type)
			{
				case ROUTER : 
						sprintf(buffer,"\nrouter addr - %ld\n",sptr_temp_option->option_data._ulong);
	   				break;

				case DOMAIN_NAME : 
						sprintf(buffer,"\ndomain_name - %s",sptr_temp_option->option_data.byte_array);
						break;

				case MAXIMUM_REASSEMBLY_SIZE :
						sprintf(buffer,"\nmax reass - %d", sptr_temp_option->option_data._ushort);
						break;

				case TTL : 
						sprintf(buffer,"\nttl  - %d", sptr_temp_option->option_data._byte);
						break;

				case MTU :
						sprintf(buffer,"\nmtu - %d", sptr_temp_option->option_data._ushort);
						break;

				case TCP_TTL : 
						sprintf(buffer,"\ntcp_ttl - %d", sptr_temp_option->option_data._byte);
						break;

				case IP_ADDRESS_LEASE_TIME :
						sprintf(buffer,"\nlease time - %ld",sptr_temp_option->option_data._ulong);
						break;

				default :
						buffer[0] = 0;
				      break;
			}
			strcat(temp_buf,buffer);
			sptr_temp_option = sptr_temp_option->sptr_next_option_entry; 
		}
		printf("%s",temp_buf);
		temp_buf[0] = 0;
	}
}
#endif
