/* --------------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July 1996 - October 1996
 --------------------------------------------------------------------------*/
#include "dhcp.h"

/* Jo 24/7/98 : Made changes for Small proxy	*/

DHCP_CLASS			dhcp;
DHCP_CLIENT_INFO  dhcp_client_addr_info[TOTAL_NUMBER_OF_PORTS];

static enum TEST register_dhcp (void);
static void initialize_dummy_values(void); 
extern void enable_ip_bootp_params_for_dhcp_relay_agent (void);


#if DHCP_SERVER
void initialize_dhcp_server (ULONG) ;
#endif

/* --------------------------------------------------------------------------
	 Function: intialize_dhcp
	 Input: Number of clock ticks per second
	 Synopsis: Called from main, initializes defaults , socket interface
 --------------------------------------------------------------------------*/
enum TEST initialize_dhcp (ULONG clock_ticks_per_second)
{
	dhcp.timer_class.clock_ticks_per_second = clock_ticks_per_second;
   dhcp.maximum_transmission_unit = MAXIMUM_PACKET_LENGTH;

#if DHCP_SERVER
   initialize_dhcp_server (clock_ticks_per_second) ;
#endif
	
	if (register_dhcp () == FAIL)	 
	{
		printf ("DHCP : Unable to register to LSL\n") ;
		return (FAIL);
	}

/* Jo 13/10/98 */
#if 0 
#if DHCP_SERVER
   return (PASS);
#endif
#endif
/* Jo 13/10/98 */

	/* Initialize client HARDWARE addresses with initial dummy identifiers */
	initialize_dummy_values();        

	/* Register the application  */
	dhcp.relay_agent_address = get_ip_address (LAN_PORT);

	if (initialize_dhcp_socket_interface()	== FAIL)
	{
		printf ("DHCP : Failed to initialize socket interface\n") ;
#if DHCP_SERVER
#else
      return (PASS);
#endif
	}

#if 0 /* 02/06/99 Jo taken Big Proxy Code Commented by Naveen on 25/6/1998 */
/* 18\06\1997 */
	if(dhcp.config.relay_agent_enabled == TRUE)
	{
		enable_ip_bootp_params_for_dhcp_relay_agent();
	}
/* 18\06\1997 */
#endif 

#if 0
	printf ("DHCP Relaying enabled : %d\n", dhcp.config.relay_agent_enabled );
	printf("DHCP Server IP Address : %08X\n", dhcp.config.server_ip_address);
	printf("DHCP Relay Agent LAN IP Address : %08X\n", dhcp.relay_agent_address);
#endif

	dhcp.timer_class.timer_enabled = TRUE;
   dhcp.enabled = TRUE; 

	printf("DHCP initialized successfully\n");
	return (PASS);
}

/* --------------------------------------------------------------------------
	 Function: register_dhcp
	 Input: None
	 Synopsis: Registers DHCP as an application 
 --------------------------------------------------------------------------*/
static enum TEST register_dhcp (void)
{
#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "DHCP", DHCP_APPLICATION, dhcp_timer, dhcp_control,
		&dhcp.application_id) == FAIL)
	{
		return (FAIL);
	}
	return (PASS);
#else
	return (FAIL);
#endif
}

/* --------------------------------------------------------------------------
	 Function: dhcp_control
	 Input: None
	 Synopsis: Control function maps to a list of operations called from outside 
 --------------------------------------------------------------------------*/
enum TEST dhcp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	PARAMETER_NOT_USED (parameter_0);
	PARAMETER_NOT_USED (parameter_1);
	
	if (dhcp.enabled != TRUE)
		return (FAIL) ;
	
	switch (command)
	{
		case START_APPLICATION:
			break;

		case TERMINATE_APPLICATION:
			dhcp.timer_class.timer_enabled = FALSE;
			lsl_control ((ULONG) DEREGISTER_APPLICATION, (ULONG) APPLICATION_LAYER_TYPE, dhcp.application_id);
      	dhcp_client_addr_info[parameter_0 ].port_status = FALSE;
			dhcp.enabled = FALSE;
			break;

      case ISSUE_DHCP_BROADCAST:
			send_dhcp_packet(parameter_0, parameter_1);
			dhcp.remote_access_enabled = TRUE;
			break; 

		case GIVE_BACK_IP_ADDRESS:
			dhcp.remote_access_enabled = FALSE;
         send_dhcp_packet(parameter_0, parameter_1);
			break;

		case IS_APPLICATION_ENABLED:
			parameter_1 = dhcp.enabled;
			break;

		default:
 			/* printf("DHCP :Command not supported\n\r") ; */
			break;
	 }
   
	 return(PASS);
}

/* --------------------------------------------------------------------------
	 Function: initialize_dummy_values
	 Input: None
	 Synopsis: Function to initialize dummy MAC addresses for WAN ports(Clients)
 --------------------------------------------------------------------------*/
static void initialize_dummy_values()
{
   BYTE i ;
	ULONG rnd_value;

	for ( i = 1 ; i < TOTAL_NUMBER_OF_PORTS ; i++ )
   {
		rnd_value = GET_RANDOM(1, MAX_RND_VALUE) ;
		memcpy (dhcp_client_addr_info[i].dummy_mac_address, &rnd_value, sizeof(ULONG)) ;
		
		dhcp_client_addr_info[i].request_second_time_indicator = 0;
		dhcp_client_addr_info[i].port_status = IDLE;
   }
}
