#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include "kdhcp.h"
#include "dhcps.h"

#ifdef _BIG_PROXY_ /* Jo */
extern void set_ip_address (char *cptr_ip_address_string,ULONG offset,ULONG ulptr_base) ;

void dhcp_set_tag_count (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3)
{
   ULONG number_of_tags ;

#if 0
   if (dhcp_server.enabled == FALSE)
      return ;
#endif

   sscanf (cptr_start_of_configuration_string, "%d", &number_of_tags) ;
   if (number_of_tags == 0)
      return ;

   dhcp_server.sptr_tag_list = (DHCP_TAG_DEFINITION *) calloc (number_of_tags, sizeof (DHCP_TAG_DEFINITION)) ;
   if (dhcp_server.sptr_tag_list == NULL)
   {
      printf ("DHCP Server : Not enough memory for Tag list\n") ;
      dhcp_server.enabled = FALSE ;
      dhcp_server.number_of_tags = 0 ;
      return ;
   }
   dhcp_server.number_of_tags = number_of_tags ;
}



void dhcp_setup_tag_definition (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3)
{
   char *cptr_temp = cptr_start_of_configuration_string ;
   int tag_number ;
   ULONG ip_address ;

   sscanf (cptr_temp, "%d", &tag_number) ;
#if DHCP_DEBUG
   if (tag_number >= dhcp_server.number_of_tags)
   {
      printf ("DHCP SERVER : Tag Number exceeds number of Tags\n") ;
      return ;
   }
#endif
   cptr_temp = strchr (cptr_temp, ',') ;
   cptr_temp++ ;
   set_ip_address (cptr_temp, (ULONG) offsetof(DHCP_TAG_DEFINITION, lower_ip_address), (ULONG) &dhcp_server.sptr_tag_list[tag_number]) ;

   cptr_temp = strchr (cptr_temp, ',') ;
   cptr_temp++ ;
   set_ip_address (cptr_temp, (ULONG) offsetof(DHCP_TAG_DEFINITION, higher_ip_address), (ULONG) &dhcp_server.sptr_tag_list[tag_number]) ;

   cptr_temp = strchr (cptr_temp, ',') ;
   cptr_temp++ ;
   set_ip_address (cptr_temp, (ULONG) offsetof(DHCP_TAG_DEFINITION, subnet_mask), (ULONG) &dhcp_server.sptr_tag_list[tag_number]) ;

   dhcp_server.sptr_tag_list[tag_number].sptr_option_list = NULL ;
   dhcp_server.sptr_tag_list[tag_number].sptr_exclusion_list = NULL ;
   dhcp_server.sptr_tag_list[tag_number].sptr_binding_list = NULL ;
}



void dhcp_setup_tag_exclusions (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3)
{
   char *cptr_temp = cptr_start_of_configuration_string ;
   int tag_number ;
   DHCP_EXCLUSION_ENTRY *sptr_exclusion_entry ;

   sscanf (cptr_temp, "%d", &tag_number) ;
#if DHCP_DEBUG
   if (tag_number >= dhcp_server.number_of_tags)
   {
      printf ("DHCP SERVER : Tag Number exceeds number of Tags\n") ;
      return ;
   }
#endif
   
   cptr_temp = strchr (cptr_temp, ',') ;
   while (1)
   {
      if (cptr_temp == NULL)
         break ;

      sptr_exclusion_entry = (DHCP_EXCLUSION_ENTRY *) malloc (sizeof (DHCP_EXCLUSION_ENTRY)) ;
      if (sptr_exclusion_entry == NULL)
      {
         printf ("DHCP SERVER : Not Enough Memory to Read Exclusion Lists\n") ;
         return ;
      }

      cptr_temp++ ;
      set_ip_address (cptr_temp, (ULONG) offsetof(DHCP_EXCLUSION_ENTRY, lower_ip_address), (ULONG) sptr_exclusion_entry) ;

      cptr_temp = strchr (cptr_temp, ',') ;
      cptr_temp++ ;
      set_ip_address (cptr_temp, (ULONG) offsetof(DHCP_EXCLUSION_ENTRY, higher_ip_address), (ULONG) sptr_exclusion_entry) ;

      sptr_exclusion_entry->sptr_next_entry = dhcp_server.sptr_tag_list[tag_number].sptr_exclusion_list ;
      dhcp_server.sptr_tag_list[tag_number].sptr_exclusion_list = sptr_exclusion_entry ;

      cptr_temp = strchr (cptr_temp, ',') ;
   }
}


void dhcp_setup_tag_bindings (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3)
{
   char *cptr_temp = cptr_start_of_configuration_string ;
   int mac_address_length, tag_number ;
   ULONG ip_address ;
   DHCP_STATIC_BINDING_ENTRY *sptr_static_binding_entry ;
   int next_byte, i ;
   
   sscanf (cptr_temp, "%d", &tag_number) ;
#if DHCP_DEBUG
   if (tag_number >= dhcp_server.number_of_tags)
   {
      printf ("DHCP SERVER : Tag Number exceeds number of Tags\n") ;
      return ;
   }
#endif

   cptr_temp = strchr (cptr_temp, ',') ;

   while (1)
   {
      if (cptr_temp == NULL)
         break ;

      cptr_temp++ ;
      set_ip_address (cptr_temp, 0L, (ULONG) &ip_address) ;

      cptr_temp = strchr (cptr_temp, ',') ;
      cptr_temp++ ; /* Point to length */
      sscanf (cptr_temp, "%X", &mac_address_length) ;

      cptr_temp = strchr (cptr_temp, ',') ;
      cptr_temp++ ; /* Point to MAC address */

      sptr_static_binding_entry = (DHCP_STATIC_BINDING_ENTRY *) malloc (sizeof(DHCP_STATIC_BINDING_ENTRY) + mac_address_length - 1) ;
      if (sptr_static_binding_entry == NULL)
      {
         printf ("DHCP SERVER : Not Enough Memory for Static Binding Entries\n") ;
         return ;
      }

      sptr_static_binding_entry->ip_address = ip_address ;
      sptr_static_binding_entry->mac_address_length = mac_address_length ;
      for (i = 0 ; i < mac_address_length ; i++)
      {
         sscanf (cptr_temp, "%2x", &next_byte) ;
         sptr_static_binding_entry->mac_address[i] = next_byte ;
         cptr_temp += 2 ;
      }

      sptr_static_binding_entry->sptr_next_entry = dhcp_server.sptr_tag_list[tag_number].sptr_binding_list ;
      dhcp_server.sptr_tag_list[tag_number].sptr_binding_list = sptr_static_binding_entry ;

      cptr_temp = strchr (cptr_temp, ',') ;
   }
}


void dhcp_read_tag_options (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3)
{
   char *cptr_temp = cptr_start_of_configuration_string ;
   int tag_number ;
   int option_type, option_length ;
   int i, ch ;

   sscanf (cptr_temp, "%d", &tag_number) ;
#if DHCP_DEBUG
   if (tag_number >= dhcp_server.number_of_tags)
   {
      printf ("DHCP SERVER : Tag Number exceeds number of Tags\n") ;
      return ;
   }
#endif
   
   cptr_temp = strchr (cptr_temp, ',') ;
   while (1)
   {
      if (cptr_temp == NULL)
         break ;

      cptr_temp++ ;
      sscanf (cptr_temp, "%X,%X", &option_type, &option_length) ;
      cptr_temp = strchr (cptr_temp, ',') ;
      cptr_temp++ ;                         /* Point to Length now */
      cptr_temp = strchr (cptr_temp, ',') ;
      cptr_temp++ ;                          /* Point to Value now */

      for (i = 0 ; i < (int) option_length ; i++)
      {
         sscanf (cptr_temp, "%2x", &ch) ;
         temp_buffer[i] = (BYTE) ch ;
         cptr_temp += 2 ;
      }

      add_dhcp_option_to_list (&dhcp_server.sptr_tag_list[tag_number].sptr_option_list,
         (BYTE) option_type,
         (BYTE) option_length, temp_buffer) ;
      cptr_temp = strchr (cptr_temp, ',') ;
   }
}

#endif
