#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include "dhcps.h"

/* 
History of Changes :
		{Jo, 18 Nov 1999, get_dhcp_ip_address () to check if preferred IP address is excluded}
/*

   NOTE : All handling with the Local Database is in Host Byte order.
*/



#if 0

/* These routines are going to change once we move over to the BOX */
/* ------------------------------------------------------------------------ */\

#define NUMBER_OF_RANGES 7
IP_ADDRESS_RANGE configured_ranges[NUMBER_OF_RANGES] =
{
   {0xC8969602L, 0xC8969664L, 0xFFFFFF00L}, /* 200.150.150.002 - 200.150.150.100 */
   {0xC8969696L, 0xC89696DCL, 0xFFFFFF00L}, /* 200.150.150.150 - 200.150.150.220 */
   {0xC9C8C802L, 0xC9C8C8FEL, 0xFFFFFF00L}, /* 201.200.200.002 - 201.200.200.254 */
   {0xCAC8C802L, 0xCAC8C8FEL, 0xFFFFFF00L}, /* 202.200.200.002 - 202.200.200.254 */
   {0xC8C896AFL, 0xC8C896C8L, 0xFFFFFF00L}, /* 200.200.150.175 - 200.200.150.200 */
   {0xC8C8C8AFL, 0xC8C8C8C8L, 0xFFFFFF00L}, /* 200.200.200.175 - 200.200.200.200 */
   {0x00000000L, 0x00000000L, 0xFFFFFFFFL}
} ;


#define MAX_OPTIONS_PER_RANGE 20
DHCP_OPTION_VALUE dhcp_default_option_values[NUMBER_OF_RANGES][MAX_OPTIONS_PER_RANGE] =
{
   {
      { SUBNET_MASK, 04, "\xff\xff\xff\x0"},
      { ROUTER, 04, "\xC8\x96\x96\x01"},
      { DOMAIN_NAME, 14, "ROUTER.COM"},
      { DNS, 04, "\xC8\x96\x96\x65"},
      { IP_ADDRESS_LEASE_TIME, 04, "\x00\x00\xFF\xFF"},
      { SERVER_ID, 04, (BYTE *)&dhcp_my_node_ip_address},
      { 00 }
   },

   {
      { SUBNET_MASK, 04, "\xff\xff\xff\x0"},
      { ROUTER, 04, "\xC8\x96\x96\x01"},
      { DOMAIN_NAME, 14, "ROUTER.COM"},
      { DNS, 04, "\xC8\x96\x96\x65"},
      { IP_ADDRESS_LEASE_TIME, 04, "\x00\x00\xFF\xFF"},
      { SERVER_ID, 04, (BYTE *)&dhcp_my_node_ip_address},
      { 00 }
   },

   {
      { SUBNET_MASK, 04, "\xff\xff\xff\x0"},
      { ROUTER, 04, "\xC9\xC8\xC8\x01"},
      { DOMAIN_NAME, 14, "ROUTER.COM"},
      { DNS, 04, "\xC8\x96\x96\x65"},
      { IP_ADDRESS_LEASE_TIME, 04, "\x00\x00\xFF\xFF"},
      { SERVER_ID, 04, (BYTE *)&dhcp_my_node_ip_address},
      { 00 }
   },

   {
      { SUBNET_MASK, 04, "\xff\xff\xff\x0"},
      { ROUTER, 04, "\xCA\xC8\xC8\x01"},
      { DOMAIN_NAME, 14, "ROUTER.COM"},
      { DNS, 04, "\xC8\x96\x96\x65"},
      { IP_ADDRESS_LEASE_TIME, 04, "\x00\x00\xFF\xFF"},
      { SERVER_ID, 04, (BYTE *)&dhcp_my_node_ip_address},
      { 00 }
   },

   {
      { SUBNET_MASK, 04, "\xff\xff\xff\x0"},
      { ROUTER, 04, "\xC8\xC8\x96\x01"},
      { DOMAIN_NAME, 14, "SECOND.FLOOR"},
      { DNS, 04, "\xC8\x96\x96\x65"},
      { IP_ADDRESS_LEASE_TIME, 04, "\x00\x00\x00\xFF"},
      { SERVER_ID, 04, (BYTE *)&dhcp_my_node_ip_address},
      { 00 }
   },

   {
      { SUBNET_MASK, 04, "\xff\xff\xff\x0"},
      { ROUTER, 04, "\xC8\xC8\xC8\x01"},
      { DOMAIN_NAME, 14, "FIRST.FLOOR"},
      { DNS, 04, "\xC8\x96\x96\x65"},
      { IP_ADDRESS_LEASE_TIME, 04, "\x00\x00\xFF\xFF"},
      { SERVER_ID, 04, (BYTE *)&dhcp_my_node_ip_address},
      { 00 }
   }

} ;

#endif



int is_ip_address_excluded (ULONG ip_address, int range_index)
{
   DHCP_EXCLUSION_ENTRY *sptr_exclusion_entry ;

   if (range_index >= dhcp_server.number_of_tags)
      return (TRUE) ;

   sptr_exclusion_entry = dhcp_server.sptr_tag_list[range_index].sptr_exclusion_list ;

   while (sptr_exclusion_entry)
   {
      if ((sptr_exclusion_entry->lower_ip_address <= ip_address) &&
          (sptr_exclusion_entry->higher_ip_address >= ip_address))
         return (TRUE) ;

      sptr_exclusion_entry = sptr_exclusion_entry->sptr_next_entry ;
   }

   return (FALSE) ;
}


STATIC ULONG get_ip_address_from_binding_list (int range_index, char mac_address[], BYTE mac_address_length)
{
   DHCP_STATIC_BINDING_ENTRY *sptr_binding_entry ;

   if (range_index >= dhcp_server.number_of_tags)
      return (0L) ;

   sptr_binding_entry = dhcp_server.sptr_tag_list[range_index].sptr_binding_list ;

   while (sptr_binding_entry)
   {
      if ((sptr_binding_entry->mac_address_length == mac_address_length) &&
          (memcmp (&sptr_binding_entry->mac_address[0], &mac_address[0], mac_address_length) == 0))
            return (sptr_binding_entry->ip_address) ;

      sptr_binding_entry = sptr_binding_entry->sptr_next_entry ;
   }
   return (0L) ;
}


STATIC int get_range_index (ULONG ip_address)
{
   int range_index = 0 ;

   /* We start from 1 because index 0 is fixed for the default setup */
   for (range_index = 1 ; range_index < dhcp_server.number_of_tags ; range_index++)
   {
      if ((ip_address & dhcp_server.sptr_tag_list[range_index].subnet_mask) !=
          (dhcp_server.sptr_tag_list[range_index].lower_ip_address & dhcp_server.sptr_tag_list[range_index].subnet_mask))
      {
         continue ;
      }

      /* Note that this is NOT SUFFICIENT for a subnetted environment */

      return (range_index) ;
   }
   return (-1) ;
}


int is_mac_address_bound (char chaddr[], BYTE hlen)
{
   int range_index = 0 ;
   ULONG ip_address ;

   for (range_index = 1 ; range_index < dhcp_server.number_of_tags ; range_index++)
   {
      ip_address = get_ip_address_from_binding_list (range_index, chaddr, hlen) ;
      if (ip_address)
         return (1) ;
   }
   return (0) ;
}


int is_ip_address_bound (ULONG ip_address)
{
   DHCP_STATIC_BINDING_ENTRY *sptr_binding_entry ; 
   int range_index = get_range_index (ip_address) ;

   if (range_index == -1)
      return (0) ;

   sptr_binding_entry = dhcp_server.sptr_tag_list[range_index].sptr_binding_list ;
   while (sptr_binding_entry)
   {
      if (sptr_binding_entry->ip_address == ip_address)
            return (1) ;

      sptr_binding_entry = sptr_binding_entry->sptr_next_entry ;
   }
   return (0) ;
}


int can_ip_address_be_allocated (ULONG ip_address, int range_index)
{
   DHCP_STATIC_BINDING_ENTRY *sptr_binding_entry ;

   if (range_index >= dhcp_server.number_of_tags)
      return (0L) ;

   if ((ip_address <= dhcp_server.sptr_tag_list[range_index].higher_ip_address) &&
       (ip_address >= dhcp_server.sptr_tag_list[range_index].lower_ip_address))
   {
      sptr_binding_entry = dhcp_server.sptr_tag_list[range_index].sptr_binding_list ;
      while (sptr_binding_entry)
      {
         /* Note that by the time this call is made, the binding list is already looked at */
         if (sptr_binding_entry->ip_address == ip_address)
            return (0) ;

         sptr_binding_entry = sptr_binding_entry->sptr_next_entry ;
      }
      return (1) ;
   }
   else
      return (0) ;
}



int get_dhcp_option_length (ULONG client_ip_address, BYTE_ENUM (DHCP_OPTION_TYPE) option_type)
{
   int range_index ;
   DHCP_OPTION_ENTRY *sptr_dhcp_option_entry ;

   range_index = get_range_index (client_ip_address) ;

   if (range_index == -1)
      return (-1) ;

   for (sptr_dhcp_option_entry = dhcp_server.sptr_tag_list[range_index].sptr_option_list ;
        sptr_dhcp_option_entry ;
        sptr_dhcp_option_entry = sptr_dhcp_option_entry->sptr_next_option_entry)
   {
      if (sptr_dhcp_option_entry->option_type == option_type)
         return ((int)sptr_dhcp_option_entry->option_length) ;
   }

   /* Look for the option in the default setup */
   for (sptr_dhcp_option_entry = dhcp_server.sptr_tag_list[0].sptr_option_list ;
        sptr_dhcp_option_entry ;
        sptr_dhcp_option_entry = sptr_dhcp_option_entry->sptr_next_option_entry)
   {
      if (sptr_dhcp_option_entry->option_type == option_type)
         return ((int)sptr_dhcp_option_entry->option_length) ;
   }

   return (-1) ;
}


/* It is assumed that the Byte array is big enough to hold the value */
int get_dhcp_option_value (ULONG client_ip_address, BYTE_ENUM (DHCP_OPTION_TYPE) option_type, BYTE *option_value)
{
   int range_index ;
   DHCP_OPTION_ENTRY *sptr_dhcp_option_entry ;

   range_index = get_range_index (client_ip_address) ;
   if (range_index == -1)
      return (FAIL) ;

   for (sptr_dhcp_option_entry = dhcp_server.sptr_tag_list[range_index].sptr_option_list ;
        sptr_dhcp_option_entry ;  
        sptr_dhcp_option_entry = sptr_dhcp_option_entry->sptr_next_option_entry)
   {
      if (sptr_dhcp_option_entry->option_type == option_type)
      {
         memcpy (option_value, &sptr_dhcp_option_entry->option_data, sptr_dhcp_option_entry->option_length) ;
         return (sptr_dhcp_option_entry->option_length) ;
      }
   }

   /* Now look for the option in the default range */
   for (sptr_dhcp_option_entry = dhcp_server.sptr_tag_list[0].sptr_option_list ;
        sptr_dhcp_option_entry  ; 
        sptr_dhcp_option_entry = sptr_dhcp_option_entry->sptr_next_option_entry)
   {
      if (sptr_dhcp_option_entry->option_type == option_type)
      {
         memcpy (option_value, &sptr_dhcp_option_entry->option_data, sptr_dhcp_option_entry->option_length) ;
         return (sptr_dhcp_option_entry->option_length) ;
      }
   }
   return (FAIL) ;
}


ULONG get_dhcp_ip_address (ULONG preferred_ip_address, ULONG relay_agent_address, BYTE *mac_address, BYTE mac_address_length)
{
   int range_index = get_range_index (relay_agent_address) ;
   ULONG next_ip_address ;

   if (range_index == -1)
      return (0L) ;

   next_ip_address = get_ip_address_from_mac_address (mac_address, mac_address_length) ;
   if (next_ip_address)
   {
      /* There is an entry in the Database which corresponds to this MAC address.
      Make sure that the request is legitimate. That is, check if the entry in the
      database is OK with respect to the relay agent address */

      if (get_range_index (relay_agent_address) == get_range_index (next_ip_address))
         return (next_ip_address) ;

      /* This means, the node has switched places. Makes sense to take it
      off from the database */
      delete_entry_given_ip_address (next_ip_address) ;
   }

   next_ip_address = get_ip_address_from_binding_list (range_index, mac_address, mac_address_length) ;
   if (next_ip_address)
      return (next_ip_address) ;

   if ((is_ip_address_free (preferred_ip_address) == PASS) &&
       (get_range_index (preferred_ip_address) == range_index) &&
       can_ip_address_be_allocated (preferred_ip_address, range_index)

/* ...Jo Added on 18 Nov 1999 If the Server has already allocated an IP address 
		to client and then if that address range is excluded the server was still 
		allocating the same address. To fix this check if the preferred IP Address is 
		in the exclusion list */

		&& (is_ip_address_excluded (preferred_ip_address, range_index) == FALSE))

/* ...Jo Added on 18 Nov 1999 */
	      return (preferred_ip_address) ;

   for (next_ip_address = dhcp_server.sptr_tag_list[range_index].lower_ip_address ;
        next_ip_address <= dhcp_server.sptr_tag_list[range_index].higher_ip_address ;
        next_ip_address++)
   {
      if (is_ip_address_excluded (next_ip_address, range_index))
         continue ;

      if (can_ip_address_be_allocated (next_ip_address, range_index) == 0)
         continue ; /* The IP address is bound to some other MAC address */

      if (is_ip_address_free (next_ip_address) == PASS)
         return (next_ip_address) ;
   }

   /* This means, all the addresses are either offered or leased out
   or are marked dirty. It is best to use up something that has been marked
   dirty */

   next_ip_address = get_first_dirty_ip_address () ;
   if (next_ip_address != 0L)
   {
      delete_entry_given_ip_address (next_ip_address) ;
      return (next_ip_address) ;
   }

   return (0L) ;
}


/* ------------------------------------------------------------------------ */




DHCP_OPTION_ENTRY *add_dhcp_option_entry_to_list (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_link, DHCP_OPTION_ENTRY *sptr_dhcp_new_option)
{
   sptr_dhcp_new_option->sptr_next_option_entry = sptr_dhcp_option_entry_link ;

   return (sptr_dhcp_new_option) ;
}


int delete_option_entry_from_list (DHCP_OPTION_ENTRY **sptr_dhcp_option_entry_list, BYTE_ENUM (DHCP_OPTION_TYPE) option)
{
   PARAMETER_NOT_USED (sptr_dhcp_option_entry_list) ;
   PARAMETER_NOT_USED (option) ;

   return FAIL ;
}


int add_dhcp_option_to_list (DHCP_OPTION_ENTRY **sptr_dhcp_option_entry_list, BYTE_ENUM (DHCP_OPTION_TYPE) option, BYTE length, void *value)
{
   DHCP_OPTION_ENTRY *sptr_dhcp_new_option_entry ;

   sptr_dhcp_new_option_entry = (DHCP_OPTION_ENTRY *) malloc (length + 2 + sizeof (DHCP_OPTION_ENTRY *)) ;
   if (sptr_dhcp_new_option_entry == NULL)
      return (FAIL) ;

   sptr_dhcp_new_option_entry->option_type = option ;
   sptr_dhcp_new_option_entry->option_length = length ;
   memcpy (&sptr_dhcp_new_option_entry->option_data, value, length) ;

   *sptr_dhcp_option_entry_list = add_dhcp_option_entry_to_list (*sptr_dhcp_option_entry_list, sptr_dhcp_new_option_entry) ;

   return (PASS) ;
}

DHCP_OPTION_ENTRY *get_dhcp_option_entry (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_list, BYTE_ENUM (DHCP_OPTION_TYPE) option_type)
{
   while (sptr_dhcp_option_entry_list)
   {
      if (sptr_dhcp_option_entry_list->option_type == option_type)
         return (sptr_dhcp_option_entry_list) ;
      sptr_dhcp_option_entry_list = sptr_dhcp_option_entry_list->sptr_next_option_entry ;
   }
   return (NULL) ;
}

int get_length_of_options (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_list)
{
   int options_length = 0 ;

   while (sptr_dhcp_option_entry_list)
   {
      options_length += sptr_dhcp_option_entry_list->option_length ;
      options_length += sizeof (BYTE) + sizeof (BYTE) ;

      sptr_dhcp_option_entry_list = sptr_dhcp_option_entry_list->sptr_next_option_entry ;
   }

   return (options_length) ;
}


DHCP_OPTION_ENTRY *parse_dhcp_options (void *vptr_dhcp_packet)
{
   DHCP_OPTION_ENTRY *sptr_dhcp_option_list = (DHCP_OPTION_ENTRY *)NULL ;
   DHCP_PACKET *sptr_dhcp_data = (DHCP_PACKET *)vptr_dhcp_packet ;
   DHCP_OPTION *sptr_dhcp_option = (DHCP_OPTION *)&sptr_dhcp_data->options_list[0] ;
   BYTE *bptr_temp ;
   int option_length = 0 ;

   while (sptr_dhcp_option->option_type != DHCP_END_OPTION)
   {
      if (sptr_dhcp_option->option_type == DHCP_PAD_OPTION)
      {
         bptr_temp = (BYTE *)sptr_dhcp_option ;
         bptr_temp++ ;
         sptr_dhcp_option = (DHCP_OPTION *)bptr_temp ;
         option_length++ ;
         break ;
      }
#if DHCP_DEBUG
      if (sptr_dhcp_option->option_length > 50)
      {
         while (1)
         {
            printf ("DHCP : Error in packet parsing\n") ;
         }
      }
#endif
      add_dhcp_option_to_list (&sptr_dhcp_option_list, sptr_dhcp_option->option_type, sptr_dhcp_option->option_length, &sptr_dhcp_option->option_data) ;

      bptr_temp = (BYTE *)sptr_dhcp_option ;
      bptr_temp += (2 + sptr_dhcp_option->option_length) ;
      sptr_dhcp_option = (DHCP_OPTION *)bptr_temp ;
      option_length += sptr_dhcp_option->option_length ;

#if DHCP_DEBUG
      if (option_length > 1200)
      {
         while (1)
         {
            printf ("DHCP : Error in packet parsing\n") ;
         }
      }
#endif

   }
   return (sptr_dhcp_option_list) ;
}



void swing_dhcp_options_into_packet (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_list, BYTE *bptr_dhcp_options)
{
   DHCP_OPTION *sptr_dhcp_option ;

   while (sptr_dhcp_option_entry_list)
   {
      sptr_dhcp_option = (DHCP_OPTION *)bptr_dhcp_options ;

      sptr_dhcp_option->option_type = sptr_dhcp_option_entry_list->option_type ;
      sptr_dhcp_option->option_length = sptr_dhcp_option_entry_list->option_length ;
      memcpy (&sptr_dhcp_option->option_data.byte_array[0], &sptr_dhcp_option_entry_list->option_data.byte_array[0], sptr_dhcp_option_entry_list->option_length) ;

      bptr_dhcp_options += (sptr_dhcp_option_entry_list->option_length + sizeof(BYTE) + sizeof(BYTE_ENUM(DHCP_OPTION_TYPE)));
      sptr_dhcp_option_entry_list = sptr_dhcp_option_entry_list->sptr_next_option_entry ;
   }
   *bptr_dhcp_options = (BYTE) DHCP_END_OPTION ;
}

void free_dhcp_list (DHCP_OPTION_ENTRY *sptr_dhcp_option_list)
{
   if (sptr_dhcp_option_list != NULL)
   {
      free_dhcp_list (sptr_dhcp_option_list->sptr_next_option_entry) ;
      free (sptr_dhcp_option_list) ;
   }
}


void add_server_id_option_to_default_option_list ()
{
   if ((dhcp_server.enabled == FALSE) || (dhcp_server.number_of_tags == 0))
      return ;

   add_dhcp_option_to_list (&dhcp_server.sptr_tag_list[0].sptr_option_list, SERVER_ID, sizeof(dhcp_server.dhcp_my_node_ip_address), (BYTE *)&dhcp_server.dhcp_my_node_ip_address) ;
}

/* Jo 21/04/99 */
#if 0
int does_mac_or_ip_address_belong_to_any_static_binding_list (ULONG ip_address, char mac_address[], BYTE mac_address_length)
{
   int tag_index ;
   DHCP_STATIC_BINDING_ENTRY *sptr_binding_entry ;

   for (tag_index = 1 ; tag_index < dhcp_server.number_of_tags ; tag_index++)
   {
      for (sptr_binding_entry = dhcp_server.sptr_tag_list[tag_index].sptr_binding_list ;
           sptr_binding_entry ;
           sptr_binding_entry = sptr_binding_entry->sptr_next_entry)
      {
         if (ip_address == sptr_binding_entry->ip_address)
            return (TRUE) ;

         if ((mac_address_length == sptr_binding_entry->mac_address_length) &&
             (memcmp (&mac_address[0], &sptr_binding_entry->mac_address[0], mac_address_length) == 0))
         {
            return (TRUE) ;
         }
      }
   }
   return (FALSE) ;
}
#endif
/* Jo 21/04/99 */


/* Jo 21/04/99 */
#if PRINT_CONFIG
enum DHCP_OPTION_DATA_TYPE
{
   BYTE_STREAM_TYPE = 0,
   ULONG_TYPE,
   USHORT_TYPE,
   IP_ADDRESS_TYPE,
   STRING_TYPE
} ;

typedef struct
{
   char *name ;
   enum DHCP_OPTION_DATA_TYPE type ;
} DHCP_OPTION_NAME_AND_TYPE ;

DHCP_OPTION_NAME_AND_TYPE dhcp_option_names[] =
{
   { "DHCP_PAD_OPTION            ", BYTE_STREAM_TYPE },
   { "SUBNET_MASK                ", IP_ADDRESS_TYPE  },
   { "TIME_OFFSET                ", BYTE_STREAM_TYPE },
   { "ROUTER                     ", IP_ADDRESS_TYPE  },
   { "TIME_SERVER                ", IP_ADDRESS_TYPE  },
   { "NAME_SERVER                ", IP_ADDRESS_TYPE  },
   { "DNS                        ", IP_ADDRESS_TYPE  },
   { "LOG_SERVER                 ", IP_ADDRESS_TYPE  },
   { "COOKIE_SERVER              ", IP_ADDRESS_TYPE  },
   { "LPR_SERVER                 ", IP_ADDRESS_TYPE  },
   { "IMPRESS_SERVER             ", IP_ADDRESS_TYPE  },
   { "RESOURCE_LOCATION_SERVER   ", IP_ADDRESS_TYPE  },
   { "HOST_NAME                  ", STRING_TYPE      },
   { "BOOT_FILE_SIZE             ", BYTE_STREAM_TYPE },
   { "MERIT_DUMP_FILE            ", BYTE_STREAM_TYPE },
   { "DOMAIN_NAME                ", STRING_TYPE      },
   { "SWAP_SERVER                ", IP_ADDRESS_TYPE  },
   { "ROOT_PATH                  ", BYTE_STREAM_TYPE },
   { "EXTENSIONS_PATH            ", BYTE_STREAM_TYPE },
   { "IP_FORWARDING_ENABLE       ", BYTE_STREAM_TYPE },
   { "NON_LOCAL_SOURCE_ROUTING   ", BYTE_STREAM_TYPE },
   { "POLICY_FILTER              ", BYTE_STREAM_TYPE },
   { "MAXIMUM_REASSEMBLY_SIZE    ", BYTE_STREAM_TYPE },
   { "TTL                        ", BYTE_STREAM_TYPE },
   { "PATH_MTU_AGING_TIMEOUT     ", BYTE_STREAM_TYPE },
   { "PATH_MTU_PLATEAU_TABLE     ", BYTE_STREAM_TYPE },
   { "MTU                        ", BYTE_STREAM_TYPE },
   { "ALL_SUBNETS_ARE_LOCAL      ", BYTE_STREAM_TYPE },
   { "BROADCAST_ADDRESS          ", BYTE_STREAM_TYPE },
   { "PERFORM_MASK_RECOVERY      ", BYTE_STREAM_TYPE },
   { "MASK_SUPPLIER              ", BYTE_STREAM_TYPE },
   { "PERFORM_ROUTER_DISCOVERY   ", BYTE_STREAM_TYPE },
   { "ROUTER_SOLICITATION        ", BYTE_STREAM_TYPE },
   { "STATIC_ROUTE               ", BYTE_STREAM_TYPE },
   { "TRAILER_ENCAPSULATION      ", BYTE_STREAM_TYPE },
   { "ARP_CACHE_TIMEOUT          ", BYTE_STREAM_TYPE },
   { "ETHERNET_ENCAPSULATION     ", BYTE_STREAM_TYPE },
   { "TCP_TTL                    ", BYTE_STREAM_TYPE },
   { "TCP_KEEP_ALIVE_INTERVAL    ", BYTE_STREAM_TYPE },
   { "TCP_KEEP_ALIVE_GARBAGE     ", BYTE_STREAM_TYPE },
   { "NETWORK_INFORMATION_SERVICE", BYTE_STREAM_TYPE },
   { "NETWORK_INFORMATION_SERVERS", BYTE_STREAM_TYPE },
   { "NETWORK_TIME_PROTOCOL_SERVE", BYTE_STREAM_TYPE },
   { "X_WHAT_IS_THIS             ", BYTE_STREAM_TYPE },
   { "NB_OVER_TCPIP_NAME_SERVER  ", BYTE_STREAM_TYPE },
   { "NB_OVER_TCPIP_DRAM_DIST_SER", BYTE_STREAM_TYPE },
   { "NB_OVER_TCPIP_NODE_TYPE    ", BYTE_STREAM_TYPE },
   { "NB_OVER_TCPIP_SCOPE        ", BYTE_STREAM_TYPE },
   { "X_W_SYSTEM_FONT_SERVER     ", BYTE_STREAM_TYPE },
   { "X_W_SYSTEM_DISPLAY_MANAGER ", BYTE_STREAM_TYPE },
   { "REQUESTED_IP_ADDRESS       ", IP_ADDRESS_TYPE  },
   { "IP_ADDRESS_LEASE_TIME      ", ULONG_TYPE       },
   { "OPTION_OVERLOAD            ", BYTE_STREAM_TYPE },
   { "DHCP_MESSAGE_TYPE          ", BYTE_STREAM_TYPE },
   { "SERVER_ID                  ", IP_ADDRESS_TYPE  },
   { "PARAMETER_REQUEST_LIST     ", BYTE_STREAM_TYPE },
   { "MESSAGE                    ", BYTE_STREAM_TYPE },
   { "MAXIMUM_DHCP_MESSAGE_TYPE  ", BYTE_STREAM_TYPE },
   { "RENEWAL_T1_TIME_VALUE      ", BYTE_STREAM_TYPE },
   { "REBINDING_T2_TIME_VALUE    ", BYTE_STREAM_TYPE },
   { "CLASS_ID                   ", BYTE_STREAM_TYPE },
   { "CLIENT_ID                  ", BYTE_STREAM_TYPE }
} ;

void display_dhcp_options (DHCP_OPTION_ENTRY *sptr_dhcp_option_list)
{
   int temp, index, option_count = 0 ;
   int option_type ;

   buffer_to_print[0] = 0 ;
   strcat (&buffer_to_print[0], "DHCP Options    : ............\n") ;

   while (sptr_dhcp_option_list)
   {
      option_count++ ;
      temp = (int) sptr_dhcp_option_list->option_type ;
      sprintf (temp_buffer, "TYPE : %s ", (temp >= FIRST_UNKNOWN_DHCP_OPTION_TYPE) ?
         "UNKNOWN                    " : dhcp_option_names[temp].name) ;
      strcat (buffer_to_print, temp_buffer) ;
      option_type = dhcp_option_names[temp].type ;

      temp = (int) sptr_dhcp_option_list->option_length ;
      sprintf (temp_buffer, "LENGTH : %02X, DATA : ", temp) ;
      strcat (buffer_to_print, temp_buffer) ;

      switch (option_type)
      {
         case (ULONG_TYPE) :
            sprintf (temp_buffer, "%08X", sptr_dhcp_option_list->option_data._ulong) ;
            strcat (buffer_to_print, temp_buffer) ;
            break ;

         case (IP_ADDRESS_TYPE) :
            strcat (buffer_to_print, ulong_to_dot_format(&temp_buffer[0], sptr_dhcp_option_list->option_data._ulong)) ;
            break ;

         case (STRING_TYPE) :
            for (index = 0 ; index < sptr_dhcp_option_list->option_length ; index++)
               temp_buffer[index] = sptr_dhcp_option_list->option_data.byte_array[index] ;
            temp_buffer[index] = 0 ;
            strcat (buffer_to_print, temp_buffer) ;
            break ;

         default :
            for (index = 0 ; index < (int) sptr_dhcp_option_list->option_length ; index++)
            {
               temp = sptr_dhcp_option_list->option_data.byte_array[index] ;
               sprintf (temp_buffer, "%02X ", temp) ;
               strcat (buffer_to_print, temp_buffer) ;
            }
            break ;
      }

      strcat (buffer_to_print, "\n") ;
      if (strlen (buffer_to_print) >= (MAX_PRINT_BUFFER_SIZE - 100))
      {
         dhcp_server_printf ("%s", buffer_to_print) ;
         buffer_to_print[0] = 0 ;
      }
      sptr_dhcp_option_list = sptr_dhcp_option_list->sptr_next_option_entry ;
   }
   if (option_count && strlen(&buffer_to_print[0]))
      dhcp_server_printf ("%s", buffer_to_print) ;
}

#endif
/* Jo 21/04/99 */
