/* ----------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July 1996 - October 1996
 ---------------------------------------------------------------------- */

/* DHCP constants are defined below */

#define DHCP_CLIENT_PORT				  68
#define DHCP_SERVER_PORT				  67
#define LAN_PORT							  0	
#define TOTAL_NUMBER_OF_PORTS         4

#define HOP_COUNT						  	  01
#define MAX_HOP_COUNT					  16
#define BROADCAST_FLAG                0x80	 /* Check it out!!! */
#define MAC_ADDR_LEN	   				  16
#define SERVER_HOST_NAME_LENGTH       64
#define BOOT_FILE_NAME_LENGTH         128
#define MINIMUM_OPTIONS_LIST_LENGTH   312     /* RFC1542--> 64  */
#define MAGIC_COOKIE                  0x63825363L

#define TICKS_FACTOR                  20
#define WAIT_FOR_RESPONSE_TIME        40
#define NUMBER_OF_REQUESTS            2
#define RENEWAL_TIME_FACTOR           2
#define REBIND_TIME_FACTOR            5
#define DHCP_MINIMUM_PACKET_LENGTH    576
#define MAXIMUM_PACKET_LENGTH         1518
#define MAX_RND_VALUE                 1000

/*  Constants pertaining to DHCP_DISCOVER_OPTIONS_LIST  */

#define DISCOVER_MESSAGE_TYPE_LEN     3
#define DISCOVER_OPTION_LIST_LEN      5

/*  Constants pertaining to DHCP_REQUEST_OPTIONS_LIST  */

#define REQUEST_MESSAGE_TYPE_LEN     3
#define REQUEST_OPTION_LIST_LEN      5
#define IPADDRESS_MESSAGE_TYPE_LEN   6

/* Constants pertaining to DHCP_DECLINE_OPTIONS_LIST */

#define DECLINE_MESSAGE_LENGTH		 30

/* DHCP Option codes are listed below */

#define  SUBNET_MASK_OPTION                  0x01
#define  IP_ADDRESS_LEASE_TIME_OPTION        0x33
#define  MESSAGE_TYPE_OPTION                 0x35
#define  SERVER_IDENTIFIER_OPTION            0x36
#define  PARAMETER_REQUEST_LIST_OPTION       0x37
#define  DECLINE_OPTION                      0x38
#define  RENEWAL_TIME_OPTION                 0x3A
#define  REBIND_TIME_OPTION                  0x3B
#define  END_OPTION                          0xFF

/* define a MACRO for generating random numbers */

#define  GET_RANDOM(min, max) ( (rand() % (int) (max+1- min)) + min )

enum DHCP_OPCODE_TYPE
{
	DHCP_REQUEST = 0x01,
   DHCP_REPLY = 0x02
};

enum HARDWARE_TYPE
{
	ETHERNET_TYPE = 0x01
};

enum ADDRESS_LENGTH
{
	ETHERNET_ADDRESS_LENGTH = 0x06
};

/* DHCP Packet types are listed below  */

enum DHCP_PACKET_TYPE
{
	DHCPDISCOVER           	 =  0x01,
	DHCPOFFER              	 =  0x02,
	DHCPREQUEST            	 =  0x03,
	DHCPDECLINE            	 =  0x04,
	DHCPACK                	 =  0x05,
	DHCPNAK                	 =  0x06,
	DHCPRELEASE            	 =  0x07,
	DHCPREQUEST_LEASE_RENEW	 =  0x08,
	DHCPREQUEST_LEASE_REBIND =  0x09
};

enum DHCP_LEASE_STATE
{
  INIT_STATE = 0x01,
  BOUND_STATE = 0x02,
  LEASE_RENEW_STATE = 0x03,
  LEASE_REBIND_STATE	= 0x04,
  LEASE_EXPIRED_STATE = 0x05
};

enum DHCP_PORT_STATUS
{
	IDLE,
	OFFER_ACCEPTED,
	ACK_ACCEPTED
};

#define DHCP_SERVER 1
