/* ----------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July 1996 - October 1996
 ---------------------------------------------------------------------- */

#ifndef _VDHCPSTR_H_
#define _VDHCPSTR_H_
 
/* This structure defines a DHCP packet  */

typedef struct DHCP_DATA
{
    BYTE_ENUM (DHCP_OPCODE_TYPE)  op_code; 
    BYTE_ENUM (HARDWARE_TYPE)     hardware_type;
	 BYTE_ENUM (ADDRESS_LENGTH)    hardware_addr_len;
	 BYTE									 number_of_hops;
	 ULONG								 transaction_id;
	 USHORT								 seconds;
	 USHORT								 flags_field;
	 ULONG								 client_ip_address;
	 ULONG								 your_ip_address;
	 ULONG								 server_ip_address;
	 ULONG								 gateway_ip_address;
	 BYTE									 client_hardware_address[MAC_ADDR_LEN];
	 BYTE									 server_host_name[SERVER_HOST_NAME_LENGTH];
	 BYTE									 boot_file_name[BOOT_FILE_NAME_LENGTH];
	 BYTE									 options_list[MINIMUM_OPTIONS_LIST_LENGTH];
} DHCP_DATA;

/* This structure defines the format of the DHCPDISCOVER options list */

typedef struct    DHCP_DISCOVER_OPTION
{
    ULONG                         magic_cookie;
    BYTE     							 dicover_message_type[DISCOVER_MESSAGE_TYPE_LEN];
    BYTE                          dhcp_request_list[DISCOVER_OPTION_LIST_LEN];
	 BYTE                          end_of_request_option;
} DHCP_DISCOVER_OPTION;

/* This structure defines the format of the DHCPREQUEST options list */

typedef struct    DHCP_REQUEST_OPTION
{
    ULONG                         magic_cookie;
    BYTE     							 request_message_type[REQUEST_MESSAGE_TYPE_LEN];
    BYTE                          dhcp_request_list[REQUEST_OPTION_LIST_LEN];
    BYTE                          server_id_message_type[IPADDRESS_MESSAGE_TYPE_LEN];
    BYTE                          ipaddress_message_type[IPADDRESS_MESSAGE_TYPE_LEN];  
	 BYTE                          end_of_request_option;
} DHCP_REQUEST_OPTION;

/* Structure defines the DHCP_DECLINE_OPTION  */

typedef struct    DHCP_DECLINE_OPTION
{
    ULONG                         magic_cookie;
    BYTE     							 decline_message_type[REQUEST_MESSAGE_TYPE_LEN];
	 BYTE                          decline_option_array[DECLINE_MESSAGE_LENGTH];
    BYTE                          server_id_message_type[IPADDRESS_MESSAGE_TYPE_LEN];
  	 BYTE                          ipaddress_message_type[IPADDRESS_MESSAGE_TYPE_LEN];  
	 BYTE                          end_of_request_option;
} DHCP_DECLINE_OPTION;

/* Structure defines the DHCP_RELEASE_OPTION  */

typedef struct    DHCP_RELEASE_OPTION
{
    ULONG                         magic_cookie;
    BYTE     							 release_message_type[REQUEST_MESSAGE_TYPE_LEN];
    BYTE                          server_id_message_type[IPADDRESS_MESSAGE_TYPE_LEN];
	 BYTE                          end_of_request_option;
} DHCP_RELEASE_OPTION;

typedef	struct	DCHP_TIMER_CLASS
{
	BYTE_ENUM (BOOLEAN)				timer_enabled;
	ULONG									clock_ticks_per_second;
	ULONG									tick_counter;
} DHCP_TIMER_CLASS;

typedef struct DHCP_CONFIG_CLASS
{
	BYTE_ENUM (BOOLEAN)				relay_agent_enabled;
	ULONG									server_ip_address;
/* Jo 02/06/99 Took from Naveen 26/6/1998 ... */
	BYTE_ENUM (BOOLEAN)				client_enabled;
/* ... Added By Naveen 26/6/1998 */
} DHCP_CONFIG_CLASS;

typedef	struct	DHCP_CLASS
{
	BYTE_ENUM (BOOLEAN)				enabled;
	BYTE_ENUM (BOOLEAN)				remote_access_enabled;
	ULONG 								application_id;
	BYTE_ENUM (BOOLEAN) 				socket_interface_initialized;
	int 									relay_agent_socket_descriptor;
	int 									relay_agent_reply_socket_descriptor;
	ULONG									relay_agent_address;
	USHORT 								maximum_transmission_unit;
	DHCP_TIMER_CLASS 					timer_class;
	DHCP_CONFIG_CLASS					config;
} DHCP_CLASS;

/* This structure maintains the DHCP remote client information */

typedef  struct  DHCP_CLIENT_INFO
{
  BYTE                           port_status;
  BYTE                           requested_message_type;
  ULONG                          ras_ip_address;
  ULONG                          dhcp_server_ip_address;
  ULONG                          dhcp_assigned_ip_address;
  ULONG                          lease_duration_in_ticks;
  ULONG                          lease_renew_time_in_ticks;
  ULONG                          lease_rebind_time_in_ticks;
  ULONG                          subnet_mask;
  BYTE                           dummy_mac_address[MAC_ADDR_LEN];
  ULONG                          client_transaction_id;
  BYTE_ENUM (DHCP_LEASE_STATE)   lease_status;
  BYTE                           request_second_time_indicator;
  BYTE                   			request_and_wait_time_in_ticks;
} DHCP_CLIENT_INFO;

/* This structure maintains the Date and Time format */

typedef struct 
{
    USHORT Year;
    BYTE   Month;
    BYTE   Day;
    BYTE   WeekDay;
    BYTE   Hour;
    BYTE   Minute;
    BYTE   Second;
    BYTE   FracSecond;
} DateTime;

/* dhcpinit.c */

enum TEST dhcp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
extern ULONG get_ip_address (USHORT virtual_port_number);

/*  dhcptimr.c */

void dhcp_timer (void);
/*
extern void ip_set_port_remote_address(BYTE port_number);
*/

/*   dhcpsock.c   */

enum TEST initialize_dhcp_socket_interface(void);
void send_dhcp_packet(BYTE port_num, BYTE packet_type);
int dhcp_read_data_from_socket (char *, int);
void regenarate_and_relay_dhcp_packet (char *);
void forward_reply_packets_to_dhcp_clients(char *);
/*   dhcputil.c    */

BYTE my_bytcmp(char *ptr_1, char *ptr_2,BYTE port_number);
void scan_option_list_and_fill_values(char *ptr_1, BYTE resp_packet_type, BYTE port_number);

#endif /* _VDHCPSTR_H_ */
