/* sudha 8 Jan 1999 */
#define	DEBUG 1 


#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <kstart.h>

#include <string.h>
#include <memory.h>
#include "proxy.h"

#include <redblack.h>
#include "pptprb1.h"

#include "vpptpstr.h"


#include "..\..\stacks\ip\karp.h"
#include "..\..\stacks\ip\kip.h"
#include "..\..\stacks\ip\kipuser.h"
#include "..\..\stacks\ip\varpuser.h"
#include "..\..\stacks\ip\varpstr.h"
#include "..\..\stacks\ip\vrarpusr.h"
#include "..\..\stacks\ip\vrarpstr.h"
#include "..\..\stacks\ip\kroute.h"	  
#include "..\..\stacks\ip\viprtstr.h"	  
#include "..\..\stacks\ip\vipusstr.h"  
#include "..\..\stacks\ip\vsktstr.h"
#include "..\..\stacks\ip\kudp.h"
#include "..\..\stacks\ip\vipktstr.h"
#include "..\..\stacks\ip\kicmp.h"
#include "..\..\stacks\ip\vudpuser.h"
#include "..\..\stacks\ip\vudpbuf.h"
#include "..\..\stacks\ip\vudpstr.h"
#include "..\..\stacks\ip\krip.h"
#include "..\..\stacks\ip\vripstr.h"
#include "..\..\stacks\ip\vicmpstr.h"
#include "..\..\stacks\ip\viprastr.h"
#include "..\..\stacks\ip\vipstr.h" 





extern PPTP_PNS_DESCRIPTOR_NODE *sptr_pptp_pns_descriptor_tree ;
extern PPTP_PAC_DESCRIPTOR_NODE *sptr_pptp_pac_descriptor_tree ;
extern BYTE *get_ptr_to_ip_data_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);


extern PPTP_PNS_DESCRIPTOR_NODE *pptp_pns_descriptor_search	(PPTP_PNS_DESCRIPTOR_NODE *Tree, PPTP_PNS_RB_KEY_TYPE key);
extern PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_search (PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key);
extern BYTE *get_ptr_to_tcp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);

extern void print_pptp_packet_type(USHORT pptp_pkt_type, char *from);

/* sudha taken from BIG_PROXY sources 08 Jan 1999... */
#ifdef DEBUG
extern PPTP_PNS_DESCRIPTOR_NODE *debug_pptp_pns_descriptor_search	(PPTP_PNS_DESCRIPTOR_NODE *Tree, PPTP_PNS_RB_KEY_TYPE key);
extern PPTP_PAC_DESCRIPTOR_NODE *debug_pptp_pac_descriptor_search (PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key);
#endif

/* The following two search routines are added by vidy. This is to take
care of the disconnect packets as they are contain own callid and not
peers' callid. this search is done on the corresponding trees, but since
the trees are not organised with owncallid as the key, they do and exhaustive
comparison. We don't bother the efficiency of these calls as they are not
frequent at all. */
extern PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_search_with_client_call_id
	(PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key);
extern PPTP_PNS_DESCRIPTOR_NODE *pptp_pns_descriptor_search_with_server_call_id
	(PPTP_PNS_DESCRIPTOR_NODE *Tree, PPTP_PNS_RB_KEY_TYPE key);

/* ...sudha taken from BIG_PROXY sources 08 Jan 1999 */

USHORT pptp_client_call_id = 25;
USHORT pptp_server_call_id = 50;


/* sudha taken from BIG_PROXY sources on 8 Jan 1999... */

#ifdef DEBUG
PPTP_PNS_DESCRIPTOR_NODE *debug_pptp_pns_descriptor_search	(PPTP_PNS_DESCRIPTOR_NODE *Tree, PPTP_PNS_RB_KEY_TYPE key)
{
	printf("Search PNS, ip=%lx, id=%d\n", key.destination_address, key.call_id);
	return pptp_pns_descriptor_search	(Tree, key);
}

PPTP_PAC_DESCRIPTOR_NODE *debug_pptp_pac_descriptor_search (PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key)
{
	printf("Search PAC, ip=%lx, id=%d\n", key.destination_ip_address, key.call_id);
	return pptp_pac_descriptor_search	(Tree, key);
}
#endif
/* ... sudha taken from BIG_PROXY sources on 8 Jan 1999 */

/* if we need to assign call id based on destination address we need to
	modify this function */

USHORT get_new_client_call_id (ULONG destination_address)
{
	pptp_client_call_id++;
	
	if (pptp_client_call_id == 0)
		pptp_client_call_id = 25;

	proxy_printf ("PPTP: NEW client call id is %d\n",pptp_client_call_id);
	return (pptp_client_call_id);	
}

/* here packet call id is to be modified */

void process_pptp_outgoing_call_request (OUTGOING_CALL_REQUEST_PKT *ptr_to_pptp_packet,
		IP_PARAMETERS *sptr_ip_parameters, USHORT tx_port_number)
{
	PPTP_INFO_DESCRIPTOR *pptp_info_descriptor;
	PPTP_RB_KEY_TYPE  pptp_pac_key_type;
/*	PPTP_PNS_RB_KEY_TYPE pptp_pns_key_type; */
	
	pptp_info_descriptor = (PPTP_INFO_DESCRIPTOR *) calloc (sizeof (PPTP_INFO_DESCRIPTOR), 1);

	if (pptp_info_descriptor == NULL)
	{
	 	proxy_printf ("PPTP: Memory Allocation Error\n");
		return;
	}
	
	pptp_pac_key_type.destination_ip_address = sptr_ip_parameters->destination_address;

	pptp_info_descriptor->client_call_id = ptr_to_pptp_packet->call_id;
	pptp_info_descriptor->mapped_client_call_id = get_new_client_call_id (sptr_ip_parameters->destination_address);
	pptp_info_descriptor->destination_ip_address = sptr_ip_parameters->destination_address;
	pptp_info_descriptor->source_ip_address = sptr_ip_parameters->source_address;
	pptp_info_descriptor->idle_timer = 5000;
	pptp_info_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;
	pptp_info_descriptor->tx_port_number = tx_port_number;
	pptp_info_descriptor->outgoing_port_address = get_ip_address (tx_port_number);


	ptr_to_pptp_packet->call_id = pptp_info_descriptor->mapped_client_call_id;

	pptp_pac_key_type.call_id = ptr_to_pptp_packet->call_id;
	

#if 0
	pptp_pns_key_type.call_id = pptp_info_descriptor->mapped_call_id;
	pptp_pns_key_type.destination_address = sptr_ip_parameters->destination_address;
#endif

	add_entry_to_pptp_pac_descriptor_tree (pptp_info_descriptor, &pptp_pac_key_type);

/* sudha taken from BIG_PROXY on 8 Jan 1999... */
#ifdef DEBUG
	printf("Add to PAC ip = %lx, id=%d",
		pptp_pac_key_type.destination_ip_address, pptp_pac_key_type.call_id);
#endif
/* ...sudha taken from BIG_PROXY on 8 Jan 1999 */

#if 0
	add_entry_to_pptp_pns_descriptor_tree (pptp_info_descriptor, &pptp_pns_key_tyep);
#endif

	return;

}

/* sudha taken from BIG_PROXY sources on 8 Jan 1999... */

void process_pptp_client_call_clear_request (CALL_CLEAR_REQUEST_PKT *ptr_to_pptp_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	PPTP_RB_KEY_TYPE  pptp_pac_key_type;
	PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_node;

	pptp_pac_key_type.destination_ip_address = sptr_ip_parameters->destination_address;
	pptp_pac_key_type.call_id = ptr_to_pptp_packet->call_id;

	pptp_pac_descriptor_node = 
		pptp_pac_descriptor_search_with_client_call_id
			(sptr_pptp_pac_descriptor_tree, pptp_pac_key_type);

	if (pptp_pac_descriptor_node == NULL)
	{
		proxy_printf ("PPTP: Descriptor Search Failed for Call Clear Request\n");
		return;
	}

	ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)(pptp_pac_descriptor_node->info.ptr_to_pptp_descriptor);

	ptr_to_pptp_packet->call_id = ptr_to_pptp_info->mapped_client_call_id;

#ifdef DEBUG
		printf ("PPTP: call clear req: Changing client Call id from %d  to %d\n", ptr_to_pptp_info->client_call_id,
			ptr_to_pptp_info->mapped_client_call_id);
#endif
}

/* ... sudha taken from BIG_PROXY sources on 8 Jan 1999 */

#if 0

void 	process_pptp_incoming_call_reply ((INCOMING_CALL_REQUEST_PKT *)ptr_to_pptp_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT tx_port_number)
{
	PPTP_INFO_DESCRIPTOR *pptp_info_descriptor;


	pptp_info_descriptor = (PPTP_INFO_DESCRIPTOR *) malloc (sizeof (PPTP_INFO_DESCRIPTOR));

	if (pptp_info_descriptor == NULL)
	{
	 	proxy_printf ("PPTP: Memory Allocation Error\n");
		return;
	}
	
	ptr_to_pptp_info->server_call_id = ptr_to_pptp_packet->call_id;
	ptr_to_pptp_info->mapped_server_call_id = get_mapped_server_call_id(sptr_ip_parameters->destination_address);

	ptr_to_pptp_packet->call_id = ptr_to_pptp_info->mapped_server_call_id;

	pptp_server_key_type.destination_address = sptr_ip_parameters->source_address;
	pptp_server_key_type.call_id = ptr_to_pptp_info->mapped_server_call_id;

	add_entry_to_pptp_pns_descriptor_tree (ptr_to_pptp_info, &pptp_server_key_type);
	return;
	
}
#endif



void process_pptp_wan_error_notify_packet (WAN_ERROR_NOTIFY_PKT *ptr_to_pptp_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	PPTP_PNS_DESCRIPTOR_NODE *pptp_pns_descriptor_node;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	PPTP_PNS_RB_KEY_TYPE pptp_pns_key_type;
	

	pptp_pns_key_type.destination_address = sptr_ip_parameters->destination_address;
	pptp_pns_key_type.call_id = ptr_to_pptp_packet->peers_call_id;

/* sudha taken from BIG_PROXY on 8 Jan 1999... */
#ifdef DEBUG
	pptp_pns_descriptor_node = debug_pptp_pns_descriptor_search (sptr_pptp_pns_descriptor_tree, pptp_pns_key_type);	
#else
	pptp_pns_descriptor_node = pptp_pns_descriptor_search (sptr_pptp_pns_descriptor_tree, pptp_pns_key_type);	
#endif
/* ...sudha taken from BIG_PROXY on 8 Jan 1999 */

	if (pptp_pns_descriptor_node == NULL)
	{
		proxy_printf ("PPTP: Descriptor Search Failed for WAN Error Notify pkt\n");
		return;
	}

	ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)(pptp_pns_descriptor_node->info.ptr_to_pptp_descriptor);

	ptr_to_pptp_packet->peers_call_id = ptr_to_pptp_info->server_call_id;

	proxy_printf ("PPTP: Changing server Call id from %d  to %d\n", ptr_to_pptp_info->mapped_server_call_id,
				ptr_to_pptp_info->server_call_id);

	return;
}

void check_for_pptp_client_packet_and_process (BYTE *uptr_ip_rx_packet , IP_PARAMETERS *sptr_ip_parameters,
		USHORT tx_port_number)
{
	USHORT source_port=0, destination_port=0, pptp_pkt_type=0;
	PPTP_PACKET_HEADER_TYPE *ptr_to_pptp_packet;
	
	destination_port = get_tcp_port_number_from_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters, 
									source_port);
	if (destination_port != PPTP_APPLICATION_PORT)
	{
		return;
	};
	
	ptr_to_pptp_packet = (PPTP_PACKET_HEADER_TYPE *)
				get_ptr_to_tcp_packet (uptr_ip_rx_packet, sptr_ip_parameters) ;

/*	pptp_pkt_type = *(USHORT *)(ptr_to_pptp_packet+8); sudha 8 Jan 1999 */
	pptp_pkt_type = ptr_to_pptp_packet->ctl_msg_type; 

/* Jo	proxy_printf ("PPTP: Received packet type is %d\n", pptp_pkt_type); */

	switch (pptp_pkt_type)
	{
		case PPTP_START_CTL_CONN_REQUEST:
			proxy_printf ("PPTP: Start control connection request packet received\n");
			break;

		case PPTP_START_CTL_CONN_REPLY:
			proxy_printf ("PPTP: Start control connection reply packet received\n");
			break;
			
		case PPTP_STOP_CTL_CONN_REQUEST:
			proxy_printf ("PPTP: Stop control connection request packet received\n");
			break;
  	
		case PPTP_STOP_CTL_CONN_REPLY:
			proxy_printf ("PPTP: Stop control connection reply packet received\n");
			break;
			
		case PPTP_ECHO_REQUEST:
			proxy_printf ("PPTP: Echo request packet received\n");
			break;
			
		case PPTP_ECHO_REPLY:
			proxy_printf ("PPTP: Echo Reply packet received\n");
			break;
			
		case PPTP_OUTGOING_CALL_REQUEST:
			proxy_printf ("PPTP: Outgoing Call Request packet received\n");

			process_pptp_outgoing_call_request ((OUTGOING_CALL_REQUEST_PKT *)ptr_to_pptp_packet, sptr_ip_parameters, tx_port_number);

			break;
			
		case PPTP_OUTGOING_CALL_REPLY:
			proxy_printf ("PPTP: Outgoing Call Reply packet received\n");
			break;
			
		case PPTP_INCOMING_CALL_REQUEST:
			proxy_printf ("PPTP: Incoming Call Request packet received\n");
			break;
			
		case PPTP_INCOMING_CALL_REPLY:
#if 0
			process_pptp_incoming_call_reply ((INCOMING_CALL_REQUEST_PKT *)ptr_to_pptp_packet, sptr_ip_parameters, tx_port_number);
#endif
			proxy_printf ("PPTP: Incoming Call Reply packet received\n");
			break;
			
		case PPTP_INCOMING_CALL_CONNECTED:
			proxy_printf ("PPTP: Incoming Call connected packet received\n");
			break;
			
		case PPTP_CALL_CLEAR_REQUEST:
/* sudha 8 Jan 1999 */
			process_pptp_client_call_clear_request ((CALL_CLEAR_REQUEST_PKT *)ptr_to_pptp_packet, sptr_ip_parameters);
			break;
			
		case PPTP_CALL_DISCONNECT_NOTIFY:
			break;
			
		case PPTP_WAN_ERROR_NOTIFY:
			proxy_printf ("PPTP: WAN Error Notify Packet received\n");
			process_pptp_wan_error_notify_packet ((WAN_ERROR_NOTIFY_PKT *)ptr_to_pptp_packet, sptr_ip_parameters);
			break;
			
		case PPTP_SET_LINK_INFO:
			break;
		
		default:
/*			printf ("PPTP: Packet not recognized\n"); */
			break;
	}
	return;
}


USHORT get_mapped_server_call_id (ULONG destination_ip_address)
{
	pptp_server_call_id++;

	if (pptp_server_call_id == 0)
		pptp_server_call_id = 50;

	proxy_printf ("PPTP: Server call id is %d\n", pptp_server_call_id);

	return pptp_server_call_id;
}

/* sudha taken from BIG_PROXY on 8 Jan 1999... */

/* this is to process a disconnect notify packet from server */
void process_pptp_server_call_disconnect_pkt (CALL_DISCONNECT_NOTIFY_PKT *ptr_to_pptp_packet, 
		IP_PARAMETERS *sptr_ip_parameters)
{
	PPTP_PNS_DESCRIPTOR_NODE *ptr_to_pptp_descriptor_node;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	PPTP_PNS_RB_KEY_TYPE  pptp_pns_key;
	PPTP_RB_KEY_TYPE  pptp_pac_key;

	pptp_pns_key.destination_address = sptr_ip_parameters->source_address;
	pptp_pns_key.call_id = ptr_to_pptp_packet->call_id;

#ifdef DEBUG
	printf("PPTP: Search PNS, ip=%lx, ser_call_id=%d\n",
			pptp_pns_key.destination_address, pptp_pns_key.call_id);
#endif

	ptr_to_pptp_descriptor_node = pptp_pns_descriptor_search_with_server_call_id
			(sptr_pptp_pns_descriptor_tree, pptp_pns_key);

	if (ptr_to_pptp_descriptor_node == NULL)
	{
		printf ("PPTP: Descriptor Search Failed for Reply Packet\n");
	 	return;
	}
	ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *) (ptr_to_pptp_descriptor_node->info.ptr_to_pptp_descriptor);

	ptr_to_pptp_packet->call_id = ptr_to_pptp_info->mapped_server_call_id;
#ifdef DEBUG
	printf ("Changing client call id from %d to %d\n",ptr_to_pptp_info->server_call_id,
				ptr_to_pptp_info->mapped_server_call_id); 
#endif

	/* need to delete the pac and pns tree entries corresponding to
	this call */
	pptp_pac_key.destination_ip_address = sptr_ip_parameters->source_address;
	pptp_pac_key.call_id = ptr_to_pptp_info->mapped_client_call_id;
	if ( !delete_entry_from_pptp_pac_tree (pptp_pac_key))
		printf("PPTP: Couldn't delete PAC node on disconnect\n");


	pptp_pns_key.destination_address = sptr_ip_parameters->source_address;
	pptp_pns_key.call_id = ptr_to_pptp_info->mapped_server_call_id;
	if ( !delete_entry_from_pptp_pns_tree (pptp_pns_key))
		printf("PPTP: Couldn't delete PNS node on disconnect\n");
}

void process_pptp_link_info_packet (SET_LINK_INFO_PKT *ptr_to_pptp_packet, 
		IP_PARAMETERS *sptr_ip_parameters)
{
	PPTP_PAC_DESCRIPTOR_NODE *ptr_to_pptp_descriptor_node;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	PPTP_RB_KEY_TYPE  pptp_pac_key_type;

	pptp_pac_key_type.destination_ip_address = sptr_ip_parameters->source_address;
	pptp_pac_key_type.call_id = ptr_to_pptp_packet->peer_call_id;

#ifdef DEBUG	
	ptr_to_pptp_descriptor_node = debug_pptp_pac_descriptor_search (sptr_pptp_pac_descriptor_tree, pptp_pac_key_type);
#else
	ptr_to_pptp_descriptor_node = pptp_pac_descriptor_search (sptr_pptp_pac_descriptor_tree, pptp_pac_key_type);
#endif

	if (ptr_to_pptp_descriptor_node == NULL)
	{
		printf ("PPTP: Descriptor Search Failed for Link Info.\n");
	 	return;
	}
	ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *) (ptr_to_pptp_descriptor_node->info.ptr_to_pptp_descriptor);

	ptr_to_pptp_packet->peer_call_id = ptr_to_pptp_info->client_call_id;
#ifdef DEBUG
	printf ("Changing client call id from %d to %d\n",ptr_to_pptp_info->mapped_client_call_id,
				ptr_to_pptp_packet->peer_call_id); 
#endif
}
/* ... sudha taken from BIG_PROXY on 8 Jan 1999 */

void process_pptp_outgoing_call_reply  (OUTGOING_CALL_REPLY_PKT *ptr_to_pptp_packet, 
		IP_PARAMETERS *sptr_ip_parameters)
{
	PPTP_PNS_RB_KEY_TYPE pptp_server_key_type;
	PPTP_PAC_DESCRIPTOR_NODE *ptr_to_pptp_descriptor_node;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	PPTP_RB_KEY_TYPE  pptp_pac_key_type;

	pptp_pac_key_type.destination_ip_address = sptr_ip_parameters->source_address;
	pptp_pac_key_type.call_id = ptr_to_pptp_packet->peers_call_id;
	
#ifdef DEBUG	
	ptr_to_pptp_descriptor_node = debug_pptp_pac_descriptor_search (sptr_pptp_pac_descriptor_tree, pptp_pac_key_type);
#else
	ptr_to_pptp_descriptor_node = pptp_pac_descriptor_search (sptr_pptp_pac_descriptor_tree, pptp_pac_key_type);
#endif

	if (ptr_to_pptp_descriptor_node == NULL)
	{
		printf ("PPTP: Descriptor Search Failed for Reply Packet\n");
	 	return;
	}

	ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *) (ptr_to_pptp_descriptor_node->info.ptr_to_pptp_descriptor);

	ptr_to_pptp_info->server_call_id = ptr_to_pptp_packet->call_id;
/* sudha 8 Jan 1999 */
	ptr_to_pptp_info->mapped_client_call_id = ptr_to_pptp_packet->peers_call_id;
	ptr_to_pptp_info->mapped_server_call_id = get_mapped_server_call_id(sptr_ip_parameters->destination_address);

	ptr_to_pptp_packet->peers_call_id = ptr_to_pptp_info->client_call_id;
	ptr_to_pptp_packet->call_id = ptr_to_pptp_info->mapped_server_call_id;
	
	pptp_server_key_type.destination_address = sptr_ip_parameters->source_address;
	pptp_server_key_type.call_id = ptr_to_pptp_info->mapped_server_call_id;

	add_entry_to_pptp_pns_descriptor_tree (ptr_to_pptp_info, &pptp_server_key_type);
#ifdef DEBUG
	printf("Add to PNS ip = %lx, id=%d\n",
		pptp_server_key_type.destination_address, pptp_server_key_type.call_id);
#endif
	return;
}

void check_for_pptp_server_packet_and_process (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT source_port=0, destination_port=0, pptp_pkt_type=0;
	PPTP_PACKET_HEADER_TYPE *ptr_to_pptp_packet;
	
	destination_port = get_tcp_port_number_from_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters, 
									&source_port);

/* Jo	proxy_printf ("PPTP: Source Port : %04x  Destination Port : %04x\n", source_port,
					destination_port);  */

/* Jo 15/3/99 fix for PPTP */

	if (source_port != PPTP_APPLICATION_PORT)
		return;

/* Jo 15/3/99 fix for PPTP */

	ptr_to_pptp_packet = (PPTP_PACKET_HEADER_TYPE *)
				get_ptr_to_tcp_packet (uptr_ip_rx_packet, sptr_ip_parameters) ;
	pptp_pkt_type = ptr_to_pptp_packet->ctl_msg_type;

/* Jo	proxy_printf ("PPTP: Received packet type is %d\n", pptp_pkt_type); */

	switch (pptp_pkt_type)
	{
		case PPTP_START_CTL_CONN_REQUEST:
			proxy_printf ("PPTP: Start control connection request packet received\n");
			break;

		case PPTP_START_CTL_CONN_REPLY:
			proxy_printf ("PPTP: Start control connection reply packet received\n");
			break;
			
		case PPTP_STOP_CTL_CONN_REQUEST:
			proxy_printf ("PPTP: Stop control connection request packet received\n");
			break;
  	
		case PPTP_STOP_CTL_CONN_REPLY:
			proxy_printf ("PPTP: Stop control connection reply packet received\n");
			break;
			
		case PPTP_ECHO_REQUEST:
			proxy_printf ("PPTP: Echo request packet received\n");
			break;
			
		case PPTP_ECHO_REPLY:
			proxy_printf ("PPTP: Echo Reply packet received\n");
			break;
			
		case PPTP_OUTGOING_CALL_REQUEST:
			proxy_printf ("PPTP: Outgoing Call Request packet received\n");
			break;
			
		case PPTP_OUTGOING_CALL_REPLY:
			proxy_printf ("PPTP: Outgoing Call Reply packet received\n");

			process_pptp_outgoing_call_reply ((OUTGOING_CALL_REPLY_PKT *)ptr_to_pptp_packet, sptr_ip_parameters);

			break;
			
		case PPTP_INCOMING_CALL_REQUEST:
			
			proxy_printf ("PPTP: Incoming Call Request packet received\n");
			break;
			
		case PPTP_INCOMING_CALL_REPLY:
			proxy_printf ("PPTP: Incoming Call Reply packet received\n");
			break;
			
		case PPTP_INCOMING_CALL_CONNECTED:
			proxy_printf ("PPTP: Incoming Call connected packet received\n");
			break;
			
		case PPTP_CALL_CLEAR_REQUEST:
			break;
			
		case PPTP_CALL_DISCONNECT_NOTIFY:
/* sudha 8 Jan 1999 */
			process_pptp_server_call_disconnect_pkt ((CALL_DISCONNECT_NOTIFY_PKT *)ptr_to_pptp_packet,sptr_ip_parameters);
			break;
			
		case PPTP_WAN_ERROR_NOTIFY:
			break;
			
		case PPTP_SET_LINK_INFO:
/* sudha 8 Jan 1999 */
		 	process_pptp_link_info_packet ((SET_LINK_INFO_PKT *)ptr_to_pptp_packet, sptr_ip_parameters);
			break;
		
		default:
/*			printf ("PPTP: Packet not recognized\n"); */
			break;
	}
}


PPTP_INFO_DESCRIPTOR *get_ptr_to_pptp_info_from_gre_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	GRE_PACKET_TYPE *ptr_to_gre_packet;
	PPTP_PNS_DESCRIPTOR_NODE *pptp_pns_descriptor_node;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	PPTP_PNS_RB_KEY_TYPE pptp_pns_key_type;

	ptr_to_gre_packet = (GRE_PACKET_TYPE *) get_ptr_to_ip_data_packet((UNION_IP_PACKET *)uptr_ip_rx_packet, sptr_ip_parameters);
	
	pptp_pns_key_type.destination_address = sptr_ip_parameters->destination_address;
	pptp_pns_key_type.call_id = ptr_to_gre_packet->call_id;
 
#ifdef DEBUG	
	pptp_pns_descriptor_node = debug_pptp_pns_descriptor_search (sptr_pptp_pns_descriptor_tree, pptp_pns_key_type);	
#else
	pptp_pns_descriptor_node = pptp_pns_descriptor_search (sptr_pptp_pns_descriptor_tree, pptp_pns_key_type);	
#endif
	
	if (pptp_pns_descriptor_node == NULL)
	{
		printf ("PPTP: Descriptor Search Failed for GRE Packet from Client\n");
		return NULL;
	}

	ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)(pptp_pns_descriptor_node->info.ptr_to_pptp_descriptor);
	return ptr_to_pptp_info;
}


void process_client_gre_packet_if_required (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
		PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info)
{
	GRE_PACKET_TYPE *ptr_to_gre_packet;


	ptr_to_gre_packet = (GRE_PACKET_TYPE *) get_ptr_to_ip_data_packet((UNION_IP_PACKET *)uptr_ip_rx_packet, sptr_ip_parameters);

	ptr_to_gre_packet->call_id = ptr_to_pptp_info->server_call_id;

	proxy_printf ("PPTP: Changing server Call id from %d  to %d\n", ptr_to_pptp_info->mapped_server_call_id,
				ptr_to_pptp_info->server_call_id);

	return;
}


PPTP_INFO_DESCRIPTOR *get_ptr_to_pptp_info_from_gre_response_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	GRE_PACKET_TYPE *ptr_to_gre_packet;
	PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_node;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	PPTP_RB_KEY_TYPE pptp_pac_key_type;

		
	ptr_to_gre_packet = (GRE_PACKET_TYPE *) get_ptr_to_ip_data_packet((UNION_IP_PACKET *)uptr_ip_rx_packet, sptr_ip_parameters);
	
	pptp_pac_key_type.destination_ip_address = sptr_ip_parameters->source_address;
	pptp_pac_key_type.call_id = ptr_to_gre_packet->call_id;

#ifdef DEBUG	
	pptp_pac_descriptor_node = debug_pptp_pac_descriptor_search (sptr_pptp_pac_descriptor_tree, pptp_pac_key_type);	
#else
	pptp_pac_descriptor_node = pptp_pac_descriptor_search (sptr_pptp_pac_descriptor_tree, pptp_pac_key_type);	
#endif
	
	if (pptp_pac_descriptor_node == NULL)
	{
		printf ("PPTP: Descriptor Search Failed for GRE Packet from Server\n");
		return NULL;
	}

	ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)(pptp_pac_descriptor_node->info.ptr_to_pptp_descriptor);
	return ptr_to_pptp_info;
}

void process_server_gre_packet_if_required (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
			PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info)
{
	GRE_PACKET_TYPE *ptr_to_gre_packet;

	ptr_to_gre_packet = (GRE_PACKET_TYPE *) get_ptr_to_ip_data_packet((UNION_IP_PACKET *)uptr_ip_rx_packet, sptr_ip_parameters);
	if (ptr_to_gre_packet == NULL)
	{
		printf ("PPTP: GRE Packet header is NULL\n");
		return;
	}
	
	ptr_to_gre_packet->call_id = ptr_to_pptp_info->client_call_id;

	proxy_printf ("PPTP: Changing client call id from %d to %d\n",ptr_to_pptp_info->mapped_client_call_id,
					ptr_to_pptp_info->client_call_id);
	return;
}

/* Jo 20/04/99 */
#if 0
/* sudha taken from BIG_PROXY on 8 Jan 1999... */
#ifdef DEBUG
char *pptp_packet_types[] =
{
	"Unknown Packet Type",	
	"Start Ctrl Conn Request",			/* START_CTL_CONN_REQUEST = 1 */
	"Start Ctrl Conn Reply",			/*	START_CTL_CONN_REPLY   = 2 */
	"Stop Ctrl Conn Request",			/*	STOP_CTL_CONN_REQUEST  = 3 */
	"Stop Ctrl Conn Reply",				/*	STOP_CTL_CONN_REPLY    = 4 */
	"Echo Request",						/*	ECHO_REQUEST           = 5 */
	"Echo Reply",							/*	ECHO_REPLY             = 6 */
	"Outgoing Call Request",			/*	OUTGOING_CALL_REQUEST  = 7 */
	"Outgoing Call	Reply",				/* OUTGOING_CALL_REPLY    = 8 */
	"Incoming Call Request",			/*	INCOMING_CALL_REQUEST  = 9 */
	"Incoming Call Reply",				/*	INCOMING_CALL_REPLY    = 10 */
	"Incoming Call Connected",			/*	INCOMING_CALL_CONNECTED= 11 */
	"Call Clear Request",				/*	CALL_CLEAR_REQUEST     = 12 */
	"Call Disconnect Notify",			/*	CALL_DISCONNECT_NOTIFY = 13 */
	"WAN error Notify",					/*	WAN_ERROR_NOTIFY       = 14 */
	"Set Link Info"						/*	SET_LINK_INFO          = 15 */
};

#endif
/* ... sudha taken from BIG_PROXY on 8 Jan 1999 */
#endif
/* Jo 20/04/99 */
