/* sudhir */

#include <defs.h>

#include <stdio.h>
#include <stdlib.h>
#include <kstart.h>
#include <memory.h>

#include "proxy.h"
#include <rwarebuf.h>

extern PROXY_SERVER_CLASS proxy_server;

enum TEST proxy_static_nat_cfg_string (char *cptr_nat_cfg_string)
{
	PROXY_NAT_ADDRESS_LIST *sptr_global_address_list;
	BYTE *ptr_to_global_addr;
	

	if (proxy_server.number_of_global_address == 0)
	{
		if ((proxy_server.global_address_list = (PROXY_NAT_ADDRESS_LIST *) table_malloc (
										proxy_server.total_number_of_global_address, sizeof (PROXY_NAT_ADDRESS_LIST))) == NULL)						
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_global_address_list = proxy_server.global_address_list + 
											proxy_server.number_of_global_address;
	

	ptr_to_global_addr = strchr (cptr_nat_cfg_string , ',');
	if (ptr_to_global_addr == NULL)
	{
		printf ("PROXY: NAT configuration Error\n");
		return FAIL;
	}

	*ptr_to_global_addr = 0;
	sptr_global_address_list->global_address = str_to_net (cptr_nat_cfg_string);
	ptr_to_global_addr++;
	sptr_global_address_list->local_address = str_to_net (ptr_to_global_addr);

	proxy_server.number_of_global_address++;
	return PASS;
}	

enum TEST proxy_dynamic_internet_server_cfg_string (char *cptr_nat_cfg_string)
{
	PROXY_DYNAMIC_SERVER_LIST *sptr_dynamic_internet_server_list;
	BYTE *ptr_to_server_addr;
	int protocol=0, application_port=0;
	

	if (proxy_server.number_of_dynamic_servers == 0)
	{
		if ((proxy_server.dynamic_internet_server_list = (PROXY_DYNAMIC_SERVER_LIST *) table_malloc (
						proxy_server.total_number_of_dynamic_servers, sizeof (PROXY_DYNAMIC_SERVER_LIST))) == NULL)					
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_dynamic_internet_server_list = proxy_server.dynamic_internet_server_list +
													proxy_server.number_of_dynamic_servers;


	ptr_to_server_addr = strchr (cptr_nat_cfg_string , ',');
	if (ptr_to_server_addr == NULL)
	{
		printf ("PROXY: NAT Cconfiguration Error\n");
		return FAIL;
	}

	*ptr_to_server_addr = 0;
	sptr_dynamic_internet_server_list->dynamic_server_ip_address = str_to_net (cptr_nat_cfg_string);
	
	ptr_to_server_addr++;
	
	if (sscanf (ptr_to_server_addr, "%04x,%04x", &protocol, &application_port) == 0)
		return FAIL;   

	sptr_dynamic_internet_server_list->ip_protocol_type = protocol;
	sptr_dynamic_internet_server_list->application_port = application_port;		 
	proxy_server.number_of_dynamic_servers++; 
	return PASS;
}				

void proxy_nat_address_list ()
{
	USHORT index=0;
	PROXY_DYNAMIC_SERVER_LIST *sptr_dynamic_server_list;
	
	sptr_dynamic_server_list = proxy_server.dynamic_internet_server_list ;

	for (index=0; index < proxy_server.total_number_of_dynamic_servers; 
			index++,sptr_dynamic_server_list++)
	{
		printf ("%d     %d   %d\n", index+1, sptr_dynamic_server_list->ip_protocol_type,
				sptr_dynamic_server_list->application_port);
	}
}



void set_dynamic_server_ip_address (char *cptr_dynamic_server_address)
{
	BYTE ip_address_string[25];
	BYTE *cptr_ip_address;

	cptr_ip_address = &ip_address_string[0];

	sscanf (cptr_dynamic_server_address,"%03ju.%03ju.%03ju.%03ju",(int *)(cptr_ip_address + 0),(int *)(cptr_ip_address + 1),
		(int *)(cptr_ip_address + 2),(int *)(cptr_ip_address + 3));

	proxy_server.proxy_local_internet_server_address = *((ULONG *) cptr_ip_address);		

}
