#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>
#include "proxy.h"

#include <redblack.h>
#include "proxyrb.h"

#define PROXY_RB_INSERT_OVERFLOW 0
#define PROXY_RB_NEW_ENTRY 1
#define PROXY_RB_UPDATED 2


/* Define this and do operations like copying and comparisons more optimally */
#define PROXY_CUSTOM_OPERATIONS 1
#define PROXY_RB_STATISTICS 0

/* Jo 20/04/99 commented out anything related to PROXY_RB_STATISTICS */
#if PROXY_RB_STATISTICS
static struct
{
	unsigned long number_of_nodes ; /* (PROXY_RB_NEW_ENTRY) */
	unsigned long number_of_search_hits ;
	unsigned long number_of_insert_hits ; /* (PROXY_RB_UPDATED) */
	unsigned long number_of_insert_overflows ;
   unsigned long number_of_deletions ;
} statistics ;
#endif
/* Jo 20/04/99 commented out anything related to PROXY_RB_STATISTICS */

/* The following need to defined for the specific application */


PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;

void proxy_rb_pasv_ftp_ctrl_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_SERVER_INFO *ptr_proxy_info);

static PROXY_CLIENT_DESCRIPTOR_NODE far *get_new_proxy_rb_node ()
{
#if PROXY_CUSTOM_OPERATIONS
	return ((PROXY_CLIENT_DESCRIPTOR_NODE far *) _fmalloc (sizeof (PROXY_CLIENT_DESCRIPTOR_NODE))) ;
#else
	return ((PROXY_CLIENT_DESCRIPTOR_NODE far *) _fmalloc (sizeof (PROXY_CLIENT_DESCRIPTOR_NODE))) ;
#endif
}

static void free_proxy_rb_node (PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_node)
{
#if PROXY_CUSTOM_OPERATIONS
	_ffree (sptr_node) ;
#else
	_ffree (sptr_node) ;
#endif
}


static int proxy_RB_demo_insert_node(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_RB_CLIENT_KEY_TYPE key, PROXY_RB_CLIENT_INFO_TYPE info, PROXY_CLIENT_DESCRIPTOR_NODE far **ptr_sptr_new_node)
{
	PROXY_CLIENT_DESCRIPTOR_NODE far *nptr ;

	int retVal ;

#if PROXY_CUSTOM_OPERATIONS
	retVal = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_CLIENT_KEY_TYPE)) ;
#else
	retVal = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_CLIENT_KEY_TYPE)) ;
#endif
	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (proxy_RB_demo_insert_node ((PROXY_CLIENT_DESCRIPTOR_NODE far *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PROXY_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if PROXY_CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER far *)nptr ;
#if PROXY_RB_STATISTICS
			statistics.number_of_nodes++ ;
#endif
			return PROXY_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
		{
			return (proxy_RB_demo_insert_node ((PROXY_CLIENT_DESCRIPTOR_NODE far *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		}
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PROXY_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if PROXY_CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER far *) nptr ;
#if PROXY_RB_STATISTICS
			statistics.number_of_nodes++ ;
#endif
			return PROXY_RB_NEW_ENTRY ;
		}
	}
#if PROXY_CUSTOM_OPERATIONS
	/* Here is where you should be putting in things like updating
	the information fields and things like that. For example you
	may want to reset an age field or update some field like
	information_source_port .... */
#endif
#if PROXY_RB_STATISTICS
	statistics.number_of_insert_hits++ ;
#endif
	return PROXY_RB_UPDATED ;
}


static int proxy_RB_demo_insert(PROXY_RB_CLIENT_KEY_TYPE key, PROXY_RB_CLIENT_INFO_TYPE info)
{
	PROXY_CLIENT_DESCRIPTOR_NODE far *nptr, far *sptr_new_node ;
	int retVal ;

	if (sptr_proxy_client_descriptor_tree == (PROXY_CLIENT_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_proxy_rb_node() ;
		if (nptr == NULL)
		{
#if PROXY_RB_STATISTICS
			statistics.number_of_insert_overflows++ ;
#endif
			return PROXY_RB_INSERT_OVERFLOW ;
		}
#if PROXY_CUSTOM_OPERATIONS
		nptr->key = key ;
		nptr->info = info ;
#else
		nptr->key = key ;
		nptr->info = info ;
#endif
		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_proxy_client_descriptor_tree = nptr ;
#if PROXY_RB_STATISTICS
		statistics.number_of_nodes++ ;
#endif
		return PROXY_RB_NEW_ENTRY ;
	}

	retVal = proxy_RB_demo_insert_node (sptr_proxy_client_descriptor_tree, key, info, &sptr_new_node) ;

	if (retVal == PROXY_RB_NEW_ENTRY)
	{
		sptr_proxy_client_descriptor_tree = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER far *)sptr_new_node, (RED_BLACK_NODE_HEADER far *)sptr_proxy_client_descriptor_tree) ;
	}
	return retVal ;
}


PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_rb_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_RB_CLIENT_KEY_TYPE key)
{
	int ret_val ;
	
	if (Tree == NULL)
		return NULL;

	if (Tree == (PROXY_CLIENT_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
		return NULL ;

#if PROXY_CUSTOM_OPERATIONS
	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_CLIENT_KEY_TYPE)) ;
#else
	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_CLIENT_KEY_TYPE)) ;
#endif

	if (ret_val < 0)
	{
		return proxy_rb_client_descriptor_search ((PROXY_CLIENT_DESCRIPTOR_NODE far *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return proxy_rb_client_descriptor_search((PROXY_CLIENT_DESCRIPTOR_NODE far *)Tree->rb_header.LChild, key) ;
	}
		else
		{
#if PROXY_RB_STATISTICS
			statistics.number_of_search_hits++ ;
#endif	

			return Tree ;
		}
} 

/* sudha for associating pasv ftp ctrl descriptor with its corresponding 
data descriptor.30 March 1999... */

void proxy_rb_pasv_ftp_ctrl_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_SERVER_INFO *ptr_proxy_info)
{
	int ret_val ;

	PROXY_SERVER_INFO *temp_proxy_info;
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_client_root;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_client_node;	
	if (Tree == NULL)
		return ;

	if (Tree == (PROXY_CLIENT_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
		return ;

#if PROXY_CUSTOM_OPERATIONS
	ret_val = _fmemcmp((unsigned char far *)&Tree->key.client_ip_address, (unsigned char far *)&ptr_proxy_info->client_ip_address, sizeof (ULONG)) ;
#else
	ret_val = _fmemcmp((unsigned char far *)&Tree->key.client_ip_address, (unsigned char far *)&ptr_proxy_info->client_ip_address, sizeof (ULONG)) ;
#endif

	if (ret_val == 0)
	{
		temp_proxy_info = (PROXY_SERVER_INFO *)Tree->info.client_descriptor;		
#ifdef CTRL_DEBUG
printf("\n\rPROXYRB1: t_ip is %x, t_desip is %x, t_port is %x", temp_proxy_info->client_ip_address,
temp_proxy_info->destination_address, temp_proxy_info->pasv_port);
printf("\n\rPROXYRB1: p_ip is %x, p_desip is %x, p_port is %x", ptr_proxy_info->client_ip_address,
ptr_proxy_info->destination_address, ptr_proxy_info->destination_port);
#endif
		if ((temp_proxy_info->client_ip_address == ptr_proxy_info->client_ip_address)
			&& (temp_proxy_info->destination_address == ptr_proxy_info->destination_address)
			&& (temp_proxy_info->pasv_port != 0) 
			&& (temp_proxy_info->pasv_port == ptr_proxy_info->destination_port))
		{
			ptr_proxy_info->ptr_to_ftp_command_descriptor = temp_proxy_info;
			temp_proxy_info->ptr_to_ftp_data_descriptor = ptr_proxy_info;
			ptr_proxy_info->physical_port_for_pasv_ftp_data_connection =
				temp_proxy_info->outgoing_physical_port; 
/* Jo 29/06/99 Added from Jessi */
/* sudha 24 May 1999.
This is required because, pasv ftp data connection used to go thru' all the
available links which are up, thus resulting in control connection being 
opened in one link & data connections thru the same control connection used
to go thru in different links, which is wrong.Now, for all the data connections
thru the same control connection, the same physical port number will be
assigned. */
#ifdef CTRL_DEBUG
printf("\n\rPROXYRB1: temp_proxy_info is %x, ptr_proxy_info is %x",temp_proxy_info,
ptr_proxy_info);
#endif
			return;
		}

		sptr_client_root = Tree;
		sptr_next_client_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_client_root) ;
		while (sptr_next_client_node != NULL)
		{
#ifdef CTRL_DEBUG
printf("\n\rPROXYRB2: sptr_ip is %x", sptr_next_client_node->key.client_ip_address);
#endif
			if (sptr_next_client_node->key.client_ip_address == ptr_proxy_info->client_ip_address)
			{
				temp_proxy_info = (PROXY_SERVER_INFO *)sptr_next_client_node->info.client_descriptor;		
#ifdef CTRL_DEBUG
printf("\n\rPROXYRB2: t_ip is %x, t_desip is %x, t_port is %x", temp_proxy_info->client_ip_address,
temp_proxy_info->destination_address, temp_proxy_info->pasv_port);
printf("\n\rPROXYRB2: p_ip is %x, p_desip is %x, p_port is %x", ptr_proxy_info->client_ip_address,
ptr_proxy_info->destination_address, ptr_proxy_info->destination_port);
#endif
				if ((temp_proxy_info->client_ip_address == ptr_proxy_info->client_ip_address)
					&& (temp_proxy_info->destination_address == ptr_proxy_info->destination_address)
					&& (temp_proxy_info->pasv_port != 0) 
					&& (temp_proxy_info->pasv_port == ptr_proxy_info->destination_port))
				{
					ptr_proxy_info->ptr_to_ftp_command_descriptor = temp_proxy_info;
					temp_proxy_info->ptr_to_ftp_data_descriptor = ptr_proxy_info;
					ptr_proxy_info->physical_port_for_pasv_ftp_data_connection =
						temp_proxy_info->outgoing_physical_port; 
/* Jo 29/06/99 Added from Jessi */
/* sudha 24 May 1999.
This is required because, pasv ftp data connection used to go thru' all the
available links which are up, thus resulting in control connection being 
opened in one link & data connections thru the same control connection used
to go thru in different links, which is wrong.Now, for all the data connections
thru the same control connection, the same physical port number will be
assigned. */
#ifdef CTRL_DEBUG
printf("\n\rPROXYRB1: temp_proxy_info is %x, ptr_proxy_info is %x",temp_proxy_info,
ptr_proxy_info);
#endif
					return;
				}
			}
			sptr_next_client_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_client_node) ;
		}
		return;
	}
	if (ret_val < 0)
	{
		proxy_rb_pasv_ftp_ctrl_client_descriptor_search ((PROXY_CLIENT_DESCRIPTOR_NODE far *)Tree->rb_header.RChild, ptr_proxy_info) ;
	}
	else if (ret_val > 0)
	{	
	 	proxy_rb_pasv_ftp_ctrl_client_descriptor_search((PROXY_CLIENT_DESCRIPTOR_NODE far *)Tree->rb_header.LChild, ptr_proxy_info) ;
	}
} 
/* ...sudha for associating pasv ftp ctrl descriptor with its corresponding 
data descriptor.30 March 1999 */


#if 0
extern unsigned long scc1_collision_errors ;
extern unsigned long scc1_overflow_errors ;
extern unsigned long scc1_CRC_errors ;
extern unsigned long scc1_short_frame_errors ;
extern unsigned long scc1_non_octet_aligned_frame_errors ;
extern unsigned long scc1_frame_length_violation_errors ;
#define PRINT_BUFFER_SIZE 1000
char print_buffer[PRINT_BUFFER_SIZE] ;

void display_proxy_tree ()
{
#if 0
	int index=0 ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;
	
	printf ("\n\nDisplaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		printf ("[%d]. %d      %d\n", ++index, sptr_next_node->key.protocol_type,
						sptr_next_node->key.application_port);
					
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}

#endif

#if 1
	BYTE application_buffer[200], temp_buffer[100];
	USHORT index = 0 ;
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;
		
	application_buffer[0] = 0 ;
	printf ("\nPROXY: Proxy Server Configuration...............\n") ;
	printf ("Number of Applications %d\n",statistics.number_of_nodes);
	while (sptr_next_node)
	{
		if (index && ((index % 3) == 0))
		{
			printf ("%s", &application_buffer[0]) ;
			application_buffer[0] = 0 ;
		}
		sprintf (&temp_buffer[0], "\tProtocol : %04d Application : %04d\n",
					sptr_next_node->key.protocol_type,
					sptr_next_node->key.application_port);
		strcat (&application_buffer[0], &temp_buffer[0]) ;
		index++;
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
#endif
	return ;
}

#endif

void add_entry_to_proxy_client_descriptor_tree (BYTE *proxy_client_descriptor, unsigned char *vptr_buffer)
{
   PROXY_RB_CLIENT_INFO_TYPE info ;
	
	if (sptr_proxy_client_descriptor_tree == NULL)
		sptr_proxy_client_descriptor_tree = (PROXY_CLIENT_DESCRIPTOR_NODE far *) sptr_RB_sentinal_node;


   info.client_descriptor = proxy_client_descriptor ;

   proxy_RB_demo_insert (*((PROXY_RB_CLIENT_KEY_TYPE *)(vptr_buffer)), info) ;
	/* this 8 is sizeof(ULONG) and USHORT */
}

#define TEMP 0
#if 0
void initialize_proxy_rb_tree ()
{
   PROXY_RB_CLIENT_KEY_TYPE proxy_descriptor_key ;
   int i ;
   PROXY_RB_CLIENT_INFO_TYPE info ;

   info.age = proxy_descriptor_rb_node_age ;

   sptr_proxy_client_descriptor_tree = (PROXY_CLIENT_DESCRIPTOR_NODE far *) sptr_RB_sentinal_node ;

   ethernet_address.ethernet_address_ulong = 0x00FFFFFF ;
   ethernet_address.ethernet_address_ushort = 0xFFFF ;

   for (i = 0 ; i < 300 ; i++)
   {
      proxy_RB_demo_insert (ethernet_address, info) ;
      ethernet_address.ethernet_address_ulong-- ;
   }
}
#endif


int delete_entry_from_proxy_client_tree (PROXY_RB_CLIENT_KEY_TYPE key)
{
   PROXY_CLIENT_DESCRIPTOR_NODE *sptr_node_to_delete ;
	BYTE is_root_node=FALSE;

   sptr_node_to_delete = proxy_rb_client_descriptor_search (sptr_proxy_client_descriptor_tree, key) ;
   if (sptr_node_to_delete)
   {
#if PROXY_RB_STATISTICS
      statistics.number_of_deletions++ ;
#endif
     	sptr_proxy_client_descriptor_tree = RB_delete ((RED_BLACK_NODE_HEADER far *)sptr_proxy_client_descriptor_tree, (RED_BLACK_NODE_HEADER far *)sptr_node_to_delete, (unsigned long) sizeof (PROXY_CLIENT_DESCRIPTOR_NODE), (RED_BLACK_NODE_HEADER far **)&sptr_node_to_delete) ;
		free (sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}

/* Jo 19/04/99 */
#if 0
void age_proxy_client_descriptor_tree ()
{
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_temp, far *sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_proxy_client_descriptor_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
      sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
      if (sptr_temp->info.age)
      {
         sptr_temp->info.age-- ;
      }
      else
      {
#if 0
         sptr_proxy_client_descriptor_tree = (PROXY_CLIENT_DESCRIPTOR_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)sptr_temp,
                      (RED_BLACK_NODE_HEADER far *)sptr_proxy_client_descriptor_tree,
                      (unsigned long) sizeof (PROXY_CLIENT_DESCRIPTOR_NODE),
                      (RED_BLACK_NODE_HEADER far **)&sptr_temp) ;
#endif
      }
   }
}

void delete_aged_out_entries_in_proxy_client_descriptor (void)
{
	PROXY_CLIENT_DESCRIPTOR_NODE far *x, far *sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_proxy_client_descriptor_tree) ;
   
   while (sptr_next_node)
   {
      if (sptr_next_node->info.age)
      {
      }
      else
      {
         sptr_proxy_client_descriptor_tree = (PROXY_CLIENT_DESCRIPTOR_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)sptr_next_node,
                      (RED_BLACK_NODE_HEADER far *)sptr_proxy_client_descriptor_tree,
                      (unsigned long) sizeof (PROXY_CLIENT_DESCRIPTOR_NODE),
                      (RED_BLACK_NODE_HEADER far **)&x) ;
#if PROXY_RB_STATISTICS
         statistics.number_of_deletions++ ;
#endif
         free_proxy_rb_node (x) ;
         /* In one pass, delete just one. In fact as an optimization,
         we can keep track of the existence of aged out entries in
         a class variable so that we dont even need to call this function
         in case there are no aged entries */
         return ;
      }
      sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
   }
}
#endif
/* Jo 19/04/99 */

#define PRINT_BUFFER_SIZE 1000
void display_proxy_client_descriptors ()
{
	int i = 1, j ;
	unsigned char ch ;
	unsigned char far *x ;
	char pr_print_buffer[PRINT_BUFFER_SIZE] ; 
	char *print_buffer_ptr = &pr_print_buffer[0] ;
	int print_buffer_length = 0 ;
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node;

	if ( sptr_root != NULL )
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;
	else {
		printf("\nNo Client descriptors\n");
		return;
	}

	printf ("\n\nClient Tree.....\n") ;
	while (sptr_next_node)
	{
		sprintf (print_buffer_ptr, "\n\tNode %04d : ", i++) ;
		print_buffer_ptr += 14 ;
		print_buffer_length += 14 ;
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
		x = (unsigned char far *) &sptr_next_node->key ;
		for (j = 0 ; j < sizeof (PROXY_RB_CLIENT_KEY_TYPE) ; j++)
		{
			ch =  *x++ ;
			sprintf (print_buffer_ptr, "%02X", ch) ;
			print_buffer_ptr += 2 ;
			print_buffer_length += 2 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
#if 1
      sprintf (print_buffer_ptr, ", Age : %04d seconds",
			((PROXY_SERVER_INFO*)(sptr_next_node->info.client_descriptor))->proxy_idle_timer/20) ;
		print_buffer_ptr += 20 ;
		print_buffer_length += 20 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
#if 0
      sprintf (print_buffer_ptr, ", Port : %04d", sptr_next_node->info.port_number) ;
		print_buffer_ptr += 13 ;
		print_buffer_length += 13 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}


		if (sptr_next_node == sptr_root)
		{
			sprintf (print_buffer_ptr, " (ROOT)") ;
			print_buffer_ptr += 7 ;
			print_buffer_length += 7 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}

	if (print_buffer_length)
		printf ("%s\n\n", &pr_print_buffer[0]) ;
	
	return ;
}
