/* sudhir */

/*
History of Changes : 
		{Jo, 02 Dec 1999. Changes in process_proxy_server_domain_name_filters() and
		set_resolved_address_in_list() functions to retry resolving unresolved 
		domain names for 20 times}
*/

#include <defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <kstart.h>
#include "proxy.h"

#include <redblack.h>
#include "proxyrb.h"
#include "..\..\stacks\ip\kdns.h" 

/* sudha 03 dec 1998 */
#include "\rtrware\devdrvrs\ppp\pr_ppp.h"

extern PROXY_SERVER_CLASS proxy_server;

extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_proxy_server_descriptor_tree ;
extern int delete_entry_from_proxy_server_tree (PROXY_RB_SERVER_KEY_TYPE key);
/* Jo extern enum TEST get_ip_address_from_name (BYTE *domain_name, USHORT port_number, void (*fptr_complete_routine)(ULONG , USHORT, enum DNS_STATE));*/
extern enum TEST get_ip_address_from_name (BYTE *domain_name, USHORT port_number, void (*fptr_complete_routine)(ULONG *, USHORT,USHORT, enum DNS_STATE));
extern int delete_entry_from_proxy_client_tree (PROXY_RB_CLIENT_KEY_TYPE key);
void set_resolved_address_in_list(ULONG *resolved_ip_address, USHORT count,USHORT port_number, enum DNS_STATE status);
void process_proxy_server_domain_name_filters ();

/* sudha 03 dec 1998 */
extern void ppp_proxy_link_active (USHORT port_number);
extern enum BOOLEAN is_dial_out_initially_is_needed();
extern enum BOOLEAN is_status_of_trigger_port_open_is_initially_not_required(USHORT port_number);
enum BOOLEAN is_triggering_is_needed(USHORT port_number);



/*extern PROXY_DYNAMIC_APP_LIST *proxy_server_dynamic_application_list; */

void free_corresponding_application_list_entry (USHORT application_port)
{
	PROXY_DYNAMIC_APP_LIST *temp_application_list;
	PROXY_DYNAMIC_APP_LIST *previous_application_list;
	
	temp_application_list = proxy_server.proxy_server_dynamic_application_list;

	while (temp_application_list)
	{
		if (application_port == temp_application_list->application_port)
		{
			if (temp_application_list == proxy_server.proxy_server_dynamic_application_list)
			{
				proxy_server.proxy_server_dynamic_application_list = 
						proxy_server.proxy_server_dynamic_application_list->sptr_forward_link;					
			}

			printf ("PROXY: Freeing application list for %d\n",temp_application_list->application_port);
			previous_application_list->sptr_forward_link = temp_application_list->sptr_forward_link;
			free (temp_application_list);
			return;
		}			
		previous_application_list = temp_application_list;
		temp_application_list = temp_application_list->sptr_forward_link;
	}
	printf ("PROXY: Failed to free application list for %d\n", application_port);
	return;
}

void proxy_server_client_descriptor_timer ()
{
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	int client_ret_val=0, server_ret_val=0;
	
		
	if (sptr_root == NULL )
		return;


	sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	while (sptr_next_node)
	{
		if (sptr_next_node == NULL)
			return;

		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.client_descriptor;
		
		if (ptr_to_proxy_server_info->protocol_type == IP_DATA_ICMP)
		{
			sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
			continue;
		}
		
		if (!ptr_to_proxy_server_info->proxy_idle_timer)
		{
/* sudhir added for ftp passive */
			
			if (ptr_to_proxy_server_info->protocol_type == TCP_PROTOCOL &&
					ptr_to_proxy_server_info->destination_port > 1024)
			{
				printf ("PROXY : Trying to free %d\n", ptr_to_proxy_server_info->destination_port);
				free_corresponding_application_list_entry (ptr_to_proxy_server_info->destination_port);
			}

			proxy_printf ("PROXY : Freeing up Descriptor with dst port: %d physical port: %d\n", ptr_to_proxy_server_info->destination_port,
					ptr_to_proxy_server_info->outgoing_physical_port);

#ifdef CTRL_DEBUG
printf("\n\rPR_TIMER: desc is %x",ptr_to_proxy_server_info);
#endif

/*			delete_entry_from_list ((LINK *)&proxy_server.proxy_server_info_list, (LINK *)ptr_to_proxy_server_info);
			free (ptr_to_proxy_server_info); */
			proxy_server.number_of_proxied_clients--;
/* printf("\n\rPseudo connections decremented in client timer is %d",proxy_server.total_number_of_pseudo_connections);*/
			proxy_server.total_number_of_pseudo_connections--;
			
			client_descriptor_key.client_ip_address = ptr_to_proxy_server_info->client_ip_address;
			client_descriptor_key.protocol_type = ptr_to_proxy_server_info->protocol_type;
			client_descriptor_key.application_port = ptr_to_proxy_server_info->source_port;
			client_ret_val = delete_entry_from_proxy_client_tree (client_descriptor_key);

			server_descriptor_key.protocol_type = ptr_to_proxy_server_info->protocol_type;
/* sudha changing the position of this condition to come above. 15 Dec 1998..... */
#if sudha
			if (ptr_to_proxy_server_info->protocol_type == IP_DATA_ICMP)
			{
				server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_icmp_packet_id;
/*				printf ("Deleting ICMP Descriptor with id %d\n",
							ptr_to_proxy_server_info->mapped_icmp_packet_id); */
			}
			else
#endif
/* sudha changing the position of this condition to come above. 15 Dec 1998..... */

				server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_port;

			server_ret_val = delete_entry_from_proxy_server_tree (server_descriptor_key);

			if (client_ret_val && server_ret_val)
			{
	         if (proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections)
   				proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections--;			
      	   else
         	   printf ("PROXY :Trying to Free unknown Descriptor\n");
			 
				printf ("Freed Up Descriptor for %08x :: Application %d for port %04x\n",
					ptr_to_proxy_server_info->client_ip_address,
					ptr_to_proxy_server_info->destination_port,
					ptr_to_proxy_server_info->outgoing_physical_port);

#ifdef CTRL_DEBUG
printf("\n\rPR_TIMER: desc is %x",ptr_to_proxy_server_info);
#endif

				free (ptr_to_proxy_server_info);
			}
			else
				printf ("Failed to remove entry\n");

		}
		else
			ptr_to_proxy_server_info->proxy_idle_timer--;

 	
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
			
	}
}


void proxy_server_descriptor_timer ()
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_server_descriptor_tree ;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_node;
	int server_ret_val=0;
		
	
	if (sptr_root == NULL)
		return;


	sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	while (sptr_next_node)
	{
		if (sptr_next_node == NULL)
			return;

		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.server_descriptor;

		if (ptr_to_proxy_server_info->protocol_type != IP_DATA_ICMP)
		{
			sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
			continue;
		}
		 	
		if (!ptr_to_proxy_server_info->proxy_idle_timer)
		{
			proxy_printf ("PROXY : Freeing up Descriptor for ICMP\n");

#if sudha
			proxy_server.number_of_proxied_clients--;
printf("\n\rPseudo connections before decremented in server timer %d",proxy_server.total_number_of_pseudo_connections);
			proxy_server.total_number_of_pseudo_connections--;
printf("\n\rPseudo connections after decrementing is %d",proxy_server.total_number_of_pseudo_connections);
#endif
			
			server_descriptor_key.protocol_type = ptr_to_proxy_server_info->protocol_type;
			server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_icmp_packet_id;

			server_ret_val = delete_entry_from_proxy_server_tree (server_descriptor_key);

			if (server_ret_val)
			{
	         if (proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections)
   				proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections--;			
      	   else
         	   printf ("PROXY :Trying to Free unknown Descriptor\n");
				
				free (ptr_to_proxy_server_info);
			}
			else
				printf ("Failed to remove entry\n");

		}
		else
			ptr_to_proxy_server_info->proxy_idle_timer--;

 	
		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
}

void process_total_descriptors_and_trigger ()
{
	USHORT port_number=0;

	for (port_number =2; port_number <= NUMBER_OF_PROXY_PORTS; port_number++)
	{
		if (!proxy_server.port[port_number].maximum_number_of_connections_to_dial)
			continue;
		

		if (proxy_server.port[port_number].start_monitoring_port_traffic == FALSE)
		{
			if (proxy_server.total_number_of_pseudo_connections >= 
					proxy_server.port[port_number].maximum_number_of_connections_to_dial)
			{
				proxy_server.port[port_number].start_monitoring_port_traffic = TRUE;
				proxy_server.port[port_number].do_not_allocate_this_port = FALSE;
			}
			else
			{
				proxy_server.port[port_number].start_monitoring_port_traffic = FALSE;
				proxy_server.port[port_number].do_not_allocate_this_port = TRUE;
				proxy_server.port[port_number].port_monitoring_timer = 0;
			}
		}
		else
		{
			if (proxy_server.total_number_of_pseudo_connections >= 
				proxy_server.port[port_number].maximum_number_of_connections_to_dial)

				proxy_server.port[port_number].port_monitoring_timer++;
			else
			{
/* sudha 16 Dec 1998... */
				proxy_server.port[port_number].start_monitoring_port_traffic = FALSE;
				proxy_server.port[port_number].do_not_allocate_this_port = TRUE;
/* ...sudha 16 Dec 1998 */	
				proxy_server.port[port_number].port_monitoring_timer = 0;
			}
		}

		if (proxy_server.port[port_number].port_monitoring_timer >= PROXY_PORT_MONITORING_TIMER)
		{
			proxy_printf ("PROXY: Connections threshold timer exceeded maximum value\n");
#if sudha
printf("\n\rPR_TIMER: pseudo connections : %d,port %d and connections %d, max_connections\
%d",proxy_server.total_number_of_pseudo_connections ,port_number,
proxy_server.port[port_number].number_of_connections,
proxy_server.port[port_number].maximum_number_of_connections_to_dial);
#endif

/* Jo 23/09/99 Added to fix Initial Need To Dial Out problem when port type is Proxy/RAS */
	if ((is_wan_enabled(port_number - 1) == TRUE) &&
		(is_port_is_remote_access(port_number) == FALSE))
		{
			if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
				(is_triggering_is_needed(port_number - 1) == TRUE) ||
			  	((is_wan_port_answering(port_number - 1) == FALSE) &&
			  	(is_ipport_up(port_number) == FALSE)))
			{
				ppp_proxy_link_active (port_number-1);
				proxy_server.port[port_number].port_monitoring_timer = 0;
				printf ("PROXY: Triggering Port %d due to maximum number of Descriptors\n", port_number);
			}
			proxy_server.port[port_number].start_monitoring_port_traffic = FALSE;
			proxy_server.port[port_number].port_monitoring_timer = 0;
			}
		}
	}
}


void process_total_number_of_hosts_and_trigger ()
{
	USHORT port_number=0;

	for (port_number = 2; port_number <= NUMBER_OF_PROXY_PORTS; port_number++)
	{
		if (!proxy_server.port[port_number].maximum_number_of_hosts_to_dial)
			continue;
		
		if (proxy_server.port[port_number].host_threshold_level_reached == FALSE)
		{
			if (proxy_server.proxy_number_of_active_hosts >= 
				proxy_server.port[port_number].maximum_number_of_hosts_to_dial)
			{
/* sudha 21 sep 1998 */
				proxy_server.port[port_number].do_not_allocate_this_port = FALSE;
/* sudha 21 sep 1998 */
				proxy_server.port[port_number].host_threshold_level_reached = TRUE;
			}
			else
			{
				proxy_server.port[port_number].host_threshold_level_reached = FALSE;
				proxy_server.port[port_number].do_not_allocate_this_port = TRUE;
				proxy_server.port[port_number].host_threshold_monitoring_timer = 0;
			}
		}
		else
		{
			if (proxy_server.proxy_number_of_active_hosts >= 
				proxy_server.port[port_number].maximum_number_of_hosts_to_dial)
		
				proxy_server.port[port_number].host_threshold_monitoring_timer++;
			else
			{
				proxy_server.port[port_number].host_threshold_monitoring_timer = 0;
/* sudha 16 Dec 1998... */
				proxy_server.port[port_number].host_threshold_level_reached = FALSE;
				proxy_server.port[port_number].do_not_allocate_this_port = TRUE;
/* ...sudha 16 Dec 1998 */
			}
		}

		if (proxy_server.port[port_number].host_threshold_monitoring_timer >= PROXY_PORT_MONITORING_TIMER)
		{
			proxy_printf ("PROXY: Host threshold timer exceeded maximum value\n");
#if sudha
printf("\n\rPR_TIMER: active hosts : %d,port %d and max_hosts\
%d",proxy_server.proxy_number_of_active_hosts ,port_number,
proxy_server.port[port_number].maximum_number_of_hosts_to_dial);
#endif

	if ((is_wan_enabled(port_number - 1) == TRUE) &&
		(is_port_is_remote_access(port_number) == FALSE))
		{
/* Jo 23/09/99 Added to fix Initial Need To Dial Out problem when port type is Proxy/RAS */
			if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
				(is_triggering_is_needed(port_number-1) == TRUE ) ||
			  	((is_wan_port_answering(port_number - 1) == FALSE) &&
			  	(is_ipport_up(port_number) == FALSE)))
			{
				ppp_proxy_link_active (port_number-1);
				proxy_server.port[port_number].host_threshold_monitoring_timer = 0;
				proxy_server.port[port_number].host_threshold_level_reached = FALSE;
				printf ("PROXY: Triggering Port %d due to maximum number Hosts\n", port_number);
			}
			proxy_server.port[port_number].host_threshold_monitoring_timer = 0;
			proxy_server.port[port_number].host_threshold_level_reached = FALSE;
			}
		}
	}
}


void poll_for_port_traffic_and_bring_down ()
{
	if (proxy_server.minimum_connections_required_for_port2 &&
		 	proxy_server.minimum_hosts_required_for_port2)
	{
		if ((proxy_server.total_number_of_pseudo_connections < 
	  			proxy_server.minimum_connections_required_for_port2) &&
		  (proxy_server.proxy_number_of_active_hosts <
			 	proxy_server.minimum_hosts_required_for_port2))
			proxy_server.port[2].do_not_allocate_this_port = TRUE;
	 	
	}


	if (proxy_server.minimum_connections_required_for_port3 &&
		 	proxy_server.minimum_hosts_required_for_port3)
	{
		if ((proxy_server.total_number_of_pseudo_connections < 
	  			proxy_server.minimum_connections_required_for_port3) &&
		  (proxy_server.proxy_number_of_active_hosts <
			 	proxy_server.minimum_hosts_required_for_port3))
			proxy_server.port[3].do_not_allocate_this_port = TRUE;
	}
}


void process_nat_descriptor_timer ()
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor = NULL, *ptr_to_next_node=NULL;
	USHORT number_of_nat_descriptors=0;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);
	
	while (sptr_internet_server_descriptor != NULL)
	{
		ptr_to_next_node = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);

		if (sptr_internet_server_descriptor->idle_timer)
			sptr_internet_server_descriptor->idle_timer--;
		else
		{
			delete_entry_from_list ((LINK *) &proxy_server.proxy_internet_server_list,
				(LINK *) sptr_internet_server_descriptor);
#ifdef CTRL_DEBUG
	printf("\n\rPR_TIMER: nat entry freed is %x",sptr_internet_server_descriptor);
#endif
			free (sptr_internet_server_descriptor);
			number_of_nat_descriptors++;
		}

		sptr_internet_server_descriptor = ptr_to_next_node;
	}	 
	if (number_of_nat_descriptors)
		printf ("PROXY: Deleted %04x descriptors from NAT table\n",number_of_nat_descriptors);
	return;	
}

void process_nat_descriptor_table ()
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor=NULL;
	USHORT number_of_nat_descriptors=0;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);
	
	while (sptr_internet_server_descriptor != NULL)
	{
		sptr_internet_server_descriptor->idle_timer = 0;
		number_of_nat_descriptors++;

		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}

	if (number_of_nat_descriptors)
		printf ("PROXY: Deleted %04x descriptors from NAT table\n",number_of_nat_descriptors);
	return;	
}

void proxy_server_timer ()
{
	if (!proxy_server.proxy_server_enabled)
	{
		proxy_printf ("PROXY_SERVER : Proxy server disabled\n");
		return;
	}

	proxy_server_client_descriptor_timer ();
	proxy_server_descriptor_timer ();

	if (proxy_server.start_resolving_dns_filters == TRUE && 
		proxy_server.dns_resolver_state == PROXY_START_DNS_CLIENT)
			process_proxy_server_domain_name_filters ();

/* for link control */	
	process_total_descriptors_and_trigger ();
/* for link control */	

	process_nat_descriptor_timer ();

	link_control_tree_timer ();		
	process_total_number_of_hosts_and_trigger ();
	
	poll_for_port_traffic_and_bring_down ();
}


void start_resolving_proxy_dns_filters ()
{
	proxy_server.start_resolving_dns_filters = TRUE;
}

void process_proxy_server_domain_name_filters ()
{
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address;
	BYTE domain_name_buffer[255];

/* Jo 02 Dec 1999... */
	USHORT dummy_count = 0 ;		
	
	if (proxy_server.number_of_address_resolved == proxy_server.max_number_of_restricted_domain_address)
	{
/*		printf ("PROXY: All Domain names resolved\n");  */
		proxy_server.start_resolving_dns_filters = FALSE;
		return;
	}

	while (1)
	{
		if (dummy_count == proxy_server.max_number_of_restricted_domain_address)
				break;

		if (proxy_server.number_of_address_resolved == proxy_server.max_number_of_restricted_domain_address)
			proxy_server.number_of_address_resolved = 0;		
		
		sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address +
			proxy_server.number_of_address_resolved;
	
		dummy_count++;

		if ((sptr_next_restricted_domain_address->dns_query_response_status == DNS_RESOLVING_SUCCESS) ||
			(sptr_next_restricted_domain_address->dns_query_response_status == DNS_RESOLVING_FAILED))
		{
			proxy_server.number_of_address_resolved++;
			continue;			 
		}
		else
			break;
	}
/* ...Jo 02 Dec 1999 */

	strcpy (&domain_name_buffer[0], sptr_next_restricted_domain_address->domain_name);
/* Jo 02 Dec 1999... */
	sptr_next_restricted_domain_address->dns_retry_count++;
/* ...Jo 02 Dec 1999 */
	proxy_server.number_of_address_resolved++;

	printf ("DNS: Trying to Resolve %s\n",domain_name_buffer);
	
	proxy_server.dns_resolver_state = PROXY_WAIT_TO_RESOLVE;
   if (get_ip_address_from_name (domain_name_buffer, 0, set_resolved_address_in_list) == FAIL)
   {
		proxy_server.dns_resolver_state = PROXY_START_DNS_CLIENT;
		printf ("PROXY :resolving failed\n");
   } 
	return;
}

void set_resolved_address_in_list(ULONG *resolved_ip_address, USHORT count,USHORT port_number, enum DNS_STATE status)
{
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address;
	USHORT domain_name_index=0,index = 0;
	BYTE dns_buffer[50];
	ULONG *temp_ptr;

	domain_name_index = proxy_server.number_of_address_resolved;
	domain_name_index--;

	sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address +
															domain_name_index;

	if (status == RESOLVED)
	{
		sptr_next_restricted_domain_address->count = 0; 		
		temp_ptr = sptr_next_restricted_domain_address->destination_ip_address = (ULONG *) calloc ( count, sizeof (ULONG));
		if ( temp_ptr == NULL )
		{
			printf("\n\rError allocating memory for resolved ip address.");
			return;
		}
      *temp_ptr = 0;
		for (index = 0;index < count;index++)
		{
			*(temp_ptr) = *(resolved_ip_address);
			convert_ip_address_to_dot_format (&dns_buffer[0], *(temp_ptr));
#if 1
			printf ("PROXY: Resolved Name is %s %s\n",sptr_next_restricted_domain_address->domain_name, dns_buffer);
#endif
   		sptr_next_restricted_domain_address->count++; 		
			temp_ptr++;
			resolved_ip_address++;
		}
/* Jo 02 Dec 1999... */
		proxy_server.actual_number_of_address_resolved++;
		sptr_next_restricted_domain_address->dns_query_response_status = DNS_RESOLVING_SUCCESS;
/* ...Jo 02 Dec 1999 */
	}
	else
	{
/* Jo 02 Dec 1999... */
		if (sptr_next_restricted_domain_address->dns_retry_count == MAX_RETRIES_TO_RESOLVE_DOMAIN_NAME_FILTERS)
		{
			proxy_server.actual_number_of_address_resolved++;
			sptr_next_restricted_domain_address->dns_query_response_status = DNS_RESOLVING_FAILED;
		}
/* ...Jo 02 Dec 1999 */
		printf ("PROXY: DNS Resolving Failed\n");
	}

	proxy_server.dns_resolver_state = PROXY_START_DNS_CLIENT;

	return;
}

/* sudha 30 Nov 1998 */
enum BOOLEAN is_triggering_is_needed(USHORT port_number)
{
	if (( is_dial_out_initially_is_needed() == FALSE ) && 
		(is_status_of_trigger_port_open_is_initially_not_required(port_number) == TRUE))
			return TRUE ;
	else
		return FALSE ;
}
/* sudha 30 Nov 1998 */
