/* sudhir */
/* Jo 24/07/98 Made changes for Small proxy */

/* 
History of Changes :
		{Jo, 02 Dec 1999. Changes in proxy_read_configuration() function 
				to fix unresolved domain name filter problem} 
*/

#include <defs.h>


#include	<stdio.h>
#include	<stdarg.h>
#include <stddef.h>
#include	<stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>
#include "proxy.h"
#include	<cnffile.h>    / * Jo 24/07/98 */
#include "vnvproxy.h"

#include <redblack.h>
#include "proxyrb.h"

/* Jo 24/07/98 */
#define NUMBER_OF_FILTER_TYPES 	5
#define NUMBER_OF_MAPPING_TYPES  3
extern int strcmpi (char *s1, char *s2);
extern USHORT get_port_command_length (BYTE *ptr_to_start_of_port_command);
extern USHORT get_application_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT *destination_port, enum IP_PROTOCOL_VALUE *protocol_type);
extern BYTE *get_ptr_to_tcp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_rb_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_RB_CLIENT_KEY_TYPE key);


extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;
extern enum BOOLEAN is_port_is_remote_access (USHORT port_number);
extern enum BOOLEAN is_ipport_up (USHORT port_number);

extern void ppp_proxy_link_active (USHORT port_number);
extern enum BOOLEAN is_triggering_is_needed(USHORT port_number); /* sudha 30 Nov 1998 */

#if PROXY_DEBUG
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type) ;
extern char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number) ;
#endif

/* Jo 24/07/98 */
int proxy_read_configuration (char *cptr_config) ;
void print_proxy_configured_parameters () ;
void print_proxy_app_port_ranges();  /* Imran */
/* Jo 24/07/98 */

/* Jo 09/08/99 Added for Static routes */
extern enum BOOLEAN static_port_list[NUMBER_OF_IP_PORTS] ;
extern enum BOOLEAN get_port_number_if_statically_configured (ULONG destination_address, USHORT *port_number) ;
/* Jo 09/08/99 Added for Static routes */

/* Jo 20/04/99 */
#if 0

/* Sachin, 09/01/1998 */
BYTE same_port_required_for_ftp = FALSE  ;
/* Sachin, 09/01/1998 */

enum TEST just_read_out (char *cptr_proxy_server_app_string)
{
   return PASS ;
}

enum TEST proxy_server_applications_cfg_string (char *cptr_proxy_server_app_string)
{
	int protocol_port, protocol ;
	PROXY_RB_KEY_TYPE	next_application_list;
	BYTE same_port_required=TRUE;

	while (1)
   {
		if (sscanf (cptr_proxy_server_app_string, "%04x,%04x", &protocol, &protocol_port) == 0)
   		break;

		next_application_list.protocol_type = (USHORT) protocol ;
	   next_application_list.application_port = (USHORT) protocol_port ;

/* new addition for strict port forwarding */
		switch (next_application_list.application_port)
		{
			case WEB_RESERVED_PORT :
				same_port_required = FALSE;				
/*				next_application_list.same_port_required = FALSE; */
				break;

			default :
				same_port_required = TRUE;				
/*				next_application_list.same_port_required = TRUE; */
				break;
		}
/* new addition for strict port forwarding */

		add_entry_to_proxy_rb_tree (same_port_required, &next_application_list) ;

		proxy_server.number_of_applications++ ;

      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;

      cptr_proxy_server_app_string++ ;
      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;
      cptr_proxy_server_app_string++ ;
	}

	return PASS;
}

void proxy_dummy_function ()
{

}

enum TEST proxy_forbidden_site_address_string (char *cptr_proxy_forbidden_address)
{
	PROXY_FORBIDDEN_SITE_LIST *sptr_next_forbidden_site;
	char *cptr_ip_address;
	char scanf_string[20];
	
	if (proxy_server.number_of_forbidden_sites == 0)
	{
		if ((proxy_server.ptr_to_forbidden_list = (PROXY_FORBIDDEN_SITE_LIST *) table_malloc (
						proxy_server.max_number_of_forbidden_sites, sizeof (PROXY_FORBIDDEN_SITE_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_next_forbidden_site = proxy_server.ptr_to_forbidden_list + proxy_server.number_of_forbidden_sites;
	cptr_ip_address = &scanf_string[0];

	while (1)
	{
		sscanf (cptr_proxy_forbidden_address,"%03ju.%03ju.%03ju.%03ju",(int *)(cptr_ip_address + 0),(int *)(cptr_ip_address + 1),
			(int *)(cptr_ip_address + 2),(int *)(cptr_ip_address + 3));

		sptr_next_forbidden_site->destination_ip_address = *((ULONG *)cptr_ip_address); 	
		proxy_server.number_of_forbidden_sites++;

#if 0
		printf ("PROXY :Restricted Dest Address is %08x\n",sptr_next_forbidden_site->destination_ip_address);
#endif

		cptr_proxy_forbidden_address = strchr (cptr_proxy_forbidden_address, ',');
		if (cptr_proxy_forbidden_address == NULL)
			break;
		cptr_proxy_forbidden_address++;
		sptr_next_forbidden_site++;
	}
	return PASS;
}

enum TEST proxy_restricted_client_address_string (char *cptr_proxy_forbidden_address)
{
	PROXY_RESTRICTED_CLIENT_LIST *sptr_next_restricted_client;
	char *cptr_ip_address;
	char scanf_string[20];
	
	if (proxy_server.number_of_restricted_clients == 0)
	{
		if ((proxy_server.ptr_to_restricted_client_list = (PROXY_RESTRICTED_CLIENT_LIST *) table_malloc (
						proxy_server.max_number_of_restricted_clients, sizeof (PROXY_RESTRICTED_CLIENT_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_next_restricted_client = proxy_server.ptr_to_restricted_client_list + proxy_server.number_of_restricted_clients;
	cptr_ip_address = &scanf_string[0];

	while (1)
	{
		sscanf (cptr_proxy_forbidden_address,"%03ju.%03ju.%03ju.%03ju",(int *)(cptr_ip_address + 0),(int *)(cptr_ip_address + 1),
			(int *)(cptr_ip_address + 2),(int *)(cptr_ip_address + 3));

		sptr_next_restricted_client->source_ip_address = *((ULONG *)cptr_ip_address); 	

		proxy_server.number_of_restricted_clients++;
	
		cptr_proxy_forbidden_address = strchr (cptr_proxy_forbidden_address, ',');
		if (cptr_proxy_forbidden_address == NULL)
			break;
		cptr_proxy_forbidden_address++;	
		sptr_next_restricted_client++;
	}
	return PASS;
}

enum TEST proxy_restricted_application_string (char *cptr_proxy_server_app_string)
{
	int protocol_port, protocol ;
	PROXY_APPLICATION_TABLE	*sptr_next_application;
	
	/* number_of_applications : Number of applications configured to be proxied
	   max_number_of_applications : Another field, which decides on the amount of memory to alloocate
	   sptr_application_list : pointer to the applications list
	*/

	if (proxy_server.number_of_restricted_applications == 0)
	{
		/* Malloc only when the first of the application list strings appear */
		if ((proxy_server.sptr_restricted_application_list = (PROXY_APPLICATION_TABLE *) table_malloc (
					proxy_server.max_number_of_restricted_applications,sizeof (PROXY_APPLICATION_TABLE))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	/* Start from the first free slot in the applications list */
	sptr_next_application = proxy_server.sptr_restricted_application_list + proxy_server.number_of_restricted_applications ;


	while (1)
   {
      if (sscanf (cptr_proxy_server_app_string, "%04x,%04x", &protocol, &protocol_port) == 0)
         break ;

      sptr_next_application->protocol_type = (USHORT) protocol ;
      sptr_next_application->protocol_port = (USHORT) protocol_port ;
		
#if 0
		printf ("PROXY : Application is %04x  %04x\n",sptr_next_application->protocol_type,
					sptr_next_application->protocol_port);			 
#endif
		sptr_next_application++;
		proxy_server.number_of_restricted_applications++ ;

      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;

      cptr_proxy_server_app_string++ ;
      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;
      cptr_proxy_server_app_string++ ;
   }
	return PASS;
}

enum TEST proxy_restricted_MAC_address_string (char *cptr_restricted_MAC_address_string)
{
	PROXY_RESTRICTED_MAC_ADDRESS_LIST *sptr_next_restricted_MAC_address_list;
	BYTE *temp, mac_address_array[20];
	
	if (proxy_server.number_of_restricted_MAC_address == 0)
	{
		if ((proxy_server.ptr_to_restricted_MAC_address_list = (PROXY_RESTRICTED_MAC_ADDRESS_LIST *) table_malloc (
						proxy_server.max_number_of_restricted_MAC_address, sizeof (PROXY_RESTRICTED_MAC_ADDRESS_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_next_restricted_MAC_address_list = proxy_server.ptr_to_restricted_MAC_address_list +
					proxy_server.number_of_restricted_MAC_address;

	while (1)
	{
		sscanf (cptr_restricted_MAC_address_string,"%02jx%02jx%02jx%02jx%02jx%02jx",
				(int *) (mac_address_array), (int *) (mac_address_array+1),
				(int *) (mac_address_array+2), (int *) (mac_address_array+3),
				(int *) (mac_address_array+4), (int *) (mac_address_array+5));

		temp = &sptr_next_restricted_MAC_address_list->mac_address[0];

		*temp++ = (BYTE) mac_address_array[0];
		*temp++ = (BYTE) mac_address_array[1];
		*temp++ = (BYTE) mac_address_array[2];
		*temp++ = (BYTE) mac_address_array[3];
		*temp++ = (BYTE) mac_address_array[4];
		*temp++ = (BYTE) mac_address_array[5];
	
#if 0
		printf ("PROXY : MAC address is %08x\n",sptr_next_restricted_MAC_address_list->mac_address);
#endif
				
		proxy_server.number_of_restricted_MAC_address++;		

		cptr_restricted_MAC_address_string = strchr (cptr_restricted_MAC_address_string, ',');
		if (cptr_restricted_MAC_address_string == NULL)
			break;
		cptr_restricted_MAC_address_string++;
		sptr_next_restricted_MAC_address_list++;
	}

	return PASS;
}

enum TEST proxy_restricted_domain_name_string (char *cptr_restricted_domain_name_string)
{
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address;
	
	if (proxy_server.number_of_restricted_domain_address == 0)
	{
		if ((proxy_server.ptr_to_restricted_domain_address = (PROXY_FORBIDDEN_DOMAIN_ADDRESS *) table_malloc (proxy_server.max_number_of_restricted_domain_address, sizeof (PROXY_FORBIDDEN_DOMAIN_ADDRESS))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}
		
	sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address +
												proxy_server.number_of_restricted_domain_address;
	
	strcpy (sptr_next_restricted_domain_address->domain_name, cptr_restricted_domain_name_string);
	proxy_server.number_of_restricted_domain_address++;

	return PASS;
	
}

enum TEST proxy_privileged_user_list (char *privileged_user_list)
{
	PROXY_PRIVILEGED_USER_LIST *ptr_to_next_user_list;
	BYTE ip_address_string[25], *cptr_ip_address, *ptr_to_comma, rhs_string[50];
	ULONG host_ip_address;
  	ULONG port_number=0;

	
	if (proxy_server.number_of_privileged_users == 0)
	{
		if ((proxy_server.ptr_to_privileged_user_list = (PROXY_PRIVILEGED_USER_LIST *) table_malloc (proxy_server.max_number_of_privileged_users, sizeof (PROXY_PRIVILEGED_USER_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}
	
	ptr_to_next_user_list = proxy_server.ptr_to_privileged_user_list +			
							proxy_server.number_of_privileged_users;

	cptr_ip_address = &ip_address_string[0];
	

	sscanf (privileged_user_list, "%02u,%s", (int *) &port_number, &rhs_string[0]);
	privileged_user_list = rhs_string ;			

	while (1)
	{
		ptr_to_comma = strchr (privileged_user_list, ',');
		if (ptr_to_comma == NULL)
		{
			if (sscanf (privileged_user_list ,"%03ju.%03ju.%03ju.%03ju", (int *) (cptr_ip_address+0), 
				(int *) (cptr_ip_address+1), (int *) (cptr_ip_address+2), (int *) (cptr_ip_address+3)) == 0)
					break;

			host_ip_address = *((ULONG *)cptr_ip_address);
			ptr_to_next_user_list->host_ip_address =host_ip_address;
			ptr_to_next_user_list->reserved_port = (USHORT) port_number;
			proxy_server.number_of_privileged_users++;
			ptr_to_next_user_list++;
			break;
		}
		
		*ptr_to_comma = 0;

		if (sscanf (privileged_user_list ,"%03ju.%03ju.%03ju.%03ju", (int *) (cptr_ip_address+0), 
			(int *) (cptr_ip_address+1), (int *) (cptr_ip_address+2), (int *) (cptr_ip_address+3)) == 0)
				break;

		host_ip_address = *((ULONG *)cptr_ip_address);

		ptr_to_next_user_list->host_ip_address =host_ip_address;
		ptr_to_next_user_list->reserved_port = (USHORT) port_number;
		proxy_server.number_of_privileged_users++;
		ptr_to_next_user_list++;
		privileged_user_list = ptr_to_comma + 1;
	}
	return PASS;
}

ULONG string_to_ip_address (BYTE *Str)
{
	int f1, f2, f3, f4;

	if (sscanf(Str,"%3u,%3u,%3u,%3u", &f1, &f2, &f3, &f4) != 4)
		return(-1l);

	if ((f1 < 0) || (f1 > 255) || (f2 < 0) || (f2 > 255) ||
			(f3 < 0) || (f3 > 255) || (f4 < 0) || (f4 > 255))
		return(-1);

	return ((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
}

#endif
/* Jo 20/04/99 */


/* Jo 23/09/99 Added for configurable FTP control and Data ports */	
void set_ftp_port_numbers_during_init()
{
	USHORT prev_ctrl_port = 0, prev_data_port = 0, ctrl_port = 0, data_port = 0;
	USHORT ctrl_index = 0, data_index = 0, ret_val, protocol=0;
	char application[10];

	ctrl_port = proxy_server.ftp_ctrl_conn_port;
	data_port = proxy_server.ftp_data_conn_port; 
	strcpy(application, "FTP");

	protocol = TCP_PROTOCOL;		
	ret_val = get_port_numbers_from_application(protocol, application, 
					&prev_ctrl_port, &prev_data_port, &ctrl_index, &data_index);
	if (ret_val == 1)
	{
		set_protocol_port_number(protocol, ctrl_port, ctrl_index);
		set_protocol_port_number(protocol, data_port, data_index);
	}

	protocol = UDP_PROTOCOL;		
	ret_val = get_port_numbers_from_application(protocol, application, 
					&prev_ctrl_port, &prev_data_port, &ctrl_index, &data_index);
	if (ret_val == 1)
	{
		set_protocol_port_number(protocol, ctrl_port, ctrl_index);
		set_protocol_port_number(protocol, data_port, data_index);
	}
	return ;
}
/* Jo 23/09/99 Added for configurable FTP control and Data ports */	

extern ULONG str_to_net (char *) ;
void get_ftp_src_port_and_address (BYTE *ptr_to_tcp_pkt, USHORT *source_port, ULONG *source_address)
{
	BYTE temp_buffer[50], temp_ip_address[25], temp_port[10];
	USHORT port1, port2, new_port_number, buffer_index=0, number_of_commas=0,index=0;
	ULONG src_ip_address;

	ptr_to_tcp_pkt += 5;
	memcpy (temp_buffer, ptr_to_tcp_pkt, 40);
	temp_buffer[40] = 0;
	strtok (temp_buffer, "\n");

	while (temp_buffer[buffer_index])
	{
		temp_ip_address[buffer_index] = temp_buffer[buffer_index];
		if (temp_buffer[buffer_index] == ',')
		{
			temp_ip_address[buffer_index] = '.';			
			number_of_commas++;
		}

		if (number_of_commas == 4)
		{
			temp_ip_address[buffer_index] = 0;
			buffer_index++;
			break;
		}
		buffer_index++;
	}		

	src_ip_address = str_to_net (temp_ip_address);	
	*source_address = src_ip_address;

	while (temp_buffer[buffer_index])
	{
		temp_port[index++] = temp_buffer[buffer_index];		
		if (temp_buffer[buffer_index] == '\n')
		{
			temp_port[index-2] = 0;			
			break;
		}
		buffer_index++;
	}	
	sscanf (temp_port ,"%hu,%hu",&port1, &port2);		
	
	port1 = port1 & 0x00ff;
	port1 = port1 << 8;
	port2 = port2 &0x00ff;
	new_port_number = (port1 | port2);
	*source_port = new_port_number;	

	return;
}



BYTE *check_for_ftp_port_command_and_process (BYTE *uptr_ip_rx_packet, enum BOOLEAN *return_value, IP_PARAMETERS *sptr_ip_parameters, PROXY_SERVER_INFO *sptr_control_connection)
{
	BYTE temp_buff[6];
	BYTE *ptr_to_tcp_pkt;
	USHORT source_port=0;
	ULONG source_ip_address;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
#if PROXY_DEBUG
	char mapped_ip_address[20], src_ip_address[20], dest_application[10], protocol_type_string[10] ;
	USHORT protocol_port ;
	enum IP_PROTOCOL_VALUE protocol_type ;
#endif
	USHORT ip_total_length = sptr_ip_parameters->total_length ;
	USHORT port_command_length, ip_header_length = sptr_ip_parameters->header_length ;
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	PROXY_LINKCTRL_RB_KEY_TYPE link_control_key;
	
	
	ptr_to_tcp_pkt = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	if ((port_command_length = get_port_command_length (ptr_to_tcp_pkt)) > 35)
	{
		/* It can never be greater */
		*return_value = FALSE ;
		return NULL ;
	}
	if (port_command_length + ip_header_length + sizeof (TCP_HEADER) != ip_total_length)
	{
		*return_value = FALSE ;
		return NULL ;
	}
	memcpy (temp_buff,ptr_to_tcp_pkt,4);
	temp_buff[4] = 0;
	if (strcmpi (temp_buff, "Port"))
	{
		*return_value = FALSE;
		return NULL;
	}

/*	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) malloc (sizeof (PROXY_SERVER_INFO)); */
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) calloc (sizeof (PROXY_SERVER_INFO), 1);
	if (ptr_to_proxy_server_info == NULL)
	{
		proxy_printf ("PROXY_SERVER: Not Enough memory to proxy, Dropping packet\n");	
		return NULL;
	}


	ptr_to_proxy_server_info->outgoing_physical_port = 
		sptr_control_connection->outgoing_physical_port ;

	if (ptr_to_proxy_server_info->outgoing_physical_port == 0)
	{
		free (ptr_to_proxy_server_info);
		return NULL;
	}	

   proxy_server.port[sptr_control_connection->outgoing_physical_port].number_of_connections++ ;
	get_ftp_src_port_and_address (ptr_to_tcp_pkt, &source_port, &source_ip_address);
	ptr_to_proxy_server_info->mapped_port = get_a_free_port(0, source_port);
	ptr_to_proxy_server_info->outgoing_port_address = get_ip_address (ptr_to_proxy_server_info->outgoing_physical_port);
				


/*	get_ftp_src_port_and_address (ptr_to_tcp_pkt, &source_port, &source_ip_address);*/

	ptr_to_proxy_server_info->source_port = source_port;
	ptr_to_proxy_server_info->client_ip_address = source_ip_address;
	ptr_to_proxy_server_info->protocol_type = sptr_ip_parameters->protocol;
	ptr_to_proxy_server_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
	ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout;

/* Sachin, 23/12/1997 */
   if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
	{
	   ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
		ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout;
	}
/* Sachin, 23/12/1997 */
	ptr_to_proxy_server_info->connection_closing = FALSE;

	
/*	add_entry_to_list ((LINK *)&proxy_server.proxy_server_info_list, (LINK *)ptr_to_proxy_server_info); */
	client_descriptor_key.client_ip_address = source_ip_address;
	client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	client_descriptor_key.application_port = source_port;

	add_entry_to_proxy_client_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &client_descriptor_key);

	server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_port ;

	add_entry_to_proxy_server_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &server_descriptor_key);

	link_control_key.source_ip_address = ptr_to_proxy_server_info->client_ip_address;
/* Jo printf("\n\rPR_UTIL : link ctrl tree client ip address is : %lX",link_control_key.source_ip_address); */
	add_entry_to_link_control_descriptor_tree (NULL, (BYTE *) &link_control_key);
/* sudha 17 Dec 1998 */
	reset_link_control_tree_timer (link_control_key);

	
#if PROXY_DEBUG
	protocol_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &protocol_port, &protocol_type) ;	
	proxy_printf ("PROXY: Mapping <%s,%04X> to <%s,%04X> to proxy %s port %s on WAN %04X\n",
		convert_ip_address_to_dot_format (&src_ip_address[0], ptr_to_proxy_server_info->client_ip_address),
		ptr_to_proxy_server_info->source_port,
		convert_ip_address_to_dot_format (&mapped_ip_address[0], ptr_to_proxy_server_info->outgoing_port_address),
		ptr_to_proxy_server_info->mapped_port,
		get_protocol_type (&protocol_type_string[0], protocol_type),
		get_port_type (&dest_application[0], protocol_type, protocol_port), 
		ptr_to_proxy_server_info->outgoing_physical_port-1) ;
#endif

	
	proxy_server.number_of_proxied_clients++;
	proxy_server.total_number_of_pseudo_connections++;

	if (proxy_server.number_of_proxied_clients > proxy_server.peak_concurrent_descriptor_count)
		proxy_server.peak_concurrent_descriptor_count = proxy_server.number_of_proxied_clients ;
	
	printf ("PROXY: FTP Port command detected\n");
	*return_value = TRUE;
	return ((BYTE *)ptr_to_proxy_server_info);
}


/* Jo 09/08/99 Modified for Static routes */
USHORT get_first_active_port (ULONG destination_ip_address)
{
	USHORT port_number ;
/* Jo 09/08/99 Added for Static routes */

	if (get_port_number_if_statically_configured (destination_ip_address, &port_number) == TRUE)	
	{
		if ((port_number != INVALID_PHYSICAL_PORT) && (port_number != 0))
		{
			if (is_ipport_up (port_number) == TRUE)
			{
      	   proxy_server.port[port_number].number_of_connections++ ;
				return (port_number) ;
			}
			else
			{
/* Jo 23/09/99 Added to fix Initial Need To Dial Out problem when port type is Proxy/RAS */
				if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
					(is_triggering_is_needed(port_number - 1) == TRUE) ||
				  	((is_wan_port_answering(port_number - 1) == FALSE) &&
					  	(is_ipport_up(port_number) == FALSE)))
				{
   		        proxy_server.port[port_number].number_of_connections++ ;
				     printf ("PROXY : Triggering off dialing up of down-by-demand of Statically configured WAN port %04X\n", port_number-1) ;
      			  ppp_proxy_link_active (port_number-1) ;
		 			  return port_number ;	
				}
			}
		}	
	}	
/* Jo 09/08/99 Added for Static routes */

	for (port_number = 1 ; port_number <= NUMBER_OF_PROXY_PORTS ; port_number++)
	{
/* Jo 29/06/99 Added from Jessi */
		if (is_wan_enabled(port_number - 1) == FALSE)
			continue;
		if (!proxy_server.port[port_number].proxy_server_enabled)
			continue;

		if (is_port_is_remote_access (port_number) == TRUE)
			continue;

/* Jo 30/07/99 Added for Static routes */
		
		if (static_port_list[port_number] == TRUE)		
			continue;
	
/* Jo 30/07/99 Added for Static routes */

		if (is_ipport_up (port_number) == TRUE)
		{
         proxy_server.port[port_number].number_of_connections++ ;
			return (port_number);
		}
	}

	for (port_number = 1 ; port_number <= NUMBER_OF_PROXY_PORTS ; port_number++)
	{
/* Jo 29/06/99 Added from Jessi */
		if (is_wan_enabled(port_number - 1) == FALSE)
			continue;

		if (!proxy_server.port[port_number].proxy_server_enabled)
			continue;

		if (is_port_is_remote_access (port_number) == TRUE)
			continue;

/* Jo 30/07/99 Added for Static routes */
		
		if (static_port_list[port_number] == TRUE)		
			continue;
	
/* Jo 30/07/99 Added for Static routes */

/* Jo 23/09/99 Added to fix Initial Need To Dial Out problem when port type is Proxy/RAS */
		if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
			(is_triggering_is_needed(port_number - 1) == TRUE ) ||
			((is_wan_port_answering(port_number - 1) == FALSE) &&
				(is_ipport_up(port_number) == FALSE)))
		{
           proxy_server.port[port_number].number_of_connections++ ;
		     printf ("PROXY : Triggering off dialing up of down-by-demand WAN port %04X\n", port_number-1) ;
      	  ppp_proxy_link_active (port_number-1) ;
	 		  return port_number;	
		}
	}
	return 0;
}

USHORT get_matched_port_from_existing_descriptor (USHORT reserved_port, IP_PARAMETERS *sptr_ip_parameters)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	USHORT port_number = 0;
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_temp_client_descriptor_list;

	client_descriptor_key.client_ip_address = sptr_ip_parameters->source_address;
	client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	client_descriptor_key.application_port = reserved_port;

	proxy_temp_client_descriptor_list = proxy_rb_client_descriptor_search (
							sptr_proxy_client_descriptor_tree, client_descriptor_key);

	if (proxy_temp_client_descriptor_list == NULL)
	{
		printf ("PROXY: Search failed in client descriptor list\n");
		return port_number;
	}

	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) proxy_temp_client_descriptor_list->info.client_descriptor;
	if (ptr_to_proxy_server_info)
		port_number = ptr_to_proxy_server_info->outgoing_physical_port;
	else
		printf ("PROXY: No Descriptor exist for this tree\n");
	
/*	printf ("PROXY :Matched Port is %d\n", port_number); */
	return port_number;
	
#if 0
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list);

	while (ptr_to_proxy_server_info != NULL)
	{
		printf ("Matching %x  %x::  %d  %d :: %x  %x \n",ptr_to_proxy_server_info->client_ip_address,
			sptr_ip_parameters->source_address,
			ptr_to_proxy_server_info->destination_port, reserved_port,
			ptr_to_proxy_server_info->destination_address, sptr_ip_parameters->destination_address);
			
		if ((ptr_to_proxy_server_info->client_ip_address == sptr_ip_parameters->source_address) &&
			(ptr_to_proxy_server_info->destination_port == reserved_port))
/*			(ptr_to_proxy_server_info->destination_address == sptr_ip_parameters->destination_address)) */
		{
			port_number = ptr_to_proxy_server_info->outgoing_physical_port;
			break;
		}
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info);
	}
#endif

}

void proxy_printf (const char *cptr_format, ...)
{
   enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format); 

   print_string = proxy_server.proxy_server_printf_enabled;

	if (print_string == TRUE)
	{
		vprintf (cptr_format,argptr);
	}

	va_end (argptr);
}

/* Jo 19/04/99 */
#if 0

void proxy_configuration ()
{
	BYTE application_buffer[200], temp_buffer_1[20], temp_buffer_2[20], temp_buffer[100] ;
	PROXY_APPLICATION_TABLE *sptr_proxy_application_list = proxy_server.sptr_application_list;
	USHORT index = 0 ;
	
	application_buffer[0] = 0 ;
	printf ("\nPROXY: Proxy Server Configuration...............\n") ;
	printf ("PROXY: Number of Applications : %d\n", proxy_server.number_of_applications) ;
	for (index = 0 ; index < proxy_server.number_of_applications ; sptr_proxy_application_list++, index++)
	{
		if (index && ((index % 3) == 0))
		{
			proxy_printf ("%s", &application_buffer[0]) ;
			application_buffer[0] = 0 ;
		}
		sprintf (&temp_buffer[0], "\tProtocol : %s Application : %s (%04d)\n",
					get_protocol_type (&temp_buffer_1[0], sptr_proxy_application_list->protocol_type),
					get_port_type (&temp_buffer_2[0], sptr_proxy_application_list->protocol_type, sptr_proxy_application_list->protocol_port),
					sptr_proxy_application_list->protocol_port) ;
		strcat (&application_buffer[0], &temp_buffer[0]) ;
	}
	if (proxy_server.number_of_applications)
		proxy_printf ("%s", &application_buffer[0]) ;
}

void proxy_status ()
{
	int count = 0 ;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node;
	

	if (sptr_root == NULL )
		return;


	sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		count++;
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
	printf ("\nPROXY: Displaying status............\n") ;
	printf ("Number of active clients being proxied : %d\n", proxy_server.number_of_proxied_clients) ;
	printf ("Number of descriptors in the list : %d\n", count) ;
	printf ("Peak Active Descriptor Count : %d\n", proxy_server.peak_concurrent_descriptor_count) ;
	
#if 0
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list);

	while (ptr_to_proxy_server_info != NULL)
	{
		count++ ;
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info);
	}	  

	printf ("\nPROXY: Displaying status............\n") ;
	printf ("Number of active clients being proxied : %d\n", proxy_server.number_of_proxied_clients) ;
	printf ("Number of descriptors in the list : %d\n", count) ;
	printf ("Peak Active Descriptor Count : %d\n", proxy_server.peak_concurrent_descriptor_count) ;
#endif
}

void proxy_internet_port_status ()
{
	USHORT port_index;
	BYTE temp_buffer1[25], temp_buffer2[25];

	for (port_index = 1;	port_index <= NUMBER_OF_PROXY_PORTS; port_index++)
	{
		if (is_ipport_up (port_index) == FALSE)
			continue;
			
		printf ("PROXY: Displaying status of Port %d...\n",port_index);				
		printf ("Local IP Address : %s   Remote IP Address : %s\n",
				convert_ip_address_to_dot_format (temp_buffer1, get_ip_address (port_index)),
				convert_ip_address_to_dot_format (temp_buffer2, get_ip_remote_address (port_index)));
      printf ("Number of connections : %d\n", proxy_server.port[port_index].number_of_connections) ;

		if (proxy_server.port[port_index].maximum_number_of_hosts_to_dial)
		{
			printf ("Number of Hosts to Dial : %d\n", proxy_server.port[port_index].maximum_number_of_hosts_to_dial);
			printf ("Total Number of Connections :%d\n",proxy_server.proxy_number_of_active_hosts);
		}

		if (proxy_server.port[port_index].maximum_number_of_connections_to_dial)
		{
			printf ("Number of Connections to Dial : %d\n", proxy_server.port[port_index].maximum_number_of_connections_to_dial);
			printf ("Total Number of Connections :%d\n",proxy_server.total_number_of_pseudo_connections);
		}
	}										
	return;
}

void debug_proxy_dns_filter_info ()
{
	USHORT filter_index=0,index = 0;
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address;
	BYTE ip_address[25];
	ULONG *temp_ptr;

	sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address;

	printf ("PROXY : Proxy Server DNS Filter List......\n");

printf("PROXY: Max DNS entries : %d",proxy_server.max_number_of_restricted_domain_address);
	for (filter_index = 0; filter_index < proxy_server.max_number_of_restricted_domain_address;
			filter_index++, sptr_next_restricted_domain_address++)
	{
		temp_ptr = sptr_next_restricted_domain_address->destination_ip_address;
printf("PROXY: Max IP entries for entry %d is %d",filter_index,sptr_next_restricted_domain_address->count);
		for ( index = 0;index < sptr_next_restricted_domain_address->count;index++)
		{
				printf ("Domain Name: %s Resolved Address : %s\n",		
				sptr_next_restricted_domain_address->domain_name,
				convert_ip_address_to_dot_format (&ip_address[0], *(temp_ptr)));
		   temp_ptr++;
		}
	}
}

#endif
/* Jo 19/04/99 */

/* sudhir for ftp passive command handling */

void add_port_to_application_list (USHORT application_port_number)
{
	PROXY_DYNAMIC_APP_LIST *temp_app_list_ptr;

	/* temp_app_list_ptr = (PROXY_DYNAMIC_APP_LIST *) malloc (sizeof (PROXY_DYNAMIC_APP_LIST));	 */
	temp_app_list_ptr = (PROXY_DYNAMIC_APP_LIST *) calloc (sizeof (PROXY_DYNAMIC_APP_LIST), 1);
	if (temp_app_list_ptr == NULL)
	{
		printf ("PROXY : Not Enough memory add application\n");
		return;
	} 
/*	printf ("Added new entry to list %d\n",application_port_number);	 */
	temp_app_list_ptr->application_port = application_port_number;
	temp_app_list_ptr->sptr_forward_link = proxy_server.proxy_server_dynamic_application_list;
	proxy_server.proxy_server_dynamic_application_list = temp_app_list_ptr;
	return;
}

USHORT add_passive_port_to_application_list (BYTE *ptr_to_data_packet)
{
	BYTE temp_buffer[75], temp_port[10];	
	USHORT number_of_commas =0, buffer_index = 0, index =0, port1, port2, new_port_number;
	

	memcpy (temp_buffer, ptr_to_data_packet, 60);
	temp_buffer[60] = 0;
	strtok (temp_buffer, "\n");

	while (temp_buffer[buffer_index])
	{
		if (temp_buffer[buffer_index] == ',')
			number_of_commas++;
		
		buffer_index++;
		if (number_of_commas == 4)
			break;
	}

	while (temp_buffer[buffer_index])
	{
		temp_port[index++] = temp_buffer[buffer_index];		
		if (temp_buffer[buffer_index] == '\n')
		{
			temp_port[index-2] = 0;			
			break;
		}
		buffer_index++;
	}	
	sscanf (temp_port ,"%hu,%hu",&port1, &port2);		
	port1 = port1 & 0x00ff;
	port1 = port1 << 8;
	port2 = port2 &0x00ff;
	new_port_number = (port1 | port2);

	add_port_to_application_list (new_port_number);
	proxy_printf ("PROXY : Added Port number %d to application list\n",new_port_number);

	return(new_port_number);	
}

/* Jo 24/07/98 : reads the PROXY configuration from flash into PROXY_CLASS 
					  starting from the location specified by cptr_config */

int proxy_read_configuration (char *cptr_config)
{
    CNF_PROXY_HEADER *proxy_header_ptr ;
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
	 CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;
    CNF_PROXY_FILTER *proxy_filter_ptr ; 
    CNF_PROXY_PORT *proxy_port_ptr, *temp_proxy_port_ptr ; 

    PROXY_RB_KEY_TYPE	next_application_list ;
    BYTE same_port_required = TRUE ;

    CNF_PROXY_ADDRESS_INFO *proxy_restricted_address_ptr ;
    CNF_PROXY_APP *proxy_restricted_application_ptr ;
    CNF_PROXY_MAC_ADDRESS_INFO *proxy_restricted_mac_address_ptr ;
    CNF_PROXY_DOMAIN_NAME_INFO *proxy_restricted_domain_name_ptr ;

    CNF_PROXY_STATIC_INFO  *static_mapping_ptr ;
    CNF_PROXY_DYNAMIC_INFO  *dynamic_mapping_ptr ;

    PROXY_FORBIDDEN_SITE_LIST *sptr_next_forbidden_site ;
	 PROXY_RESTRICTED_CLIENT_LIST *sptr_next_restricted_client ;
 	 PROXY_APPLICATION_TABLE	*sptr_next_application ;
	 PROXY_RESTRICTED_MAC_ADDRESS_LIST *sptr_next_restricted_MAC_address_list ;
	 PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address ;
	 PROXY_PRIVILEGED_USER_LIST *ptr_to_next_user_list ;

	 PROXY_NAT_ADDRESS_LIST *sptr_global_address_list ;
	 PROXY_DYNAMIC_SERVER_LIST *sptr_dynamic_internet_server_list ;
	 PROXY_APP_PORT_RANGE_LIST *ptr_to_port_range ;     /* Imran */

	 BYTE *temp, mac_address_array[6] ;
	 char *temp_mac_addr_ptr ;
	 USHORT index, port_index, section_length, temp_number_of_address_entries = 0 ;
	 int i = 0 ;

	 proxy_header_ptr = (CNF_PROXY_HEADER *)cptr_config ;
	 if (proxy_header_ptr->magic_number != CNF_PROXY_MAGIC_NUMBER)
			return (0) ;


	 proxy_server.proxy_server_enabled = proxy_header_ptr->enabled ;
	 proxy_server.proxy_server_idle_timeout = 25000 ;
	 proxy_server.proxy_server_printf_enabled = 1 ;
	 proxy_server.proxy_any_application_enabled = proxy_header_ptr->proxy_any_app ;
	 section_length = proxy_header_ptr->section_length ;

/* Jo 23/09/99 Statically configure the Dynamic FTP port numbers.*/
	proxy_server.ftp_data_conn_port = proxy_header_ptr->ftp_data_port ;
	proxy_server.ftp_ctrl_conn_port = proxy_header_ptr->ftp_control_port ;

/* APPLICATION ENTRIES */

    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)proxy_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 

	 proxy_server.max_number_of_applications = proxy_application_ptr->number_of_application_entries ;
	 for (index = 0; index < proxy_server.max_number_of_applications; index++)
	 {
	  		next_application_list.protocol_type = proxy_application_ptr->application_entries[index].protocol ;
	  		next_application_list.application_port = proxy_application_ptr->application_entries[index].port ;
			if	(next_application_list.application_port == WEB_RESERVED_PORT)
				same_port_required = FALSE ;				
			else
				same_port_required = TRUE ;				

			add_entry_to_proxy_rb_tree (same_port_required, &next_application_list) ;
		   proxy_server.number_of_applications++ ;
	 }

/* USER DEFINED ENTRIES */
/* PORT RANGE ENTRIES */

    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr +
     (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 

	 proxy_server.proxy_server_application_port_range_list = NULL ;

	 for (index = 0; index < proxy_user_defined_application_ptr->number_of_user_defined_application_entries ; index++)
	 {
/* If it is user defined entry add to rb tree  else if port range, add to 
   linked list */
	 	if(!proxy_user_defined_application_ptr->user_defined_application_entries[index].higher_port_number)
		{
	      next_application_list.protocol_type = proxy_user_defined_application_ptr->user_defined_application_entries[index].protocol;
	  		next_application_list.application_port = proxy_user_defined_application_ptr->user_defined_application_entries[index].lower_port_number;
			if	(next_application_list.application_port == WEB_RESERVED_PORT)
				same_port_required = FALSE ;				
			else
				same_port_required = TRUE ;				

			add_entry_to_proxy_rb_tree (same_port_required, &next_application_list) ;
	  }
	  else
	  {
			ptr_to_port_range = (PROXY_APP_PORT_RANGE_LIST *) malloc (sizeof(PROXY_APP_PORT_RANGE_LIST));
			if(ptr_to_port_range == NULL)
			{
				printf("\nPROXY_SERVER : Not enough memory to create application port range list\n");
				return ; 
			}

			ptr_to_port_range->protocol = proxy_user_defined_application_ptr->user_defined_application_entries[index].protocol;
			ptr_to_port_range->lower_port_number = proxy_user_defined_application_ptr->user_defined_application_entries[index].lower_port_number;
			ptr_to_port_range->higher_port_number = proxy_user_defined_application_ptr->user_defined_application_entries[index].higher_port_number;

			ptr_to_port_range->sptr_forward_link = proxy_server.proxy_server_application_port_range_list ;
			proxy_server.proxy_server_application_port_range_list = ptr_to_port_range;
		}
	   proxy_server.number_of_applications++ ; 
	 }

/* VIRTUAL SERVER */

    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *) proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;

	 proxy_server.total_number_of_global_address = proxy_virtual_server_ptr->number_of_static_mapping_entries ;
	 proxy_server.total_number_of_dynamic_servers = proxy_virtual_server_ptr->number_of_dynamic_mapping_entries ;

/* Static Mapping */
	 if (proxy_server.total_number_of_global_address != 0)
	 {
	 	if ((proxy_server.global_address_list = (PROXY_NAT_ADDRESS_LIST *) table_malloc (
										proxy_server.total_number_of_global_address, sizeof (PROXY_NAT_ADDRESS_LIST))) == NULL)						
	 	{
				proxy_printf ("PROXY: Memory Allocation Failed for Static Mapping\n") ;
				return ;
 	 	}

	 	static_mapping_ptr = ((CNF_PROXY_STATIC_INFO *) ((char *) proxy_virtual_server_ptr + (NUMBER_OF_MAPPING_TYPES * sizeof(USHORT)) + sizeof(ULONG) +
                           (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_server_ptr->number_of_global_address_entries))) ;

   	sptr_global_address_list = proxy_server.global_address_list + proxy_server.number_of_global_address ;
	 	for (index = 0; index < proxy_server.total_number_of_global_address; index++)
	   {
		   sptr_global_address_list->global_address = static_mapping_ptr->global_address ;
			sptr_global_address_list->local_address = static_mapping_ptr->local_address ;
			sptr_global_address_list++ ;
			static_mapping_ptr++ ;
	      proxy_server.number_of_global_address++ ;
	 	}
	 }
/* Dynamic Mapping */

	 if (proxy_server.total_number_of_dynamic_servers != 0)
	 {
		 if ((proxy_server.dynamic_internet_server_list = (PROXY_DYNAMIC_SERVER_LIST *) table_malloc (
										proxy_server.total_number_of_dynamic_servers, sizeof (PROXY_DYNAMIC_SERVER_LIST))) == NULL)						
	 	 {
				proxy_printf ("PROXY: Memory Allocation Failed for Dynamic Mapping\n") ;
				return ;
	 	 }

		 dynamic_mapping_ptr = ((CNF_PROXY_DYNAMIC_INFO *) ((char *) proxy_virtual_server_ptr + (NUMBER_OF_MAPPING_TYPES * sizeof(USHORT)) + sizeof(ULONG) +
                           (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_server_ptr->number_of_global_address_entries) + 
									(sizeof(CNF_PROXY_STATIC_INFO) * proxy_virtual_server_ptr->number_of_static_mapping_entries))) ;

	 	 sptr_dynamic_internet_server_list = proxy_server.dynamic_internet_server_list +
													proxy_server.number_of_dynamic_servers ;

	 	 proxy_server.proxy_local_internet_server_address = proxy_virtual_server_ptr->dynamic_mapping_global_address ;

		 for (index = 0; index < proxy_server.total_number_of_dynamic_servers; index++)
	 	 {
		  		sptr_dynamic_internet_server_list->dynamic_server_ip_address = dynamic_mapping_ptr->local_address ;
		   	sptr_dynamic_internet_server_list->ip_protocol_type = dynamic_mapping_ptr->protocol ;
				sptr_dynamic_internet_server_list->application_port = dynamic_mapping_ptr->port ;
				dynamic_mapping_ptr++ ;
				sptr_dynamic_internet_server_list++ ;
				proxy_server.number_of_dynamic_servers++ ;  
	 	 }
	 }

/* FILTERS */

    proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
                           (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                           (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                           (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 

	 proxy_server.max_number_of_forbidden_sites = proxy_filter_ptr->number_of_forbidden_sites_entries ;
	 proxy_server.max_number_of_restricted_clients = proxy_filter_ptr->number_of_restricted_clients_entries ;  
	 proxy_server.max_number_of_restricted_applications = proxy_filter_ptr->number_of_restricted_application_entries ;
	 proxy_server.max_number_of_restricted_MAC_address = proxy_filter_ptr->number_of_mac_address_entries ;
	 proxy_server.max_number_of_restricted_domain_address = proxy_filter_ptr->number_of_domain_name_entries ;

/* Forbidden sites */

	 if (proxy_server.max_number_of_forbidden_sites != 0)
	 {
		 if ((proxy_server.ptr_to_forbidden_list = (PROXY_FORBIDDEN_SITE_LIST *) table_malloc (
	 					proxy_server.max_number_of_forbidden_sites, sizeof (PROXY_FORBIDDEN_SITE_LIST))) == NULL)
		 {
	 			proxy_printf ("PROXY : Memory Allocation failed for forbidden sites filter\n") ;
			 	return ;
	 	 }
		 proxy_restricted_address_ptr = (CNF_PROXY_ADDRESS_INFO *) ((char *) proxy_filter_ptr + (NUMBER_OF_FILTER_TYPES * sizeof(USHORT))) ;
		 sptr_next_forbidden_site = proxy_server.ptr_to_forbidden_list + proxy_server.number_of_forbidden_sites ;

		 for (index = 0; index < proxy_server.max_number_of_forbidden_sites; index++)
	 	 {
		 		sptr_next_forbidden_site->destination_ip_address = proxy_restricted_address_ptr->address ;
			   proxy_restricted_address_ptr++ ;
		 	   sptr_next_forbidden_site++ ;
				proxy_server.number_of_forbidden_sites++ ;
	 	 }
	 }
/* Restricted clients */


	 if (proxy_server.max_number_of_restricted_clients != 0)
	 {
		 if ((proxy_server.ptr_to_restricted_client_list = (PROXY_RESTRICTED_CLIENT_LIST *) table_malloc (
	 				proxy_server.max_number_of_restricted_clients, sizeof (PROXY_RESTRICTED_CLIENT_LIST))) == NULL)
		 {
		 		proxy_printf ("PROXY : Memory Allocation failed for restricted clients filter\n") ;
			 	return ;
		 }

		 proxy_restricted_address_ptr = (CNF_PROXY_ADDRESS_INFO *) ((char *) proxy_filter_ptr + (NUMBER_OF_FILTER_TYPES * sizeof(USHORT)) +
				  								(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries)) ;
	 	 sptr_next_restricted_client = proxy_server.ptr_to_restricted_client_list + proxy_server.number_of_restricted_clients ;

	 	 for (index = 0; index < proxy_server.max_number_of_restricted_clients; index++)
	    {
			    sptr_next_restricted_client->source_ip_address = proxy_restricted_address_ptr->address ;
				 proxy_restricted_address_ptr++ ;
				 sptr_next_restricted_client++ ;
				 proxy_server.number_of_restricted_clients++ ;
		 }
	 }
/* Restricted Applications */

	 if (proxy_server.max_number_of_restricted_applications != 0)
	 {
		 if ((proxy_server.sptr_restricted_application_list = (PROXY_APPLICATION_TABLE *) table_malloc (
						proxy_server.max_number_of_restricted_applications,sizeof (PROXY_APPLICATION_TABLE))) == NULL)
	 	 {
		 		proxy_printf ("PROXY : Memory Allocation failed for restricted application filter\n") ;
			 	return ;
		 }

	 	 proxy_restricted_application_ptr = (CNF_PROXY_APP *) ((char *) proxy_filter_ptr + (NUMBER_OF_FILTER_TYPES * sizeof(USHORT)) +
				  								   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
				  								   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries)) ;

		 sptr_next_application = proxy_server.sptr_restricted_application_list + proxy_server.number_of_restricted_applications ;

		 for (index = 0; index < proxy_server.max_number_of_restricted_applications; index++)
		 {
				 sptr_next_application->protocol_type = proxy_restricted_application_ptr->protocol ;
				 sptr_next_application->protocol_port = proxy_restricted_application_ptr->port ;
				 proxy_restricted_application_ptr++ ;
				 sptr_next_application++ ;
				 proxy_server.number_of_restricted_applications++ ;
		 }
	 }
/* Restricted MAC Address */

	 if (proxy_server.max_number_of_restricted_MAC_address != 0)
	 {
	 	 if ((proxy_server.ptr_to_restricted_MAC_address_list = (PROXY_RESTRICTED_MAC_ADDRESS_LIST *) table_malloc (
					proxy_server.max_number_of_restricted_MAC_address,sizeof (PROXY_RESTRICTED_MAC_ADDRESS_LIST))) == NULL)
		 {
			 	proxy_printf ("PROXY : Memory Allocation failed for restricted MAC address filter\n") ;
		 		return ;
		 }
	
	 	 proxy_restricted_mac_address_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) ((char *) proxy_filter_ptr + (NUMBER_OF_FILTER_TYPES * sizeof(USHORT)) +
				  								   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
				  								   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries)	+
				  								   (sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries)) ;

		 sptr_next_restricted_MAC_address_list = proxy_server.ptr_to_restricted_MAC_address_list +
						proxy_server.number_of_restricted_MAC_address ;

		 for (index = 0; index < proxy_server.max_number_of_restricted_MAC_address; index++)
		 {
			 temp_mac_addr_ptr = (char *) proxy_restricted_mac_address_ptr->address ;
			 sscanf (temp_mac_addr_ptr, "%02jx%02jx%02jx%02jx%02jx%02jx",
				 (int *)	(mac_address_array), (int *) (mac_address_array+1),
				 (int *)	(mac_address_array+2), (int *) (mac_address_array+3),
				 (int *)	(mac_address_array+4), (int *) (mac_address_array+5)) ;

			 temp = &sptr_next_restricted_MAC_address_list->mac_address[0] ;

			 *temp++ = (BYTE) mac_address_array[0] ;
			 *temp++ = (BYTE) mac_address_array[1] ;
			 *temp++ = (BYTE) mac_address_array[2] ;
			 *temp++ = (BYTE) mac_address_array[3] ;
			 *temp++ = (BYTE) mac_address_array[4] ;
			 *temp++ = (BYTE) mac_address_array[5] ;

			 proxy_restricted_mac_address_ptr++ ;
			 sptr_next_restricted_MAC_address_list++ ;
			 proxy_server.number_of_restricted_MAC_address++ ;		
		 }
	 }
/* Restricted Domain Names */

	 if (proxy_server.max_number_of_restricted_domain_address != 0)
	 {
		 if ((proxy_server.ptr_to_restricted_domain_address = (PROXY_FORBIDDEN_DOMAIN_ADDRESS *) table_malloc (
					proxy_server.max_number_of_restricted_domain_address, sizeof (PROXY_FORBIDDEN_DOMAIN_ADDRESS))) == NULL)
		 {
		 		proxy_printf ("PROXY : Memory Allocation failed for Forbidden Domain Name filter\n") ;
			 	return ;
		 }

		 proxy_restricted_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) ((char *) proxy_filter_ptr + (NUMBER_OF_FILTER_TYPES * sizeof(USHORT)) +
					  								   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
					  								   (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries)	+
					  								   (sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries) +
				  									   (sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * proxy_filter_ptr->number_of_mac_address_entries)) ;

		 sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address +
												proxy_server.number_of_restricted_domain_address ;

		 for (index = 0; index < proxy_server.max_number_of_restricted_domain_address; index++)
		 {
			 strcpy (sptr_next_restricted_domain_address->domain_name, proxy_restricted_domain_name_ptr->domain_name) ;
/* Jo 02 Dec 1999... */
			sptr_next_restricted_domain_address->count = 0 ;
			sptr_next_restricted_domain_address->dns_query_response_status = DNS_TRYING_TO_RESOLVE ;
			sptr_next_restricted_domain_address->dns_retry_count = 0 ;
/* ...Jo 02 Dec 1999 */
			 proxy_restricted_domain_name_ptr++ ;
			 sptr_next_restricted_domain_address++ ;
	   	 proxy_server.number_of_restricted_domain_address++ ;
		 }
	 }
/* Link Control */

   proxy_port_ptr = ((CNF_PROXY_PORT *)((char*) proxy_filter_ptr + sizeof(CNF_PROXY_FILTER) + (
                      (proxy_filter_ptr->number_of_forbidden_sites_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_clients_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_application_entries - 1) * sizeof(CNF_PROXY_APP) +
                      (proxy_filter_ptr->number_of_mac_address_entries - 1) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_domain_name_entries - 1) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)))) ; 

	 temp_proxy_port_ptr = (CNF_PROXY_PORT *)	proxy_port_ptr ;
	 for (port_index = 0; port_index < NUMBER_OF_IP_PORTS ; port_index++)   /*removed -1 */ 
	 {
			temp_number_of_address_entries += temp_proxy_port_ptr->number_of_address_entries ;
		   temp_proxy_port_ptr = ((CNF_PROXY_PORT *) ((char *) temp_proxy_port_ptr + sizeof (CNF_PROXY_PORT) + ((temp_proxy_port_ptr->number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO)))) ;
	 }
	 proxy_server.max_number_of_privileged_users = temp_number_of_address_entries ;

	 if (proxy_server.max_number_of_privileged_users != 0)
	 {
    	if ((proxy_server.ptr_to_privileged_user_list = (PROXY_PRIVILEGED_USER_LIST *) table_malloc (proxy_server.max_number_of_privileged_users, sizeof (PROXY_PRIVILEGED_USER_LIST))) == NULL)
	 	{
	  			proxy_printf ("PROXY: Memory Allocation Failed for Privileged Users List\n") ;
	  			return FAIL ;
	 	}
	 }
	 for (port_index = 0; port_index < NUMBER_OF_IP_PORTS ; port_index++)   
	 {
		  proxy_server.port[port_index].proxy_server_enabled = proxy_port_ptr->enabled ;
		  proxy_server.port[port_index].maximum_number_of_hosts_to_dial = proxy_port_ptr->number_of_hosts_to_trigger ;
		  proxy_server.port[port_index].maximum_number_of_connections_to_dial = proxy_port_ptr->number_of_connections_to_trigger ;
 	     ptr_to_next_user_list = proxy_server.ptr_to_privileged_user_list + proxy_server.number_of_privileged_users ;

/* sudha 15 Dec 1998.Initialized these variables....*/
		  if (port_index == 2)
		  {
			  proxy_server.number_of_descriptors_to_trigger_port2 = proxy_server.port[port_index].maximum_number_of_connections_to_dial;
			  proxy_server.number_of_active_hosts_to_trigger_port2 = proxy_server.port[port_index].maximum_number_of_hosts_to_dial ;
		  }

		  if (port_index == 3)
		  {
			  proxy_server.number_of_descriptors_to_trigger_port3 = proxy_server.port[port_index].maximum_number_of_connections_to_dial;
			  proxy_server.number_of_active_hosts_to_trigger_port3 = proxy_server.port[port_index].maximum_number_of_hosts_to_dial ;
		  }
/* ...sudha 15 Dec 1998.Initialized these variables.*/

		  for (index = 0;	index < proxy_port_ptr->number_of_address_entries; index++)
		  {
				ptr_to_next_user_list->host_ip_address = proxy_port_ptr->port_address[index].address ;
				ptr_to_next_user_list->reserved_port = port_index ;
				proxy_server.number_of_privileged_users++ ;
 	     		ptr_to_next_user_list = proxy_server.ptr_to_privileged_user_list + proxy_server.number_of_privileged_users ;
		  }
		  proxy_port_ptr = ((CNF_PROXY_PORT *) ((char *) proxy_port_ptr + sizeof (CNF_PROXY_PORT) + ((proxy_port_ptr->number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO)))) ;
	 }

#if PRINT_CONFIG
	 print_proxy_configured_parameters () ; 
    print_proxy_app_port_ranges() ;
#endif
	 return (section_length) ;
}

/* Jo 19/04/99 */
#if PRINT_CONFIG
void print_proxy_configured_parameters ()
{
	 char buffer1[1300] ;

	 sprintf (buffer1, "proxy_server_enabled : %d\n"
				   "idle_timeout : %d\n"
				   "no of appl : %d\n"
				   "ps no of appl : %d\n"
				   "no of static mapping : %d\n"
				   "ps no of static mapping : %d\n"
				   "no of dynamic mapping : %d\n"
				   "ps no of dynamic mapping : %d\n"
				   "dynamic address : %d\n"
				   "no of forbidden sites : %d\n"
				   "ps no of forbidden sites : %d\n"
				   "no of restricted clients : %d\n"
				   "ps no of restricted clients : %d\n"
				   "no of restricted appl : %d\n"
				   "ps no of restricted appl : %d\n"
				   "no of restricted MAC addr: %d\n"
				   "ps no of restricted MAC addr: %d\n"
				   "no of restricted domain names : %d\n"
				   "ps no of restricted domain names : %d\n"

					"port 1 enabled : %d\n"
					"max hosts : %d\n"
					"max conn : %d\n"
					"port 2 enabled : %d\n"
					"max hosts : %d\n"
					"max conn : %d\n"
					"port 3 enabled : %d\n"
					"max hosts : %d\n"
					"max conn : %d\n"
					"port 4 enabled : %d\n"
					"max hosts : %d\n"
					"max conn : %d\n"
					"address entries : %d\n"
					"ps address entries : %d\n",
					 proxy_server.proxy_server_enabled,
					 proxy_server.proxy_server_idle_timeout,
					 proxy_server.max_number_of_applications,
					 proxy_server.number_of_applications,
					 proxy_server.total_number_of_global_address, 
					 proxy_server.number_of_global_address,
					 proxy_server.total_number_of_dynamic_servers,
					 proxy_server.number_of_dynamic_servers,
					 proxy_server.proxy_local_internet_server_address,
					 proxy_server.max_number_of_forbidden_sites,
					 proxy_server.number_of_forbidden_sites,
					 proxy_server.max_number_of_restricted_clients,
 					 proxy_server.number_of_restricted_clients,
					 proxy_server.max_number_of_restricted_applications,
					 proxy_server.number_of_restricted_applications,
					 proxy_server.max_number_of_restricted_MAC_address,
 					 proxy_server.number_of_restricted_MAC_address,
					 proxy_server.max_number_of_restricted_domain_address,
					 proxy_server.number_of_restricted_domain_address,
					 proxy_server.port[0].proxy_server_enabled,
					 proxy_server.port[0].maximum_number_of_hosts_to_dial,
					 proxy_server.port[0].maximum_number_of_connections_to_dial,
					 proxy_server.port[1].proxy_server_enabled,
					 proxy_server.port[1].maximum_number_of_hosts_to_dial,
					 proxy_server.port[1].maximum_number_of_connections_to_dial,
					 proxy_server.port[2].proxy_server_enabled,
					 proxy_server.port[2].maximum_number_of_hosts_to_dial,
					 proxy_server.port[2].maximum_number_of_connections_to_dial,
					 proxy_server.port[3].proxy_server_enabled,
					 proxy_server.port[3].maximum_number_of_hosts_to_dial,
					 proxy_server.port[3].maximum_number_of_connections_to_dial,
					 proxy_server.max_number_of_privileged_users,
					 proxy_server.number_of_privileged_users) ;
					 printf ("buffer : %s\n", buffer1) ;

}

void print_proxy_app_port_ranges()
{
	PROXY_APP_PORT_RANGE_LIST *temp_app_port_range_ptr;

	temp_app_port_range_ptr = proxy_server.proxy_server_application_port_range_list;
	while(temp_app_port_range_ptr)
	{
		printf("\nProtocol - %d",temp_app_port_range_ptr->protocol);
		printf("\nLower Port - %d , Higher Port - %d",temp_app_port_range_ptr->lower_port_number,temp_app_port_range_ptr->higher_port_number);
		temp_app_port_range_ptr = temp_app_port_range_ptr->sptr_forward_link;
	}
}
#endif
