#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <redblack.h>
#include "ethernet.h"

#define RB_INSERT_OVERFLOW 0
#define RB_NEW_ENTRY 1
#define RB_UPDATED 2


/* Define this and do operations like copying and comparisons more optimally */
#define CUSTOM_OPERATIONS 1
#define STATISTICS 1

#if STATISTICS
static struct
{
	unsigned long number_of_nodes ; /* (RB_NEW_ENTRY) */
	unsigned long number_of_search_hits ;
	unsigned long number_of_insert_hits ; /* (RB_UPDATED) */
	unsigned long number_of_insert_overflows ;
   unsigned long number_of_deletions ;
} statistics ;
#endif

/* The following need to defined for the specific application */
typedef struct
{
   unsigned long ethernet_address_ulong ;
   unsigned short ethernet_address_ushort ;
} KEY_TYPE ;
typedef struct
{
	unsigned long age ;
} INFO_TYPE ;

typedef struct
{
	RED_BLACK_NODE_HEADER rb_header ;
	KEY_TYPE key ;
	INFO_TYPE info ;
} ETHERNET_ADDRESS_NODE ;
ETHERNET_ADDRESS_NODE far *sptr_ethernet_address_tree ;
unsigned long ethernet_rb_node_age = 5 * 20 ;

static ETHERNET_ADDRESS_NODE far *get_new_rb_node ()
{
#if CUSTOM_OPERATIONS
	return ((ETHERNET_ADDRESS_NODE far *) _fmalloc (sizeof (ETHERNET_ADDRESS_NODE))) ;
#else
	return ((ETHERNET_ADDRESS_NODE far *) _fmalloc (sizeof (ETHERNET_ADDRESS_NODE))) ;
#endif
}

static void free_rb_node (ETHERNET_ADDRESS_NODE far *sptr_node)
{
#if CUSTOM_OPERATIONS
	_ffree (sptr_node) ;
#else
	_ffree (sptr_node) ;
#endif
}


int RB_demo_insert_node(ETHERNET_ADDRESS_NODE far *Tree, KEY_TYPE key, INFO_TYPE info, ETHERNET_ADDRESS_NODE far **ptr_sptr_new_node)
{
	ETHERNET_ADDRESS_NODE far *nptr ;
	int retVal ;

#if CUSTOM_OPERATIONS
	retVal = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (KEY_TYPE)) ;
#else
	retVal = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (KEY_TYPE)) ;
#endif
	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (RB_demo_insert_node ((ETHERNET_ADDRESS_NODE far *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_rb_node() ;
			if (nptr == NULL)
			{
#if STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER far *)nptr ;
#if STATISTICS
			statistics.number_of_nodes++ ;
#endif
			return RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
		{
			return (RB_demo_insert_node ((ETHERNET_ADDRESS_NODE far *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		}
		else
		{
			*ptr_sptr_new_node = nptr = get_new_rb_node() ;
			if (nptr == NULL)
			{
#if STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER far *) nptr ;
#if STATISTICS
			statistics.number_of_nodes++ ;
#endif
			return RB_NEW_ENTRY ;
		}
	}
#if CUSTOM_OPERATIONS
	/* Here is where you should be putting in things like updating
	the information fields and things like that. For example you
	may want to reset an age field or update some field like
	information_source_port .... */
#endif
#if STATISTICS
	statistics.number_of_insert_hits++ ;
#endif
	return RB_UPDATED ;
}


int RB_demo_insert(KEY_TYPE key, INFO_TYPE info)
{
	ETHERNET_ADDRESS_NODE far *nptr, far *sptr_new_node ;
	int retVal ;

	if (sptr_ethernet_address_tree == (ETHERNET_ADDRESS_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_rb_node() ;
		if (nptr == NULL)
		{
#if STATISTICS
			statistics.number_of_insert_overflows++ ;
#endif
			return RB_INSERT_OVERFLOW ;
		}
#if CUSTOM_OPERATIONS
		nptr->key = key ;
		nptr->info = info ;
#else
		nptr->key = key ;
		nptr->info = info ;
#endif
		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_ethernet_address_tree = nptr ;
#if STATISTICS
		statistics.number_of_nodes++ ;
#endif
		return RB_NEW_ENTRY ;
	}

	retVal = RB_demo_insert_node (sptr_ethernet_address_tree, key, info, &sptr_new_node) ;

	if (retVal == RB_NEW_ENTRY)
	{
		sptr_ethernet_address_tree = (ETHERNET_ADDRESS_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER far *)sptr_new_node, (RED_BLACK_NODE_HEADER far *)sptr_ethernet_address_tree) ;
	}
	return retVal ;
}

ETHERNET_ADDRESS_NODE far *RB_demo_search(ETHERNET_ADDRESS_NODE far *Tree, KEY_TYPE key)
{
	int ret_val ;

	if (Tree == (ETHERNET_ADDRESS_NODE far *)sptr_RB_sentinal_node)
		return NULL ;

#if CUSTOM_OPERATIONS
	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (KEY_TYPE)) ;
#else
	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (KEY_TYPE)) ;
#endif

	if (ret_val < 0)
		return RB_demo_search ((ETHERNET_ADDRESS_NODE far *)Tree->rb_header.RChild, key) ;
	else
		if (ret_val > 0)
			return RB_demo_search((ETHERNET_ADDRESS_NODE far *)Tree->rb_header.LChild, key) ;
		else
		{
#if STATISTICS
			statistics.number_of_search_hits++ ;
#endif
			return Tree ;
		}
} 

extern unsigned long scc1_collision_errors ;
extern unsigned long scc1_overflow_errors ;
extern unsigned long scc1_CRC_errors ;
extern unsigned long scc1_short_frame_errors ;
extern unsigned long scc1_non_octet_aligned_frame_errors ;
extern unsigned long scc1_frame_length_violation_errors ;
#define PRINT_BUFFER_SIZE 1000
char print_buffer[PRINT_BUFFER_SIZE] ;
void display_ethernet_tree ()
{
	int i = 1, j ;
	unsigned char ch ;
	unsigned char far *x ;
	char *print_buffer_ptr = &print_buffer[0] ;
	int print_buffer_length = 0 ;
   ETHERNET_ADDRESS_NODE far *sptr_root = sptr_ethernet_address_tree ;
	ETHERNET_ADDRESS_NODE far *sptr_next_node = (ETHERNET_ADDRESS_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	printf ("\n\nDisplaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		sprintf (print_buffer_ptr, "\n\tNode %04d : ", i++) ;
		print_buffer_ptr += 14 ;
		print_buffer_length += 14 ;
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &print_buffer[0]) ;
			print_buffer_ptr = &print_buffer[0] ;
			print_buffer_length = 0 ;
		}
		x = (unsigned char far *) &sptr_next_node->key ;
		for (j = 0 ; j < sizeof (KEY_TYPE) ; j++)
		{
			ch =  *x++ ;
			sprintf (print_buffer_ptr, "%02X", ch) ;
			print_buffer_ptr += 2 ;
			print_buffer_length += 2 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &print_buffer[0]) ;
				print_buffer_ptr = &print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
      sprintf (print_buffer_ptr, ", Age : %04d seconds", sptr_next_node->info.age/20) ;
		print_buffer_ptr += 20 ;
		print_buffer_length += 20 ;
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &print_buffer[0]) ;
			print_buffer_ptr = &print_buffer[0] ;
			print_buffer_length = 0 ;
		}
		if (sptr_next_node == sptr_root)
		{
			sprintf (print_buffer_ptr, "\t\t(ROOT)") ;
			print_buffer_ptr += 8 ;
			print_buffer_length += 8 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &print_buffer[0]) ;
				print_buffer_ptr = &print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
		sptr_next_node = (ETHERNET_ADDRESS_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}

	if (print_buffer_length)
		printf ("%s\n\n", &print_buffer[0]) ;
	
   printf ("\n\nStatistics........\n\
      \tNumber of Insert Hits              : %d\n\
      \tNumber of Deletions                : %d\n\
      \tNumber of Collisions               : %d\n\
      \tNumber of Overflows                : %d\n\
      \tNumber of CRC Errors               : %d\n\
      \tNumber of Short Frame              : %d\n\
      \tNumber of Non-octet aligned Frames : %d\n\
      \tNumber of Frame Length Violations  : %d\n\
      ",
      statistics.number_of_insert_hits,
      statistics.number_of_deletions,
      scc1_collision_errors,
      scc1_overflow_errors,
      scc1_CRC_errors,
      scc1_short_frame_errors,
      scc1_non_octet_aligned_frame_errors,
      scc1_frame_length_violation_errors
      ) ;

	return ;
}

extern ETHERNET_CLASS ethernet ;
void add_entry_to_ethernet_rb_tree (unsigned short port_number, unsigned char *vptr_buffer)
{
   INFO_TYPE info ;

   if (ethernet.port.isr_level_filtering == FALSE)
      return ;

   info.age = ethernet_rb_node_age ;

   RB_demo_insert (*((KEY_TYPE *)(vptr_buffer+6)), info) ;
}

#define TEMP 0
void initialize_ethernet_rb_tree ()
{
#if TEMP
   KEY_TYPE ethernet_address ;
   int i ;
   INFO_TYPE info ;

   info.age = ethernet_rb_node_age ;
#endif

   sptr_ethernet_address_tree = (ETHERNET_ADDRESS_NODE far *) sptr_RB_sentinal_node ;

#if TEMP
   ethernet_address.ethernet_address_ulong = 0x00FFFFFF ;
   ethernet_address.ethernet_address_ushort = 0xFFFF ;

   for (i = 0 ; i < 300 ; i++)
   {
      RB_demo_insert (ethernet_address, info) ;
      ethernet_address.ethernet_address_ulong-- ;
   }
#endif
}


int delete_entry_from_ethernet_rb_tree (KEY_TYPE key)
{
   ETHERNET_ADDRESS_NODE *sptr_node_to_delete ;

   sptr_node_to_delete = RB_demo_search (sptr_ethernet_address_tree, key) ;
   if (sptr_node_to_delete)
   {
#if STATISTICS
      statistics.number_of_deletions++ ;
#endif
      RB_delete ((RED_BLACK_NODE_HEADER far *)sptr_ethernet_address_tree, (RED_BLACK_NODE_HEADER far *)sptr_node_to_delete, (unsigned long) sizeof (ETHERNET_ADDRESS_NODE), (RED_BLACK_NODE_HEADER far **)&sptr_node_to_delete) ;
      return (1) ;
   }
   return (0) ;
}



void age_ethernet_rb_tree ()
{
#if 0
	ETHERNET_ADDRESS_NODE far *sptr_temp, far *sptr_next_node = (ETHERNET_ADDRESS_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_ethernet_address_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
      sptr_next_node = (ETHERNET_ADDRESS_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
      if (sptr_temp->info.age)
      {
         sptr_temp->info.age-- ;
      }
      else
      {
#if 0
         sptr_ethernet_address_tree = (ETHERNET_ADDRESS_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)sptr_temp,
                      (RED_BLACK_NODE_HEADER far *)sptr_ethernet_address_tree,
                      (unsigned long) sizeof (ETHERNET_ADDRESS_NODE),
                      (RED_BLACK_NODE_HEADER far **)&sptr_temp) ;
#endif
      }
   }
#endif
}

void delete_aged_out_entries_in_ethernet_rb_tree (void)
{
	ETHERNET_ADDRESS_NODE far *x, far *sptr_next_node = (ETHERNET_ADDRESS_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_ethernet_address_tree) ;
   
   while (sptr_next_node)
   {
      if (sptr_next_node->info.age)
      {
      }
      else
      {
         sptr_ethernet_address_tree = (ETHERNET_ADDRESS_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)sptr_next_node,
                      (RED_BLACK_NODE_HEADER far *)sptr_ethernet_address_tree,
                      (unsigned long) sizeof (ETHERNET_ADDRESS_NODE),
                      (RED_BLACK_NODE_HEADER far **)&x) ;
#if STATISTICS
         statistics.number_of_deletions++ ;
#endif
         free_rb_node (x) ;
         /* In one pass, delete just one. In fact as an optimization,
         we can keep track of the existence of aged out entries in
         a class variable so that we dont even need to call this function
         in case there are no aged entries */
         return ;
      }
      sptr_next_node = (ETHERNET_ADDRESS_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
   }
}



#if 0
void main()
{
	int choice ;
	unsigned long int_key ;
	KEY_TYPE key ;
	INFO_TYPE info ;
	ETHERNET_ADDRESS_NODE far *sptr_node_to_delete ;

	sptr_ethernet_address_tree = (ETHERNET_ADDRESS_NODE far *)sptr_RB_sentinal_node ;

	while (1)
	{
		printf ("\n\n") ;
		printf ("\n\t1. Insert a Node") ;
		printf ("\n\t2. Delete a Node") ;
		printf ("\n\t3. Display the Tree") ;
		printf ("\n\t4. Search") ;
		printf ("\n\t5. Exit") ;

		printf ("\n\n\tEnter Your Choice : ") ;
		scanf ("%d", &choice) ;

		switch (choice)
		{
			case (1) :
				printf ("\n\n\tEnter the Key : ") ;
				scanf ("%lX", &int_key) ;
				*((unsigned long *)&key) = int_key ;
				RB_demo_insert (key, info) ;
				break ;
				
			case (2) :
				printf ("\n\n\tEnter the Key : ") ;
				scanf ("%lX", &key) ;
				sptr_node_to_delete = RB_demo_search (sptr_ethernet_address_tree, key) ;
				if (sptr_node_to_delete)
				{
					sptr_ethernet_address_tree = (ETHERNET_ADDRESS_NODE far *)
						RB_delete ((RED_BLACK_NODE_HEADER far *)sptr_node_to_delete,
					              (RED_BLACK_NODE_HEADER far *)sptr_ethernet_address_tree,
									  (unsigned long) sizeof (ETHERNET_ADDRESS_NODE),
									  (RED_BLACK_NODE_HEADER far **)&sptr_node_to_delete) ;
					free_rb_node (sptr_node_to_delete) ;
				}
				else
					printf ("\n\tKey not found in the Tree\n\n") ;

				break ;

			case (3) :
				display_tree (sptr_ethernet_address_tree) ;
				break ;

			case (4) :
				printf ("\n\n\tEnter the Key : ") ;
				scanf ("%lX", &key) ;
				if (RB_demo_search (sptr_ethernet_address_tree, key))
					printf ("\n\tKey found in the Tree\n\n") ;
				else
					printf ("\n\tKey not found in the Tree\n\n") ;
				break ;

			default :
				printf ("\n\n") ;
				return ;
		}
	}
}
#endif
