#define _VPN_PPTP_

#define PPTP_APPLICATION_PORT 1723

enum PPTP_CONTROL_MESSAGE 
{
	 PPTP_START_CTL_CONN_REQUEST = 1 ,
	 PPTP_START_CTL_CONN_REPLY   = 2 ,
	 PPTP_STOP_CTL_CONN_REQUEST  = 3 ,
	 PPTP_STOP_CTL_CONN_REPLY    = 4	,
	 PPTP_ECHO_REQUEST           = 5	,
	 PPTP_ECHO_REPLY             = 6	,
	 PPTP_OUTGOING_CALL_REQUEST  = 7	,
	 PPTP_OUTGOING_CALL_REPLY    = 8	,
	 PPTP_INCOMING_CALL_REQUEST  = 9	,
	 PPTP_INCOMING_CALL_REPLY    = 10 ,
	 PPTP_INCOMING_CALL_CONNECTED= 11 ,
	 PPTP_CALL_CLEAR_REQUEST     = 12 ,
	 PPTP_CALL_DISCONNECT_NOTIFY = 13 ,
	 PPTP_WAN_ERROR_NOTIFY       = 14 ,
	 PPTP_SET_LINK_INFO          = 15
};


typedef struct
{
	USHORT  client_call_id;
	USHORT  mapped_client_call_id;
	USHORT  server_call_id;
	USHORT  mapped_server_call_id;

	ULONG source_ip_address;
	ULONG destination_ip_address;
	USHORT idle_timer;
	
	USHORT rx_port_number;
	USHORT tx_port_number;
	ULONG  outgoing_port_address;
}PPTP_INFO_DESCRIPTOR;

typedef struct
{
	USHORT	control_parameters;
	USHORT   protocol_type;
	USHORT   payload_length;
	USHORT   call_id;
	ULONG    seq_number;
	ULONG    ack_number;
} GRE_PACKET_TYPE;







/* sudha taken from BIG_PROXY on 8 Jan 1999... */
typedef struct 
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT 	ctl_msg_type;
}PPTP_PACKET_HEADER_TYPE;
/* ... sudha taken from BIG_PROXY on 8 Jan 1999 */

typedef struct 
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT 	ctl_msg_type;
	USHORT 	reserved0;
	BYTE 		result_code;
	BYTE 		error_code;
	USHORT	reserved1;
}STOP_CONN_REPLY_PKT;

typedef struct 
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT 	ctl_msg_type;
	USHORT 	reserved0;
	BYTE 		reason;
	BYTE 		reserved1;
	USHORT 	reserved2;
}STOP_CONN_REQUEST_PKT;


typedef struct 
{
	USHORT	packet_length;
	USHORT 	message_type;
	ULONG  	magic_cookie;
	USHORT 	ctrl_msg_type;
	USHORT 	reserved0;
	USHORT 	protocol_version;
	USHORT 	reserved1;
	ULONG  	framing_cap;
	ULONG  	bearer_cap;
	USHORT 	max_channels;
	USHORT 	fw_version;
	BYTE 		host_name[64];
	BYTE 		vendor_string[64];
} START_CONN_REQUEST_PKT;


typedef struct 
{
	USHORT	packet_length;
	USHORT 	message_type;
	ULONG  	magic_cookie;
	USHORT 	ctrl_msg_type;
	USHORT 	reserved0;
	USHORT 	protocol_version;
	BYTE     result_code;
	BYTE     error_code;
	ULONG  	framing_cap;
	ULONG  	bearer_cap;
	USHORT 	max_channels;
	USHORT 	fw_version;
	BYTE 		host_name[64];
	BYTE 		vendor_string[64];
} START_CONN_REPLY_PKT;


typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	ULONG    identifier;
}ECHO_REQUEST_PKT;


typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	ULONG    identifier;
	BYTE     result_code;
	BYTE     error_code;
	USHORT   reserved1;
}ECHO_REPLY_PKT;

typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   call_id;
	USHORT   call_serial_number;
	ULONG    min_bps;
	ULONG    max_bps;
	ULONG    bearer_type;
	ULONG    framing_type;
	USHORT   win_size;
	USHORT   pkt_pr_delay;
	USHORT   phone_number_length;
	USHORT   reserved1;
	BYTE     phone_number[64];
	BYTE     sub_address[64];
}OUTGOING_CALL_REQUEST_PKT;



typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   call_id;
	USHORT   peers_call_id;
	BYTE     result_code;
	BYTE     error_code;
	USHORT   cause_code;
	ULONG    connect_speed;
	USHORT   win_size;
	USHORT   pkt_pr_delay;
	ULONG    channel_id;
}OUTGOING_CALL_REPLY_PKT;

typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   call_id;
	USHORT   call_serial_number;
	ULONG    call_bearer_type;
	ULONG    channel_id;
	USHORT   dialed_number_length;
	USHORT   dialing_number_length;
	BYTE     dialed_number[64];
	BYTE     dialing_number[64];
	BYTE     sub_address[64];
}INCOMING_CALL_REQUEST_PKT;

typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   call_id;
	USHORT   peers_call_id;
	BYTE     result_code;
	BYTE     error_code;
	USHORT   win_size;
	USHORT   pkt_tx_delay;
	USHORT   reserved1;
}INCOMING_CALL_REPLY_PKT;


typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   peers_call_id;
	USHORT   reserved1;
	ULONG    connect_speed;
	USHORT   win_size;
	USHORT   pkt_tx_delay;
	ULONG    framing_type;
}INCOMING_CALL_CONNECTED_PKT;


typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   call_id;
	USHORT   reserved1;
}CALL_CLEAR_REQUEST_PKT;



typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   call_id;
	BYTE     result_code;
	BYTE     error_code;
	USHORT   cause_code;
	USHORT   reserved1;
	BYTE     call_statistics[128];
}CALL_DISCONNECT_NOTIFY_PKT;


typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   peers_call_id;
	BYTE     reserved1[28];
}WAN_ERROR_NOTIFY_PKT;


typedef struct
{
	USHORT 	pkt_length;
	USHORT 	mesg_type;
	ULONG 	magic_cookie;
	USHORT   ctl_mesg_type;
	USHORT   reserved0;
	USHORT   peer_call_id;
	BYTE     reserved1[10];
}SET_LINK_INFO_PKT;

typedef union UNION_PPTP_PACKET 
{
	START_CONN_REQUEST_PKT     	sccreq_pkt;
	START_CONN_REPLY_PKT    		sccrep_pkt;
	STOP_CONN_REQUEST_PKT   		stopreq_pkt;
	STOP_CONN_REPLY_PKT				stoprep_pkt;
	ECHO_REQUEST_PKT        		echoreq_pkt;
	ECHO_REPLY_PKT          		echorep_pkt;
	OUTGOING_CALL_REQUEST_PKT		ocreq_pkt;
	OUTGOING_CALL_REPLY_PKT    	ocrep_pkt;
	INCOMING_CALL_REQUEST_PKT  	increq_pkt;
	INCOMING_CALL_REPLY_PKT    	increp_pkt;
	INCOMING_CALL_CONNECTED_PKT   incconn_pkt;
	CALL_CLEAR_REQUEST_PKT        ccreq_pkt;
	CALL_DISCONNECT_NOTIFY_PKT    ccrep_pkt;
	WAN_ERROR_NOTIFY_PKT          wanerr_pkt;
	SET_LINK_INFO_PKT             linkinfo_pkt;
};
