#include	"defs.h"
/*	$Modname: snmpagnt.c$  $version: 1.11$		 $date: 06/27/95$	  */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.3 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.4 05/26/94 keyur
1.5 05/28/94 keyur adding enumerations.
1.6 06/01/94 ross
1.7 06/03/94 ross adding protocol and driver traps.
1.8 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.9 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.10 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
1.11 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "snmp.h"
/**********************************************************************************/
static BYTE *verify_snmp_header (BYTE *bptr_rxed_packet, USHORT length_of_rxed_packet, enum SNMP_PDU_TYPE *eptr_request_type,
	enum ASN_TYPES *eptr_type, ULONG *ulptr_request_id, ULONG *ulptr_error_status, ULONG *ulptr_error_index);
static enum TEST build_response_snmp_header (BYTE **bptr_response_packet, BYTE **bptr_out_authentication, BYTE **bptr_out_header,
	BYTE **bptr_out_request_id, USHORT *usptr_length_of_response_packet, ULONG *ulptr_zero, ULONG *ulptr_request_id,
	enum ASN_TYPES *eptr_type);
/**********************************************************************************/
enum TEST snmp_agent_parse (BYTE *bptr_rxed_packet, USHORT length_of_rxed_packet,
	BYTE *bptr_response_packet, USHORT *usptr_length_of_response_packet, MANAGER_CLASS *sptr_manager)
{
	USHORT header_shift;
	USHORT authentication_shift;
	USHORT starting_length;
	ULONG request_id;
	ULONG error_status;
	ULONG error_index;
	ULONG zero;
	enum SNMP_PDU_TYPE message_type;
	enum ASN_TYPES	type;
	BYTE *bptr_out_authentication;
	BYTE *bptr_out_header;
	BYTE *bptr_out_request_id;
	BYTE *bptr_starting_data;
	BYTE *bptr_end_of_packet;

	zero = 0x00000000L;
	starting_length = length_of_rxed_packet;
	bptr_starting_data = bptr_rxed_packet;

	snmp.length_of_session_id = SESSION_ID_MAXIMUM_LENGTH;

	bptr_rxed_packet = verify_snmp_header (bptr_rxed_packet, length_of_rxed_packet, &message_type, &type,
		&request_id, &error_status, &error_index);

	if (bptr_rxed_packet == NULL)
		{
/*		printf("\n\r verify_snmp_header failed\n\r");*/
		return (FAIL);
		}

	if (build_response_snmp_header (&bptr_response_packet, &bptr_out_authentication,
		&bptr_out_header, &bptr_out_request_id, usptr_length_of_response_packet, &zero, &request_id, &type) == FAIL)
		{
/*		printf("\n\r build_response_snmp_header failed\n\r");*/
		return (FAIL);
		}

	error_status = (ULONG) parse_variable_bindings_list (bptr_rxed_packet, length_of_rxed_packet, bptr_response_packet,
		*usptr_length_of_response_packet, message_type, (ULONG *) &error_index, FALSE, sptr_manager, &bptr_end_of_packet);

	++snmp.mib.snmpOutGetResponses;

if(message_type == SET_REQUEST_MESSAGE)
/*	printf("\r\n error_status is %d\r\n",error_status);*/

	if (message_type == SET_REQUEST_MESSAGE && error_status == SNMP_OK)
		{
		/*
	  * SETS require 2 passes through the var_op_list.The first pass verifies that
	  * all types,lengths,and values are valid, and the second does the set.  Then
	 	* the identical GET RESPONSE packet is returned.
	 	*/
		error_status = (ULONG) parse_variable_bindings_list (bptr_rxed_packet, length_of_rxed_packet, bptr_response_packet,
			*usptr_length_of_response_packet, message_type, (ULONG *) &error_index, TRUE, sptr_manager, &bptr_end_of_packet);

/* Srikar 6 Jan 97 */
		if (create_identical_packet (bptr_starting_data, bptr_out_authentication, starting_length, error_status,
			error_index, &bptr_end_of_packet) == PASS)
			{
			*usptr_length_of_response_packet = length_of_rxed_packet;

		 	return (PASS);
			}
		else
			{
/*		printf("\n\r create_identical_packet failed\n\r");*/
			return (FAIL);
			}
	 	}
/* Srikar 6 Jan 97 */

/* If request is SET and no error found then we do not need to go beyond this point..... */
/* If request is Get or GET_NEXT type then we need to process the following before returning. */

	switch (error_status)
		{
		case SNMP_OK:
		/*
		 * Because of the assumption above that header lengths would be encoded
		 * in one byte, things need to be fixed, now that the actual lengths are known.
		 */
			header_shift = 0x0000;
			*usptr_length_of_response_packet = (USHORT) ((ULONG) bptr_end_of_packet - (ULONG) bptr_out_request_id);

			if (*usptr_length_of_response_packet >= 0x80)
				{
				++header_shift;

				if (*usptr_length_of_response_packet > 0xff)
					{
			 		++header_shift;
					}
		 		}

			authentication_shift = 0x0000;
			*usptr_length_of_response_packet = (USHORT) (((ULONG) bptr_end_of_packet - (ULONG) bptr_out_authentication) - 2 +
				header_shift);

	 		if (*usptr_length_of_response_packet >= 0x80)
				{
				++authentication_shift;

				if (*usptr_length_of_response_packet > 0xff)
					{
			 		++authentication_shift;
					}
		 		}

			if ((authentication_shift + header_shift) != 0x0000)
				{
				/* Shift packet (from request id to end of packet) by the sum of the necessary shift counts. */

				shift_array (bptr_out_request_id, (USHORT) (bptr_end_of_packet - bptr_out_request_id),
					(short) (authentication_shift + header_shift));

				/* Now adjust pointers into the packet */

				bptr_end_of_packet = (BYTE *) ((ULONG) bptr_end_of_packet + authentication_shift + header_shift);
				bptr_out_request_id = (BYTE *) ((ULONG) bptr_out_request_id + authentication_shift + header_shift);
				bptr_out_header = (BYTE *) ((ULONG) bptr_out_header + authentication_shift);
		 		}
		 
			/* re-encode the headers with the real lengths */

			bptr_response_packet = bptr_out_header;

			*usptr_length_of_response_packet = (USHORT) (bptr_end_of_packet - bptr_out_request_id);

			bptr_response_packet = asn_build_header (bptr_response_packet, usptr_length_of_response_packet,
				(enum ASN_TYPES) GET_RESPONSE_MESSAGE, *usptr_length_of_response_packet);

			if (bptr_response_packet != bptr_out_request_id)
				{
				snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Internal Error\n");

				return (FAIL);
				}

			bptr_response_packet = bptr_out_authentication;

			*usptr_length_of_response_packet = (USHORT) (bptr_end_of_packet - bptr_out_authentication);

			bptr_response_packet = snmp_authentication_build (bptr_response_packet, usptr_length_of_response_packet,
				&snmp.session_id[0], &snmp.length_of_session_id, &zero, (USHORT) (bptr_end_of_packet - bptr_out_header));

			if (bptr_response_packet != bptr_out_header)
				{
				snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Internal Error\n");

				return (FAIL);
				}
			else
				{
				break;
				}

		case SNMP_ERROR_NO_SUCH_NAME:
		case SNMP_ERROR_TOO_BIG:
		case SNMP_ERROR_BAD_VALUE:
		case SNMP_ERROR_READ_ONLY:
		case SNMP_ERROR_GENERAL_ERROR:

		 	if (create_identical_packet (bptr_starting_data, bptr_out_authentication, starting_length, error_status,
				error_index, &bptr_end_of_packet) == PASS)
				{
				break;
				}
			else
  				{
			 	return (FAIL);
				}

		default:

		 	return (FAIL);
		}

	*usptr_length_of_response_packet = (USHORT) (bptr_end_of_packet - bptr_out_authentication);

	return (PASS);
}
/**********************************************************************************/
static BYTE *verify_snmp_header (BYTE *bptr_rxed_packet, USHORT length_of_rxed_packet, enum SNMP_PDU_TYPE *eptr_request_type,
	enum ASN_TYPES *eptr_type, ULONG *ulptr_request_id, ULONG *ulptr_error_status, ULONG *ulptr_error_index)
{
	ULONG snmp_version;
	USHORT snmp_community;

	/* authenticates message and returns length, if valid */

	bptr_rxed_packet = snmp_auth_parse (bptr_rxed_packet, &length_of_rxed_packet, &snmp.session_id[0],
		&snmp.length_of_session_id, &snmp_version); 

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Bad Authentication\r\n");

		return (NULL);
	 	}

	if (snmp_version != SNMP_VERSION_1)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Wrong SNMP Version\r\n");

		++snmp.mib.snmpInBadVersions;

		return (NULL);
	 	}

	snmp_community = get_snmp_community (&snmp.session_id[0]);

	if (snmp_community == NUMBER_OF_SNMP_COMMUNITIES + 1)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Wrong SNMP Community\r\n");

		/* Srikar, Mar 19, 1997. Changed the field from snmpInBadCommunities to snmpInBadCommunityNames. */
		++snmp.mib.snmpInBadCommunityNames;

		return (NULL);
		}

	/* this next parsing gets the snmp pdu type and length of pdu */

/*	printf("\n\r%cu,%cu\t",*bptr_rxed_packet,*(bptr_rxed_packet+1));*/
	bptr_rxed_packet = asn_parse_header (bptr_rxed_packet, &length_of_rxed_packet, (UNION_SNMP_TYPES *) eptr_request_type);

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Bad SNMP Header\r\n");

		++snmp.mib.snmpInAsnParseErrs;

		return (NULL);
	 	}


	if ((*eptr_request_type != GET_REQUEST_MESSAGE) && (*eptr_request_type != GET_NEXT_REQUEST_MESSAGE) &&
		(*eptr_request_type != SET_REQUEST_MESSAGE))
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Bad SNMP Request Received\r\n");

		++snmp.mib.snmpInBadValues;

		return (NULL);
	 	}

	/* this next parsing gets request id */

	bptr_rxed_packet = asn_parse_integer (bptr_rxed_packet, &length_of_rxed_packet, eptr_type, ulptr_request_id,
		(USHORT) sizeof (ULONG), 0x00);

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Bad Parse of request id\n");

		++snmp.mib.snmpInBadValues;

		return (NULL);
	 	}

	/* this next parsing gets error status */

	bptr_rxed_packet = asn_parse_integer (bptr_rxed_packet, &length_of_rxed_packet, eptr_type, ulptr_error_status,
		(USHORT) sizeof (ULONG), 0x00);

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Bad Parse of error status \r\n");

		++snmp.mib.snmpInBadValues;

		return (NULL);
	 	}

	/* this next parsing gets error index */

	bptr_rxed_packet = asn_parse_integer (bptr_rxed_packet, &length_of_rxed_packet, eptr_type, ulptr_error_index,
		(USHORT) sizeof (ULONG), 0x00);

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Bad Parse of error index\r\n");

		++snmp.mib.snmpInBadValues;

		return (NULL);
	 	}

	return (bptr_rxed_packet);
}
/**********************************************************************************/
static enum TEST build_response_snmp_header (BYTE **bptr_response_packet, BYTE **bptr_out_authentication, BYTE **bptr_out_header,
	BYTE **bptr_out_request_id, USHORT *usptr_length_of_response_packet, ULONG *ulptr_zero, ULONG *ulptr_request_id,
	enum ASN_TYPES *eptr_type)
{
	/*
	 * Now start cobbling together what is known about the output packet.
	 * The final lengths are not known now, so they will have to be recomputed later.
	 */

	*bptr_out_authentication = *bptr_response_packet;

	*bptr_out_header = snmp_authentication_build (*bptr_out_authentication, usptr_length_of_response_packet,
		&snmp.session_id[0], &snmp.length_of_session_id, ulptr_zero, 0x0000);

	if (*bptr_out_header == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: authentication build failed\r\n");

		return (FAIL);
	 	}

	*bptr_out_request_id = asn_build_header (*bptr_out_header, usptr_length_of_response_packet,
		(enum ASN_TYPES) GET_RESPONSE_MESSAGE, 0x0000);

	if (*bptr_out_request_id == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Build Header for request_id failed \r\n");

		return (FAIL);
	 	}

	*eptr_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_INTEGER);

	/* return identical request id */

	*bptr_response_packet = asn_build_integer (*bptr_out_request_id, usptr_length_of_response_packet,
		(enum ASN_TYPES) *eptr_type, ulptr_request_id, (USHORT) sizeof (ULONG), 0x00); 						/* was 0x01 */

	if (*bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Build request_id failed\r\n");

		return (FAIL);
	 	}

	/* assume that error status will be zero */
	*bptr_response_packet = asn_build_integer (*bptr_response_packet, usptr_length_of_response_packet,
		(enum ASN_TYPES) *eptr_type, ulptr_zero, (USHORT) sizeof (ULONG), 0x00);

	if (*bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Build error_status failed \r\n");

		return (FAIL);
	 	}

	/* assume that error index will be zero */
	*bptr_response_packet = asn_build_integer (*bptr_response_packet, usptr_length_of_response_packet,
		(enum ASN_TYPES) *eptr_type, ulptr_zero, (USHORT) sizeof (ULONG), 0x00);

	if (*bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: Build error_index failed\r\n");

		return (FAIL);
	 	}

	return (PASS);
}
/**********************************************************************************/
USHORT check_access_to_this_snmp_community (USHORT access_control_list, USHORT snmp_community, USHORT read_write)
{
	USHORT return_value;

	/*
	 * Each group has 2 bits, the more significant one is for read access,
	 * the less significant one is for write access.
	 */

	snmp_community <<= 1;	/* multiply by two two shift two bits at a time */

	if (read_write == READ)
		{
		return_value = (USHORT) (access_control_list & (2 << snmp_community)); 		/* return the correct bit */

		return (return_value);
	 	} 
	else 
		{
		return_value = (USHORT) (access_control_list & (1 << snmp_community));

		return (return_value);
	 	}
}
/**********************************************************************************/
USHORT get_snmp_community (char *cptr_session_id)
{
	USHORT community_count;
	USHORT return_value;

	for (community_count = 0x0000; community_count < NUMBER_OF_SNMP_COMMUNITIES; ++community_count)
		{
		if (strcmp (communities[community_count], (char *) cptr_session_id) == STRINGS_MATCH)
			{
		 	break;
			}
	 	}

	if (community_count == NUMBER_OF_SNMP_COMMUNITIES)
		{
		return_value = (USHORT) (NUMBER_OF_SNMP_COMMUNITIES + 1);

		return (return_value);
		}

	return (community_count);
}

