#include	"defs.h"
/*	$Modname: snmpauth.c$  $version: 1.10$		$date: 01/26/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 04/28/94 keyur
1.3 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.4 05/26/94 keyur
1.5 05/28/94 keyur adding enumerations.
1.6 06/01/94 ross
1.7 06/03/94 ross adding protocol and driver traps.
1.8 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.9 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.10 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "snmp.h"
/****************************************************************************/
BYTE *snmp_auth_parse (BYTE *bptr_rxed_packet, USHORT *usptr_length, char *cptr_session_id, USHORT *usptr_length_of_session_id,
	ULONG *ulptr_version)
{
	enum ASN_TYPES authentication_header_type;

	bptr_rxed_packet = asn_parse_header (bptr_rxed_packet, usptr_length, (UNION_SNMP_TYPES *) &authentication_header_type);

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Bad Header received (parsed)\r\n");

		return (NULL);
		}

	if (authentication_header_type != ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR))
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Wrong Authentication header type received (parsed)\n");

		return (NULL);
		}

	bptr_rxed_packet = asn_parse_integer (bptr_rxed_packet, usptr_length,
		(enum ASN_TYPES *) &authentication_header_type, ulptr_version, sizeof (ULONG), 0x00);

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Bad SNMP Version received (parsed)\r\n");

		return (NULL);
		}

	bptr_rxed_packet = asn_parse_string (bptr_rxed_packet, usptr_length, &authentication_header_type,
		&snmp.session_id[0], &snmp.length_of_session_id);

	if (bptr_rxed_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Bad SNMP Community received (parsed)\n");

		return (NULL);
		}

	cptr_session_id[*usptr_length_of_session_id] = 0x00;

	return (bptr_rxed_packet);
}
/****************************************************************************/
BYTE *snmp_authentication_build (BYTE *bptr_response_packet, USHORT *usptr_length, char *cptr_session_id,
	USHORT *usptr_length_of_session_id, ULONG *ulptr_snmp_version, USHORT length_of_message)
{
	enum ASN_TYPES asn_type;

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR);

	bptr_response_packet = asn_build_header (bptr_response_packet, usptr_length, asn_type,
		(USHORT) (length_of_message + *usptr_length_of_session_id + 5));

	if (bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Header Build failed \r\n");

		return (NULL);
		}

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_INTEGER);

	bptr_response_packet = asn_build_integer (bptr_response_packet, usptr_length, asn_type, ulptr_snmp_version, sizeof (ULONG),
		0x00);

	if (bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Integer Build failed\n");

		return (NULL);
		}

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_OCTET_STRING);

	bptr_response_packet = asn_build_string (bptr_response_packet, usptr_length, asn_type, cptr_session_id,
		*usptr_length_of_session_id);

	if (bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: String Build failed \r\n");

		return (NULL);
		}

	return (bptr_response_packet);
}
