#include	"defs.h"
/*	$Modname: snmpinit.c$  $version: 1.11$		$date: 06/27/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.3 05/26/94 keyur
1.4 05/28/94 keyur adding enumerations.
1.5 06/01/94 ross
1.6 06/03/94 ross adding protocol and driver traps.
1.7 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.8 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.9 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
1.10 03/08/95 ross mib table change for source routing.  lsl_control added.
1.11 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define GLOBAL_FILE
#include <stdlib.h>
#include "snmp.h"
#include "vsnmpmib.h"
/**********************************************************************************/
static enum TEST register_snmp (void);
enum TEST snmp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
static enum TEST snmp_delete_all_managers (void);
/**********************************************************************************/
enum TEST initialize_snmp (ULONG clock_ticks_per_second)
{
	snmp.timer_class.clock_ticks_per_second = clock_ticks_per_second;

	snmp.number_of_variables = sizeof (variables) / sizeof (VARIABLE);

	snmp.statistics.number_of_tx_packets = 0x0000L;
	snmp.statistics.number_of_rx_packets = 0x0000L;

	if (snmp.enabled == FALSE)
		{
		return (PASS);
		}

	if (register_snmp () == FAIL)
		{
		return (FAIL);
		}
	else
		{
		snmp.timer_class.timer_enabled = TRUE;

#ifdef __LSL__
		lsl_control (REGISTER_LSL_TRAP_FUNCTION,
			(void (*) (USHORT real_port_number, enum DEVICE_CONTROL_OPERATION control_command)) lsl_trap_function);
#endif

		if (snmp.socket_interface_initialized == FALSE)
			{
			initialize_snmp_socket_interface ();
			}
		snmp.mib.snmpEnableAuthenTraps = 1;
		return (PASS);
		}
}
/**********************************************************************************/
static enum TEST register_snmp (void)
{
#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "SNMP Management", SNMP_MANAGEMENT, snmp_timer, snmp_control,
		&snmp.application_id) == FAIL)
		{
		snmp_printf (SNMP_INIT_PRINTF, "SNMP: register_application () failed to register SNMP with lsl\n");

		return (FAIL);
		}

	return (PASS);
#else
	return (FAIL);
#endif
}
/**********************************************************************************/
enum TEST snmp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	PARAMETER_NOT_USED (parameter_0);
	PARAMETER_NOT_USED (parameter_1);

	switch (command)
		{
		case START_APPLICATION:

			break;

		case TERMINATE_APPLICATION:

			snmp_delete_all_managers ();

			lsl_control ((ULONG) DEREGISTER_APPLICATION, (ULONG) APPLICATION_LAYER_TYPE, snmp.application_id);

			snmp.enabled = FALSE;

			break;

		case READ_DATA_FROM_SOCKET:

			if (snmp_read_data_from_socket () == FAIL)
				{
				snmp_printf (SNMP_RX_PRINTF, "SNMP: read data from socket failed\n");
				}

			break;

		case IS_APPLICATION_ENABLED:

			*((enum BOOLEAN *) parameter_1) = snmp.enabled;

			break;

		default:

			break;
		}

	return (PASS);
}
/**********************************************************************************/
static enum TEST snmp_delete_all_managers (void)
{
	MANAGER_CLASS *sptr_manager;
	MANAGER_CLASS *sptr_manager_next;

	sptr_manager = (MANAGER_CLASS *) get_pointer_to_first_entry_in_list ((LINK *) &snmp.manager_list);

	while (sptr_manager != NULL)
		{
		sptr_manager_next = (MANAGER_CLASS *) get_pointer_to_next_entry_in_list ((LINK *) sptr_manager);

		delete_entry_from_list ((LINK *) &snmp.manager_list, (LINK *) sptr_manager);

		snmp_free_receive_queue (sptr_manager);

		table_free ((void *) sptr_manager);

		sptr_manager = sptr_manager_next;
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_free_receive_queue (MANAGER_CLASS *sptr_manager)
{
	SNMP_BUFFER *sptr_snmp_buffer;
	SNMP_BUFFER *sptr_snmp_buffer_next;

	sptr_snmp_buffer = (SNMP_BUFFER *) get_pointer_to_first_entry_in_list ((LINK *) &sptr_manager->receive_queue);

	while (sptr_snmp_buffer != NULL)
		{
		sptr_snmp_buffer_next = (SNMP_BUFFER *) get_pointer_to_next_entry_in_list ((LINK *) sptr_snmp_buffer);

		delete_entry_from_list ((LINK *) &sptr_manager->receive_queue, (LINK *) sptr_manager);

		free_snmp_buffer ((void *) sptr_snmp_buffer);

		sptr_snmp_buffer = sptr_snmp_buffer_next;
		}

	return (PASS);
}

