#include	"defs.h"
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "snmp.h"
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
/* usptr_number_of_bytes_in_table_indices - usptr_number_of_table_indices */
enum SNMP_STATE process_get_next_request_message (VARIABLE **ptr_to_sptr_mib_variable,
	BYTE *bptr_actual_variable_value, USHORT *usptr_length_of_actual_variable_value,
	USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name, VARIABLE *sptr_mib_variable_last, enum ASN_TYPES *eptr_mib_variable_type)
{
	while (((*ptr_to_sptr_mib_variable)->fptr_find_mib_variable) (GET_NEXT_OPERATION,
		&(*ptr_to_sptr_mib_variable)->mib_name[0], bptr_actual_variable_value, usptr_length_of_actual_variable_value,
		usptr_number_of_table_indices, sptr_table_indices, eptr_end_of_table, ptr_to_cptr_next_variable_name) == FAIL)
		{
		snmp_printf (SNMP_PARSE_PRINTF, "SNMP: end_of_table:%u, cptr_next_variable_name:%p\n", *eptr_end_of_table,
			*ptr_to_cptr_next_variable_name);

		if (*ptr_to_sptr_mib_variable != sptr_mib_variable_last)
			{
			++(*ptr_to_sptr_mib_variable);

			*eptr_mib_variable_type = (*ptr_to_sptr_mib_variable)->type;

			*ptr_to_cptr_next_variable_name = &(*ptr_to_sptr_mib_variable)->mib_name[0];

			*eptr_end_of_table = FALSE;

			*usptr_number_of_table_indices = 0x0000;
			}
		else
			{
			return (SNMP_ERROR_TOO_BIG);
			}
		}

	return (SNMP_OK);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
/* usptr_number_of_bytes_in_table_indices - usptr_number_of_table_indices */
enum SNMP_STATE process_get_request_message (VARIABLE *sptr_mib_variable,
	BYTE *bptr_actual_variable_value, USHORT *usptr_length_of_actual_variable_value,
	USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name)
{
	if ((sptr_mib_variable->fptr_find_mib_variable) (GET_OPERATION,
		&sptr_mib_variable->mib_name[0], bptr_actual_variable_value, usptr_length_of_actual_variable_value,
		usptr_number_of_table_indices, sptr_table_indices, eptr_end_of_table, ptr_to_cptr_next_variable_name) == FAIL)
		{
		return (SNMP_ERROR_TOO_BIG);
		}

	return (SNMP_OK);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
/* usptr_number_of_bytes_in_table_indices - usptr_number_of_table_indices */
enum SNMP_STATE process_set_request_message (VARIABLE *sptr_mib_variable,
	BYTE *bptr_actual_variable_value, USHORT *usptr_length_of_actual_variable_value,
	USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name, enum BOOLEAN do_set, enum ASN_TYPES variable_value_type,
	USHORT length_of_variable_value, enum ASN_TYPES mib_variable_type, BYTE *bptr_to_variable_value)
{
	/* see if the type and value are consistent with this entity's variable */

		switch (mib_variable_type)
			{
			case ASN_INTEGER:
			case GAUGE:
			case COUNTER:
			case TIMETICKS:
			case IP_ADDRESS:
				*usptr_length_of_actual_variable_value = 4;
				break;

			case ASN_OCTET_STRING:
				*usptr_length_of_actual_variable_value = 256;
				break;

			case OPAQUE:
				break;

			case ASN_OBJECT_ID:
				break;

			case ASN_NULL:
				break;

			default:
				break;

			}
	if (is_it_a_good_value (variable_value_type, length_of_variable_value, mib_variable_type,
		*usptr_length_of_actual_variable_value) == FAIL)
		{
		++snmp.mib.snmpInBadValues;
		return (SNMP_ERROR_BAD_VALUE);
		}

	/* Now if necessary, actually do the set */

	if (do_set == TRUE)
		{
		++snmp.mib.snmpInTotalSetVars;

		if (set_the_variable_value (bptr_to_variable_value, variable_value_type, bptr_actual_variable_value,
			*usptr_length_of_actual_variable_value) == FAIL)
			{
			++snmp.mib.snmpInBadValues;

			return (SNMP_ERROR_BAD_VALUE);
			}

		if ((sptr_mib_variable->fptr_find_mib_variable) (SET_OPERATION,
			&sptr_mib_variable->mib_name[0], bptr_actual_variable_value, usptr_length_of_actual_variable_value,
			usptr_number_of_table_indices, sptr_table_indices, eptr_end_of_table, ptr_to_cptr_next_variable_name) == FAIL)
			{
			++snmp.mib.snmpInBadValues;

			return (SNMP_ERROR_BAD_VALUE);
			}
		}

	return (SNMP_OK);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the function 'rebuild_object_id_and_table_indices' because of changing the type of */
/* object-id from BYTE to ULONG. Changed 'BYTE *bptr_table_indices' to 'OBJECT_ID *sptr_table_indices'. */
/* Changed the type and names of the following parameters */
/* bptr_to_table_indices_in_variable_binding_name - sptr_to_table_indices_in_variable_binding_name */
/* number_of_bytes_in_received_table_indices - number_of_received_table_indices */
/* usptr_number_of_bytes_in_table_indices - usptr_number_of_table_indices */

void rebuild_object_id_and_table_indices (VARIABLE *sptr_mib_variable, VARIABLE **ptr_to_sptr_mib_variable_next,
	OBJECT_ID *sptr_to_table_indices_in_variable_binding_name, USHORT number_of_received_table_indices,
	enum ASN_TYPES *eptr_mib_variable_type, USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices,
	char *cptr_next_variable_name, OBJECT_ID *sptr_object_id_name, USHORT *usptr_length_of_object_id_name)
{
	if (cptr_next_variable_name != NULL)
		{
		snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Rebuilding object id :");
		print_variable_and_indices (cptr_next_variable_name, *usptr_number_of_table_indices, sptr_table_indices);
		*ptr_to_sptr_mib_variable_next = get_mib_variable_using_name (cptr_next_variable_name);

		*eptr_mib_variable_type = (*ptr_to_sptr_mib_variable_next)->type;

		rebuild_object_id_in_variable_binding_name (sptr_object_id_name, usptr_length_of_object_id_name,
			*ptr_to_sptr_mib_variable_next, &sptr_to_table_indices_in_variable_binding_name,
			number_of_received_table_indices);
		}
	else
		{
		print_variable_and_indices (&sptr_mib_variable->mib_name[0], *usptr_number_of_table_indices, sptr_table_indices);
		}

	if (*usptr_number_of_table_indices > 0x0000)
		{
		snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Rebuilding table indices : %d ->", *usptr_number_of_table_indices);
		rebuild_table_indices_in_variable_binding_name (usptr_length_of_object_id_name, number_of_received_table_indices,
			sptr_to_table_indices_in_variable_binding_name, *usptr_number_of_table_indices, sptr_table_indices);
		snmp_printf (SNMP_PARSE_PRINTF, " %d\n", *usptr_number_of_table_indices);
		}
	else
		{
		snmp_printf (SNMP_PARSE_PRINTF, "SNMP: No table indices\n", *usptr_number_of_table_indices);
		}
}
/**********************************************************************************/
BYTE *parse_a_variable_binding (BYTE *bptr_variable_bindings, USHORT *usptr_length_of_variable_bindings,
	OBJECT_ID *sptr_object_id_name, USHORT *usptr_length_of_object_id_name, enum ASN_TYPES *eptr_variable_value_type,
	USHORT *usptr_length_of_variable_value, BYTE **bptr_to_variable_value_type)
{
	USHORT variable_binding_length;
	enum ASN_TYPES	variable_binding_type;
	BYTE	*bptr_variable_bindings_start;
	USHORT variable_value_length;
																					 
 	variable_binding_length = *usptr_length_of_variable_bindings;

	bptr_variable_bindings_start = bptr_variable_bindings;

	/* this next statement parses the variable binding header */

	bptr_variable_bindings = asn_parse_header (bptr_variable_bindings, &variable_binding_length,
		(UNION_SNMP_TYPES *) &variable_binding_type);

	snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Length of variable binding is %d\n", variable_binding_length);

	if (bptr_variable_bindings == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: NULL error in parsing header \r\n");

		return (NULL);
		}

	if (variable_binding_type != (BYTE) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR))
		{
		return (NULL);
		}

	/* this next statement parses the variable name (or object id) */

	bptr_variable_bindings = asn_parse_object_id (bptr_variable_bindings, &variable_binding_length,
		(enum ASN_TYPES *) &variable_binding_type, sptr_object_id_name, usptr_length_of_object_id_name);

	snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Length of object id is %d\n", *usptr_length_of_object_id_name);

	if (bptr_variable_bindings == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: NULL error in parsing object id \r\n");

		return (NULL);
		}

	if (variable_binding_type != (BYTE) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_OBJECT_ID))
		{
		return (NULL);
		}

	*bptr_to_variable_value_type = bptr_variable_bindings;	/* save pointer to the type of object */

	/* this statement parses for the type of object */

	variable_value_length = variable_binding_length;

	bptr_variable_bindings = asn_parse_header (bptr_variable_bindings, &variable_value_length,
		(UNION_SNMP_TYPES *) eptr_variable_value_type);

	snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Length of variable value is %d\n", variable_value_length);

	if (bptr_variable_bindings == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: NULL error in parsing header \r\n");

		return (NULL);
		}

	*usptr_length_of_variable_value = variable_value_length;

	bptr_variable_bindings = (BYTE *) ((ULONG) bptr_variable_bindings + variable_value_length);

	*usptr_length_of_variable_bindings = (USHORT) (*usptr_length_of_variable_bindings -
		(USHORT) (bptr_variable_bindings - bptr_variable_bindings_start));

	return (bptr_variable_bindings);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. The function print_variable_and_indices modified to change the table indices from byte */
/* to ulong because of the change in the type of object-id. The second parameter 'number_of_bytes_in_table_indices' */
/* changed to 'number_of_table_indices', and 'bptr_table_indices' changed to 'sptr_table_indices'. */

void print_variable_and_indices (char *cptr_variable_name, USHORT number_of_table_indices,
	OBJECT_ID *sptr_table_indices)
{
	USHORT table_index;

	snmp_printf (SNMP_PARSE_PRINTF, " %s, ", cptr_variable_name);

	if (number_of_table_indices > 0x0000)
		{
		table_index = 0x0000;

		snmp_printf (SNMP_PARSE_PRINTF, "Indices (%d) are: ", number_of_table_indices);

		while (table_index < number_of_table_indices)
			{
			/* Srikar, Mar 19, 1997. Changed format string from "%u." to "%lu." for OBJECT_ID */
			snmp_printf (SNMP_PARSE_PRINTF, "%lu.", *sptr_table_indices);

			++table_index;

			++sptr_table_indices;
			}

		snmp_printf (SNMP_PARSE_PRINTF, "\n");
		}
	else
		{
		snmp_printf (SNMP_PARSE_PRINTF, "No Indices\n");
		}
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the type and name of the following parameters and variables */
/* bptr_to_table_indices_in_variable_binding_name - bptr_to_table_indices_in_variable_binding_name(BYTE ** - OBJECT_ID **) */
/* number_of_bytes_in_received_table_indices - number_of_received_table_indices */
/* number_of_bytes_common - number_of_common_indices */
/* number_of_bytes_new - number_of_new_indices */
/* maximum_number_of_common_bytes - maximum_number_of_common_indices */
/* maximum_number_of_new_bytes - maximum_number_of_new_indices */

enum TEST rebuild_object_id_in_variable_binding_name (OBJECT_ID *sptr_object_id_name,
	USHORT *usptr_length_of_object_id_name, VARIABLE *sptr_mib_variable_next,
	OBJECT_ID **sptr_to_table_indices_in_variable_binding_name, USHORT number_of_received_table_indices)
{
	USHORT number_of_common_indices;
	USHORT number_of_new_indices;
	USHORT maximum_number_of_common_indices;
	USHORT maximum_number_of_new_indices;
	USHORT new_length_of_object_id_name;
	USHORT difference_in_length_of_object_id;
	OBJECT_ID *sptr_object_id_1;
	OBJECT_ID *sptr_object_id_2;

	sptr_object_id_1 = sptr_object_id_name;

	sptr_object_id_2 = sptr_mib_variable_next->object_id;

	number_of_common_indices = 0x0000;

	maximum_number_of_common_indices = (USHORT) (*usptr_length_of_object_id_name - number_of_received_table_indices - 1);

	while ((*sptr_object_id_1 == *sptr_object_id_2) && (number_of_common_indices < (maximum_number_of_common_indices + 1)))
		{
		++sptr_object_id_2;

		++sptr_object_id_1;

		++number_of_common_indices;
		}

	if (number_of_common_indices == (maximum_number_of_common_indices + 1))
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: number_of_bytes_common exceeded maximum value\n");

		return (FAIL);
		}

	number_of_new_indices = 0x0000;

	maximum_number_of_new_indices = (USHORT) (MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID - number_of_common_indices -
		number_of_received_table_indices);

	/* Srikar, Mar 19, 1997. Changed the constants 0x00, 0xff to 0x00000000, 0xffffffff */
	while ((*sptr_object_id_2 != 0x00000000) && (*sptr_object_id_2 != 0xffffffff) && (number_of_new_indices < maximum_number_of_new_indices))
		{
		*sptr_object_id_1 = *sptr_object_id_2;

		++sptr_object_id_2;

		++sptr_object_id_1;

		++number_of_new_indices;
		}

	if (number_of_new_indices == maximum_number_of_new_indices)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: number_of_bytes_new exceeded maximum value\n");

		return (FAIL);
		}

	new_length_of_object_id_name = (USHORT) (number_of_common_indices + number_of_new_indices +
		number_of_received_table_indices);

	if (*usptr_length_of_object_id_name > new_length_of_object_id_name)
		{
		difference_in_length_of_object_id = (USHORT) (*usptr_length_of_object_id_name - new_length_of_object_id_name);

		/* Srikar, Mar 19, 1997. Removed some type casting which was not required after */
		/* changing object id type from BYTE to ULONG */
		*sptr_to_table_indices_in_variable_binding_name =
			*sptr_to_table_indices_in_variable_binding_name - difference_in_length_of_object_id;
		}
	else if (*usptr_length_of_object_id_name < new_length_of_object_id_name)
		{
		difference_in_length_of_object_id = (USHORT) (new_length_of_object_id_name - *usptr_length_of_object_id_name);

		/* Srikar, Mar 19, 1997. Removed some type casting which was not required after */
		/* changing object id type from BYTE to ULONG */
		*sptr_to_table_indices_in_variable_binding_name =
			*sptr_to_table_indices_in_variable_binding_name + difference_in_length_of_object_id;
		}

	*usptr_length_of_object_id_name = new_length_of_object_id_name;

	return (PASS);
}

/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the type and name of the following parameters */
/* number_of_bytes_in_received_table_indices - number_of_received_table_indices */
/* number_of_bytes_in_table_indices - number_of_table_indices */
/* bptr_to_table_indices_in_variable_binding_name - sptr_to_table_indices_in_variable_binding_name */
/* (BYTE * - OBJECT_ID *) */
/* bptr_table_indices - sptr_table_indices (BYTE * - OBJECT_ID *) */
enum TEST rebuild_table_indices_in_variable_binding_name (USHORT *usptr_length_of_object_id_name,
	USHORT number_of_received_table_indices, OBJECT_ID *sptr_to_table_indices_in_variable_binding_name,
	USHORT number_of_table_indices, OBJECT_ID *sptr_table_indices)
{
	USHORT index;

	index = 0x0000;

	while (index < number_of_table_indices)
		{
		*sptr_to_table_indices_in_variable_binding_name = *sptr_table_indices;

		++sptr_to_table_indices_in_variable_binding_name;

		++sptr_table_indices;

		++index;
		}

	*usptr_length_of_object_id_name = (USHORT) (*usptr_length_of_object_id_name - number_of_received_table_indices +
		number_of_table_indices);

	if (*usptr_length_of_object_id_name >= MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: *usptr_length_of_object_id_name exceeded maximum value\n");

		return (FAIL);
		}

	return (PASS);
}

