#include	"defs.h"
/*	$Modname: snmprx.c$	$version: 1.9$		 $date: 01/26/95$	*/
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.3 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.4 05/26/94 keyur
1.5 05/28/94 keyur adding enumerations.
1.6 06/03/94 ross adding protocol and driver traps.
1.7 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.8 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.9 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "snmp.h"
/**********************************************************************************/
void snmp_receive (SOCKADDR_IN *sptr_remote_sockaddr_in, void *vptr_rxed_buffer, USHORT number_of_bytes_rxed)
{
	SNMP_BUFFER *sptr_snmp_buffer;
	MANAGER_CLASS *sptr_manager;

	sptr_manager = find_snmp_manager (sptr_remote_sockaddr_in->sin_addr.s_addr);

	++snmp.mib.snmpInPkts;

	if (sptr_manager == NULL)
		{
		sptr_manager = add_snmp_manager (sptr_remote_sockaddr_in->sin_addr.s_addr);

		if (sptr_manager == NULL)
			{
			++snmp.statistics.number_of_packets_rejected_because_of_no_manager;

			return;
			}
		}

	sptr_snmp_buffer = (SNMP_BUFFER *) table_malloc (1, sizeof (SNMP_BUFFER));

	if (sptr_snmp_buffer == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: snmp_receive (): table_malloc failed\n");

		return;
		}

	sptr_snmp_buffer->vptr_start_of_data = duplicate_snmp_data_buffer (vptr_rxed_buffer, number_of_bytes_rxed);

	sptr_snmp_buffer->size = number_of_bytes_rxed;
	sptr_snmp_buffer->count = number_of_bytes_rxed;
	sptr_snmp_buffer->vptr_buffer = sptr_snmp_buffer->vptr_start_of_data;

	memcpy ((void *) &sptr_snmp_buffer->remote_sockaddr_in, (void *) sptr_remote_sockaddr_in, sizeof (SOCKADDR_IN));

	add_entry_to_list ((LINK *) &sptr_manager->receive_queue, (LINK *) sptr_snmp_buffer);
}


