#include	"defs.h"
/************************************************************************/
/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include "snmp.h"
/****************************************************************************/
/* Sachin 17/01/1996 */
extern ULONG get_ip_address (USHORT) ;

enum TEST initialize_snmp_socket_interface (void)
{
	int bind_return_value;
	SOCKADDR_IN local_read_sockaddr_in;

	if (snmp.socket_interface_initialized == FALSE)
		{
		local_read_sockaddr_in.sin_family = AF_INET;
		local_read_sockaddr_in.sin_port = SNMP_PORT;
		/* local_read_sockaddr_in.sin_addr.s_addr = INTERNET_ADDRESS_ANY; */
/* Sachin 17/01/1997 */
		local_read_sockaddr_in.sin_addr.s_addr = get_ip_address (0) ;

		snmp.socket_descriptor = socket (AF_INET, SOCK_DGRAM, 0x00000000L);

		if (snmp.socket_descriptor == FAILED)
			{
			snmp_printf (SNMP_INIT_PRINTF, "SNMP: failed to create socket\n");

			return (FAIL);
			}

		associate_application_with_socket (snmp.socket_descriptor, snmp.application_id);

		bind_return_value = bind (snmp.socket_descriptor, (SOCKADDR *) &local_read_sockaddr_in, sizeof (SOCKADDR_IN));

		if (bind_return_value == FAILED)
			{
			snmp_printf (SNMP_INIT_PRINTF, "SNMP: failed to bind\n");

			return (FAIL);
			}

		snmp.socket_interface_initialized = TRUE;
		}
	else
		{
		snmp_printf (SNMP_INIT_PRINTF, "SNMP: failed to initialize snmp socket interface\n");

		return (FAIL);
		}


	return (PASS);
}
/****************************************************************************/
enum TEST snmp_read_data_from_socket (void)
{
	void *vptr_buffer;
	int number_of_bytes_received;
	SOCKADDR_IN remote_sockaddr_in;
	ULONG sockaddr_length;
	BYTE print_buffer_arg1[25];

	vptr_buffer = table_malloc (1, snmp.maximum_transmission_unit);

	if (vptr_buffer == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: snmp_read_data_from_socket (): table_malloc failed\n");

		return (FAIL);
		}

	sockaddr_length = sizeof (SOCKADDR_IN);

	number_of_bytes_received = recvfrom (snmp.socket_descriptor, (char *) vptr_buffer, snmp.maximum_transmission_unit,
		(int) NULL, (SOCKADDR *) &remote_sockaddr_in, (int *) &sockaddr_length);

	if (number_of_bytes_received <= 0x0000)
		{
		table_free ((void *) vptr_buffer);

		return (FAIL);
		}

	snmp_printf (SNMP_RX_PRINTF, "SNMP: received message: length %d: from %s : %u\n", number_of_bytes_received,
		convert_ip_address_to_dot_format ((char *) print_buffer_arg1, remote_sockaddr_in.sin_addr.s_addr),
		remote_sockaddr_in.sin_port);

	snmp_receive (&remote_sockaddr_in, vptr_buffer, (USHORT) number_of_bytes_received);

	table_free ((void *) vptr_buffer);

	return (PASS);
}
/****************************************************************************/
enum TEST set_snmp_local_internet_address (char *cptr_internet_address_string)
{
	USHORT internet_address_array[10];

	sscanf (cptr_internet_address_string,"%03hu.%03hu.%03hu.%03hu",
		(int *) &internet_address_array[0], (int *) &internet_address_array[1], (int *) &internet_address_array[2],
		(int *) &internet_address_array[3]);

	snmp.local_internet_address = convert_4_bytes_to_ulong ((BYTE) internet_address_array[0],(BYTE) internet_address_array[1],
		(BYTE) internet_address_array[2],(BYTE) internet_address_array[3]);

#ifdef RTRERROR
	snmp.local_internet_address = net_to_host_long ( *((ULONG *) &internet_address_array[0]));

#endif
	return (PASS);
}

