#include	"defs.h"
/*	$Modname: snmptimr.c$  $version: 1.10$		$date: 01/26/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 04/28/94 keyur
1.3 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.4 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.5 05/26/94 keyur
1.6 05/28/94 keyur adding enumerations.
1.7 06/01/94 ross
1.8 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.9 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.10 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include "snmp.h"
/**********************************************************************************/
static void process_snmp_packets (MANAGER_CLASS *sptr_manager);
/****************************************************************************/
void snmp_timer (void)
{
	MANAGER_CLASS *sptr_manager;
	SNMP_BUFFER *sptr_snmp_buffer;

	if (snmp.timer_class.timer_enabled == FALSE)
		{
		return;
		}

	++snmp.timer_class.tick_counter;

	if (snmp.timer_class.tick_counter >= snmp.timer_class.clock_ticks_per_second)
		{
		snmp.timer_class.tick_counter = 0x00000000L;

		sptr_manager = (MANAGER_CLASS *) get_pointer_to_first_entry_in_list ((LINK *) &snmp.manager_list);

		while (sptr_manager != NULL)
			{
			sptr_snmp_buffer = (SNMP_BUFFER *) get_pointer_to_first_entry_in_list ((LINK *) &sptr_manager->receive_queue);

			if (sptr_snmp_buffer != NULL)
				{
				process_snmp_packets (sptr_manager);
				}

			sptr_manager = (MANAGER_CLASS *) get_pointer_to_next_entry_in_list ((LINK *) sptr_manager);
			}
		}
}
/**********************************************************************************/
static void process_snmp_packets (MANAGER_CLASS *sptr_manager)
{
	USHORT number_of_bytes_to_send;
	void *vptr_snmp_response_packet;
	SNMP_BUFFER *sptr_snmp_buffer;

	sptr_snmp_buffer = (SNMP_BUFFER *) get_entry_from_list ((LINK *) &sptr_manager->receive_queue);

	if (sptr_snmp_buffer == NULL)
		{
		return;
		}

	vptr_snmp_response_packet = table_malloc (1, snmp.maximum_transmission_unit);

	if (vptr_snmp_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: process_snmp_packets (): table_malloc failed\n");

		return;
		}

	number_of_bytes_to_send = snmp.maximum_transmission_unit;

	if (snmp_agent_parse ((BYTE *) sptr_snmp_buffer->vptr_start_of_data, sptr_snmp_buffer->count,
		(BYTE *) vptr_snmp_response_packet, &number_of_bytes_to_send, sptr_manager) == PASS)
		{
		snmp_printf (SNMP_DATA_PRINTF, "sent %d bytes to internet address: %08lx\n", number_of_bytes_to_send,
			sptr_snmp_buffer->remote_sockaddr_in.sin_addr);
		}

	send_snmp_packet (&sptr_snmp_buffer->remote_sockaddr_in, vptr_snmp_response_packet, number_of_bytes_to_send);

	table_free (vptr_snmp_response_packet);

	free_snmp_buffer (sptr_snmp_buffer);
}
/**********************************************************************************/
enum TEST free_snmp_buffer (SNMP_BUFFER *sptr_snmp_buffer)
{
	table_free ((void *) sptr_snmp_buffer->vptr_buffer);

	table_free ((void *) sptr_snmp_buffer);

	return (PASS);
}
