/*	$Modname: vsnmpstr.h$  $version: 1.13$		$date: 06/27/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 04/28/94 keyur
1.3 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.4 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.5 05/26/94 keyur
1.6 05/28/94 keyur adding enumerations
1.7 06/01/94 ross
1.8 06/02/94 ross more general clean-up.
1.9 06/03/94 ross adding protocol and driver traps.
1.10 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.11 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.12 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
1.13 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _VSNMPSTR_H_
#define _VSNMPSTR_H_

/* Srikar, Mar 20, 1997. Commented the following line moved the type def to file kstart.h */
/*
typedef BYTE	OBJECT_ID;
*/

typedef	union	UNION_SNMP_TYPES
{
	BYTE_ENUM (ASN_TYPES)			data;
	BYTE_ENUM (SNMP_PDU_TYPE) 		pdu;
} UNION_SNMP_TYPES;


typedef	struct	VARIABLE_BINDING
{
	BYTE_ENUM (ASN_TYPES)			type;
	BYTE									length;
	BYTE									data[VARIABLE_NUMBER_OF_BYTES];
} VARIABLE_BINDING;


typedef	struct	GET_REQUEST_PDU
{
	BYTE_ENUM (SNMP_PDU_TYPE) 		type;
	BYTE									type_1;
	BYTE									type_2;
	ULONG									request_id;
	VARIABLE_BINDING					error_status;
	VARIABLE_BINDING					error_index;
	VARIABLE_BINDING					variable_bindings[1];
} GET_REQUEST_PDU;


typedef	union	UNION_SNMP_PDU
{
	GET_REQUEST_PDU					get_request;
} UNION_SNMP_PDU;


typedef	struct	SNMP_DATA
{
	BYTE 									version;
	BYTE 									community;
	UNION_SNMP_PDU 					snmp_pdu;
} SNMP_DATA;


typedef	struct	SNMP_BUFFER_LINK
{
	struct SNMP_BUFFER_LINK 		*sptr_forward_link;
	struct SNMP_BUFFER_LINK 		*sptr_backward_link;
} SNMP_BUFFER_LINK;


typedef	struct	SNMP_BUFFER
{
	SNMP_BUFFER_LINK					links;
	USHORT 								size;											/* Size of associated data buffer */
	void 									*vptr_buffer;								/* pointer to allocated buffer */
	void 									*vptr_start_of_data;						/* Active working pointers */
	USHORT 								count;
	SOCKADDR_IN							remote_sockaddr_in;
} SNMP_BUFFER;


typedef	struct	VARIABLE 
{
	OBJECT_ID							object_id[MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID];
	BYTE									object_id_length;
	BYTE_ENUM (ASN_TYPES)			type;
	char									*mib_name;
	USHORT								access_control_list;
	enum BOOLEAN 						is_table_entry;

	/* Srikar, Mar 19, 1997. Changed the function prototype due to change in object id type. */
	/* changed the parameter name from usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
	/* changed the type of parameter bptr_table_indices from BYTE * to OBJECT_ID * and its name to sptr_table_indices */
	enum TEST (*fptr_find_mib_variable) (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
		BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
		OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **cptr_next_variable_name);
} VARIABLE;


typedef	struct	SNMP_MIB
{
	ULONG									snmpInPkts;
	ULONG									snmpOutPkts;
	ULONG									snmpInBadVersions;
	ULONG									snmpInBadCommunities;
	ULONG									snmpInBadCommunityUses;
	ULONG									snmpInBadCommunityNames;
	ULONG									snmpInAsnParseErrs;
	ULONG									snmpInTooBigs;
	ULONG									snmpInNoSuchNames;
	ULONG									snmpInBadValues;
	ULONG									snmpInReadOnlys;
	ULONG									snmpInGenErrs;
	ULONG									snmpInTotalReqVars;
	ULONG									snmpInTotalSetVars;
	ULONG									snmpInGetRequests;
	ULONG									snmpInGetNexts;
	ULONG									snmpInSetRequests;
	ULONG									snmpInGetResponses;
	ULONG									snmpInTraps;
	ULONG									snmpOutTooBigs;
	ULONG									snmpOutNoSuchNames;
	ULONG									snmpOutBadValues;
	ULONG									snmpOutGenErrs;
	ULONG									snmpOutGetRequests;
	ULONG									snmpOutGetNexts;
	ULONG									snmpOutSetRequests;
	ULONG									snmpOutGetResponses;
	ULONG									snmpOutTraps;
	ULONG									snmpEnableAuthenTraps; 		/* enabled (1), disabled (2) */
} SNMP_MIB;


typedef	struct	SNMP_STATISTICS
{
	ULONG									number_of_tx_packets;
	ULONG									number_of_rx_packets;
	ULONG									number_of_packets_rejected_because_of_no_manager;
}SNMP_STATISTICS;


typedef	struct	MANAGER_CLASS_LINK
{
	struct MANAGER_CLASS 			*sptr_forward_link;
	struct MANAGER_CLASS 			*sptr_backward_link;
} MANAGER_CLASS_LINK;


typedef	struct	MANAGER_CLASS
{
	MANAGER_CLASS_LINK 				links;
	ULONG									internet_address;
	USHORT								get_next_current_index;
	ULONG									number_of_packets_rxed;
	ULONG									number_of_packets_txed;
	BYTE_ENUM (BOOLEAN) 				past_end_of_table;
	SOCKADDR_IN							remote_sockaddr_in;
	SNMP_BUFFER_LINK					receive_queue;
} MANAGER_CLASS;


typedef	struct	SNMP_PRINT_CLASS
{
	BYTE_ENUM (BOOLEAN)  			printing_enabled;
	BYTE_ENUM (BOOLEAN)				init_printing_enabled;
	BYTE_ENUM (BOOLEAN)				socket_printing_enabled;
	BYTE_ENUM (BOOLEAN)				parse_printing_enabled;
	BYTE_ENUM (BOOLEAN)				receive_printing_enabled;
	BYTE_ENUM (BOOLEAN)				transmit_printing_enabled;
	BYTE_ENUM (BOOLEAN)				mib_printing_enabled;
	BYTE_ENUM (BOOLEAN)				data_printing_enabled;
	BYTE_ENUM (BOOLEAN)				memory_printing_enabled;
	BYTE_ENUM (BOOLEAN)				alarm_printing_enabled;
} SNMP_PRINT_CLASS;


typedef	struct	SNMP_TIMER_CLASS
{
	BYTE_ENUM (BOOLEAN)				timer_enabled;
	ULONG									clock_ticks_per_second;
	ULONG									tick_counter;
} SNMP_TIMER_CLASS;


typedef	struct	SNMP_CLASS
{
	BYTE_ENUM (BOOLEAN)				enabled;
	ULONG 								application_id;
	BYTE_ENUM (BOOLEAN)				socket_interface_enabled;
	BYTE_ENUM (BOOLEAN) 				socket_interface_initialized;
	int 									socket_descriptor;
	BYTE		 							id_sequence_number;
	ULONG									local_internet_address;
	USHORT 								maximum_transmission_unit;
	SNMP_MIB								mib;
	SNMP_STATISTICS					statistics;
	USHORT								length_of_session_id;
	char									session_id[SESSION_ID_MAXIMUM_LENGTH + 1];
	USHORT								number_of_variables;
	BYTE									actual_variable_name[256];
	SNMP_TIMER_CLASS 					timer_class;
	MANAGER_CLASS_LINK				manager_list;
	SNMP_PRINT_CLASS 					print_class;
} SNMP_CLASS;


/* snmpagnt.c */

enum TEST snmp_agent_parse (BYTE *bptr_rxed_packet, USHORT length_of_rxed_packet,
	BYTE *bptr_response_packet, USHORT *usptr_length_of_response_packet, MANAGER_CLASS *sptr_manager);
USHORT check_access_to_this_snmp_community (USHORT access_control_list, USHORT snmp_community, USHORT read_write);
USHORT get_snmp_community (char *cptr_session_id);


/* snmpinit.c */

enum TEST initialize_snmp (ULONG clock_ticks_per_second);
enum TEST snmp_free_receive_queue (MANAGER_CLASS *sptr_manager);


/* snmptimr.c */

void snmp_timer (void);
enum TEST free_snmp_buffer (SNMP_BUFFER *sptr_snmp_buffer);


/* snmpsock.c */

enum TEST initialize_snmp_socket_interface (void);
enum TEST snmp_read_data_from_socket (void);
enum TEST set_snmp_local_internet_address (char *cptr_internet_address_string);


/* snmptx.c */

enum TEST send_snmp_packet (SOCKADDR_IN *sptr_remote_sockaddr_in, void *vptr_buffer, USHORT number_of_bytes);


/* snmprx.c */

void snmp_receive (SOCKADDR_IN *sptr_remote_sockaddr_in, void *vptr_rxed_buffer, USHORT number_of_bytes_rxed);


/* snmputil.c */

SNMP_BUFFER *snmp_get_a_send_packet (USHORT size_of_packet);
void snmp_free_a_send_packet (void *sptr_tx_packet);
void *duplicate_snmp_data_buffer (void *vptr_rxed_buffer, USHORT number_of_bytes);
void snmp_send_completion (void *sptr_tx_packet);
int compare (OBJECT_ID *sptr_name1, USHORT length1, OBJECT_ID *sptr_name2, USHORT length2);
void shift_array (BYTE *bptr_begin, USHORT length_of_array, short shift_amount);
enum TEST create_identical_packet (BYTE *bptr_original_packet, BYTE *bptr_output_packet,
	USHORT length_of_packet, ULONG error_status, ULONG error_index, BYTE **bptr_end_of_packet);
enum TEST null_error_check (void *vptr);
void snmp_printf (enum SNMP_PRINTF_GROUPS printf_group, const char *bptr_format, ...);

#ifdef __SNMP_STANDALONE__
	USHORT host_to_net_short (USHORT host_order_short_value);
	USHORT net_to_host_short (USHORT net_order_short_value);
	ULONG host_to_net_long (ULONG host_order_long_value);
	ULONG net_to_host_long (ULONG net_order_long_value);
#endif /* __SNMP_STANDALONE__ */


/* snmpauth.c */

BYTE *snmp_auth_parse (BYTE *bptr_rxed_packet, USHORT *usptr_length, char *cptr_session_id,
	USHORT *usptr_length_of_session_id, ULONG *ulptr_version);
BYTE *snmp_authentication_build (BYTE *bptr_response_packet, USHORT *usptr_length, char *cptr_session_id,
	USHORT *usptr_length_of_session_id, ULONG *ulptr_snmp_version, USHORT length_of_message);


/* snmpasnp.c */

BYTE *asn_parse_integer (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *eptr_asn_type,
	ULONG *ulptr_integer, USHORT size_of_integer, BYTE flag);
BYTE *asn_parse_string (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *eptr_asn_type,
	char *cptr_string_to_be_parsed, USHORT *usptr_length_of_string);
BYTE *asn_parse_header (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data,
	UNION_SNMP_TYPES *eptr_type);
BYTE *asn_parse_length (BYTE *bptr_rxed_packet, ULONG *ulptr_length);
BYTE *asn_parse_object_id (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *bptr_asn_type,
	OBJECT_ID *sptr_variable_object_id, USHORT *usptr_length_of_object_id);
BYTE *asn_parse_null (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *eptr_asn_type);


/* snmppvar.c */

enum SNMP_STATE parse_variable_bindings_list (BYTE *bptr_rxed_packet, USHORT length_of_rxed_packet, BYTE *bptr_response_packet,
	USHORT length_of_response_packet, enum SNMP_PDU_TYPE request_type, ULONG *ulptr_error_index, enum BOOLEAN do_set,
	MANAGER_CLASS *sptr_manager, BYTE **bptr_end_of_packet);


/* snmpprcs.c */

BYTE *parse_a_variable_binding (BYTE *bptr_variable_bindings, USHORT *usptr_length_of_variable_bindings,
	OBJECT_ID *sptr_object_id_name, USHORT *usptr_length_of_object_id_name, enum ASN_TYPES *eptr_variable_value_type,
	USHORT *usptr_length_of_variable_value, BYTE **bptr_to_variable_value_type);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
enum SNMP_STATE process_get_next_request_message (VARIABLE **ptr_to_sptr_mib_variable,
	BYTE *bptr_actual_variable_value, USHORT *usptr_length_of_actual_variable_value,
	USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name, VARIABLE *sptr_mib_variable_last, enum ASN_TYPES *eptr_mib_variable_type);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
enum SNMP_STATE process_get_request_message (VARIABLE *sptr_mib_variable,
	BYTE *bptr_actual_variable_value, USHORT *usptr_length_of_actual_variable_value,
	USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
enum SNMP_STATE process_set_request_message (VARIABLE *sptr_mib_variable,
	BYTE *bptr_actual_variable_value, USHORT *usptr_length_of_actual_variable_value,
	USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name, enum BOOLEAN do_set, enum ASN_TYPES variable_value_type,
	USHORT length_of_variable_value, enum ASN_TYPES mib_variable_type, BYTE *bptr_to_variable_value);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
void rebuild_object_id_and_table_indices (VARIABLE *sptr_mib_variable, VARIABLE **ptr_to_sptr_mib_variable_next,
	OBJECT_ID *sptr_to_table_indices_in_variable_binding_name, USHORT number_of_received_table_indices,
	enum ASN_TYPES *eptr_mib_variable_type, USHORT *usptr_number_of_table_indices, OBJECT_ID *sptr_table_indices,
	char *cptr_next_variable_name, OBJECT_ID *sptr_object_id_name, USHORT *usptr_length_of_object_id_name);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
void print_variable_and_indices (char *cptr_variable_name, USHORT number_of_table_indices,
	OBJECT_ID *sptr_table_indices);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
enum TEST rebuild_object_id_in_variable_binding_name (OBJECT_ID *sptr_object_id_name,
	USHORT *usptr_length_of_object_id_name, VARIABLE *sptr_mib_variable_next,
	OBJECT_ID **sptr_to_table_indices_in_variable_binding_name, USHORT number_of_received_table_indices);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
enum TEST rebuild_table_indices_in_variable_binding_name (USHORT *usptr_length_of_object_id_name,
	USHORT number_of_received_table_indices, OBJECT_ID *sptr_to_table_indices_in_variable_binding_name,
	USHORT number_of_table_indices, OBJECT_ID *sptr_table_indices);


/* snmpasnb.c */

BYTE *asn_build_integer (BYTE *bptr_response_packet, USHORT *usptr_length_of_data,
	enum ASN_TYPES asn_type, ULONG *ulptr_integer, USHORT size_of_integer, BYTE flag);
BYTE *asn_build_string (BYTE *bptr_response_packet, USHORT *usptr_length_of_data,
	enum ASN_TYPES asn_type, char *cptr_string_to_be_built, USHORT length_of_string);
BYTE *asn_build_header (BYTE *bptr_response_packet, USHORT *usptr_length_of_data,
	enum ASN_TYPES asn_type, USHORT length);
BYTE *asn_build_length (BYTE *bptr_response_packet, USHORT *usptr_length_of_data, USHORT length);
BYTE *asn_build_object_id (BYTE *bptr_tx_packet, USHORT *usptr_length_of_data,
	enum ASN_TYPES asn_type, OBJECT_ID *sptr_object_id, USHORT length_of_object_id);
BYTE *asn_build_null (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES asn_type);
BYTE *build_a_variable_binding (BYTE *bptr_response_packet, USHORT *usptr_length_of_packet, OBJECT_ID *sptr_object_id,
	USHORT length_of_object_id, enum ASN_TYPES type, USHORT length_of_variable_value, BYTE *bptr_variable_value);


/* snmptrap.c */

void lsl_trap_function (enum DEVICE_CONTROL_OPERATION control_command);
USHORT snmp_build_trap (BYTE *bptr_tx_packet, USHORT *usptr_length, ULONG tx_address, ULONG trap_type, USHORT specific_type,
	ULONG time, char *cptr_mib_variable_name);


/* snmpmib.c */

/* Srikar, Mar 19, 1997. Changed the function prototype due to change in object id type */
VARIABLE	*get_mib_variable_and_table_indices (OBJECT_ID *sptr_object_id, USHORT *usptr_object_id_length,
	enum ASN_TYPES *eptr_type, USHORT *access_control_list, enum BOOLEAN exact, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, OBJECT_ID **sptr_to_table_indices_in_variable_binding_name);

enum TEST is_it_a_good_value (BYTE in_type, USHORT in_length, BYTE actual_type, USHORT actual_length);
enum TEST set_the_variable_value (BYTE *bptr_new_variable_value, enum ASN_TYPES variable_value_type,
	BYTE *bptr_actual_variable_value, USHORT status_length);

VARIABLE	*get_mib_variable_using_name (char *cptr_mib_name);

#ifdef __SNMP_STANDALONE__
/* Srikar, Mar 19, 1997. Changed the function prototype due to change in object id type */
enum TEST get_source_routing_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 19, 1997. Changed the function prototype due to change in object id type */
enum TEST get_spanning_tree_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 19, 1997. Changed the function prototype due to change in object id type */
enum TEST get_ppp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 19, 1997. Changed the function prototype due to change in object id type */
enum TEST get_frame_relay_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 19, 1997. Changed the function prototype due to change in object id type */
enum TEST get_ipx_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);
#endif /* __SNMP_STANDALONE__ */


/* snmpmgr */

MANAGER_CLASS *find_snmp_manager (ULONG internet_address);
MANAGER_CLASS *add_snmp_manager (ULONG internet_address);
enum TEST delete_snmp_manager (ULONG internet_address);


#endif /* _VSNMPSTR_H_ */
