/* DIALOUT.C -- Code to support dialout via the telnet server in the router
**				box.
** 4, May, 1996 - Sanjay - Started coding
*/

#ifdef _BIG_PROXY_  
#include	<defs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "telnet.h"
#include "vmenu.h"
#include <uartmode.h>
#include <msm.h>
#include <wanmgr.h>

#include "dialout.h"

/*	WAN_PORT_CLASS	*sptr_wan_port_class */
#include "..\..\devdrvrs\wandrv\kwan.h"
#include "..\..\devdrvrs\wandrv\modem.h"
#include "..\..\devdrvrs\wandrv\vwanstr.h"
#include "..\..\devdrvrs\wandrv\vwan.h"

extern	WAN_CLASS	wan;

/* CHAT */
#include	"\rtrware\devdrvrs\uim\chat\kchat.h"
#include	"\rtrware\devdrvrs\uim\chat\vchatstr.h"
#include	"\rtrware\devdrvrs\uim\chat\vchat.h"
#include	"\rtrware\devdrvrs\uim\kuim.h"
#include	"\rtrware\devdrvrs\uim\vuimstr.h"

/* Constants */

/* NOTE: That there are some strings in an array in the same order as the
** constants below. If you change these values, modify the array too.
*/
#if 0	/* Superceded by the table as below */
#define AVAILABLE_FOR_DIALOUT 	0	/* if port can be used for dialout */
#define IN_USE_FOR_DIALOUT	  	1	/* if port is already in use for dialout */
#define DISABLED_TO_DIALOUT	  	2	/* if port has been disabled */
#define CANNOT_USE_FOR_DIALOUT	3	/* if port is direct connect, or dial on demand, or sync */
#define IN_USE_FOR_ROUTING		4	/* if port is being used by router/remote client */
#endif
#define PORT_AVAILABLE			0
#define PORT_DISABLED			1	/* Disabled by configuration */
#define PORT_NOT_ASYNC			2	/* We can use only ASYNC ports */
#define PORT_IN_USE				3	/* Port is in use by RAS, dialout or router */

/* External Prototypes */
extern USHORT is_DCD_present(USHORT port_number);
extern enum BOOLEAN is_port_dial_on_demand(USHORT port_number);
extern enum BOOLEAN is_callback_on (USHORT port_number);

/* Global Prototypes */
void send_chat_pkt_to_specific_telnet_client(BYTE *buffer_ptr, ULONG length, BYTE *struct_ptr);
void do_modem_init_complete_actions(USHORT port_number, enum BOOLEAN init_state);
void do_modem_hangup_complete_actions(USHORT port_number);

/* Local Prototypes */
static int validate_dialout_user(TELNET_CLIENT_CLASS *client_info_ptr, char *Username);
static int validate_dialout_password(TELNET_CLIENT_CLASS *client_info_ptr, char *password_str);
static BYTE *start_dialout(TELNET_CLIENT_CLASS *client_info_ptr);
static BYTE get_data_bits_code(USHORT DataBits);
static BYTE get_parity_code(BYTE Parity);
static BYTE get_stop_bits_code(USHORT StopBits);
static void do_dialout_chat_cleanup(TELNET_CLIENT_CLASS *client_info_ptr);
static int get_port_availability(USHORT port_number);
static void write_serial_port(USHORT port_number, BYTE *sptr_buffer, USHORT bytes_to_write);

/* Foll. three functions are temporary */
extern BYTE *is_valid_ras_user(char *username);
extern int has_ras_user_password(BYTE *user_entry);
extern int is_valid_ras_user_password(BYTE *user_entry, char *password_str);
extern int has_dialout_access(BYTE *user_entry, USHORT port_number);

/* Globals */
static BYTE CompletedStr[1024];	/* Some strings will be sprintf'ed here */

static BYTE UsernamePromptStr[] = 
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"              << Router Dial-out Services >>\n\r"
"\n\r"
"\n\r"
"  Enter your name and press <Enter> to check if you have dial-out permission.\n\r"
"\n\r"
"\n\r"
"  User Name : ";

static BYTE PasswordPromptFormatStr[] = 
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"              << Router Dial-out Services >>\n\r"
"\n\r"
"\n\r"
"  You have used the name %s.\n\r"
"  Now enter your password (if any) and press <Enter>.\n\r"
"\n\r"
"\n\r"
"  Password : ";

static BYTE NoSuchUserFormatStr[] = 
"\n\r"
"\n\r"
"User name ** %s ** is not configured for dial-out!"
"\n\r"
"\n\r"
"Press <Enter> to continue.";

static BYTE InvalidDialoutPassword[] =
"\n\r"
"\n\r"
"Invalid dial-out password for user!"
"\n\r"
"\n\r"
"Press <Enter> to continue.";

static BYTE PortChoice4Port[] =
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"               << Dial-out Ports >>\n\r"
"\n\r"
"\n\r"
"[1] WAN 1 - %s\n\r"
"[2] WAN 2 - %s\n\r"
"[3] WAN 3 - %s\n\r"
"\n\r"
"NOTE: Ports indicated as 'AVAILABLE' can be used for dial-out."
"\n\r"
"Enter your choice (1 to 3, exit or ESC to previous menu) : ";

static BYTE PortChoice2Port[] =
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"              << Dial-out Ports >>\n\r"
"\n\r"
"\n\r"
"[1] WAN 1 - %s\n\r"
"\n\r"
"NOTE: Ports indicated as 'AVAILABLE' can be used for dial-out."
"\n\r"
"Enter your choice (1 , exit or ESC to previous menu) : ";

static BYTE *PortIsBusy = 
"\n\r"
"\n\r"
"WAN %u is currently not available for dial-out. Choose a free port."
"\n\r"
"Enter your choice (1 to %d, exit) : ";

static BYTE *PortStolen = 
"\n\r"
"\n\r"
"WAN %u has been taken by another process and is currently not available!"
"\n\r"
"\n\r"
"Press <Enter> to continue.";

static BYTE *NoPortAccess = 
"\n\r"
"\n\r"
"You do not have access rights to WAN %u. Choose some other port."
"\n\r"
"Enter your choice (1 to %d, exit) : ";

BYTE DialoutDefaults[] = 
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"               << Dial-out Configuration >>\n\r"
"\n\r"
"[1] Use Default Configuration (%lu, 8N1)\n\r"
"[2] Configure for Dial-out\n\r"
"\n\r"
"Enter your choice (1 to 2, exit or ESC to previous menu) : ";

/* NOTE: if number of baud rates displayed changes, modify the range check
**		 in the code handling.
*/
BYTE BaudRates[] =
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"               << Baud Rate >>\n\r"
"\n\r"
"\n\r"
"[ 1] Default (%lu)\n\r"
"[ 2] 150 \n\r"
"[ 3] 300 \n\r"
"[ 4] 600 \n\r"
"[ 5] 1200 \n\r"
"[ 6] 2400 \n\r"
"[ 7] 4800 \n\r"
"[ 8] 9600 \n\r"
"[ 9] 19200 \n\r"
"[10] 38400 \n\r"
"[11] 57600 \n\r"
"[12] 115200 \n\r"
"\n\r"
"Enter your choice (1 to 12, exit or ESC to previous menu) : ";

BYTE DataBits[] = 
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"               << Data Bits >>\n\r"
"\n\r"
"\n\r"
"[1] Default (%lu)\n\r"
"[2] 5 \n\r"
"[3] 6 \n\r"
"[4] 7 \n\r"
"[5] 8 \n\r"
"\n\r"
"Enter your choice (1 to 5, exit or ESC to previous menu) : ";

/* NOTE: We depend on the order of strings in Parity */
BYTE Parity[] = 
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"               << Parity >>\n\r"
"\n\r"
"\n\r"
"[1] Default (%s)\n\r"
"[2] None \n\r"
"[3] Odd \n\r"
"[4] Even \n\r"
"\n\r"
"Enter your choice (1 to 4, exit or ESC to previous menu) : ";

/* NOTE: We depend on the order of strings in StopBits */
BYTE StopBits[] = 
"\n\r"
"\n\r"
"\n\r"
"\n\r"
"               << Stop Bits >>\n\r"
"\n\r"
"\n\r"
"[1] Default (%lu)\n\r"
"[2] 1 \n\r"
"[3] 2 \n\r"
"\n\r"
"Enter your choice (1 to 3, exit or ESC to previous menu) : ";

static BYTE *DialoutSetupFail = 
"\n\r"
"\n\r"
"Unable to setup WAN port %u for dialout purposes. Choose some other port."
"\n\r"
"\n\r"
"Press <Enter> to continue.";

static BYTE *InitingModemStr = "\n\rInitializing modem on WAN port %u...\n\r";
static BYTE *HuppingModemStr = "\n\rHanging up...\n\r";

/* sudhir 16/6/97 */
static BYTE *ModemInitFailed = "\n\rModem Initialization failed....\n\r";

static BYTE *FinalDialoutStr = 
"\n\r"
"\n\r"
"From now on, whatever you type will go out to the WAN port %u.\n\r"
"Baud Rate - %lu, Data Bits - %lu, Parity - %s, Stop Bits - %lu.\n\r"
"Use Telnet Client Close Connection to exit.\n\r"
"\n\r"
"\n\r";

char SessionTimedOut[] = "\n\r\n\rSession timed-out on no activity!\n\r\n\r";

char *ParityStrings[] = { "None", "Odd", "Even" };

#if 0	/* Superceded by string list below */
char *PortStateStrs[] = {
	"AVAILABLE",
	"IN USE (by dial-out)",
 	"DISABLED (by configuration)",
	"CANNOT USE (configured as direct-connect or dial-on-demand or SYNC)",
	"IN USE (for routing)"
};
#endif
char *PortStateStrs[] = {
	"AVAILABLE",
 	"DISABLED (by configuration)",
	"CANNOT USE (configured as SYNC)",
	"IN USE (for routing or dial-out or remote access)"
};

/*---- Code ----------------------------------------------------------------*/

/* initialize_for_dialout()
**		Does some setup for dialout ports.
*/
enum TEST initialize_for_dialout(void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < wan.number_of_ports; ++port_number)
	{
		telnet.wan_in_use_for_dialout[port_number] = FALSE;
	}

	/* Allocate dialout file transfer buffers */
	return PASS;
}


/* dialout_username_hdlr()
**	This function corresponds to the state TMS_DIALOUT_USERNAME. State can 
**	change to TMS_DIALOUT_PASSWORD (prompt for password and validate it) or
**	TMS_DIALOUT_ENTER (bad user name, show string and wait for enter key).
*/
BYTE *dialout_username_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (buffer == NULL)
		return UsernamePromptStr;

	/* If there is some input, then we are validating the user name. */

	if (validate_dialout_user(client_info_ptr, buffer) == 1)
	{
		if (has_ras_user_password(client_info_ptr->dialout_user_entry) == 1)
		{
			client_info_ptr->menustate = TMS_DIALOUT_PASSWORD;
			client_info_ptr->verifying_dialout_pwd = TRUE;
			sprintf(CompletedStr, PasswordPromptFormatStr, buffer);
			return CompletedStr;
		}
		else
		{
			client_info_ptr->menustate = TMS_DIALOUT_PORTCHOICE;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL));
		}
	}
	else
	{
		client_info_ptr->menustate = TMS_DIALOUT_ENTER;
		sprintf(CompletedStr, NoSuchUserFormatStr, buffer);
		return CompletedStr;
	}
}

/* validate_dialout_user()
**		Validates the user name passed by looking up in a list of valid user
**		names. If successful, the 'dialout_user_entry' field of the
**		client information record is updated.
*/
static int validate_dialout_user(TELNET_CLIENT_CLASS *client_info_ptr, char *username)
{
	client_info_ptr->dialout_user_entry = is_valid_ras_user(username);

	if (client_info_ptr->dialout_user_entry == NULL)
		return 0;
	else
		return 1;		/* For now !!! */
}

/* dialout_password_hdlr()
**		This function corresponds to the state TMS_DIALOUT_PASSWORD. Called
**		to verify password entered. Depending on validation state, an
**		error message string may be returned or the next level of menu
**		entered (TMS_DIALOUT_ENTER or TMS_DIALOUT_PORTCHOICE)
*/
BYTE *dialout_password_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	client_info_ptr->verifying_dialout_pwd = FALSE;

	if (validate_dialout_password(client_info_ptr, buffer) == 1)
	{
		client_info_ptr->menustate = TMS_DIALOUT_PORTCHOICE;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL));
	}
	else
	{
		client_info_ptr->menustate = TMS_DIALOUT_ENTER;
		return InvalidDialoutPassword;
	}
}

/* validate_dialout_password()
**		Validates the passed password.
*/
static int validate_dialout_password(TELNET_CLIENT_CLASS *client_info_ptr, char *password_str)
{
	return is_valid_ras_user_password(client_info_ptr->dialout_user_entry, password_str);
}

/* dialout_enter_hdlr()
** 	This function corresponds to the state TMS_DIALOUT_ENTER. This state is
** 	when you wait for a key press after finding a bad user name or invalid
** 	password for user. The next state always is to display the super menu
** 	(TMS_SUPERMENU).
*/
BYTE *dialout_enter_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	client_info_ptr->menustate = TMS_SUPERMENU;
	return menufsmhdlr[TMS_SUPERMENU].menu;
}

/* dialout_port_choice()
**		Called to validate choice of item in a menu of ports for dialout.
*/
BYTE *dialout_port_choice(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT port_number;
	int availability0, availability1, availability2;


	if (buffer == NULL)
	{
		if (telnet.number_of_ports == 2) 
		{
			availability0 = get_port_availability(0);
			sprintf(CompletedStr, PortChoice2Port, PortStateStrs[availability0]);
		}
		else if (telnet.number_of_ports == 4)
		{
			availability0 = get_port_availability(0);
			availability1 = get_port_availability(1);
			availability2 = get_port_availability(2);

			sprintf(CompletedStr, PortChoice4Port, PortStateStrs[availability0],
				PortStateStrs[availability1], PortStateStrs[availability2]);
		}
		return CompletedStr;
	}

	port_number = atoi(buffer);
	if (port_number > menufsmhdlr[client_info_ptr->menustate].num_of_items ||
		port_number <= 0)
	{
		/* Bad choice */
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
/*	else if (port_number == menufsmhdlr[client_info_ptr->menustate].num_of_items)
	{
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
		return menufsmhdlr[client_info_ptr->menustate].menu;
	} */
	else
	{
		/* Check if selected WAN port is free for use */
		if (get_port_availability(port_number - 1) != PORT_AVAILABLE)
		{
			/* Port is not free... */
			sprintf(CompletedStr, PortIsBusy, port_number, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return CompletedStr;
		}

		/* Check if the user has dialout access to the requested port */
		if (client_info_ptr->dialout_user_entry != NULL)
		{
			if (has_dialout_access(client_info_ptr->dialout_user_entry, port_number - 1) == 0)
			{
				sprintf(CompletedStr, NoPortAccess, port_number,
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return CompletedStr;
			}
		}

		/* Port is free for use and the user has access to it. In
		** subsequent menu's arrange to ask for baud rate etc.
		** NOTE: That while one client is looking at the subsequent
		** menus, another client can beat him to the port if he is fast
		** enough. This is okay. We make a final double check to ensure
		** that only one client uses the port.
		*/

/* We init the following here as it is not being done in the WAN code */
/* WAN code assumes 8N1 always */

		wan.port[port_number - 1].word_length = 8;
		wan.port[port_number - 1].parity = 0;
		wan.port[port_number - 1].stop_bits = 1;

	 	client_info_ptr->menu_selected_port = port_number - 1;
		client_info_ptr->menustate = TMS_DIALOUT_DEFAULTS;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));	
	}
}

/* dialout_config_hdlr()
**		Handles state TMS_DIALOUT_DEFAULTS to present the Dialout Defaults
**		menu and to handle input from there.
*/
BYTE *dialout_config_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (buffer == NULL)
	{
		sprintf(CompletedStr, DialoutDefaults, wan.port[client_info_ptr->menu_selected_port].port_speed);
		return CompletedStr;
	}

	switch (atoi(buffer))
	{
	case 1:
		client_info_ptr->baud_rate = wan.port[client_info_ptr->menu_selected_port].port_speed;
		client_info_ptr->data_bits = wan.port[client_info_ptr->menu_selected_port].word_length;
		client_info_ptr->parity = wan.port[client_info_ptr->menu_selected_port].parity;
		client_info_ptr->stop_bits = wan.port[client_info_ptr->menu_selected_port].stop_bits;
		return start_dialout(client_info_ptr);
		break;
	case 2:
		client_info_ptr->menustate = TMS_DIALOUT_BAUD;
		break;

	default:
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
		break;
	}

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* dialout_baud_hdlr()
**	Handles state TMS_DIALOUT_BAUD to present the Baud Rate menu and to 
**	handle input of baud rate.
*/
BYTE *dialout_baud_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	unsigned long retval;
	ULONG BaudRatesArray[] = { 150, 300, 600, 1200, 2400, 4800, 9600, 19200, 
			38400, 57600, 115200 };


	if (buffer == NULL)
	{
		/* Prepare (find and mark the default baud rate) and return the 
		** baud rate menu.
		*/
		sprintf(CompletedStr, BaudRates, (ULONG) wan.port[client_info_ptr->menu_selected_port].port_speed);
		return CompletedStr;
	}

	retval = (unsigned long) atoi(buffer);
	if (retval >= 2 && retval <= 12)
	{
		client_info_ptr->menustate = TMS_DIALOUT_DATABITS;
		client_info_ptr->baud_rate = BaudRatesArray[retval - 2];
	}
	else if (retval == 1)
	{
		client_info_ptr->menustate = TMS_DIALOUT_DATABITS;
		client_info_ptr->baud_rate = wan.port[client_info_ptr->menu_selected_port].port_speed;
	}
/*
	else if (retval == 13)
	{
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
	}  */
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* dialout_databits_hdlr()
**	Handles state TMS_DIALOUT_DATABITS to present the Data Bits menu and to
**	handle input of data bits.
*/
BYTE *dialout_databits_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	unsigned long retval;
	USHORT DataBitsArray[] = { 5, 6, 7, 8 };


	if (buffer == NULL)
	{
		sprintf(CompletedStr, DataBits, (ULONG) wan.port[client_info_ptr->menu_selected_port].word_length);
		return CompletedStr;
	}

	retval = (unsigned long)atoi(buffer);
	if (retval >= 2 && retval <= 5)
	{
		client_info_ptr->menustate = TMS_DIALOUT_PARITY;
		client_info_ptr->data_bits = DataBitsArray[retval - 2];
	}
	else if (retval == 1)
	{
		client_info_ptr->menustate = TMS_DIALOUT_PARITY;
		client_info_ptr->data_bits = wan.port[client_info_ptr->menu_selected_port].word_length;
	}
/*
	else if (retval == 6)
	{
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
	} */
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* dialout_parity_hdlr()
**	Handles state TMS_DIALOUT_PARITY to present the Parity menu and to
**	handle input of parity.
*/
BYTE *dialout_parity_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	unsigned long retval;
	BYTE ParityArray[] = { 0, 1, 2 };

	if (buffer == NULL)
	{
		sprintf(CompletedStr, Parity, ParityStrings[wan.port[client_info_ptr->menu_selected_port].parity]);
		return CompletedStr;
	}

	retval = (unsigned long)atoi(buffer);
	if (retval >= 2 && retval <= 4)
	{
		client_info_ptr->menustate = TMS_DIALOUT_STOPBITS;
		client_info_ptr->parity = ParityArray[retval - 2];
	}
	else if (retval == 1)
	{
		client_info_ptr->menustate = TMS_DIALOUT_STOPBITS;
		client_info_ptr->parity = wan.port[client_info_ptr->menu_selected_port].parity;
	}
/*
	else if (retval == 5)
	{
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
	}  */
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* dialout_stopbits_hdlr()
**	Handles state TMS_DIALOUT_DATABITS to present the Stop Bits menu and to
**	handle input of stop bits.
*/
BYTE *dialout_stopbits_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	unsigned long retval;
	USHORT StopBitsArray[] = { 1, 2 };

	if (buffer == NULL)
	{
		sprintf(CompletedStr, StopBits, (ULONG) (int)wan.port[client_info_ptr->menu_selected_port].stop_bits);
		return CompletedStr;
	}

	retval = (unsigned long)atoi(buffer);
	if (retval >= 2 && retval <= 3)
		client_info_ptr->stop_bits = StopBitsArray[retval - 2];
	else if (retval == 1)
		client_info_ptr->stop_bits = wan.port[client_info_ptr->menu_selected_port].stop_bits;
/*	else if (retval == 4)
	{
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	} */
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}

	return start_dialout(client_info_ptr);
}

/* start_dialout()
**	First checks if the requested dialout port is still available. And if so,
**  in one swoop, stops router from touching this port, converts the port
**	to a dialling kind, init's it to requested serial parameters and sets
**  for dial-out to occur.
*/
static BYTE *start_dialout(TELNET_CLIENT_CLASS *client_info_ptr)
{
	char *modem_init_strings[5];
	USHORT port_number = client_info_ptr->menu_selected_port;


	/* Double check */
	if (get_port_availability(port_number) != PORT_AVAILABLE)
	{
		client_info_ptr->menustate = TMS_DIALOUT_ENTER2;
		sprintf(CompletedStr, PortStolen, port_number + 1);
		return CompletedStr;
	}

	/* Stop the router's modem state machine if it was in progress */
	set_wan_port_owner(port_number, OWNED_BY_TELNET);

	/* From now on this client owns this WAN port */
	telnet.wan_in_use_for_dialout[port_number] = TRUE;

	if (start_dialout_on_port(port_number + 1, (BYTE *)client_info_ptr,
		client_info_ptr->baud_rate, 
		get_data_bits_code(client_info_ptr->data_bits),
		get_parity_code(client_info_ptr->parity),
		get_stop_bits_code(client_info_ptr->stop_bits)) == FALSE)
	{
		telnet.wan_in_use_for_dialout[port_number] = FALSE;
		set_wan_port_owner(port_number, OWNED_BY_NONE);

		client_info_ptr->menustate = TMS_DIALOUT_ENTER2;
		sprintf(CompletedStr, DialoutSetupFail, port_number + 1);
		return CompletedStr;
	}

	/* We will echo no more */
	will_temp_echo(client_info_ptr, TOECHO);

	client_info_ptr->menustate = TMS_DIALOUT_MODEM_INIT;

	/* Need to start off the modem init state machine */
	if (is_wan_direct_connect(client_info_ptr->menu_selected_port) == FALSE)
	{
		get_wan_modem_init_strings(client_info_ptr->menu_selected_port, modem_init_strings);
		client_info_ptr->fptr_inform_msm_module = start_modem_init_state_machine(
			client_info_ptr->menu_selected_port, 
			modem_init_strings,
			write_serial_port, 
			do_modem_init_complete_actions);
	}
	else
	{
		do_modem_init_complete_actions(client_info_ptr->menu_selected_port, TRUE);
/* sudhir 16/6/97 */
      return NULL;
	}
		
	sprintf(CompletedStr, InitingModemStr, client_info_ptr->menu_selected_port + 1);
	return CompletedStr;
}

void write_serial_port(USHORT port_number, BYTE *sptr_buffer, USHORT bytes_to_write)
{
	chat_send_wan_packet(sptr_buffer, bytes_to_write, port_number);
}
/* dialout_2nd_enter_hdlr()
** 	This function corresponds to the state TMS_DIALOUT_ENTER2. This state is
** 	when you wait for a key press after finding a bad user name or invalid
** 	password for user. The next state always is to display WAN port choice
**  menu (TMS_DIALOUT_PORTCHOICE).
*/
BYTE *dialout_2nd_enter_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	client_info_ptr->menustate = TMS_DIALOUT_PORTCHOICE;
	return dialout_port_choice(client_info_ptr, NULL);
}

BYTE *enter_dialout(TELNET_CLIENT_CLASS *client_info_ptr)
{
	client_info_ptr->dialout_idle_timer = DIALOUT_IDLE_TIME;
	client_info_ptr->menustate = TMS_DIALOUT_CHAT;

	sprintf(CompletedStr, FinalDialoutStr, client_info_ptr->menu_selected_port + 1,
		(ULONG)client_info_ptr->baud_rate, (ULONG)client_info_ptr->data_bits, 
		ParityStrings[client_info_ptr->parity], (ULONG)client_info_ptr->stop_bits);

	/* Finally in dialout. All keystrokes should from now on go to the
	** WAN port directly.
	*/				   
	return CompletedStr;
}

/* dialout_chat_hdlr()
**	This function is called on ending the dialout chat mode. This will 
**	perform any session clean-ups that are required and return to the main
**  telnet server menu. Call this function when you need to clean up all
**	traces of dialout.
*/
BYTE *dialout_chat_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	MODEM_STRINGS *modem_str_ptr = &wan.port[client_info_ptr->menu_selected_port].modem_info.strings;

	client_info_ptr->menustate = TMS_DIALOUT_MODEM_HUP;
	if (is_wan_direct_connect(client_info_ptr->menu_selected_port) == FALSE)
	{
/* Sachin, courtsey Mallu, 25/01/1997 */
/*		send_telnet_packet(client_info_ptr, HuppingModemStr, strlen(HuppingModemStr), 0); */
		start_modem_hangup_state_machine(client_info_ptr->menu_selected_port,
			modem_str_ptr->modem_hangup_string, 
			write_serial_port, 
			do_modem_hangup_complete_actions);
	}
	else
	{
		do_modem_hangup_complete_actions(client_info_ptr->menu_selected_port);
	}
	return NULL;
}

static void do_dialout_chat_cleanup(TELNET_CLIENT_CLASS *client_info_ptr)
{
	BYTE *ret_str;


	stop_dialout_on_port(client_info_ptr->menu_selected_port);

	will_echo(client_info_ptr, TOECHO);

	telnet.wan_in_use_for_dialout[client_info_ptr->menu_selected_port] = FALSE;
	set_wan_port_owner(client_info_ptr->menu_selected_port, OWNED_BY_NONE);

	if (client_info_ptr->interrupted == TRUE)
	{
		client_info_ptr->menustate = TMS_DIALOUT_PORTCHOICE;
		ret_str = dialout_port_choice(client_info_ptr, NULL);
		send_telnet_packet(client_info_ptr, ret_str, strlen(ret_str), 0);
	}
	else
	{
		client_info_ptr->dialout_user_entry = NULL;
		client_info_ptr->menustate = TMS_SUPERMENU;
	}

	if (client_info_ptr->force_close == TRUE)
	{
		client_info_ptr->force_close = FALSE;
		close_connection(client_info_ptr);
	}
}

/* send_chat_pkt_to_specific_telnet_client()
**		Called from code in UIM\CHAT section to pass on a packet received
**		from some WAN (SCCx) port. We send out the received packet as a
**		telnet packet.
** NOTES: The packet received from the serial side is to be sent on the
**	LAN to a telnet client. If the packet had (by chance) some IAC (255 hex)
**	characters, they may be interpreted by the client. So we need to quote
**	them (introduce another IAC). We may get IAC characters during file
**	transfers.
*/
void send_chat_pkt_to_specific_telnet_client(BYTE *buffer_ptr, ULONG length, BYTE *struct_ptr)
{
	ULONG i;
	ULONG new_length;
	TELNET_CLIENT_CLASS *client_info_ptr;
	BYTE *quote_buf_ptr, *src_ptr, *dst_ptr;


	if (struct_ptr == NULL)
		return;

	client_info_ptr = (TELNET_CLIENT_CLASS *)struct_ptr;

	client_info_ptr->dialout_idle_timer = DIALOUT_IDLE_TIME;

	/* Quote the packet. We need atmost twice the packet size to quote. */
	quote_buf_ptr = buffer_malloc(length * 2);
	if (quote_buf_ptr == NULL)
	{
#ifdef DEBUG
		printf("TELNET: No quote buffer space\n\r");
#endif
		/* We will not recover, simply lose the packet */
		return;
	}
	src_ptr = buffer_ptr;
	dst_ptr = quote_buf_ptr;
	new_length = length;
	for (i = 0; i < length; i++, src_ptr++, dst_ptr++)
	{
		*dst_ptr = *src_ptr;
		if (*src_ptr == TCIAC)
		{
#ifdef DEBUG
			printf("TELNET: Quoted\n\r");
#endif
			dst_ptr++;
			*dst_ptr = TCIAC;
			new_length++;
		}
	}
	if (client_info_ptr->menustate == TMS_DIALOUT_MODEM_INIT)
	{
		/* During this phase, the MSM module needs to take a look at
		** incoming WAN data.
		*/
		if (client_info_ptr->fptr_inform_msm_module)
			client_info_ptr->fptr_inform_msm_module(client_info_ptr->menu_selected_port, quote_buf_ptr, new_length);
	}

	send_telnet_packet(client_info_ptr, quote_buf_ptr, new_length, 0);
	buffer_free(quote_buf_ptr);
}

/* dialout_session_timed_out()
**		Called when idle timer has expired. Session is aborted and the
**		WAN port made available subsequently for others.
*/
void dialout_session_timed_out(TELNET_CLIENT_CLASS *client_info_ptr)
{
	send_telnet_packet(client_info_ptr, SessionTimedOut, strlen(SessionTimedOut), 0);
	client_info_ptr->interrupted = TRUE;
	dialout_chat_hdlr(client_info_ptr, NULL);
}

static BYTE get_data_bits_code(USHORT DataBits)
{
	BYTE DataBitsCode;

	switch (DataBits)
	{
	case 5:
		DataBitsCode = FIVE_DATA;
		break;
	case 6:
		DataBitsCode = SIX_DATA;
		break;
	case 7:
		DataBitsCode = SEVEN_DATA;
		break;
	case 8:
	default:
		DataBitsCode = EIGHT_DATA;
		break;
	}

	return DataBitsCode;
}

static BYTE get_parity_code(BYTE Parity)
{
	BYTE ParityCode;

	switch (Parity)
	{
	case 0:
		ParityCode = NONE;
		break;
	case 1:
		ParityCode = ODD;
		break;
	case 2:
	default:
		ParityCode = EVEN;
		break;
	}

	return ParityCode;
}

static BYTE get_stop_bits_code(USHORT StopBits)
{
	BYTE StopBitsCode;

	switch (StopBits)
	{
	case 1:
		StopBitsCode = ONE_STOP;
		break;
	case 2:
	default:
		StopBitsCode = TWO_STOP;
		break;
	}

	return StopBitsCode;
}

void do_modem_init_complete_actions(USHORT port_number, enum BOOLEAN init_state)
{
	USHORT i;
	BYTE *ret_str;
	TELNET_CLIENT_CLASS *client_info_ptr;


	/* Find the telnet session currently doing init on the specified port */

	client_info_ptr = telnet.clients_info;
	for (i = 0; i < telnet.max_telnet_connections; i++, client_info_ptr++)
	{
		if (client_info_ptr->in_use &&
			client_info_ptr->menustate == TMS_DIALOUT_MODEM_INIT &&
			client_info_ptr->menu_selected_port == port_number)
		{
			break;
		}
	}
	if (i == telnet.max_telnet_connections)	/* Such a session not found */
		return;

/* sudhir 16/6/97 */
   if (init_state == FALSE)
      send_telnet_packet (client_info_ptr, ModemInitFailed, strlen(ModemInitFailed), 0);

	ret_str = enter_dialout(client_info_ptr);
	send_telnet_packet(client_info_ptr, ret_str, strlen(ret_str), 0);
}

void do_modem_hangup_complete_actions(USHORT port_number)
{
	USHORT i;
	TELNET_CLIENT_CLASS *client_info_ptr;

	/* Find the telnet session currently doing hangup on the specified port */
	client_info_ptr = telnet.clients_info;
	for (i = 0; i < telnet.max_telnet_connections; i++, client_info_ptr++)
	{
		if (client_info_ptr->in_use)
		{
			if (client_info_ptr->menustate == TMS_DIALOUT_MODEM_HUP &&
					client_info_ptr->menu_selected_port == port_number)
			{
				break;
			}
		}
	}
	if (i == telnet.max_telnet_connections)	/* Such a session not found */
	{
		return;
	}

	/* Finally we have terminated the dialout session. Perform telnet
	** state change related activities.
	*/
	do_dialout_chat_cleanup(client_info_ptr);
}

#if 0	/* get_port_availability() is superceded by a newer function */
/* get_port_availability()
** 	Called to determine if a specified port can be use for dialout.
** Params:
** 	port number to check
** Returns:
**	AVAILABLE_FOR_DIALOUT 	- if port can be used for dialout
**  IN_USE_FOR_DIALOUT	  	- if port is already in use for dialout
**	DISABLED_TO_DIALOUT	  	- if port has been disabled
**	CANNOT_USE_FOR_DIALOUT	- if port is direct connect, or dial on demand, or sync
**  IN_USE_FOR_ROUTING		- if port is being used by router/remote client
*/
static int get_port_availability(USHORT port_number)
{
	USHORT i;
	TELNET_CLIENT_CLASS *client_info_ptr;


	/* Find the telnet session using this port (if there is any) */
	client_info_ptr = telnet.clients_info;
	for (i = 0; i < telnet.max_telnet_connections; i++, client_info_ptr++)
	{
		if (client_info_ptr->in_use && telnet.wan_in_use_for_dialout[port_number])
		{
			return IN_USE_FOR_DIALOUT;
		}
	}

	/* This port is not in use for dialout purposes... */

	if (wan.port[port_number].enabled == FALSE)
		return DISABLED_TO_DIALOUT;

	if ((wan.port[port_number].direct_connect_enabled == TRUE) ||
			(wan.port[port_number].asyncport == FALSE)) 
#if 0
			||
			(is_port_dial_on_demand (port_number) == TRUE))
#endif
		return CANNOT_USE_FOR_DIALOUT;

	if (is_DCD_present(port_number) || is_callback_on(port_number))
	{
		/* The earlier check for in use by dialout, excludes dialout case
		** here.
		*/
		return IN_USE_FOR_ROUTING;
	}

	return AVAILABLE_FOR_DIALOUT;
}
#endif

int get_port_availability(USHORT port_number)
{
	if (get_wan_port_owner(port_number) != OWNED_BY_NONE)
		return PORT_IN_USE;

	if (is_wan_enabled(port_number) == FALSE)
		return PORT_DISABLED;

	if (is_wan_async(port_number) == FALSE)
		return PORT_NOT_ASYNC;

	return PORT_AVAILABLE;
}
#endif /* _BIG_PROXY_ */
