#ifdef _BIG_PROXY_
#include	<defs.h>
#include	<stdio.h>
#include <string.h>

#include	"telnet.h"
#include	"menu.h"
#include	"dialout.h"

#include <serial.h>

#include	"..\..\devdrvrs\uim\chat\kchat.h"
#include	"..\..\devdrvrs\uim\chat\vchatstr.h"
#include	"..\..\devdrvrs\uim\chat\vchat.h"

extern void *malloc (ULONG) ;
extern void free (void *) ;

BYTE	soinfsm[NSTATES][NCHRS];

#ifdef  _BIG_PROXY_
struct	fsm_trans	soinstab[] = {
	/* State			Input				NextState			Action	*/
	/* -----			-----				---------			------	*/
	{ TSDATA,		TCIAC,			TSIAC,				no_opt	},
	{ TSDATA,		TCANY,			TSDATA,				save_buffer },
	{ TSIAC,			TCIAC,			TSDATA,				save_buffer },
/*	{ TSIAC,			TCSB,				TSSUBNEG,			no_opt }, */

	{ TSIAC,			TCNOP,			TSDATA,				no_opt },
	{ TSIAC,			TCDM,				TSDATA,				tcdm },

	{ TSIAC,			TCWILL,			TSWOPT,				recopt },
	{ TSIAC,			TCWONT,			TSWOPT,				recopt },
	{ TSIAC,			TCDO,				TSDOPT,				recopt },
	{ TSIAC,			TCDONT,			TSDOPT,				recopt },

	{ TSIAC,			TCAYT,			TSDATA,				hello },
	{ TSIAC,			TCEC,				TSDATA,				edit_cmnd },
	{ TSIAC,			TCEL,				TSDATA,				edit_cmnd },

	{ TSIAC,			TCIP,				TSDATA,				interrupt_process },
	{ TSIAC,			TCAO,				TSDATA,				abort_output },
	{ TSIAC,			TCANY,			TSDATA,				no_opt },

/*	{ TSSUBNEG,		TCIAC,			TSSUBIAC,			no_opt },
	{ TSSUBNEG,		TCANY,			TSSUBNEG,			subopt },
	{ TSSUBIAC,		TCSE,				TSDATA,				subend },
	{ TSSUBIAC,		TCANY,			TSSUBNEG,			subopt }, */

/* sudhir */
   { TSWOPT,      TOECHO,        TSDATA,           do_echo},
   { TSWOPT,      TONOGA,        TSDATA,           do_noga},
/* sudhir */

/*	{ TSWOPT,		TOTXBINARY,		TSDATA,				do_txbinary },*/
	{ TSWOPT,		TOTIMINGMARK,	TSDATA,				do_timing_mark },
/*	{ TSWOPT,		TOTERMTYPE,		TSDATA,				do_termtype },*/
	{ TSWOPT,		TCANY,			TSDATA,				do_notsup },

 	{ TSDOPT,		TOECHO,			TSDATA,				will_echo },
/*	{ TSDOPT,		TOTXBINARY,		TSDATA,				will_txbinary },*/
	{ TSDOPT,		TONOGA,			TSDATA,				will_noga },
	{ TSDOPT,		TOTIMINGMARK,	TSDATA,				will_timing_mark },
	{ TSDOPT,		TCANY,			TSDATA,				will_notsup },

	{ FSINVALID,	TCANY,			FSINVALID,			no_opt },
};
#endif

/****************************************************************************
	Routine	: socket_in
	Input		: Index to TELNET structure corresponding to this connection.
				  buf - pointer to the character buffer received.
				  char_count - number of characters received.
	Synopsis	: Calls a function in the Finite State Machine for every 
				  character received.
****************************************************************************/
void socket_in(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buf, USHORT char_count)
{
#ifdef _BIG_PROXY_  /* Imran */

	USHORT i, ki;
	fsm_trans *pt;
	char *temp_buff ;

/* sudhir 16/8/97 */

   if (client_info_ptr->menustate == TMS_DIALOUT_MODEM_INIT)
      return;

	for (i = 0; i < char_count; i++, buf++) 
	{
		ki = soinfsm[client_info_ptr->sostate][*buf];
		pt = &soinstab[ki];

		/* Return value = 0 indicates that connection has been closed */

		/* NOTE: If we are doing IP dialout and some file transfer is going on,
		** calling a function for each character was found to be too slow. So
		** below is a quick-fix, where we check for such a situation and do the
		** job of the function here itself. Saves overhead of call. Special
		** handling is done to take care of the IAC-IAC sequence which can occur
		** during binary transfers.
		*/
		if ((client_info_ptr->menustate == TMS_DIALOUT_CHAT) ||
			((client_info_ptr->in_use_by_terminal_server) && (client_info_ptr->client_state == CONNECTED_TO_SERVER)))
		{
			if (client_info_ptr->sostate == TSDATA ||
				client_info_ptr->sostate == TSIAC && *buf == TCIAC)
			{
				/* If IAC is the input, we are interested in checking and
				** replacing the IAC-IAC sequence by a single IAC.
				*/
				if ((*buf == TCIAC) && (client_info_ptr->sostate == TSDATA))
				{
					/* Next character could be a TCIAC so skip this character. The
					/* state table approach will see to it that the next state is
					** TSIAC. No other handling is required in this case.
					*/
				}
				else 
				{
					/* Buffer till all characters are analysed */

					*(BYTE *)(client_info_ptr->char_buffer_ptr + (int)client_info_ptr->bytes_in_char_buffer) = *buf;
					++client_info_ptr->bytes_in_char_buffer;

					/* Send out on the serial side if buffer is full */
					if (client_info_ptr->bytes_in_char_buffer == MAX_CHAR_BUFFER_SIZE)
					{
/* sudhir 6/2/97 */
                  if ((client_info_ptr->in_use_by_terminal_server) && (client_info_ptr->client_state == CONNECTED_TO_SERVER))
                  {
                     
                     /* Send the packet through the serial driver */
                     temp_buff = malloc (client_info_ptr->bytes_in_char_buffer) ;
                     if (temp_buff != NULL)
                     {
                        memcpy (temp_buff, client_info_ptr->char_buffer_ptr,
                                           client_info_ptr->bytes_in_char_buffer) ;
                        if (serial_tx_packet (client_info_ptr->port_used_by_client, temp_buff, client_info_ptr->bytes_in_char_buffer, APPLICATION) == FAIL)
                        {
                           free (temp_buff);
                           printf ("Packet send failed\n");
                        }
                        else
                        {
                           telnet.term_server_port[client_info_ptr->port_used_by_client].number_of_wan_pkts_forwarded++;
                           printf ("Packet of length %d put on port %d\n",
                                    client_info_ptr->bytes_in_char_buffer,
                                    client_info_ptr->port_used_by_client) ;
                           client_info_ptr->bytes_in_char_buffer = 0;
                        }
                     }
                     else 
                        printf ("Not enough memory\n");
                  }
                  else
                  {

							if (chat_send_wan_packet(client_info_ptr->char_buffer_ptr, client_info_ptr->bytes_in_char_buffer, client_info_ptr->menu_selected_port) == FAIL)
							{
								/* Send failed, keep the buffer until later. Do no further
								** socket reads until then in the timer code. Rather try to
								** do this serial send.
								*/
							}
							else
							{
								client_info_ptr->dialout_idle_timer = DIALOUT_IDLE_TIME;
								client_info_ptr->bytes_in_char_buffer = 0;
							}
						}
					}
				}
			}
			else 
			{
				if (!(pt->ft_action)(client_info_ptr, *buf))
					break;
			}
		}
		else if (!(pt->ft_action)(client_info_ptr, *buf))
			break;
#if 0 
		/* If delayed_tx_buffer has been allocated, then a SEND is waiting.
		** Stop processing any input and exit.
		*/
		if (client_info_ptr->delayed_tx_buffer != NULL)
			break;
#endif			
		client_info_ptr->sostate = pt->ft_next;
	}
	/* Suppose we were in the TELNET_DIALOUT_CHAT state, all characters to
	** be sent out would have been put into a buffer. Since at this point,
	** we are done with processing all characters (via the state machine),
	** send out the buffer on the serial side.
	*/
	if (((client_info_ptr->menustate == TMS_DIALOUT_CHAT) ||
		((client_info_ptr->in_use_by_terminal_server) && (client_info_ptr->client_state == CONNECTED_TO_SERVER)))
       && client_info_ptr->bytes_in_char_buffer != 0) 
	{
		/* sudhir 6/2/97 */
      if ((client_info_ptr->in_use_by_terminal_server) && (client_info_ptr->client_state == CONNECTED_TO_SERVER))
      {
         /* Send the packet through the serial driver */
         temp_buff = malloc (client_info_ptr->bytes_in_char_buffer) ;
         if (temp_buff != NULL)
         {
            memcpy (temp_buff, client_info_ptr->char_buffer_ptr,
                               client_info_ptr->bytes_in_char_buffer) ;
            if (serial_tx_packet (client_info_ptr->port_used_by_client, temp_buff, client_info_ptr->bytes_in_char_buffer, APPLICATION) == FAIL)
            {
               free (temp_buff);
               printf ("Packet send failed\n");
            }
            else
            {
               telnet.term_server_port[client_info_ptr->port_used_by_client].number_of_wan_pkts_forwarded++;
               printf ("Packet of length %d put on port %d\n",
                        client_info_ptr->bytes_in_char_buffer,
                        client_info_ptr->port_used_by_client) ;
               client_info_ptr->bytes_in_char_buffer = 0;
            }
         }
         else 
            printf ("Not enough memory\n");
      }
      else
      {

			if (chat_send_wan_packet(client_info_ptr->char_buffer_ptr, client_info_ptr->bytes_in_char_buffer, client_info_ptr->menu_selected_port) == FAIL)
			{
				/* Send failed, keep the buffer until later. Do no further
				** socket reads until then in the timer code. Rather try to
				** do this serial send.
				*/
			}
			else
		 		client_info_ptr->bytes_in_char_buffer = 0;
		 }
	}
#endif 
}
#endif

