#include	<defs.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include	"telnet.h"
#include	"vmenu.h"

/* CHAT */
#include	"..\..\devdrvrs\uim\chat\kchat.h"
#include	"..\..\devdrvrs\uim\chat\vchatstr.h"
#include	"..\..\devdrvrs\uim\chat\vchat.h"
#include	"\rtrware\devdrvrs\uim\kuim.h"
#include	"\rtrware\devdrvrs\uim\vuimstr.h"

/* Sudha 12 Feb 1998 */
/* #include "..\..\store\hardware.h" */

/* Sachin 18/12/1996 */
#include <wanmgr.h>
enum WAN_PORT_AVAILABILITY get_wan_port_avail_error_code () ;
/* Sachin 18/12/1996 */

/* ChattingClientPtr is initialized when a chat session is established. */
TELNET_CLIENT_CLASS	*ChatClientPtr = NULL;
/* Jo 27/04/99 */
const BYTE		*ChatEnd = "\n\rEnd of WANTalk mode. Resetting Router";

/* Sudha 12 Feb 1998 */
extern void generate_no_of_ports_strings(int no_of_ports, int section_id);

/****************************************************************************
	Routine		: close_all_other_client_sockets
	Input			: ptr to TELNET_CLIENT_CLASS structure
	Synopsis		: Closes all TELENT connections except the connection
					  whose ptr is sent as input. This is calles when any client
					  requests to go into Chat mode with the router's wan port.
****************************************************************************/

void	close_all_other_client_sockets(TELNET_CLIENT_CLASS *client_info_ptr)
{
	int		index;
	TELNET_CLIENT_CLASS	*connection_ptr;
	BYTE		*ChatCloseCon = "\n\rClosing Connection. Router in WANTalk mode";

	connection_ptr = telnet.clients_info;
	for(index = 0; index < telnet.max_telnet_connections; index++, connection_ptr++) {
		if(connection_ptr->in_use && connection_ptr != client_info_ptr) {
			send_telnet_packet(connection_ptr, ChatCloseCon, strlen(ChatCloseCon), 0);
			close_connection(connection_ptr);
		}
	}
}
	

BYTE	*chat_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer) 
   {
      /* Sudha 12 Feb 1998 */
		/* return (menufsmhdlr[client_info_ptr->menustate].menu); */
      generate_no_of_ports_strings(telnet.number_of_ports - 1,CHAT_ID);
      return (telnet.tx_buffer);
   }
	/* If we are waiting for ENTER to be pressed after error message,
	 go back to the parent menu */
	if (client_info_ptr->more) {
		back_to_normal_mode(client_info_ptr);
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}	

	port_number = atoi(buffer);
	/* Sanjay */
#if 0
	if (port_number > menufsmhdlr[client_info_ptr->menustate].num_of_items ||	
		port_number <= 0)
#endif
	if (port_number > telnet.number_of_ports - 1 ||
		port_number <= 0)
	{
		/* Bad choice */
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
#if 0
/*	else if (port_number == menufsmhdlr[client_info_ptr->menustate].num_of_items)
	{
		/* To parent menu */
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	} */
#endif

	else
	{
	 	if (start_chat_on_port(port_number, TELNET_CHAT))
		{
	 		ChatIdleTimer = CHAT_IDLE_TIMER_VALUE;	/* set this before ints */
	 		StartTimer(0);
	 		close_all_other_client_sockets(client_info_ptr);
	 		ChatClientPtr = client_info_ptr;
	  		/* While chatting, every character needs to be sent to the port
	 			immediately */
	 		will_temp_echo(client_info_ptr, TOECHO);
			client_info_ptr->menustate = TMS_CHATMODE;
	 		client_info_ptr->menu_selected_port = port_number-1;

/*Deepak 12/05/97...*/
	 		if (client_info_ptr->dumbtty == 0)
/*...Deepak 12/05/97*/
				sprintf(telnet.tx_buffer, PortInChatMode, client_info_ptr->menu_selected_port+1);
/*Deepak 12/05/97...*/
			else
   			sprintf(telnet.tx_buffer, PortInChatModeForDTTY, client_info_ptr->menu_selected_port+1);
/*...Deepak 12/05/97*/

	 		return (telnet.tx_buffer);
	 	}
		else
		{
	 		will_temp_echo(client_info_ptr, TOECHO);
	 		client_info_ptr->more++;
/* Sachin 18/12/1996 */
	 		return ((int)wan_conf_return_strings[get_wan_port_avail_error_code()]);
/* Sachin 18/12/1996 */
	 	}
	}
}


/****************************************************************************
* Called from chatrx.c when a packet is received from a WAN port which
* is chatting with a telnet client.
****************************************************************************/
void	send_chat_pkt_to_telnet_client(BYTE *buffer_ptr, ULONG length)
{
	if (ChatClientPtr)
		send_telnet_packet(ChatClientPtr, buffer_ptr, length, 0); 
}

