#if 0
#include	<defs.h>

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include <stddef.h>

#include	"telnet.h"
#include	"vmenu.h"
#include	"frstr.h"

#include <kstart.h>
#include <v8022str.h>
#include "\rtrware\devdrvrs\frmrelay\kfr.h"
#include "\rtrware\devdrvrs\frmrelay\krfc1490.h"
#include <vethstr.h>
#include <lslproto.h>
#include "\rtrware\devdrvrs\frmrelay\vfrstr.h"
#include "\rtrware\devdrvrs\frmrelay\kfrad.h"
#include "\rtrware\devdrvrs\frmrelay\vfradstr.h"
#include "\rtrware\devdrvrs\frmrelay\vfr.h"
#include <rwarebuf.h>

#include "..\..\include\vnvrmstr.h"		  

#include <cfgmgr.h>

#define MIN_DLCI_NO 16
#define MAX_DLCI_NO 1007

extern	BYTE 	*get_ip_address_str(BYTE *buf, USHORT port_number);
extern	BYTE	*get_ipx_network_number(BYTE *buf, USHORT port_number);
extern  	ULONG  get_wan_port_speed();
extern 	BYTE  *to_upper_string (BYTE *);

extern   PARA_STR *ptr_to_first_node;

extern CONFIGURATION_TABLE frame_relay_configuration_table; 
extern int toupper (int);

extern int no_of_ip_ports;		/* oss */
extern int no_of_ipx_networks;
extern int no_of_stp_ports;

extern 	int 	modify_config_visited;

int 	index_of_dlci_in_struct(int dlci_number);
int 	strnicmp (char *c1, char *c2, int size);
void 	initialize_default_dlci_parameters (void);
void 	load_dlci_values_from_ll (void);
void 	make_dlci_list_from_struct(BYTE *buffer);
BYTE 	*make_fr_mode_str (BYTE *buf, int mode);
void 	change_wan_parameters_for_fr();

/*#if 0*/
void 	delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr);
void  modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr);
BYTE 	*get_rhs_from_linked_list(BYTE *lhs_para_str, ULONG PortNo, PARA_STR *starting_addr);
BYTE 	*get_rhs_for_disp (ULONG offset, CONFIGURATION_TABLE configuration_table, ULONG PortNo, PARA_STR *starting_addr);
void 	set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr,
										BYTE *new_rhs);
PARA_STR *search_for_string (BYTE *lhs_para_str, BYTE *rhs_string, PARA_STR *start_addr);
void 	force_write_string_with_port_num (BYTE *, ULONG , BYTE *, PARA_STR *);
BYTE 	*copy_to_temp_struct(BYTE *buffer, BYTE *char_array);
/*#endif*/

ULONG check_if_mapped (int Flag, int DLCI_value_to_check);

/* oss on 5-3-97 */
int Total_No_of_DLCIs;
static DLCI_STORE dlci_values[MAX_NO_OF_DLCIS];
int first_time_in_DLCIs = 1;
int Check_for_dlci_modification = 0;
ULONG wan_port_speed;

void get_all_ip_address();
void get_all_ipx_networks();
void get_all_stp_ports();

int	dlci_index = 0;
int	dlci_selected = 0;

BYTE Buffer[50];


BYTE *frame_relay_conf_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
/*	printf ("It has come to frame_Relay_conf_hdlr\n"); */
	if (!buffer)
	{
		get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].enabled - (BYTE *) &frame_relay),
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0],
				10);
		get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].annex_d.enabled - (BYTE *) &frame_relay),
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[1].ReplyStr[0],
				10);
		
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0],
			(strcmp (&ReplyStrs[0].ReplyStr[0], "disabled")) ? "Annex D" : "LMI");
		return(telnet.tx_buffer);
	}

/*	printf ("It has come past buffer in frame_Relay_conf_hdlr\n"); */
	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd > 4) ||
		 (client_info_ptr->modify_option_rcvd < 1))
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	client_info_ptr->menustate = TMS_MOD_FRMAIN;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *frame_relay_conf_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG offset, new_value, port_no = NOT_PORT_PARAMETER;
	BYTE *lhs_para_str, *ret_str, *new_rhs, store_temp_value[10];
	BYTE Store_Buffer[50];
	extern int frame_relay_enabled;

	int AnnexD_Enabled;

/*	printf ("It has come to frame_Relay_conf_info_hdlr\n"); */
	get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].annex_d.enabled - (BYTE *) &frame_relay),
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0],
				10);
		
	AnnexD_Enabled = 	(strcmp (&ReplyStrs[0].ReplyStr[0], telnet_disabled_str)) ? 1 : 0;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case FR_ENABLE :	ret_str = EnaOrDis;
									break;
			case MGMT_TYPE :	ret_str = MgmtType;
									break;
			case DLCI_CONF :	client_info_ptr->menustate = TMS_MOD_DLCI_CONF;
									if (first_time_in_DLCIs)
										load_dlci_values_from_ll();
									wan_port_speed = get_wan_port_speed();
									return (menufsmhdlr[client_info_ptr->menustate].menuhdlr
												(client_info_ptr, NULL));
			case MGMT_PARAMETERS :
				if (AnnexD_Enabled == TRUE)
					new_rhs = AnnexDParameters;
				else
					new_rhs = LMIParameters;
				
				get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].annex_d.frDlcmiFullEnquiryInterval - (BYTE *) &frame_relay),
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 15);

				get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].annex_d.frDlcmiErrorThreshold - (BYTE *) &frame_relay),
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[1].ReplyStr[0], 15);

				(BYTE *) get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].annex_d.frDlcmiMonitoredEvents - (BYTE *) &frame_relay),
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[2].ReplyStr[0], 15);
									
				get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].annex_d.frDlcmiPollingInterval  - (BYTE *) &frame_relay),
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[3].ReplyStr[0], 15);

				get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.port[0].annex_d.polling_verification_timer_T392 - (BYTE *) &frame_relay),
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[4].ReplyStr[0], 15);

				sprintf (telnet.tx_buffer, new_rhs, 
					MakePunctNumStr(&ReplyStrs[5].ReplyStr[0], &ReplyStrs[0].ReplyStr[0]), 
					MakePunctNumStr(&ReplyStrs[6].ReplyStr[0], &ReplyStrs[1].ReplyStr[0]),
					MakePunctNumStr(&ReplyStrs[7].ReplyStr[0], &ReplyStrs[2].ReplyStr[0]),
					MakePunctNumStr(&ReplyStrs[8].ReplyStr[0], &ReplyStrs[3].ReplyStr[0]),
					MakePunctNumStr(&ReplyStrs[9].ReplyStr[0], &ReplyStrs[4].ReplyStr[0])); 
				ret_str = telnet.tx_buffer;
									break;
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				ret_str = telnet.tx_buffer;
		}
		return (ret_str);
	}

/*	printf ("It has come past buffer in frame_Relay_conf_info_hdlr\n"); */
	new_value = atoi (buffer);
	port_no = 1;
	switch (client_info_ptr->modify_option_rcvd)
	{
		case FR_ENABLE : 
			if (new_value == 1)
			{
				change_wan_parameters_for_fr();
				new_rhs = &telnet_enabled_str[0];
				frame_relay_enabled = 1;
			}
			else
				if (new_value == 2)
				{
					frame_relay_enabled = 0;
					strcpy (store_temp_value, "0");
					new_rhs = &store_temp_value[0];
					strcpy (Store_Buffer, "Frame Relay Number of Ports");
					lhs_para_str = &Store_Buffer[0];

					strcpy (Store_Buffer, "WAN Port Type");
					new_rhs = &telnet_disabled_str[0];
				}
				else
				{
					sprintf(telnet.tx_buffer, EnterProperChoice, "2");
					return(telnet.tx_buffer);
				}

			offset = (BYTE *) &frame_relay.port[0].enabled - (BYTE *) &frame_relay;  
			if (lhs_para_str == NULL)
				return (not_supported);
							break;
		case MGMT_TYPE :
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
				else
				{
					sprintf(telnet.tx_buffer, EnterProperChoice, "2");
					return(telnet.tx_buffer);
				}
			offset = (BYTE *) &frame_relay.port[0].annex_d.enabled - (BYTE *) &frame_relay;  
			if (lhs_para_str == NULL)
				return (not_supported);
							break;
		case MGMT_PARAMETERS :
			if ((new_value > 5) || (new_value < 1))
			{
				sprintf(telnet.tx_buffer, EnterProperChoice, "5");
				return(telnet.tx_buffer);
			}
			else
			{
				client_info_ptr->modify_option_rcvd = new_value;
				client_info_ptr->menustate =  TMS_MOD_FR_MGMT_PARA;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
			}
				break;
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
	}
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_MOD_FRPARAMETERS;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *frame_relay_mgmt_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG offset, new_value, port_no = NOT_PORT_PARAMETER;
	BYTE *lhs_para_str, *new_rhs;


	if (!buffer)
		return (NewValue);


	new_value = atoi (buffer);
	port_no = 1;
	new_rhs = buffer;

	switch (client_info_ptr->modify_option_rcvd)
	{
		case   MGMT_N391 :
			if ((new_value > 255) || (new_value < 1))
				return (EnterAgain);

			offset = (BYTE *) &frame_relay.port[0].annex_d.frDlcmiFullEnquiryInterval - (BYTE *) &frame_relay;  
			if (lhs_para_str == NULL)
				return (not_supported);
/*			printf ("The value to which %s is set is %s", lhs_para_str, new_rhs); */
							break;
		case	 MGMT_N392 :
			if ((new_value > 10) || (new_value < 1))
				return (EnterAgain);

			offset = (BYTE *) &frame_relay.port[0].annex_d.frDlcmiErrorThreshold - (BYTE *) &frame_relay;  
			if (lhs_para_str == NULL)
				return (not_supported);
			
            break;
		case	 MGMT_N393 :
			if ((new_value > 10) || (new_value < 1))
				return (EnterAgain);

			offset = (BYTE *) &frame_relay.port[0].annex_d.frDlcmiMonitoredEvents - (BYTE *) &frame_relay;  
			if (lhs_para_str == NULL)
				return (not_supported);
							break;
		case	 MGMT_T391 :
			if ((new_value != 5) && (new_value != 10) && (new_value != 15) &&
				(new_value != 20) && (new_value != 25) && (new_value != 30))
				return (TimerValueNotProper);

			offset = (BYTE *) &frame_relay.port[0].annex_d.frDlcmiPollingInterval - (BYTE *) &frame_relay;  
			if (lhs_para_str == NULL)
				return (not_supported);
							break;
		case	 MGMT_T392 :
			if ((new_value != 5) && (new_value != 10) && (new_value != 15) &&
				(new_value != 20) && (new_value != 25) && (new_value != 30))
				return (TimerValueNotProper);

			offset = (BYTE *) &frame_relay.port[0].annex_d.polling_verification_timer_T392 - (BYTE *) &frame_relay;  
			if (lhs_para_str == NULL)
				return (not_supported);
							break;
	}
	client_info_ptr->modify_option_rcvd = MGMT_PARAMETERS;
	client_info_ptr->menustate = TMS_MOD_FRMAIN;

	modify_config_visited = 1;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *frame_relay_dlci_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
/*	printf ("It has come to frame_Relay_dlci_hdlr\n"); */
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, SelectDLCI_Start, Total_No_of_DLCIs);
		make_dlci_list_from_struct(telnet.tx_buffer);
		strcat (telnet.tx_buffer, DLCIMenu);
		return (telnet.tx_buffer);
	}
/*	printf ("It has come past buffer in frame_Relay_dlci_hdlr\n"); */
	if ((*buffer == 'D') || (*buffer == 'd'))
		   client_info_ptr->menustate =  TMS_DELETE_DLCI;
	else	
		if ((*buffer == 'M') || (*buffer == 'm'))
		   client_info_ptr->menustate =  TMS_MOD_DLCI;
	else
		if ((*buffer == 'A') || (*buffer == 'a'))
		{
			if (Total_No_of_DLCIs >= 16)
			{
				sprintf (telnet.tx_buffer, "\n\rCan't have more than 16 DLCI's at a time. So can't add a new DLCI.");
				return (telnet.tx_buffer);
			}
			else
			{
				modify_config_visited = 1;
				Check_for_dlci_modification = 1;
				initialize_default_dlci_parameters();
				Total_No_of_DLCIs ++;
			}
			client_info_ptr->menustate =  TMS_ADD_DLCI;
		}
		else
			return (InvalidChoice);

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *frame_relay_dlci_mod_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int dlci_number;

/*	printf ("It has come to frame_Relay_dlci_mod_hdlr\n"); */
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, DLCINumber, "to Modify");
		return (telnet.tx_buffer);
	}

/*	printf ("It has come past buffer in frame_Relay_dlci_mod_hdlr\n"); */
 	dlci_number = atoi(buffer);
	dlci_index = index_of_dlci_in_struct(dlci_number);
	if (dlci_index <= 15)
	{
			dlci_selected = dlci_number;
			client_info_ptr->menustate = TMS_ADD_DLCI;	/* for common menu display */
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
	}
	else
	{
		strcpy (telnet.tx_buffer, InvalidChoice);
		return (telnet.tx_buffer);
	}
}

BYTE *frame_relay_dlci_add_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

/*	printf ("It has come to frame_Relay_dlci_add_hdlr\n"); */
	if (!buffer)
	{
		sprintf (telnet.tx_buffer,
					menufsmhdlr[client_info_ptr->menustate].menu, dlci_values[dlci_index].DLCI_No,
				(dlci_values[dlci_index].Mapped_to_IP_Port== NOT_PORT_PARAMETER) ? "NO" :
					get_ip_address_str( &ReplyStrs[0].ReplyStr[0], (ULONG)dlci_values[dlci_index].Mapped_to_IP_Port),
				(dlci_values[dlci_index].Mapped_to_IPX_Network == NOT_PORT_PARAMETER) ? "NO" :
					get_ipx_network_number ( &ReplyStrs[1].ReplyStr[0], (ULONG)dlci_values[dlci_index].Mapped_to_IPX_Network),
				(dlci_values[dlci_index].Mapped_to_STP_Port == NOT_PORT_PARAMETER) ? "NO" :
					MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], (ULONG)dlci_values[dlci_index].Mapped_to_STP_Port + 1),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], (ULONG)dlci_values[dlci_index].CIR),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], (ULONG)dlci_values[dlci_index].Be),
				make_fr_mode_str( &ReplyStrs[5].ReplyStr[0], dlci_values[dlci_index].Mode));
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);
/*	printf ("Option rcvd is %d\n",client_info_ptr->modify_option_rcvd); */
	if (client_info_ptr->modify_option_rcvd < 1  || client_info_ptr->modify_option_rcvd > 7)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	client_info_ptr->menustate = TMS_MOD_DLCI_OPTIONS; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

void initialize_default_dlci_parameters()
{
	ULONG set_to_def = NOT_PORT_PARAMETER;
		dlci_values[Total_No_of_DLCIs].DLCI_No = 0;
		dlci_values[Total_No_of_DLCIs].Mapped_to_IP_Port = set_to_def ;
		dlci_values[Total_No_of_DLCIs].Mapped_to_IPX_Network = set_to_def ;
		dlci_values[Total_No_of_DLCIs].Mapped_to_STP_Port = set_to_def ;

		dlci_values[Total_No_of_DLCIs].Mapped_to_Channel1 = set_to_def ;
		dlci_values[Total_No_of_DLCIs].Mapped_to_Channel2 = set_to_def ;

		dlci_values[Total_No_of_DLCIs].CIR = 56000;
		dlci_values[Total_No_of_DLCIs].Be	= 0;
		dlci_values[Total_No_of_DLCIs].Mode = 0;
		dlci_index = Total_No_of_DLCIs;
		dlci_selected = 0;
}

BYTE *dlci_options_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int new_value, i;

/*	printf ("It has come to dlci options handler function\n"); */
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case DLCI_Number			:	sprintf (telnet.tx_buffer, DLCINumber,"to change");
												break;
			case DLCI_IP_Address		:	get_all_ip_address();
												break;
			case DLCI_IPX_Network	:	get_all_ipx_networks();
												break;
			case DLCI_STP_Port		:	get_all_stp_ports();
												break;
			case DLCI_CIR				:	sprintf (telnet.tx_buffer, NewValue);
												break;
			case DLCI_Be				:	sprintf (telnet.tx_buffer, NewValue);
												break;
			case DLCI_Mode				:	sprintf (telnet.tx_buffer, DLCIModeMenu);
												break;
			default						:
				sprintf (telnet.tx_buffer, EnterProperChoice, 
							menufsmhdlr[client_info_ptr->menustate].num_of_items);
												break;
		}
/*		printf ("%s", telnet.tx_buffer); */
		return (telnet.tx_buffer);
	}

/*	printf ("It has come past buffer in dlci_options_hdlr\n"); 
	printf ("Value in buffer is %s\n", buffer);					  */
	new_value = atoi(buffer);
 	switch (client_info_ptr->modify_option_rcvd)
	{
		case DLCI_Number			:	
				for (i = 0; i < Total_No_of_DLCIs; i++)
					if (dlci_values[i].DLCI_No == new_value)
					{
						if (i == dlci_index)
							continue;
						strcpy (telnet.tx_buffer, DLCIAlreadyExists);
						return (telnet.tx_buffer);
					}

				if ((new_value < MIN_DLCI_NO) || (new_value > MAX_DLCI_NO))
				{
						sprintf (telnet.tx_buffer, MinMaxRangeexceeding, MIN_DLCI_NO, MAX_DLCI_NO);
						return (telnet.tx_buffer);
				}
				dlci_values[dlci_index].DLCI_No = new_value;
				dlci_selected = new_value;
						break;
		case DLCI_IP_Address		:
			if (new_value == no_of_ip_ports)
			{
				dlci_values[dlci_index].Mapped_to_IP_Port = NOT_PORT_PARAMETER;
				break;
			}
			for (i = 0; i < Total_No_of_DLCIs; i++)
				if (dlci_values[i].Mapped_to_IP_Port  == new_value)
				{
					if (i == dlci_index)
						continue;
					sprintf (telnet.tx_buffer, AlreadyMapped, "IP PORT",	dlci_values[i].DLCI_No);
					return (telnet.tx_buffer);
				}
			if ((new_value > no_of_ip_ports) || (new_value < 1 ))
				return (InvalidChoice);
		  	else
				dlci_values[dlci_index].Mapped_to_IP_Port = new_value;
								break;
		case DLCI_IPX_Network	:
			if (new_value == no_of_ipx_networks - 3)
			{
				dlci_values[dlci_index].Mapped_to_IPX_Network = NOT_PORT_PARAMETER;
				break;
			}
			for (i = 0; i < Total_No_of_DLCIs; i++)
				if ((dlci_values[i].Mapped_to_IPX_Network + 3) == new_value)
				{
					if (i == dlci_index)
						continue;
					sprintf (telnet.tx_buffer, AlreadyMapped, "IPX Network", dlci_values[i].DLCI_No);
					return (telnet.tx_buffer);
				}
				if ((new_value > no_of_ipx_networks - 3) || (new_value < 1 ))
					return (InvalidChoice);
		  		else
					dlci_values[dlci_index].Mapped_to_IPX_Network = new_value + 3;
				break;
		case DLCI_STP_Port		:
			if (new_value >= no_of_stp_ports)
			{
				dlci_values[dlci_index].Mapped_to_STP_Port = NOT_PORT_PARAMETER;
				break;
			}
			for (i = 0; i < Total_No_of_DLCIs; i++)
				if (dlci_values[i].Mapped_to_STP_Port == new_value)
				{
					if (i == dlci_index)
						continue;
					sprintf (telnet.tx_buffer, AlreadyMapped, "STP Port", dlci_values[i].DLCI_No);
					return (telnet.tx_buffer);
				}
			  	if ((new_value >= no_of_stp_ports) || (new_value < 1 ))
					return (InvalidChoice);
			  	else
					dlci_values[dlci_index].Mapped_to_STP_Port = new_value;	
				break;

		case DLCI_CIR				: 
			if ((new_value + dlci_values[dlci_index].Be) > wan_port_speed)
			{
				sprintf (telnet.tx_buffer, SpeedOutofBound, wan_port_speed, "CIR");
				return (telnet.tx_buffer);
			}
			dlci_values[dlci_index].CIR = new_value;
											break;
		case DLCI_Be				:
			if ((dlci_values[dlci_index].CIR + new_value) > wan_port_speed)
			{
				sprintf (telnet.tx_buffer, SpeedOutofBound, wan_port_speed, "Be");
				return (telnet.tx_buffer);
			}
			dlci_values[dlci_index].Be = new_value;
											break;
		case DLCI_Mode				:  if ((new_value > 3) || (new_value < 1))
												return (InvalidChoice);
											dlci_values[dlci_index].Mode = new_value - 1;
											break;
		default						: 	
			sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}

	modify_config_visited = 1;
	Check_for_dlci_modification = 1;
	client_info_ptr->menustate = TMS_ADD_DLCI;	
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *frame_relay_dlci_delete_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int i;
/*	printf ("It has come to frame_Relay_dlci_delete_hdlr\n"); */
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, DLCINumber, "to Delete");
		return (telnet.tx_buffer);
	}

/*	printf ("It has come past buffer in frame_Relay_dlci_delete_hdlr\n"); */
 	dlci_selected = atoi(buffer);
	dlci_index = index_of_dlci_in_struct (dlci_selected);
	if (dlci_index > 15)
		return (InvalidChoice);
	for (i = dlci_index; i < Total_No_of_DLCIs; i++)
		dlci_values[i] = dlci_values[i+1];
	Total_No_of_DLCIs --;
	modify_config_visited = 1;
	Check_for_dlci_modification = 1;

	client_info_ptr->menustate = TMS_MOD_DLCI_CONF;	
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *dlci_save_changes_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if ((dlci_values[dlci_index].DLCI_No < MIN_DLCI_NO) ||
		 (dlci_values[dlci_index].DLCI_No > MAX_DLCI_NO))
	{
		sprintf (telnet.tx_buffer, MinMaxRangeexceeding, MIN_DLCI_NO, MAX_DLCI_NO);
		client_info_ptr->menustate = TMS_MOD_DLCI_OPTIONS;
		client_info_ptr->modify_option_rcvd = DLCI_Number;
		return (telnet.tx_buffer);
	}

	client_info_ptr->menustate = TMS_MOD_DLCI_CONF;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

void get_all_ip_address()
{
	int i;
	BYTE temp_storage[75];
	BYTE temp_storage1[75];

	strcpy (telnet.tx_buffer, "\n\r      << Select IP Address >>\n\r");
	for (i = 1; i < no_of_ip_ports; i++)
	{
		sprintf (temp_storage, "\n\r[ %2d]  %s", i, get_ip_address_str (&temp_storage1, i));
/*		printf ("IP Address %d is %s", i, temp_storage); */
		strcat (telnet.tx_buffer, temp_storage);		
	}
	sprintf (temp_storage, "\n\r[ %2d]  None", no_of_ip_ports);
	strcat (telnet.tx_buffer, temp_storage);		
	sprintf (temp_storage, EnterChoice, no_of_ip_ports);
	strcat (telnet.tx_buffer, temp_storage);		
/*	printf ("Buffer returned in IP Port is %s", telnet.tx_buffer); */
}

void get_all_ipx_networks()
{
	int i;
	BYTE temp_storage[75];
	BYTE temp_storage1[75];

	strcpy (telnet.tx_buffer, "\n\r      << Select IPX Network Number >>\n\r");
	for (i = 4; i < no_of_ipx_networks; i++)
	{
		sprintf (temp_storage, "\n\r[ %2d]  %s", i - 3, get_ipx_network_number (&temp_storage1, i));
/*		printf ("IPX Network %d is %s", i, temp_storage); */
		strcat (telnet.tx_buffer, temp_storage);		
	}	
	sprintf (temp_storage, "\n\r[ %2d]  None", no_of_ipx_networks - 3);
	strcat (telnet.tx_buffer, temp_storage);		
	sprintf (temp_storage, EnterChoice, no_of_ipx_networks - 3);
	strcat (telnet.tx_buffer, temp_storage);		
/*	printf ("Buffer returned in IPX Network is %s", telnet.tx_buffer); */
}

void get_all_stp_ports()
{
	int i;
	BYTE temp_storage[75];

	strcpy (telnet.tx_buffer, "\n\r      << Select STP Port >>\n\r");
	for (i = 2; i <= no_of_stp_ports; i++)
	{
		sprintf (temp_storage, "\n\r[ %2d]  Port %d", i - 1, i);
/*		printf ("STP Port %d is %s", i, temp_storage); */
		strcat (telnet.tx_buffer, temp_storage);		
	}	
	sprintf (temp_storage, "\n\r[ %2d]  None", no_of_stp_ports );
	strcat (telnet.tx_buffer, temp_storage);		
	sprintf (temp_storage, EnterChoice, no_of_stp_ports);
	strcat (telnet.tx_buffer, temp_storage);		
/*	printf ("Buffer returned in STP Port is %s", telnet.tx_buffer); */
}

/* temporarily storing everything in some structures. Added by oss on 5-3-97 */

void load_dlci_values_from_ll()
{
	ULONG port_no = NOT_PORT_PARAMETER;
	int i;
	BYTE  dlci_value_store[10];

	get_parameter (CM_PPP_SECTION, (void *) ((BYTE *) &frame_relay.total_number_of_dlci_connections - (BYTE *) &frame_relay),
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);
			
	copy_to_temp_struct (&dlci_value_store[0], &ReplyStrs[0].ReplyStr[0]);
 
	Total_No_of_DLCIs = atoi (dlci_value_store);
	for (i = 0; i < Total_No_of_DLCIs; i++)
	{
/* xxxx */
		port_no = i + 2;
		copy_to_temp_struct (&dlci_value_store[0],
						(get_rhs_from_linked_list (
							"Frame Relay DLCI Number =", port_no,
							Pointers_SectHdr.ptrs[6])));
		dlci_values[i].DLCI_No = atoi (dlci_value_store);
		
		port_no = dlci_values[i].DLCI_No + 1;
/* xxxx */
		dlci_values[i].CIR = atoi (get_rhs_from_linked_list (
						"Frame Relay DLCI CIR =", port_no,
						Pointers_SectHdr.ptrs[6]));
		
		dlci_values[i].Be = atoi (get_rhs_from_linked_list (
						"Frame Relay DLCI Be =", port_no,
						Pointers_SectHdr.ptrs[6]));
		
		dlci_values[i].Mode = atoi (get_rhs_from_linked_list (
						"Frame Relay DLCI Mode =", port_no,
						Pointers_SectHdr.ptrs[6]));
		

		dlci_values[i].Mapped_to_IP_Port = check_if_mapped (1, dlci_values[i].DLCI_No);
		dlci_values[i].Mapped_to_IPX_Network = check_if_mapped (2, dlci_values[i].DLCI_No);
		dlci_values[i].Mapped_to_STP_Port = check_if_mapped (3, dlci_values[i].DLCI_No);
	}
	first_time_in_DLCIs = 0;
}

void 	make_dlci_list_from_struct(BYTE *buffer)
{
	int i;
	BYTE temp_bfr[20];

	for (i = 0; i < Total_No_of_DLCIs; i++)
	{
		if ((i % 10) == 0)
		  sprintf (temp_bfr, "\n\r\    %4d   ", dlci_values[i].DLCI_No);
		else
		  sprintf (temp_bfr, "%4d   ", dlci_values[i].DLCI_No);
		strcat (buffer, temp_bfr);
	}
}


int index_of_dlci_in_struct(int dlci_number)
{
	int i;
	for (i = 0; i < Total_No_of_DLCIs; i++)
		if (dlci_values[i].DLCI_No == dlci_number)
			return i;

	return (NOT_PORT_PARAMETER);
}

void save_all_changes_to_linked_list()
{
	ULONG offset, port_no = NOT_PORT_PARAMETER;
	BYTE *lhs_para_str, *new_rhs;
	BYTE LHS_strings[75], temp[15];
	BYTE Mapping_DLCIs_to_port[100];
	BYTE Frame_Relay_DLCI[] = "Frame Relay DLCI %s";
	int i;

/*	printf ("calling function to delete strings from llp\n"); */
	strcpy (LHS_strings, "Frame Relay Port to DLCI");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);
	sprintf (LHS_strings, Frame_Relay_DLCI, "Number");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);

	sprintf (LHS_strings, FR_VP_DLCI, "IP");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);
	sprintf (LHS_strings, FR_VP_DLCI, "IPX");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);
	sprintf (LHS_strings, FR_VP_DLCI, "STP");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);
	sprintf (LHS_strings, Frame_Relay_DLCI,"CIR");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);
	sprintf (LHS_strings, Frame_Relay_DLCI, "Be");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);
	strcpy (LHS_strings, "Frame Relay DLCI Mode");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[6]);

	strcpy (LHS_strings, "Mux Data Port Mapped to DLCI");
	delete_string_from_linked_list (LHS_strings, Pointers_SectHdr.ptrs[7]);

 	offset = (BYTE *) &frame_relay.total_number_of_dlci_connections - (BYTE *) &frame_relay;
	sprintf (temp, "%d", Total_No_of_DLCIs);
	new_rhs = temp;

	lhs_para_str = LHS_strings;
	new_rhs = temp;

	port_no = 1;
/*	printf ("number of dlcis = %d\n", Total_No_of_DLCIs); */
	strcpy (Mapping_DLCIs_to_port, "");

	for (i = 0; i < Total_No_of_DLCIs; i ++)
	{
		sprintf (temp, "%04d", dlci_values[i].DLCI_No);

		strcat (Mapping_DLCIs_to_port, temp);
		strcat (Mapping_DLCIs_to_port, ",");

		sprintf (LHS_strings, Frame_Relay_DLCI, "Number");
		port_no = i + 2;
		force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);

		if (dlci_values[i].Mapped_to_IP_Port != NOT_PORT_PARAMETER)
		{
			sprintf (LHS_strings, FR_VP_DLCI, "IP");
			port_no = dlci_values[i].Mapped_to_IP_Port + 1;
			force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);
		}

		if (dlci_values[i].Mapped_to_IPX_Network != NOT_PORT_PARAMETER)
		{
			sprintf (LHS_strings, FR_VP_DLCI, "IPX");
			port_no = dlci_values[i].Mapped_to_IPX_Network + 1;
			force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);
		}

		if (dlci_values[i].Mapped_to_STP_Port != NOT_PORT_PARAMETER)
		{
			sprintf (LHS_strings, FR_VP_DLCI, "STP");
			port_no = dlci_values[i].Mapped_to_STP_Port + 1;
			force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);
		}

		if (dlci_values[i].Mapped_to_Channel1 == 1)
		{
			strcpy (LHS_strings, "Mux Data Port Mapped to DLCI");
			port_no = 1;
			sprintf (temp, "%04d", dlci_values[i].DLCI_No);
			force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[7]);
		}

		if (dlci_values[i].Mapped_to_Channel2 == 1)
		{
			strcpy (LHS_strings, "Mux Data Port Mapped to DLCI");
			port_no = 2;
			sprintf (temp, "%04d", dlci_values[i].DLCI_No);
			force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[7]);
		}

		port_no = dlci_values[i].DLCI_No + 1;
		strcpy (LHS_strings, "Frame Relay DLCI CIR");
		sprintf (temp, "%4lu", dlci_values[i].CIR);

		force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);

		strcpy (LHS_strings, "Frame Relay DLCI Be");
		sprintf (temp, "%lu", dlci_values[i].Be);
		force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);

		strcpy (LHS_strings, "Frame Relay DLCI Mode");
		sprintf (temp, "%d", dlci_values[i].Mode);
		force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);
	}

	strcpy (LHS_strings, "Frame Relay Port to DLCI");
	i = strlen (Mapping_DLCIs_to_port);
	Mapping_DLCIs_to_port[i-1] = '\0';
	new_rhs = &Mapping_DLCIs_to_port[0];
	port_no = 1;
	force_write_string_with_port_num (lhs_para_str, port_no, new_rhs,
					Pointers_SectHdr.ptrs[6]);
	
}

BYTE *make_fr_mode_str (BYTE *buf, int mode)
{
	if (mode == 0)
		strcpy (buf, mode_str[0]);
	else if (mode == 1)
		strcpy (buf, mode_str[1]);
	else
		strcpy (buf, mode_str[2]);
	return (buf);
}

void change_wan_parameters_for_fr()
{
	ULONG port_no;
	BYTE *new_rhs, StoreBuffer[40], new_value_to_assign[5];

	port_no = 1;
	new_rhs = &telnet_disabled_str[0];

	strcpy (StoreBuffer, "WAN Port ASYNC");


	strcpy (StoreBuffer, "WAN Port Internal Clock");

	strcpy (StoreBuffer, "WAN Port Send Idle Flags");
	new_rhs = &telnet_enabled_str[0];

	strcpy (StoreBuffer, "WAN Port Type");
	strcpy (new_value_to_assign, "2");
	new_rhs = &new_value_to_assign[0];

	strcpy (StoreBuffer, "Frame Relay Number of Ports");
	strcpy (new_value_to_assign, "1");
	new_rhs = &new_value_to_assign[0];
}



void delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr)
{
	
	PARA_STR *ptr_to_config, *ptr_to_next;
	ULONG Idle;

	ptr_to_config = start_addr;

	while ((ptr_to_config->parameter[0] != '[') && (ptr_to_config != NULL))
	{
		if (strstr (ptr_to_config->parameter, str_to_delete) != NULL)
		{
/*			printf ("deleted one string of %s\n", ptr_to_config->parameter); */
			for (Idle = 0; Idle < 0x2fff; Idle ++);
			ptr_to_next = ptr_to_config->next;
			ptr_to_config->previous->next = ptr_to_config->next;
			ptr_to_config->next->previous = ptr_to_config->previous;
			free (ptr_to_config);
			ptr_to_config = ptr_to_next;
/*			return ; */
		}
		else
			ptr_to_config = ptr_to_config->next;
	 	if (ptr_to_config == NULL)
			break;
	}
/*	printf ("%s String was not found for deletion\n", str_to_delete); */
	return;
}

void modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr)
{
	
	PARA_STR *ptr_to_config;
	char StoreTempValue[100], *ch, *ch1, RemPart[25];
	int length;

	ptr_to_config = start_addr;

	sprintf (StoreTempValue, "%s = %02d", str_to_modify, OldPortNo);
	length = strlen (StoreTempValue);
	while ((ptr_to_config->parameter[0] != '[') && (ptr_to_config != NULL))
	{
		if (!strnicmp (ptr_to_config->parameter, StoreTempValue, length))
		{
/*			printf ("found a string to change\n"); */
			ch = strchr (&ptr_to_config->parameter[0], '=');
			if (ch != NULL)
			{
				ch1 = strchr (ch, ',');
				strcpy (RemPart, ch1);
				*ch = '\0';
				strcpy (StoreTempValue, ptr_to_config->parameter);
				sprintf (ptr_to_config->parameter, "%s= %02d%s",
								StoreTempValue, NewPortNo, RemPart);
			}
/*			printf ("string %s mod to %s\n", StoreTempValue, ptr_to_config->parameter);  */
			return ; 
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
/*	printf ("%s String was not found for modification \n", StoreTempValue);  */
	return;
}

void force_write_string_with_port_num (BYTE *ptr_to_string, ULONG port_no,
														BYTE *new_rhs, PARA_STR *start_addr)
{

#if 0
	PARA_STR *ptr_to_first_string, *ptr_to_insert;
	BYTE temp[5] ;
	extern int PPP_Flag_enable;
	ptr_to_first_string = start_addr;;

/*	printf ("ptr_to_string %s\n",ptr_to_string); 
	printf ("section_name %s\n", section_name);   
	printf ("port number %d\n",port_no);
	printf ("new_rhs %s\n",new_rhs); */
	while ((ptr_to_first_string->parameter[0] != '[') &&
			 (ptr_to_first_string->next != NULL))
		ptr_to_first_string = ptr_to_first_string->next;
	if (ptr_to_first_string->next != NULL)
		ptr_to_first_string = ptr_to_first_string->previous;

	ptr_to_insert = (PARA_STR *) malloc (sizeof (ULONG) * 2 + 200) ;
	if (ptr_to_insert == NULL)
	{
		printf("Not Enough memory\n");
		return ;
	}
/*	printf ("Allocated memory\n");  */

	ptr_to_first_string->next->previous = ptr_to_insert;
	ptr_to_insert->next = ptr_to_first_string->next;
	ptr_to_insert->previous = ptr_to_first_string;
	ptr_to_first_string->next = ptr_to_insert;


	strcpy (ptr_to_insert->parameter, ptr_to_string);
		
	if (!PPP_Flag_enable) /* added by oss on 15-4-97 */
	{
		strcat (ptr_to_insert->parameter, " = ");
		if (port_no <= 16)
			sprintf (temp, "%02lu,", port_no - 1);
		else
			sprintf (temp, "%04lu,", port_no - 1);
	}

	if (port_no != NOT_PORT_PARAMETER)
		strcat (ptr_to_insert->parameter, temp);
	strcat (ptr_to_insert->parameter, new_rhs);
	strcat (ptr_to_insert->parameter, "\n");
	printf ("inserted string is %s\n",ptr_to_insert->parameter);
#endif
	return;
}

BYTE *get_rhs_from_linked_list(BYTE *lhs_para_str, ULONG PortNo, PARA_STR *starting_addr)
{
	
	PARA_STR *ptr_to_config;
	BYTE temp_bfr[100], PortNoinchar[10], *ch;

	ptr_to_config = starting_addr;
	strcpy (temp_bfr, lhs_para_str);
	if (PortNo != NOT_PORT_PARAMETER)
	{
		if (PortNo >= 16)
			sprintf (PortNoinchar, " %04d,", PortNo - 1);
		else
			sprintf (PortNoinchar, " %02d,", PortNo - 1);
		strcat (temp_bfr, PortNoinchar);
	}
	else
		strcat (temp_bfr, " ");

	while ((ptr_to_config->parameter[0] != '[') && (ptr_to_config != NULL ))
	{
		if (strstr (&ptr_to_config->parameter[0], &temp_bfr[0]) != NULL)
		{
			ch = &ptr_to_config->parameter[0] + strlen (temp_bfr);
			strcpy (Buffer, ch);
			Buffer[strlen(Buffer) - 1] = '\0';
			ch = Buffer;
			printf ("got one string of %s with rhs %s\n", temp_bfr, ch); 
			return (ch);
		}
		else
			ptr_to_config = ptr_to_config->next;
	} 
	printf ("could not get string of %s ", temp_bfr); 
	return NULL;
}

BYTE *get_rhs_for_disp (ULONG offset, CONFIGURATION_TABLE configuration_table, ULONG PortNo, PARA_STR *starting_addr)
{
	
	ULONG i = 0, len;
	PARA_STR *ptr_to_config;
	BYTE temp_bfr[100], PortNoinchar[10], *ch;
	BYTE lhs_para_str[255];

	while (1)
	{
		if (configuration_table.function[i].cptr_parameter_string == NULL)
		{
			printf ("end of ll given offset %8x is not found\n", offset);
			return (NULL);
		}
		if (configuration_table.function[i].parameter_1 ==	offset)
		{
			strcpy (lhs_para_str, configuration_table.function[i].cptr_parameter_string);
			break;
		}
		i++;
	}

	ptr_to_config = starting_addr;
	strcpy (temp_bfr, lhs_para_str);
	if (PortNo != NOT_PORT_PARAMETER)
	{
		if (PortNo >= 16)
			sprintf (PortNoinchar, " %04d,", PortNo - 1);
		else
			sprintf (PortNoinchar, " %02d,", PortNo - 1); 
		strcat (temp_bfr, PortNoinchar);
	}
	else
		strcat (temp_bfr, " ");


	len = strlen(temp_bfr);
/*	printf ("value of temp_bfr is %s and len is %d\n", temp_bfr, len); */
	while ((ptr_to_config != NULL) && (ptr_to_config->parameter[0] != '['))
	{
		if (!strnicmp (&ptr_to_config->parameter[0], temp_bfr, len))
		{
			ch = &ptr_to_config->parameter[0] + strlen (temp_bfr);
			strcpy (Buffer, ch);
			Buffer[strlen(Buffer) - 1] = '\0';
			ch = Buffer;
			printf ("got one string of %s with rhs %s\n", temp_bfr, ch);
			return (ch);
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
	printf ("lhs %s string was not found in linked list\n", temp_bfr);
	return NULL;
}

void set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr, BYTE *new_rhs)
{
	
	ULONG i = 0;
	PARA_STR *ptr_to_config;
	BYTE temp_bfr[100], PortNoinchar[10], *ch;
	BYTE lhs_para_str[255];

	
/*	printf ("The offset is %8x\n", offset);  */
	while (1)
	{
		if (configuration_table.function[i].cptr_parameter_string == NULL)
		{
			printf ("end of linked list given offset %8x is not found", offset);
			return;
		}
		if (configuration_table.function[i].parameter_1 ==	offset)
		{
			strcpy (lhs_para_str, configuration_table.function[i].cptr_parameter_string);
			break;
		}
		i++;
	}

	ptr_to_config = starting_addr;
	strcpy (temp_bfr, lhs_para_str);
	if (PortNo != NOT_PORT_PARAMETER)
	{
		if (PortNo >= 16)
			sprintf (PortNoinchar, " %04d,", PortNo - 1);
		else
			sprintf (PortNoinchar, " %02d,", PortNo - 1);
/*		sprintf (PortNoinchar, " %02d,", PortNo);  */
		strcat (temp_bfr, PortNoinchar);
	}
	else
		strcat (temp_bfr, " ");

/*	printf ("value of temp_bfr is %s\n", temp_bfr); */

	while ((ptr_to_config != NULL) && (ptr_to_config->parameter[0] != '['))
	{
		if (!strnicmp (&ptr_to_config->parameter[0], temp_bfr, strlen(temp_bfr)))
		{
			ch = &ptr_to_config->parameter[0] + strlen (temp_bfr);
			strcpy (ch, new_rhs);
			strcat (ch, "\n");
			printf ("set string %s with rhs %s\n", &ptr_to_config->parameter[0], ch);
			return ;
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
	printf ("lhs %s string not found for mod linked list\n", temp_bfr);
	return;
}

PARA_STR *search_for_string (BYTE *lhs_para_str, BYTE *rhs_string, PARA_STR *start_addr)
{
	PARA_STR *ptr_to_config;
	int length;

	ptr_to_config = start_addr;

	length = strlen (lhs_para_str);
	while (ptr_to_config != NULL)
	{
		if (ptr_to_config->parameter[0] == '[')
			return NULL; 
		if (!strnicmp (&ptr_to_config->parameter[0], lhs_para_str, length))
		{
			strcpy (rhs_string, &ptr_to_config->parameter[0] + length + 3);
/*			printf ("got %s with ret %s\n", ptr_to_config->parameter, rhs_string); */
			ptr_to_config = ptr_to_config->next;
			return (ptr_to_config);
		}
		else
			ptr_to_config = ptr_to_config->next;
	}
	printf ("%s string is not found\n", lhs_para_str); 
	return NULL;
}

ULONG check_if_mapped (int Flag, int DLCI_value_to_check)
{
	PARA_STR *store_address_temp1, *store_address_temp2;
	BYTE store_value[20], string_to_search[75], *ch, conv_DLCI_value[10];
	int j;

	switch (Flag)
	{
		case 1: sprintf (string_to_search, FR_VP_DLCI, "IP");
					break;
		case 2: sprintf (string_to_search, FR_VP_DLCI, "IPX");
					break;
		case 3: sprintf (string_to_search, FR_VP_DLCI, "STP");
					break;
	}

	store_address_temp1 = Pointers_SectHdr.ptrs[6];
	sprintf (conv_DLCI_value, "%04lu", DLCI_value_to_check);

	for (j = 0; j < Total_No_of_DLCIs; j++)
	{
		store_address_temp2 = search_for_string (string_to_search,
										&store_value[0], store_address_temp1);
		if (store_address_temp2 == NULL)
			return (NOT_PORT_PARAMETER);

/*		printf ("value obtained is %s\n", store_value); */
		ch = strchr (&store_value[0], ','); 
		if (ch != NULL)
		{
/*			printf ("Port number is %s, dlci %d\n", store_value, DLCI_value_to_check);
			printf ("comparing string %s with %s\n", ch, conv_DLCI_value); */
			if (!strnicmp(ch + 1, conv_DLCI_value, 4))
			{
				*ch = '\0';
				printf ("DLCI %s mapped to port %s", conv_DLCI_value, store_value);
				return (atoi (store_value));
			}
		}
		store_address_temp1 = store_address_temp2;
	}
/*	printf ("Dlci %d not mapped to %d flag port\n", DLCI_value_to_check, Flag); */
	return (NOT_PORT_PARAMETER);
}

int strnicmp (char *c1, char *c2, int size)
{
	int i;
/*	ULONG Idle;
	printf ("string1 is %s\n", c1);
	printf ("string2 is %s\n", c2);
	printf ("size is %d\n", size);  
	for (Idle = 0; Idle < 0xFFFF; Idle ++); */

	for (i = 0; i < size; i++)
		if (toupper( (int) *c1) != toupper ( (int) *c2))
			return 1;
		else
		{
			c1 ++;
			c2 ++;
		}
	return 0;
}

BYTE *copy_to_temp_struct(BYTE *buffer, BYTE *char_array)
{
	strcpy (buffer, char_array);
	return (buffer);
}

#endif
